/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.refactoring.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.xpand.ui.Messages;
import org.eclipse.xpand.ui.editor.IXpandEditorActionDefinitionIds;
import org.eclipse.xpand.ui.editor.XpandEditor;
import org.eclipse.xpand.ui.refactoring.actions.QuickMenuAction;
import org.eclipse.xpand.ui.refactoring.actions.RenameDefineAction;
import org.eclipse.xtend.shared.ui.core.action.SelectionDispatchAction;

public class RefactorActionGroup
extends ActionGroup {
    private static final String PERF_REFACTOR_ACTION_GROUP = "org.eclipse.jdt.ui/perf/explorer/RefactorActionGroup";
    public static final String MENU_ID = "org.eclipse.internal.xtend.xpand2.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String GROUP_CODING2 = "codingGroup2";
    private final IWorkbenchSite fSite;
    private final XpandEditor fEditor;
    private String fGroupName = "";
    private final List<SelectionDispatchAction> fActions = new ArrayList<SelectionDispatchAction>();
    private static final String QUICK_MENU_ID = "org.eclipse.internal.xtend.xpand2.editor.refactoring.quickMenu";
    private final RefactorQuickAccessAction quickAccessAction;
    private final IKeyBindingService keyBindingService;
    private final Action noActionAvailable = new NoActionAvailable();
    private final RenameDefineAction renameDefineAction;

    public RefactorActionGroup(XpandEditor editor, String groupName) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_REFACTOR_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fSite = editor.getEditorSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = editor.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.renameDefineAction = new RenameDefineAction(editor);
        this.initUpdatingAction(this.renameDefineAction, provider, selection, IXpandEditorActionDefinitionIds.REFACTOR_RENAME_DEFINE);
        editor.setAction("RenameDefine", (IAction)this.renameDefineAction);
        this.quickAccessAction = new RefactorQuickAccessAction();
        this.keyBindingService = editor.getEditorSite().getKeyBindingService();
        this.keyBindingService.registerAction((IAction)this.quickAccessAction);
    }

    private void initUpdatingAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, String actionDefinitionId) {
        action.setActionDefinitionId(actionDefinitionId);
        action.update(selection);
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
        this.fActions.add(action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.internal.xtend.xpand2.actions.RenameDefine", (IAction)this.renameDefineAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addRefactorSubmenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.disposeAction((ISelectionChangedListener)this.renameDefineAction, provider);
        if (this.quickAccessAction != null && this.keyBindingService != null) {
            this.keyBindingService.unregisterAction((IAction)this.quickAccessAction);
        }
        super.dispose();
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void addRefactorSubmenu(IMenuManager menu) {
        String menuText = Messages.RefactorActionGroup_MenuName;
        if (this.quickAccessAction != null) {
            menuText = this.quickAccessAction.addShortcut(menuText);
        }
        MenuManager refactorSubmenu = new MenuManager(menuText, MENU_ID);
        if (this.fEditor != null) {
            refactorSubmenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    RefactorActionGroup.this.refactorMenuShown(manager);
                }
            });
            refactorSubmenu.add((IAction)this.noActionAvailable);
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            for (SelectionDispatchAction element : this.fActions) {
                element.update(selection);
            }
            if (this.fillRefactorMenu((IMenuManager)refactorSubmenu) > 0) {
                menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
            }
        }
    }

    private int fillRefactorMenu(IMenuManager refactorSubmenu) {
        int added = 0;
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING));
        return added += this.addAction(refactorSubmenu, (IAction)this.renameDefineAction);
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private void refactorMenuShown(final IMenuManager refactorSubmenu) {
        Menu menu = ((MenuManager)refactorSubmenu).getMenu();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                RefactorActionGroup.this.refactorMenuHidden(refactorSubmenu);
            }
        });
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator<SelectionDispatchAction> iterator = this.fActions.iterator();
        while (iterator.hasNext()) {
            SelectionDispatchAction selectionDispatchAction;
            SelectionDispatchAction action = selectionDispatchAction = iterator.next();
            action.update((ISelection)textSelection);
        }
        refactorSubmenu.removeAll();
        if (this.fillRefactorMenu(refactorSubmenu) == 0) {
            refactorSubmenu.add((IAction)this.noActionAvailable);
        }
    }

    private void refactorMenuHidden(IMenuManager manager) {
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        Iterator<SelectionDispatchAction> iterator = this.fActions.iterator();
        while (iterator.hasNext()) {
            SelectionDispatchAction element;
            SelectionDispatchAction action = element = iterator.next();
            action.update((ISelection)textSelection);
        }
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.fEditor != null) {
            ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
            for (SelectionDispatchAction element : this.fActions) {
                element.update((ISelection)textSelection);
            }
            this.fillRefactorMenu(menu);
            for (SelectionDispatchAction element : this.fActions) {
                element.update((ISelection)textSelection);
            }
        } else {
            ISelection selection = this.fSite.getSelectionProvider().getSelection();
            for (SelectionDispatchAction element : this.fActions) {
                element.update(selection);
            }
            this.fillRefactorMenu(menu);
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(Messages.RefactorActionGroup_NoRefactoringsAvailable);
        }
    }

    private class RefactorQuickAccessAction
    extends QuickMenuAction {
        public RefactorQuickAccessAction() {
            super(RefactorActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager menu) {
            RefactorActionGroup.this.fillQuickMenu(menu);
        }
    }
}

