/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtend.typesystem.emf.EcoreUtil2;

public class XSDUtil {
    public static URI strToURI(String str) {
        if (str.length() > 0 && str.charAt(0) == '/') {
            return URI.createFileURI((String)str);
        }
        if (str.length() > 1 && str.charAt(1) == ':') {
            return URI.createFileURI((String)str);
        }
        return URI.createURI((String)str);
    }

    public static URI deresolve(URI base, URI uri) {
        if (base.equals(uri)) {
            return uri;
        }
        if (base.isRelative()) {
            base = EcoreUtil2.getURI((String)base.toString());
        }
        if (base.isRelative()) {
            base = URI.createFileURI((String)base.toString());
        }
        try {
            return uri.deresolve(base);
        }
        catch (IllegalStateException e) {
            return uri;
        }
    }

    public static boolean exists(URIConverter conv, URI uri) {
        try {
            InputStream s = conv.createInputStream(uri);
            s.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static URI resolve(URIConverter conv, URI base, String uri) {
        URI u;
        URI r = null;
        if ((base = conv.normalize(base)).isHierarchical() && !base.isRelative() && XSDUtil.exists(conv, u = URI.createURI((String)uri).resolve(base))) {
            r = u;
        }
        if (r == null) {
            r = EcoreUtil2.getURI((String)uri);
        }
        return r;
    }

    public static URI resolve(Resource res, String uri) {
        return XSDUtil.resolve(res.getResourceSet().getURIConverter(), res.getURI(), uri);
    }
}

