/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xpand;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xpand2.ast.Definition;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.parser.XpandParseFacade;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.functions.FunctionDefContextInternal;
import org.eclipse.xtend.backend.syslib.FileOutlet;
import org.eclipse.xtend.backend.syslib.InMemoryPostprocessor;
import org.eclipse.xtend.backend.syslib.UriBasedPostprocessor;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.middleend.LanguageContributor;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.MiddleEndFactory;
import org.eclipse.xtend.middleend.xpand.internal.OldDefinitionConverter;
import org.eclipse.xtend.middleend.xpand.internal.xpandlib.pr.XpandProtectedRegionResolver;
import org.eclipse.xtend.middleend.xpand.plugin.OldXpandRegistryFactory;
import org.eclipse.xtend.middleend.xpand.plugin.XpandDefinitionName;
import org.eclipse.xtend.middleend.xtend.OldHelper;
import org.eclipse.xtend.middleend.xtend.internal.TypeToBackendType;
import org.eclipse.xtend.middleend.xtend.internal.xtendlib.XtendGlobalVarOperations;
import org.eclipse.xtend.middleend.xtend.plugin.OldXtendRegistryFactory;
import org.eclipse.xtend.typesystem.MetaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XpandBackendFacade {
    private final String _xpandFile;
    private final MiddleEnd _middleEnd;
    private final String _fileEncoding;
    private final Collection<MetaModel> _mms;
    private final Collection<Outlet> _outlets;
    private static Log log = LogFactory.getLog(XpandBackendFacade.class);

    public static Object executeStatement(String code, Collection<MetaModel> mms, Map<String, Object> variables, Collection<Outlet> outlets, XpandProtectedRegionResolver resolver, boolean isLogStackTrace) {
        return XpandBackendFacade.executeStatement(code, null, mms, variables, outlets, resolver, isLogStackTrace);
    }

    public static Object executeStatement(String code, String fileEncoding, Collection<MetaModel> mms, Map<String, Object> variables, Collection<Outlet> outlets, XpandProtectedRegionResolver resolver, boolean isLogStackTrace) {
        return XpandBackendFacade.executeStatement(code, fileEncoding, mms, variables, outlets, null, resolver, isLogStackTrace);
    }

    public static Object executeStatement(String code, String fileEncoding, Collection<MetaModel> mms, Map<String, Object> variables, Collection<Outlet> outlets, List<String> advice, XpandProtectedRegionResolver resolver, boolean isLogStackTrace) {
        return XpandBackendFacade.createForFile(null, fileEncoding, mms, outlets).executeStatement(code, variables, advice, resolver, isLogStackTrace);
    }

    public Object executeStatement(String code, Map<String, Object> variables, List<String> advice, XpandProtectedRegionResolver resolver, boolean isLogStackTrace) {
        return this.executeStatement(code, variables, new HashMap<String, Object>(), advice, resolver, isLogStackTrace);
    }

    public Object executeStatement(String code, Map<String, Object> variables, Map<String, Object> globalVars, List<String> advice, XpandProtectedRegionResolver resolver, boolean isLogStackTrace) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (advice == null) {
            advice = new ArrayList<String>();
        }
        for (String adv : advice) {
            this._middleEnd.applyAdvice(adv);
        }
        Template tpl = XpandParseFacade.file((Reader)new StringReader("\u00abDEFINE dUmMy FOR dUmMy\u00bb" + code + "\u00ab" + "ENDDEFINE" + "\u00bb"), null);
        Statement[] statements = ((Definition)tpl.getDefinitions()[0]).getBody();
        XpandExecutionContext ctx = this.createXpandExecutionContext(this._fileEncoding, this._mms, this._outlets);
        for (String varName : variables.keySet()) {
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable(varName, (Object)ctx.getType(variables.get(varName))));
        }
        HashSet<XpandDefinitionName> referenced = new HashSet<XpandDefinitionName>();
        OldDefinitionConverter defConverter = new OldDefinitionConverter(ctx, new TypeToBackendType(this._middleEnd.getTypesystem(), (org.eclipse.xtend.expression.ExecutionContext)ctx));
        ExpressionBase converted = defConverter.convertStatementSequence(statements, (SyntaxElement)tpl, referenced, null);
        FunctionDefContextInternal fdc = this._middleEnd.createEmptyFdc();
        for (XpandDefinitionName xdn : referenced) {
            for (NamedFunction f : this._middleEnd.getFunctions(OldHelper.normalizeXpandResourceName((String)xdn.getCanonicalTemplateFileName())).getPublicFunctions()) {
                fdc.register(f, false);
            }
        }
        this._middleEnd.getExecutionContext().setFunctionDefContext((FunctionDefContext)fdc);
        this._middleEnd.getExecutionContext().getLocalVarContext().getLocalVars().putAll(variables);
        XpandBackendFacade.registerOutlets(this._middleEnd.getExecutionContext(), this._outlets);
        XpandBackendFacade.registerProtectedRegionResolver(this._middleEnd.getExecutionContext(), resolver);
        this._middleEnd.getExecutionContext().getContributionStateContext().storeState((Object)XtendGlobalVarOperations.GLOBAL_VAR_VALUES_KEY, globalVars);
        Object o = converted.evaluate(this._middleEnd.getExecutionContext());
        return o;
    }

    public static void registerOutlets(ExecutionContext ctx, Collection<Outlet> outlets) {
        for (Outlet oldOutlet : outlets) {
            FileOutlet newOutlet = new FileOutlet();
            newOutlet.setAppend(oldOutlet.isAppend());
            newOutlet.setBaseDir(new File(oldOutlet.getPath()));
            if (oldOutlet.getFileEncoding() != null) {
                newOutlet.setFileEncoding(oldOutlet.getFileEncoding());
            }
            newOutlet.setOverwrite(oldOutlet.isOverwrite());
            for (PostProcessor pp : oldOutlet.postprocessors) {
                newOutlet.register((InMemoryPostprocessor)new InMemoryPpAdapter(pp, oldOutlet));
                newOutlet.register((UriBasedPostprocessor)new UriBasedPpAdapter(pp, oldOutlet));
            }
            String outletName = oldOutlet.getName() != null ? oldOutlet.getName() : "OUT";
            ctx.getFunctionDefContext().invoke(ctx, new QualifiedName("registerOutlet"), Arrays.asList(outletName, newOutlet));
        }
    }

    public static void registerProtectedRegionResolver(ExecutionContext ctx, XpandProtectedRegionResolver resolver) {
        if (resolver != null) {
            ctx.getContributionStateContext().storeState((Object)"XpandProtectedRegionResolver", (Object)resolver);
        }
    }

    public static XpandBackendFacade createForFile(String xpandFilename, String fileEncoding, Collection<MetaModel> mms, Collection<Outlet> outlets) {
        return new XpandBackendFacade(xpandFilename, fileEncoding, mms, outlets);
    }

    private XpandExecutionContext createXpandExecutionContext(String fileEncoding, Collection<MetaModel> mms, Collection<Outlet> outlets) {
        fileEncoding = OldHelper.normalizedFileEncoding((String)fileEncoding);
        OutputImpl output = new OutputImpl();
        for (Outlet outlet : outlets) {
            output.addOutlet(outlet);
        }
        XpandExecutionContextImpl ctx = new XpandExecutionContextImpl((Output)output, null);
        for (MetaModel mm : mms) {
            ctx.registerMetaModel(mm);
        }
        ctx.getResourceManager().setFileEncoding(fileEncoding);
        return ctx;
    }

    private Map<Class<?>, Object> createSpecificParameters(String fileEncoding, Collection<MetaModel> mms, Collection<Outlet> outlets) {
        XpandExecutionContext ctx = this.createXpandExecutionContext(fileEncoding, mms, outlets);
        HashMap result = new HashMap();
        result.put(OldXtendRegistryFactory.class, ctx);
        result.put(OldXpandRegistryFactory.class, ctx);
        return result;
    }

    private XpandBackendFacade(String xpandFilename, String fileEncoding, Collection<MetaModel> mms, Collection<Outlet> outlets) {
        if (outlets == null) {
            outlets = new ArrayList<Outlet>();
        }
        this._xpandFile = OldHelper.normalizeXpandResourceName((String)xpandFilename);
        this._middleEnd = MiddleEndFactory.canCreateFromExtentions() ? MiddleEndFactory.createFromExtensions((BackendTypesystem)OldHelper.guessTypesystem(mms), this.createSpecificParameters(fileEncoding, mms, outlets)) : MiddleEndFactory.create((BackendTypesystem)OldHelper.guessTypesystem(mms), (List)LanguageContributor.INSTANCE.getFreshMiddleEnds(this.createSpecificParameters(fileEncoding, mms, outlets)));
        this._fileEncoding = fileEncoding;
        this._mms = mms;
        this._outlets = outlets;
    }

    public Collection<NamedFunction> getContributedFunctions() {
        return this._middleEnd.getFunctions(this._xpandFile).getPublicFunctions();
    }

    public FunctionDefContext getFunctionDefContext() {
        return this._middleEnd.getFunctions(this._xpandFile);
    }

    private static class FileHandleImpl
    implements FileHandle {
        private CharSequence _buffer;
        private final Outlet _outlet;
        private final File _file;

        public FileHandleImpl(CharSequence buffer, Outlet outlet, File file) {
            this._buffer = buffer;
            this._outlet = outlet;
            this._file = file;
        }

        public CharSequence getBuffer() {
            return this._buffer;
        }

        public String getFileEncoding() {
            return this._outlet.getFileEncoding();
        }

        public Outlet getOutlet() {
            return this._outlet;
        }

        public File getTargetFile() {
            return this._file;
        }

        public boolean isAppend() {
            return this._outlet.isAppend();
        }

        public boolean isOverwrite() {
            return this._outlet.isOverwrite();
        }

        public void setBuffer(CharSequence buffer) {
            this._buffer = buffer;
        }

        public void writeAndClose() {
            throw new UnsupportedOperationException();
        }

        public String getAbsolutePath() {
            return this.getTargetFile().getAbsolutePath();
        }
    }

    private static class InMemoryPpAdapter
    implements InMemoryPostprocessor {
        private final PostProcessor _oldPp;
        private final Outlet _outlet;

        public InMemoryPpAdapter(PostProcessor oldPp, Outlet outlet) {
            this._oldPp = oldPp;
            this._outlet = outlet;
        }

        public CharSequence process(CharSequence unprocessed, String uri) {
            FileHandleImpl fh = new FileHandleImpl(unprocessed, this._outlet, new File(uri));
            this._oldPp.beforeWriteAndClose((FileHandle)fh);
            return fh.getBuffer();
        }
    }

    private static class UriBasedPpAdapter
    implements UriBasedPostprocessor {
        private final PostProcessor _oldPp;
        private final Outlet _outlet;

        public UriBasedPpAdapter(PostProcessor oldPp, Outlet outlet) {
            this._oldPp = oldPp;
            this._outlet = outlet;
        }

        public void process(String uri) {
            FileHandleImpl fh = new FileHandleImpl("", this._outlet, new File(uri));
            this._oldPp.afterClose((FileHandle)fh);
        }
    }
}

