/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeNameUtil {
    private static final String QUALIFIEDNAME_STRING = "(?:[^\\s.:()\\[\\]{}+\\-*/&|%$!\\\"'=?]+::)*[^\\s.:()\\[\\]{}+\\-*/&|%!\"'=?]+";
    static final Pattern TYPE_PATTERN = Pattern.compile("\\A(?:(\\w+)\\[)?(?:(\\w+)!)?((?:[^\\s.:()\\[\\]{}+\\-*/&|%$!\\\"'=?]+::)*[^\\s.:()\\[\\]{}+\\-*/&|%!\"'=?]+)(?:\\])?\\z");
    static final Pattern GENERICLIST_PATTERN = Pattern.compile("\\A\\[L((?:[^\\s.:()\\[\\]{}+\\-*/&|%$!\\\"'=?]+::)*[^\\s.:()\\[\\]{}+\\-*/&|%!\"'=?]+);");

    public static String getCollectionTypeName(String name) {
        String group = TypeNameUtil.getGroup(name, TYPE_PATTERN, 1);
        if (group == null && GENERICLIST_PATTERN.matcher(name).matches()) {
            group = "List";
        }
        return group;
    }

    public static String getTypeName(String name) {
        String group = TypeNameUtil.getGroup(name, TYPE_PATTERN, 3);
        if (group == null) {
            group = TypeNameUtil.getGroup(name, GENERICLIST_PATTERN, 1);
        }
        if (group == null) {
            group = "";
        }
        return group;
    }

    private static String getGroup(String input, Pattern pattern, int group) {
        Matcher m = pattern.matcher(input);
        if (m.matches() && m.groupCount() >= group) {
            return m.group(group);
        }
        return null;
    }

    public static String getName(Class<?> class1) {
        return class1.getName().replaceAll("\\.", "::");
    }

    public static String withoutLastSegment(String fqn) {
        if (fqn.lastIndexOf("::") == -1) {
            return null;
        }
        return fqn.substring(0, fqn.lastIndexOf("::"));
    }

    public static String getLastSegment(String fqn) {
        if (fqn.lastIndexOf("::") == -1) {
            return fqn;
        }
        return fqn.substring(fqn.lastIndexOf("::") + "::".length());
    }

    public static String getSimpleName(String fqn) {
        String ct = TypeNameUtil.getCollectionTypeName(fqn);
        String inner = TypeNameUtil.getLastSegment(TypeNameUtil.getTypeName(fqn));
        StringBuffer sb = new StringBuffer();
        if (ct != null) {
            sb.append(ct).append("[");
        }
        sb.append(inner);
        if (ct != null) {
            sb.append("]");
        }
        return sb.toString();
    }

    public static String getPackage(String insertString) {
        if (insertString == null || insertString.trim().length() == 0) {
            return null;
        }
        int index = insertString.lastIndexOf("::");
        if (index != -1) {
            return insertString.substring(0, index);
        }
        return null;
    }

    public static String convertJavaTypeName(String javaTypeName) {
        if (javaTypeName == null) {
            return null;
        }
        return javaTypeName.replaceAll("\\.", "::");
    }
}

