/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.core.metamodel.Contributor;
import org.eclipse.xtend.shared.ui.core.metamodel.MetamodelContributorRegistry;
import org.eclipse.xtend.shared.ui.core.properties.MetamodelContributorsPropertyAndPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendXpandProjectWizardPage
extends WizardPage {
    private Text projectText;
    private Button generateSimpleExample;
    private Button useWorkspaceDefinedMetaModels;
    private Button useProjectSpecificMetaModels;
    private Button downButton;
    private Button upButton;
    private List<Contributor> availableMetamodelContributors;
    private Table table;
    private Composite tableContainer;
    private CheckboxTableViewer checkboxTableViewer;
    private String storeString;

    public String getStoreString() {
        return this.storeString;
    }

    private List<Contributor> getMetamodelContributors(boolean includeDisabled) {
        Map<String, Contributor> availableMetamodelContributors = MetamodelContributorRegistry.getRegisteredMetamodelContributors();
        ArrayList<Contributor> result = new ArrayList<Contributor>();
        if (includeDisabled) {
            for (Contributor contributor : availableMetamodelContributors.values()) {
                if (result.contains(contributor)) continue;
                result.add(contributor);
            }
        }
        return result;
    }

    private void updateButtonStates() {
        int index = this.table.getSelectionIndex();
        if (index == 0) {
            this.upButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
        }
        if (index >= this.checkboxTableViewer.getTable().getItemCount() - 1) {
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(true);
        }
        this.storeString = MetamodelContributorsPropertyAndPreferencePage.createStoreString(this.checkboxTableViewer.getCheckedElements());
    }

    private void enableMetamodelContributorTable(boolean enabled) {
        this.checkboxTableViewer.setAllGrayed(!enabled);
        this.checkboxTableViewer.getTable().deselectAll();
        this.tableContainer.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
        if (enabled) {
            this.updateButtonStates();
        }
    }

    public XtendXpandProjectWizardPage() {
        super(Messages.XtendXpandProjectWizardPage_Name);
        this.setTitle(Messages.XtendXpandProjectWizardPage_Title);
        this.setDescription(Messages.XtendXpandProjectWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        GridData gd = new GridData(768);
        Label label = new Label(container, 0);
        label.setText(Messages.XtendXpandProjectWizardPage_ProjectLabel);
        this.projectText = new Text(container, 2052);
        gd = new GridData(768);
        this.projectText.setLayoutData((Object)gd);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XtendXpandProjectWizardPage.this.dialogChanged();
            }
        });
        Group mm_list = new Group(container, 4);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        mm_list.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        mm_list.setLayoutData((Object)gd);
        mm_list.setText("Meta Models");
        this.useWorkspaceDefinedMetaModels = new Button((Composite)mm_list, 16);
        label = new Label((Composite)mm_list, 0);
        label.setText("Use workspace defaults");
        this.useProjectSpecificMetaModels = new Button((Composite)mm_list, 16);
        label = new Label((Composite)mm_list, 0);
        label.setText("Use project specific metamodels:");
        this.tableContainer = new Composite((Composite)mm_list, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 22;
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        this.tableContainer.setLayoutData((Object)gd);
        this.tableContainer.setLayout((Layout)layout);
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)this.tableContainer, (int)2048);
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table = this.checkboxTableViewer.getTable();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XtendXpandProjectWizardPage.this.updateButtonStates();
                XtendXpandProjectWizardPage.this.dialogChanged();
            }
        });
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(this.tableContainer, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        composite.setLayout((Layout)gridLayout_1);
        this.upButton = new Button(composite, 0);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection;
                Object firstElement;
                ISelection selection = XtendXpandProjectWizardPage.this.checkboxTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Contributor) {
                    Contributor contributor = (Contributor)firstElement;
                    int index = XtendXpandProjectWizardPage.this.availableMetamodelContributors.indexOf(contributor);
                    XtendXpandProjectWizardPage.this.availableMetamodelContributors.remove(contributor);
                    XtendXpandProjectWizardPage.this.availableMetamodelContributors.add(index - 1, contributor);
                    XtendXpandProjectWizardPage.this.checkboxTableViewer.refresh();
                }
                XtendXpandProjectWizardPage.this.updateButtonStates();
            }
        });
        GridData gridData_1 = new GridData(4, 0x1000000, false, false);
        gridData_1.widthHint = 75;
        this.upButton.setLayoutData((Object)gridData_1);
        this.upButton.setText(Messages.MetamodelContributorsPropertyAndPreferencePage_UpButton);
        this.downButton = new Button(composite, 0);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection;
                Object firstElement;
                ISelection selection = XtendXpandProjectWizardPage.this.checkboxTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Contributor) {
                    Contributor contributor = (Contributor)firstElement;
                    int index = XtendXpandProjectWizardPage.this.availableMetamodelContributors.indexOf(contributor);
                    XtendXpandProjectWizardPage.this.availableMetamodelContributors.remove(contributor);
                    XtendXpandProjectWizardPage.this.availableMetamodelContributors.add(index + 1, contributor);
                    XtendXpandProjectWizardPage.this.checkboxTableViewer.refresh();
                }
                XtendXpandProjectWizardPage.this.updateButtonStates();
            }
        });
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 75;
        this.downButton.setLayoutData((Object)gridData);
        this.downButton.setText(Messages.MetamodelContributorsPropertyAndPreferencePage_DownButton);
        this.generateSimpleExample = new Button((Composite)mm_list, 16);
        label = new Label((Composite)mm_list, 0);
        label.setText("Generate a sample EMF based Xpand project");
        this.generateSimpleExample.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XtendXpandProjectWizardPage.this.dialogChanged();
                XtendXpandProjectWizardPage.this.enableMetamodelContributorTable(false);
            }

            public void widgetSelected(SelectionEvent e) {
                XtendXpandProjectWizardPage.this.dialogChanged();
                XtendXpandProjectWizardPage.this.enableMetamodelContributorTable(false);
            }
        });
        this.useWorkspaceDefinedMetaModels.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XtendXpandProjectWizardPage.this.dialogChanged();
                XtendXpandProjectWizardPage.this.enableMetamodelContributorTable(false);
            }

            public void widgetSelected(SelectionEvent e) {
                XtendXpandProjectWizardPage.this.dialogChanged();
                XtendXpandProjectWizardPage.this.enableMetamodelContributorTable(false);
            }
        });
        this.useProjectSpecificMetaModels.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XtendXpandProjectWizardPage.this.dialogChanged();
                XtendXpandProjectWizardPage.this.enableMetamodelContributorTable(true);
            }

            public void widgetSelected(SelectionEvent e) {
                XtendXpandProjectWizardPage.this.dialogChanged();
                XtendXpandProjectWizardPage.this.enableMetamodelContributorTable(true);
            }
        });
        this.setupData();
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void setupData() {
        this.availableMetamodelContributors = this.getMetamodelContributors(true);
        this.checkboxTableViewer.setInput(this.availableMetamodelContributors);
        List<Contributor> enabledMetamodelContributors = this.getMetamodelContributors(false);
        this.checkboxTableViewer.setCheckedElements(enabledMetamodelContributors.toArray());
    }

    private void initialize() {
        this.projectText.setText(Messages.XtendXpandProjectWizardPage_DefaultFileName);
        this.tableContainer.setEnabled(false);
        this.useWorkspaceDefinedMetaModels.setSelection(true);
    }

    void dialogChanged() {
        if (this.projectText.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.XtendXpandProjectWizardPage_ProjectName_Error);
            return;
        }
        if (this.useProjectSpecificMetaModels.getSelection() && this.checkboxTableViewer.getCheckedElements().length == 0) {
            this.setErrorMessage(Messages.XtendXpandProjectWizardPage_NoMMSelected_Error);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getProjectName() {
        return this.projectText.getText();
    }

    public boolean isCreateExample() {
        return this.generateSimpleExample.getSelection();
    }

    public boolean isUseWorkspaceDefinedMM() {
        return this.useWorkspaceDefinedMetaModels.getSelection();
    }

    public boolean isProjectSpecificMM() {
        return this.useProjectSpecificMetaModels.getSelection();
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Contributor) {
                Contributor contributor = (Contributor)element;
                return contributor.getDisplayName();
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

