/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.modisco.infra.browser.dialogs.EnableDerivedLinksPromptDialog;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.common.ui.internal.util.ImageUtils;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.FacetPackage;
import org.eclipse.modisco.infra.facet.FacetSet;
import org.eclipse.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.modisco.infra.facet.ui.views.FacetSetContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFacetsAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;
    private final LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            String label;
            if (element instanceof FacetSet) {
                FacetSet facetSet = (FacetSet)element;
                label = facetSet.getName();
            } else if (element instanceof Facet) {
                Facet facet = (Facet)element;
                label = facet.getName();
            } else {
                label = element == null ? "null" : element.getClass().getName();
            }
            return label;
        }

        public Image getImage(Object element) {
            return ImageUtils.getImage((Object)element);
        }
    };

    public LoadFacetsAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.BrowserActionBarContributor_loadFacets, 1);
        this.browserActionBarContributor = browserActionBarContributor;
        this.setToolTipText(Messages.BrowserActionBarContributor_loadFacets);
        this.setImageDescriptor(ImageProvider.getInstance().getFacetIconDescriptor());
    }

    public void run() {
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    FacetSetCatalog.getSingleton().waitUntilBuilt();
                }
            });
            this.openDialog(browser);
        }
    }

    protected void openDialog(EcoreBrowser browser) {
        FacetSetContentProvider treeContentProvider = new FacetSetContentProvider(FacetPackage.eINSTANCE.getFacet());
        LoadFacetsDialog dialog = new LoadFacetsDialog(null, (ILabelProvider)this.labelProvider, (ITreeContentProvider)treeContentProvider, browser.getReferencedEPackages());
        dialog.setContainerMode(true);
        dialog.setHelpAvailable(false);
        dialog.setTitle(Messages.BrowserActionBarContributor_dialogTitle_LoadFacets);
        dialog.setMessage(Messages.BrowserActionBarContributor_chooseFacetToLoad);
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        dialog.setInput(facetSets.toArray());
        dialog.setInitialElementSelections(new ArrayList(browser.getBrowserConfiguration().getAppearanceConfiguration().getLoadedFacets()));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            browser.getBrowserConfiguration().getAppearanceConfiguration().clearFacets();
            HashSet<Facet> facetsToLoad = new HashSet<Facet>();
            boolean promptShowDerivedLinks = false;
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object resultElement = objectArray[n2];
                if (resultElement instanceof Facet) {
                    Facet facet = (Facet)resultElement;
                    facetsToLoad.add(facet);
                    if (!facet.getEReferences().isEmpty() || !facet.getEAttributes().isEmpty()) {
                        promptShowDerivedLinks = true;
                    }
                } else if (!(resultElement instanceof FacetSet)) {
                    throw new RuntimeException("Unexpected element type");
                }
                ++n2;
            }
            if (promptShowDerivedLinks && !this.browserActionBarContributor.getBrowser().isShowDerivedLinks()) {
                this.maybeShowDerivedLinks();
            }
            LoadFacetsAction.loadFacets(facetsToLoad, browser);
        }
    }

    public static void loadFacets(final Collection<Facet> facetsToLoad, final EcoreBrowser browser) {
        final Object loadFacetsFamily = new Object();
        for (final Facet facetToLoad : facetsToLoad) {
            Job loadFacetsJob = new Job(String.valueOf(Messages.LoadFacetsAction_LoadingFacet) + facetToLoad.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    browser.getBrowserConfiguration().getAppearanceConfiguration().loadFacet(facetToLoad);
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    if (family == loadFacetsFamily) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            loadFacetsJob.setPriority(30);
            loadFacetsJob.schedule();
        }
        Job job = new Job(Messages.LoadFacetsAction_LoadingFacets){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().join(loadFacetsFamily, monitor);
                }
                catch (Exception e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)MoDiscoBrowserPlugin.getPlugin());
                    return Status.CANCEL_STATUS;
                }
                if (facetsToLoad.size() > 0) {
                    browser.getBrowserConfiguration().getAppearanceConfiguration().getCustomizationEngine().loadCustomizations();
                }
                browser.getBrowserConfiguration().getInstancesForMetaclasses().buildDerivationTree();
                browser.getBrowserConfiguration().getAppearanceConfiguration().touch();
                browser.refreshDelayed(true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    private void maybeShowDerivedLinks() {
        IPreferenceStore preferenceStore = MoDiscoBrowserPlugin.getPlugin().getPreferenceStore();
        String pref = preferenceStore.getString("enable_derived_links_prompt");
        boolean showDerivedLinks = false;
        if ("enable_derived_links_ask".equals(pref)) {
            showDerivedLinks = EnableDerivedLinksPromptDialog.open(null);
        } else if ("enable_derived_links_always".equals(pref)) {
            showDerivedLinks = true;
        } else if ("enable_derived_links_never".equals(pref)) {
            showDerivedLinks = false;
        }
        if (showDerivedLinks) {
            this.browserActionBarContributor.getBrowser().setShowDerivedLinks(true);
            this.browserActionBarContributor.getBrowser().refreshToolbar();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoadFacetsDialog
    extends CheckedTreeSelectionDialog {
        private static final String LOAD_FACETS_DIALOG = "LoadFacetsDialog";
        private static final String EXPANDED_ELEMENTS = "expandedElements";

        public LoadFacetsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Collection<EPackage> ePackages) {
            super(parent, labelProvider, contentProvider);
            final HashSet<EPackage> allReferencedPackages = new HashSet<EPackage>();
            for (EPackage ePackage : ePackages) {
                allReferencedPackages.add(ePackage);
                Set referencedPackages = ModelUtils.computeReferencedPackages((EPackage)ePackage);
                allReferencedPackages.addAll(referencedPackages);
            }
            this.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof FacetSet) {
                        FacetSet facetSet = (FacetSet)element;
                        if (facetSet.getExtendedPackage() == null) {
                            return true;
                        }
                        EPackage extendedPackage = facetSet.getExtendedPackage();
                        return allReferencedPackages.contains(extendedPackage);
                    }
                    return true;
                }
            });
        }

        public int open() {
            this.restoreExpandedElements();
            return super.open();
        }

        public boolean close() {
            this.saveExpandedElements();
            return super.close();
        }

        public void saveExpandedElements() {
            try {
                Object[] expandedElements;
                String filename = this.getSettingsFilename();
                DialogSettings settings = new DialogSettings(LOAD_FACETS_DIALOG);
                ArrayList<String> expandedFacetSets = new ArrayList<String>();
                Object[] objectArray = expandedElements = this.getTreeViewer().getExpandedElements();
                int n = expandedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object expandedElement = objectArray[n2];
                    if (expandedElement instanceof FacetSet) {
                        FacetSet facetSet = (FacetSet)expandedElement;
                        expandedFacetSets.add(facetSet.getName());
                    }
                    ++n2;
                }
                String[] array = expandedFacetSets.toArray(new String[expandedFacetSets.size()]);
                settings.put(EXPANDED_ELEMENTS, array);
                settings.save(filename);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
            }
        }

        private String getSettingsFilename() {
            IPath stateLocation = MoDiscoBrowserPlugin.getPlugin().getStateLocation();
            String filename = stateLocation.append(LOAD_FACETS_DIALOG).toOSString();
            return filename;
        }

        public void restoreExpandedElements() {
            try {
                String filename = this.getSettingsFilename();
                DialogSettings settings = new DialogSettings(LOAD_FACETS_DIALOG);
                if (new File(filename).isFile()) {
                    settings.load(filename);
                    String[] array = settings.getArray(EXPANDED_ELEMENTS);
                    Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
                    ArrayList<FacetSet> expandedFacetSets = new ArrayList<FacetSet>();
                    String[] stringArray = array;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String expandedFacetSetName = stringArray[n2];
                        for (FacetSet facetSet : facetSets) {
                            if (facetSet.getName() == null || !facetSet.getName().equals(expandedFacetSetName)) continue;
                            expandedFacetSets.add(facetSet);
                        }
                        ++n2;
                    }
                    this.setExpandedElements(expandedFacetSets.toArray());
                }
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
            }
        }
    }
}

