/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.manifest.discoverer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.manifest.Bundle;
import org.eclipse.modisco.manifest.ExportedPackage;
import org.eclipse.modisco.manifest.ImportedPackage;
import org.eclipse.modisco.manifest.ManifestFactory;
import org.eclipse.modisco.manifest.RequiredBundle;
import org.eclipse.modisco.manifest.Version;
import org.eclipse.modisco.manifest.discoverer.Activator;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestModelDiscoverer2
extends AbstractModelDiscoverer<IFile> {
    public boolean isApplicableTo(IFile source) {
        return source.isAccessible() && "MANIFEST.MF".equals(source.getName());
    }

    protected void basicDiscoverElement(IFile file, IProgressMonitor monitor) throws DiscoveryException {
        String pathName = file.getFullPath() + ".xmi";
        URI uri = URI.createPlatformResourceURI((String)pathName, (boolean)true);
        this.setDefaultTargetURI(uri);
        Resource resource = this.discoverManifestModel(file);
        this.setTargetModel(resource);
    }

    private static void discoverBundleSymbolicName(Bundle bundle, String symbolicNameValue) throws DiscoveryException {
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameValue);
            if (elements != null && elements.length > 0) {
                ManifestElement manifestElement = elements[0];
                bundle.setSymbolicName(manifestElement.getValue());
                String singletonAttr = manifestElement.getDirective("singleton");
                if ("true".equals(singletonAttr)) {
                    bundle.setSingleton(true);
                }
            }
        }
        catch (BundleException e) {
            throw new DiscoveryException((Throwable)e);
        }
    }

    private Resource discoverManifestModel(IFile manifestFile) throws DiscoveryException {
        HashMap<String, String> manifestValues = new HashMap<String, String>();
        Resource manifestResource = this.createTargetModel();
        InputStream manifestContent = null;
        try {
            try {
                manifestContent = manifestFile.getContents();
                ManifestElement.parseBundleManifest((InputStream)manifestContent, manifestValues);
                Bundle bundle = ManifestFactory.eINSTANCE.createBundle();
                manifestResource.getContents().add((Object)bundle);
                bundle.setVersion((String)manifestValues.get("Bundle-Version"));
                ManifestModelDiscoverer2.discoverBundleSymbolicName(bundle, (String)manifestValues.get("Bundle-SymbolicName"));
                bundle.setName((String)manifestValues.get("Bundle-Name"));
                bundle.setActivator((String)manifestValues.get("Bundle-Activator"));
                bundle.setVendor((String)manifestValues.get("Bundle-Vendor"));
                bundle.setActivationPolicy((String)manifestValues.get("Bundle-ActivationPolicy"));
                bundle.setRequiredExecutionEnvironment((String)manifestValues.get("Bundle-RequiredExecutionEnvironment"));
                ManifestElement[] rBundleMElts = ManifestModelDiscoverer2.parseHeader(manifestValues, "Require-Bundle");
                if (rBundleMElts != null) {
                    List<RequiredBundle> requiredBundles = ManifestModelDiscoverer2.discoverRequiredBundle(rBundleMElts);
                    bundle.getRequiredBundles().addAll(requiredBundles);
                }
                ManifestModelDiscoverer2.discoverImportPackage(manifestValues, bundle);
                ManifestModelDiscoverer2.discoverExportPackage(manifestValues, bundle);
            }
            catch (Exception e) {
                throw new DiscoveryException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (manifestContent != null) {
                    manifestContent.close();
                }
            }
            catch (IOException e) {
                String string = String.format("Manifest input stream closing faied (%s)", manifestFile.getLocation().toOSString());
                Logger.logError((Throwable)e, (String)string, (Plugin)Activator.getDefault());
            }
            throw throwable;
        }
        try {
            if (manifestContent != null) {
                manifestContent.close();
            }
        }
        catch (IOException e) {
            String string = String.format("Manifest input stream closing faied (%s)", manifestFile.getLocation().toOSString());
            Logger.logError((Throwable)e, (String)string, (Plugin)Activator.getDefault());
        }
        return manifestResource;
    }

    private static void discoverExportPackage(Map<String, String> manifestValues, Bundle bundle) throws BundleException {
        ManifestElement[] exportPackages = ManifestModelDiscoverer2.parseHeader(manifestValues, "Export-Package");
        if (exportPackages != null) {
            ManifestElement[] manifestElementArray = exportPackages;
            int n = exportPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement exportPackage = manifestElementArray[n2];
                ExportedPackage exportedPackage = ManifestFactory.eINSTANCE.createExportedPackage();
                exportedPackage.setName(exportPackage.getValue());
                if (exportPackage.getDirective("x-internal") == null) {
                    String directive = exportPackage.getDirective("x-friends");
                    if (directive == null) {
                        exportedPackage.setXInternal(false);
                    } else {
                        String[] xFriends;
                        exportedPackage.setXInternal(true);
                        String[] stringArray = xFriends = directive.split(",");
                        int n3 = xFriends.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String xFriend = stringArray[n4];
                            Bundle xfBundle = ManifestFactory.eINSTANCE.createBundle();
                            xfBundle.setName(xFriend);
                            exportedPackage.getXFriends().add((Object)xfBundle);
                            ++n4;
                        }
                    }
                } else {
                    exportedPackage.setXInternal(true);
                }
                bundle.getExportPackages().add((Object)exportedPackage);
                ++n2;
            }
        }
    }

    private static void discoverImportPackage(Map<String, String> manifestValues, Bundle bundle) throws BundleException {
        ManifestElement[] importedPackages = ManifestModelDiscoverer2.parseHeader(manifestValues, "Import-Package");
        if (importedPackages != null) {
            ManifestElement[] manifestElementArray = importedPackages;
            int n = importedPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                ImportedPackage importedPackage = ManifestFactory.eINSTANCE.createImportedPackage();
                importedPackage.setName(element.getValue());
                String bundleVersion = element.getAttribute("version");
                if (bundleVersion != null) {
                    importedPackage.setVersion(ManifestModelDiscoverer2.discoverVersion(bundleVersion));
                }
                bundle.getImportedPackages().add((Object)importedPackage);
                ++n2;
            }
        }
    }

    private static ManifestElement[] parseHeader(Map<String, String> manifestValues, String key) throws BundleException {
        return ManifestElement.parseHeader((String)key, (String)manifestValues.get(key));
    }

    private static Version discoverVersion(String bundleVersion) {
        Version version = ManifestFactory.eINSTANCE.createVersion();
        String firstChar = bundleVersion.substring(0, 1);
        if ("(".equals(firstChar) || "[".equals(firstChar)) {
            if ("[".equals(firstChar)) {
                version.setMinimumIsInclusive(true);
            } else {
                version.setMinimumIsInclusive(false);
            }
            int indexOfSeparator = bundleVersion.indexOf(44);
            String minimumVersion = bundleVersion.substring(1, indexOfSeparator);
            version.setMinimum(minimumVersion);
            String maximumVersion = bundleVersion.substring(indexOfSeparator + 1, bundleVersion.length() - 1);
            version.setMaximum(maximumVersion);
            if (bundleVersion.substring(bundleVersion.length() - 1).equals("]")) {
                version.setMaximumIsInclusive(true);
            } else {
                version.setMaximumIsInclusive(false);
            }
        } else {
            version.setMinimum(bundleVersion);
        }
        return version;
    }

    private static List<RequiredBundle> discoverRequiredBundle(ManifestElement[] requiredBundles) {
        ArrayList<RequiredBundle> result = new ArrayList<RequiredBundle>();
        ManifestElement[] manifestElementArray = requiredBundles;
        int n = requiredBundles.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement element = manifestElementArray[n2];
            RequiredBundle requiredBundle = ManifestFactory.eINSTANCE.createRequiredBundle();
            requiredBundle.setSymbolicName(element.getValue());
            String bundleVersion = element.getAttribute("bundle-version");
            if (bundleVersion != null) {
                requiredBundle.setVersion(ManifestModelDiscoverer2.discoverVersion(bundleVersion));
            }
            result.add(requiredBundle);
            ++n2;
        }
        return result;
    }
}

