/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.modisco.facet.util.core.DebugUtils;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Messages;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererList;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererListFactory;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSet;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSetFactory;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.DiscovererBenchmarkDiscoverer;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.BenchmarkFactory;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Discovery;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        IWorkspaceRoot wsRoot;
        String[] args = (String[])context.getArguments().get("application.args");
        Options options = new Options();
        options.addOption("r", true, Messages.Application_Html_report_dir);
        options.addOption("d", true, Messages.Application_Comma_sep_discoverer_list);
        options.getOption("d").setRequired(true);
        options.addOption("i", true, Messages.Application_no_of_iteration);
        options.addOption("p", true, Messages.Application_Comma_sep_project_list);
        options.addOption("o", true, Messages.Application_XMI_Output);
        options.getOption("o").setRequired(true);
        options.addOption("e", true, Messages.Application_Comma_sep_existing_prj_path);
        options.addOption("m", false, Messages.Application_RecordMemoryUse);
        options.addOption("n", true, Messages.Application_MemoryPollingInterval);
        options.addOption("s", true, "Sample size discoverer");
        options.getOption("s").setRequired(true);
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption('e')) {
            Application.importExistingPrj(cmd.getOptionValue('e').split(","));
        }
        DiscovererBenchmarkDiscoverer discoverer = new DiscovererBenchmarkDiscoverer();
        discoverer.setGenerateHtmlReport(cmd.hasOption('r'));
        IDiscovererList discos = IDiscovererListFactory.INSTANCE.createDiscovererList();
        String[] stringArray = cmd.getOptionValue('d').split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String discoId = stringArray[n2];
            Discovery discovery = BenchmarkFactory.eINSTANCE.createDiscovery();
            discovery.setDiscovererId(discoId);
            discos.add(discovery);
            ++n2;
        }
        discoverer.setDiscoverers(discos);
        if (cmd.hasOption('i')) {
            discoverer.setIterations(Integer.parseInt(cmd.getOptionValue('i')));
        } else {
            discoverer.setIterations(1);
        }
        discoverer.setMeasureMemoryUse(cmd.hasOption('m'));
        if (cmd.hasOption('n')) {
            discoverer.setMemoryPollingInterval(Integer.parseInt(cmd.getOptionValue('n')));
        }
        IProjectSet projectSet = IProjectSetFactory.INSTANCE.createProjectSet();
        if (cmd.hasOption('p')) {
            wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            String[] stringArray2 = cmd.getOptionValue('p').split(",");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String projectName = stringArray2[n4];
                IProject iProject = wsRoot.getProject(projectName);
                projectSet.add(iProject);
                ++n4;
            }
        } else {
            wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = wsRoot.getProjects();
            int n5 = iProjectArray.length;
            int n6 = 0;
            while (n6 < n5) {
                IProject iProject = iProjectArray[n6];
                projectSet.add(iProject);
                ++n6;
            }
        }
        String filePath = cmd.getOptionValue('o');
        discoverer.setTargetURI(URI.createFileURI((String)filePath));
        discoverer.setSerializeTarget(true);
        discoverer.setSizeDiscovererId(cmd.getOptionValue('s'));
        if (cmd.hasOption('r')) {
            String htmlPath = cmd.getOptionValue('r');
            discoverer.setHtmlReportLocation(URI.createFileURI((String)htmlPath));
            discoverer.setGenerateHtmlReport(true);
        } else {
            discoverer.setGenerateHtmlReport(false);
        }
        discoverer.discoverBenchmark(projectSet, (IProgressMonitor)new NullProgressMonitor());
        DebugUtils.debug((String)discoverer.getTargetURI().toString());
        return null;
    }

    private static void importExistingPrj(String[] projectParents) {
        String[] stringArray = projectParents;
        int n = projectParents.length;
        int n2 = 0;
        while (n2 < n) {
            String projectParent = stringArray[n2];
            Application.importExistingPrj(projectParent);
            ++n2;
        }
    }

    private static void importExistingPrj(String projectParent) {
        File prjParentFile = new File(projectParent);
        File[] fileArray = prjParentFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dotPrj;
            File child = fileArray[n2];
            if (child.isDirectory() && (dotPrj = new File(child, ".project")).exists()) {
                Application.importExistingPrj(dotPrj);
            }
            ++n2;
        }
    }

    private static void importExistingPrj(File dotPrj) {
        try {
            String message;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path projectDescriptionFile = new Path(dotPrj.getAbsolutePath());
            IProjectDescription prjDesc = workspace.loadProjectDescription((IPath)projectDescriptionFile);
            IWorkspaceRoot wsRoot = workspace.getRoot();
            IProject project = wsRoot.getProject(prjDesc.getName());
            if (!project.exists()) {
                message = String.format("Creating the project '%s'", prjDesc.getName());
                DebugUtils.debug((String)message);
                project.create(prjDesc, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!project.isOpen()) {
                message = String.format("Opening the project '%s'", prjDesc.getName());
                DebugUtils.debug((String)message);
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            message = String.format("Refreshing the project '%s'", prjDesc.getName());
            DebugUtils.debug((String)message);
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            String message = String.format("Failed to load '%s'", dotPrj.getAbsolutePath());
            Logger.logError((String)message, (Plugin)Activator.getDefault());
        }
    }

    public void stop() {
    }
}

