/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.editors;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.modisco.infra.browser.custom.editor.Activator;

public class MetaclassViewConfiguration {
    private static final String SORT_LINKS_SETTING = "sortLinks";
    private static final String SORT_LINKS_BY_TYPE_SETTING = "sortLinksByType";
    private static final String SHOW_DERIVED_LINKS_SETTING = "showDerivedLinks";
    private static final String SHOW_FULL_QUALIFIED_NAMES_SETTING = "showFullQualifiedNames";
    private static final String SHOW_MULTIPLICITY_SETTING = "showMultiplicity";
    private boolean sortLinks = false;
    private boolean sortLinksByType = false;
    private boolean showDerivedLinks = false;
    private boolean showMetaclassesFullQualifiedNames = false;
    private boolean showMultiplicity = false;

    public void setSortLinks(boolean sortLinks) {
        this.sortLinks = sortLinks;
    }

    public boolean isSortLinks() {
        return this.sortLinks;
    }

    public void setSortLinksByType(boolean sortLinksByType) {
        this.sortLinksByType = sortLinksByType;
    }

    public boolean isSortLinksByType() {
        return this.sortLinksByType;
    }

    public void setShowDerivedLinks(boolean showDerivedLinks) {
        this.showDerivedLinks = showDerivedLinks;
    }

    public boolean isShowDerivedLinks() {
        return this.showDerivedLinks;
    }

    public void setShowMetaclassesFullQualifiedNames(boolean showMetaclassesFullQualifiedNames) {
        this.showMetaclassesFullQualifiedNames = showMetaclassesFullQualifiedNames;
    }

    public boolean isShowMetaclassesFullQualifiedNames() {
        return this.showMetaclassesFullQualifiedNames;
    }

    public void setShowMultiplicity(boolean showMultiplicity) {
        this.showMultiplicity = showMultiplicity;
    }

    public boolean isShowMultiplicity() {
        return this.showMultiplicity;
    }

    public void load() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        this.showDerivedLinks = this.getPreference(SHOW_DERIVED_LINKS_SETTING, true, dialogSettings);
        this.sortLinks = this.getPreference(SORT_LINKS_SETTING, false, dialogSettings);
        this.sortLinksByType = this.getPreference(SORT_LINKS_BY_TYPE_SETTING, false, dialogSettings);
        this.showMultiplicity = this.getPreference(SHOW_MULTIPLICITY_SETTING, false, dialogSettings);
        this.showMetaclassesFullQualifiedNames = this.getPreference(SHOW_FULL_QUALIFIED_NAMES_SETTING, false, dialogSettings);
    }

    private boolean getPreference(String settingKey, boolean defaultValue, IDialogSettings dialogSettings) {
        String value = dialogSettings.get(settingKey);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public void save() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        dialogSettings.put(SHOW_DERIVED_LINKS_SETTING, this.showDerivedLinks);
        dialogSettings.put(SORT_LINKS_SETTING, this.sortLinks);
        dialogSettings.put(SORT_LINKS_BY_TYPE_SETTING, this.sortLinksByType);
        dialogSettings.put(SHOW_FULL_QUALIFIED_NAMES_SETTING, this.showMetaclassesFullQualifiedNames);
        dialogSettings.put(SHOW_MULTIPLICITY_SETTING, this.showMultiplicity);
    }
}

