/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.NoSuchElementException;
import prefuse.util.collections.IntIterator;

public class CompositeIntIterator
extends IntIterator {
    private IntIterator[] m_iters;
    private int m_cur;

    public CompositeIntIterator(IntIterator iter1, IntIterator iter2) {
        this(new IntIterator[]{iter1, iter2});
    }

    public CompositeIntIterator(IntIterator[] iters) {
        this.m_iters = iters;
        this.m_cur = 0;
    }

    public int nextInt() {
        if (this.hasNext()) {
            return this.m_iters[this.m_cur].nextInt();
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        if (this.m_iters == null) {
            return false;
        }
        do {
            if (!this.m_iters[this.m_cur].hasNext()) continue;
            return true;
        } while (++this.m_cur < this.m_iters.length);
        this.m_iters = null;
        return false;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

