/**
 *   Copyright (c) 2010 Mia-Software.
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *   
 *   Contributors:
 *   
 *       Nicolas Guyomar (Mia-Software) - initial API and implementation
 */
package org.eclipse.modisco.jee.webapp.webapp24;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Transport Guarantee Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 
 * 	The transport-guaranteeType specifies that the communication
 * 	between client and server should be NONE, INTEGRAL, or
 * 	CONFIDENTIAL. NONE means that the application does not
 * 	require any transport guarantees. A value of INTEGRAL means
 * 	that the application requires that the data sent between the
 * 	client and server be sent in such a way that it can't be
 * 	changed in transit. CONFIDENTIAL means that the application
 * 	requires that the data be transmitted in a fashion that
 * 	prevents other entities from observing the contents of the
 * 	transmission. In most cases, the presence of the INTEGRAL or
 * 	CONFIDENTIAL flag will indicate that the use of SSL is
 * 	required.
 * 
 * 	Used in: user-data-constraint
 * 
 *       
 * <!-- end-model-doc -->
 *
 *
 * @see org.eclipse.modisco.jee.webapp.webapp24.Webapp24Package#getTransportGuaranteeType()
 * @model extendedMetaData="name='transport-guaranteeType' kind='simple'"
 * @generated
 */
public interface TransportGuaranteeType extends org.eclipse.modisco.jee.webapp.webapp24.String {
} // TransportGuaranteeType
