/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Messages;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Benchmark;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Discovery;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.DiscoveryIteration;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Event;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.MemoryMeasurement;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Project;
import org.eclipse.modisco.utils.chart.birt.core.internal.exported.BirtGraphHelper;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Axe;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Chart;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.ChartFactory;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Coordinate;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Point;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Serie;
import org.eclipse.osgi.util.NLS;

public class BenchmarkChartGeneration {
    private final File location;
    private final boolean measureMemory;
    private final ChartFactory factory;
    private final BirtGraphHelper helper;
    public static final double MEGABYTE = 1048576.0;

    public BenchmarkChartGeneration(File location, boolean measureMemory) {
        this.location = location;
        this.measureMemory = measureMemory;
        this.factory = ChartFactory.eINSTANCE;
        this.helper = BirtGraphHelper.getInstance();
    }

    public void generateAll(Benchmark b) throws Exception {
        this.createDiscoveryTimeAsProjectSizeFull(b);
        if (this.measureMemory) {
            this.createMemoryUsedAsProjectSizeFull(b);
        }
    }

    public void createDiscoveryTimeAsProjectSizeFull(Benchmark b) throws Exception {
        this.createDiscoveryTimeAsProjectSizeOverallAveraged(b);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (testedDiscoverers.contains(d.getDiscovererId())) continue;
            this.createDiscoveryTimeAsProjectSizeAveraged(b, d);
            testedDiscoverers.add(d.getDiscovererId());
        }
    }

    private void createDiscoveryTimeAsProjectSizeAveraged(Benchmark b, Discovery d) throws Exception {
        Chart chart = this.factory.createChart();
        String title = NLS.bind((String)Messages.BenchmarkChartGeneration_AvgTimeByPrjSizeFor, (Object)d.getDiscovererId());
        chart.setTitle(title);
        Serie series = this.factory.createSerie();
        series.setName(d.getDiscovererId());
        chart.getSeries().add((Object)series);
        Axe size = this.factory.createAxe();
        Axe time = this.factory.createAxe();
        size.setLegend(Messages.BenchmarkChartGeneration_PrjSize);
        time.setUnit("secondes");
        time.setLegend(Messages.BenchmarkChartGeneration_DiscoTime);
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)time);
        for (Discovery dtemp : b.getDiscoveries()) {
            if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
            Point point = this.factory.createPoint();
            point.setSerie(series);
            Coordinate t = this.factory.createCoordinate();
            t.setAxe(size);
            Project project = (Project)dtemp.getProject();
            size.setUnit(project.getInputSizeUnit());
            t.setValue(project.getInputSize());
            Coordinate m = this.factory.createCoordinate();
            m.setAxe(time);
            m.setValue(dtemp.getDiscoveryTimeAverageInSeconds());
            point.getCoordinates().add((Object)t);
            point.getCoordinates().add((Object)m);
        }
        String fileName = String.format("avgTimeBySize_%s", d.getDiscovererId());
        File reportDir = new File(this.location, "Report");
        if (!reportDir.exists()) {
            reportDir.mkdirs();
        }
        this.helper.createBirtGraph(chart, reportDir, fileName);
    }

    private void createDiscoveryTimeAsProjectSizeOverallAveraged(Benchmark b) throws Exception {
        Chart chart = this.factory.createChart();
        chart.setTitle(Messages.BenchmarkChartGeneration_DiscoTimeByPrjSizeOverall);
        Axe size = this.factory.createAxe();
        Axe time = this.factory.createAxe();
        size.setLegend(Messages.BenchmarkChartGeneration_PrjSize);
        time.setUnit("secondes");
        time.setLegend(Messages.BenchmarkChartGeneration_DiscoTime);
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)time);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (testedDiscoverers.contains(d.getDiscovererId())) continue;
            Serie s = this.factory.createSerie();
            s.setName(d.getDiscovererId());
            chart.getSeries().add((Object)s);
            for (Discovery dtemp : b.getDiscoveries()) {
                if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
                Point p = this.factory.createPoint();
                p.setSerie(s);
                Coordinate t = this.factory.createCoordinate();
                t.setAxe(size);
                Project project = (Project)dtemp.getProject();
                size.setUnit(project.getInputSizeUnit());
                t.setValue(project.getInputSize());
                Coordinate m = this.factory.createCoordinate();
                m.setAxe(time);
                m.setValue(dtemp.getDiscoveryTimeAverageInSeconds());
                p.getCoordinates().add((Object)t);
                p.getCoordinates().add((Object)m);
            }
            testedDiscoverers.add(d.getDiscovererId());
        }
        this.helper.createBirtGraph(chart, this.location, "DiscoveryTimeByProjectSizeOverall");
    }

    public void createMemoryUsedAsProjectSizeFull(Benchmark b) throws Exception {
        this.createMemoryUsedAsProjectSizeOverallAveraged(b);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (!testedDiscoverers.contains(d.getDiscovererId())) {
                this.createMemoryUsedAsProjectSizeAveraged(b, d);
                testedDiscoverers.add(d.getDiscovererId());
            }
            for (DiscoveryIteration di : d.getIterations()) {
                this.createMemoryUseByTime(d, di);
            }
        }
    }

    private void createMemoryUsedAsProjectSizeAveraged(Benchmark b, Discovery d) throws Exception {
        Chart chart = this.factory.createChart();
        String title = NLS.bind((String)Messages.BenchmarkChartGeneration_AvgUsedMemByPrjSizeFor, (Object)d.getDiscovererId());
        chart.setTitle(title);
        Serie s = this.factory.createSerie();
        s.setName(d.getDiscovererId());
        chart.getSeries().add((Object)s);
        Axe size = this.factory.createAxe();
        Axe memory = this.factory.createAxe();
        size.setLegend(Messages.BenchmarkChartGeneration_PrjSize);
        memory.setUnit("MB");
        memory.setLegend(Messages.BenchmarkChartGeneration_UsedMem);
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)memory);
        for (Discovery dtemp : b.getDiscoveries()) {
            if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
            Point p = this.factory.createPoint();
            p.setSerie(s);
            Coordinate t = this.factory.createCoordinate();
            t.setAxe(size);
            Project project = (Project)dtemp.getProject();
            size.setUnit(project.getInputSizeUnit());
            t.setValue(project.getInputSize());
            Coordinate m = this.factory.createCoordinate();
            m.setAxe(memory);
            m.setValue((double)((DiscoveryIteration)dtemp.getIterations().get(0)).getMaxUsedMemoryInBytes() / 1048576.0);
            p.getCoordinates().add((Object)t);
            p.getCoordinates().add((Object)m);
        }
        String fileName = String.format("avgMemoryByProjectSize_%s", d.getDiscovererId());
        File reportDir = new File(this.location, "Report");
        if (!reportDir.exists()) {
            reportDir.mkdirs();
        }
        this.helper.createBirtGraph(chart, reportDir, fileName);
    }

    private void createMemoryUsedAsProjectSizeOverallAveraged(Benchmark b) throws Exception {
        Chart chart = this.factory.createChart();
        chart.setTitle(Messages.BenchmarkChartGeneration_UsedMemByPrjSize);
        Axe size = this.factory.createAxe();
        Axe memory = this.factory.createAxe();
        size.setLegend(Messages.BenchmarkChartGeneration_PrjSize);
        memory.setUnit("megabytes");
        memory.setLegend(Messages.BenchmarkChartGeneration_UsedMem);
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)memory);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (testedDiscoverers.contains(d.getDiscovererId())) continue;
            Serie s = this.factory.createSerie();
            s.setName(d.getDiscovererId());
            chart.getSeries().add((Object)s);
            for (Discovery dtemp : b.getDiscoveries()) {
                if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
                Point p = this.factory.createPoint();
                p.setSerie(s);
                Coordinate t = this.factory.createCoordinate();
                t.setAxe(size);
                Project project = (Project)dtemp.getProject();
                size.setUnit(project.getInputSizeUnit());
                t.setValue(project.getInputSize());
                Coordinate m = this.factory.createCoordinate();
                m.setAxe(memory);
                m.setValue((double)((DiscoveryIteration)dtemp.getIterations().get(0)).getMaxUsedMemoryInBytes() / 1048576.0);
                p.getCoordinates().add((Object)t);
                p.getCoordinates().add((Object)m);
            }
            testedDiscoverers.add(d.getDiscovererId());
        }
        this.helper.createBirtGraph(chart, this.location, "memoryByProjectSizeOverall");
    }

    public void createMemoryUseByTime(Discovery d, DiscoveryIteration di) throws Exception {
        Chart chart = this.factory.createChart();
        String title = NLS.bind((String)Messages.BenchmarkChartGeneration_UsedMEmByTimeForOnThe, (Object[])new Object[]{d.getDiscovererId(), d.getProject().getName(), di.getDiscoveryDate().toString()});
        chart.setTitle(title);
        Serie s = this.factory.createSerie();
        s.setName(d.getDiscovererId());
        chart.getSeries().add((Object)s);
        Axe time = this.factory.createAxe();
        Axe memory = this.factory.createAxe();
        time.setUnit("ms");
        time.setLegend(Messages.BenchmarkChartGeneration_time);
        memory.setUnit("megabytes");
        memory.setLegend(Messages.BenchmarkChartGeneration_UsedMem);
        chart.getAxes().add((Object)time);
        chart.getAxes().add((Object)memory);
        for (Event mm : di.getMemoryMeasurements()) {
            if (!(mm instanceof MemoryMeasurement)) continue;
            MemoryMeasurement mem = (MemoryMeasurement)mm;
            Point p = this.factory.createPoint();
            p.setSerie(s);
            Coordinate t = this.factory.createCoordinate();
            t.setAxe(time);
            t.setValue((double)mem.getTime());
            Coordinate m = this.factory.createCoordinate();
            m.setAxe(memory);
            m.setValue((double)mem.getMemoryUsed() / 1048576.0);
            p.getCoordinates().add((Object)t);
            p.getCoordinates().add((Object)m);
        }
        String fileName = String.format("memoryByTime-%s", Integer.toString(d.getIterations().indexOf((Object)di)));
        File reportDir = new File(this.location, "Report");
        File projectDir = new File(reportDir, d.getProject().getName());
        File targetFolder = new File(projectDir, d.getDiscovererId());
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        this.helper.createBirtGraph(chart, targetFolder, fileName);
    }
}

