/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManager;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.filters.AbstractEventFilter;
import org.eclipse.ocl.examples.eventmanager.filters.ClassFilter;
import org.eclipse.ocl.examples.eventmanager.tests.EventManagerTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.AssociationFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.AttributeFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.ClassFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.ContainmentFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.EventFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.EventTypeFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.NewValueClassFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.NewValueClassIncludingSubclassesFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.OldValueClassFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.filters.OldValueClassIncludingSubclassesFilterTest;
import org.eclipse.ocl.examples.eventmanager.tests.util.BaseTest;

public class SimpleFilterTest
extends BaseTest {
    private EventManager fixture;
    private EventManagerTest.Application app;

    public void setUp() throws Exception {
        this.fixture = EventManagerFactory.eINSTANCE.createEventManager();
        this.app = new EventManagerTest.Application();
    }

    public void tearDown() throws Exception {
        this.fixture.unsubscribe((Adapter)this.app);
        this.fixture = null;
        this.app = null;
    }

    public void testBehaviourForUnknownFilter() {
        MyClassFilter f = new MyClassFilter(null, false);
        boolean thrown = false;
        try {
            this.fixture.subscribe((EventFilter)f, (Adapter)this.app);
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        SimpleFilterTest.assertTrue((String)"No Exception thrown", (boolean)thrown);
    }

    public void assertHandleEmfEvent(EventFilterTest test) {
        this.app.reset();
        this.fixture.subscribe(test.giveTestFilter(), (Adapter)this.app);
        this.fixture.handleEMFEvent(test.giveNotMatchingNotifcation());
        SimpleFilterTest.assertFalse((String)"Get wrongly notified", (boolean)this.app.isNotified());
        this.app.reset();
        Notification[] notificationArray = test.giveMatchingNotifications();
        int n = notificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Notification n3 = notificationArray[n2];
            this.fixture.handleEMFEvent(n3);
            SimpleFilterTest.assertTrue((String)"Get not notified", (boolean)this.app.isNotified());
            this.app.reset();
            ++n2;
        }
        this.fixture.unsubscribe((Adapter)this.app);
    }

    public void assertNegatedHandleEmfEvent(EventFilterTest test) {
        EventFilter f = test.giveTestFilter();
        ((AbstractEventFilter)f).setNegated(true);
        this.app.reset();
        this.fixture.subscribe(f, (Adapter)this.app);
        this.fixture.handleEMFEvent(test.giveNotMatchingNotifcation());
        SimpleFilterTest.assertTrue((String)"Get not notfied negated", (boolean)this.app.isNotified());
        this.app.reset();
        Notification[] notificationArray = test.giveMatchingNotifications();
        int n = notificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Notification n3 = notificationArray[n2];
            this.fixture.handleEMFEvent(n3);
            SimpleFilterTest.assertFalse((String)"Get wrongly notified negated", (boolean)this.app.isNotified());
            this.app.reset();
            ++n2;
        }
        this.fixture.unsubscribe((Adapter)this.app);
    }

    public void testReferenceFilter() {
        this.assertHandleEmfEvent(new AssociationFilterTest());
        this.assertNegatedHandleEmfEvent(new AssociationFilterTest());
    }

    public void testAttributeFilter() {
        this.assertHandleEmfEvent(new AttributeFilterTest());
        this.assertNegatedHandleEmfEvent(new AttributeFilterTest());
    }

    public void testClassFilter() {
        this.assertHandleEmfEvent(new ClassFilterTest());
        this.assertNegatedHandleEmfEvent(new ClassFilterTest());
    }

    public void testContainmentFilter() {
        this.assertHandleEmfEvent(new ContainmentFilterTest());
        this.assertNegatedHandleEmfEvent(new ContainmentFilterTest());
    }

    public void testEventTypeFilter() {
        this.assertHandleEmfEvent(new EventTypeFilterTest());
        this.assertNegatedHandleEmfEvent(new EventTypeFilterTest());
    }

    public void testNewValueClassFilter() {
        this.assertHandleEmfEvent(new NewValueClassFilterTest());
        this.assertNegatedHandleEmfEvent(new NewValueClassFilterTest());
    }

    public void testNewValueClassIncludingSubclassesFilter() {
        this.assertHandleEmfEvent(new NewValueClassIncludingSubclassesFilterTest());
        this.assertNegatedHandleEmfEvent(new NewValueClassIncludingSubclassesFilterTest());
    }

    public void testOldValueClassFilter() {
        this.assertHandleEmfEvent(new OldValueClassFilterTest());
        this.assertNegatedHandleEmfEvent(new OldValueClassFilterTest());
    }

    public void testOldValueClassIncludingSubclassesFilter() {
        this.assertHandleEmfEvent(new OldValueClassIncludingSubclassesFilterTest());
        this.assertNegatedHandleEmfEvent(new OldValueClassIncludingSubclassesFilterTest());
    }

    private static class MyClassFilter
    extends ClassFilter {
        public MyClassFilter(EClass clazz, boolean negated) {
            super(clazz, negated);
        }

        public ClassFilter clone() {
            return new MyClassFilter(this.getWantedClass(), true);
        }
    }
}

