/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.uml.SetType;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;

public class InitOrDerExpressionTest
extends AbstractTestSuite {
    Class banana;
    Set<EObject> allApples;
    InstanceSpecification aFruit;
    InstanceSpecification anApple;
    InstanceSpecification anotherApple;

    public void test_init_attribute_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::name : String init: '' endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)expr.getType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_attribute_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)expr.getType());
            expr = this.parse("package ocltest context Fruit inv: name endpackage");
            InitOrDerExpressionTest.assertEquals((Object)"unknown fruit", (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals((Object)"apple", (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_init_reference_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::relatedFruits : Set(Fruit) init: Set{self} endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_reference_raw() {
        try {
            OCLExpression expr = this.parseDef("package ocltest context Fruit::relatedFruits : Set(Fruit) derive: if self.oclIsKindOf(Apple) then Apple.allInstances()->excluding(self.oclAsType(Apple)) else Fruit.allInstances()->excluding(self) endif endpackage");
            Constraint constraint = (Constraint)expr.eContainer().eContainer();
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
            expr = this.parse("package ocltest context Fruit inv: relatedFruits endpackage");
            InitOrDerExpressionTest.assertEquals(this.allApples, (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals(Collections.singleton(this.anotherApple), (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_init_attribute_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getOwnedAttribute("name", null));
        try {
            Constraint constraint = (Constraint)this.helper.createInitialValueExpression("''");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)this.getBodyExpression(constraint).getType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_attribute_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getOwnedAttribute("name", null));
        try {
            Constraint constraint = (Constraint)this.helper.createDerivedValueExpression("if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertSame((Object)this.getOCLStandardLibrary().getString(), (Object)this.getBodyExpression(constraint).getType());
            OCLExpression expr = this.helper.createQuery("name");
            InitOrDerExpressionTest.assertEquals((Object)"unknown fruit", (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals((Object)"apple", (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_init_reference_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getOwnedAttribute("relatedFruits", null));
        try {
            Constraint constraint = (Constraint)this.helper.createInitialValueExpression("Set{self}");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            OCLExpression expr = this.getBodyExpression(constraint);
            InitOrDerExpressionTest.assertEquals((String)"initial", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_derive_reference_helper() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getOwnedAttribute("relatedFruits", null));
        try {
            Constraint constraint = (Constraint)this.helper.createDerivedValueExpression("if self.oclIsKindOf(Apple) then Apple.allInstances()->excluding(self.oclAsType(Apple)) else Fruit.allInstances()->excluding(self) endif");
            InitOrDerExpressionTest.assertNotNull((Object)constraint);
            OCLExpression expr = this.getBodyExpression(constraint);
            InitOrDerExpressionTest.assertEquals((String)"derivation", (String)this.getStereotype(constraint));
            InitOrDerExpressionTest.assertTrue((boolean)(expr.getType() instanceof SetType));
            InitOrDerExpressionTest.assertSame((Object)this.fruit, (Object)((SetType)expr.getType()).getElementType());
            expr = this.helper.createQuery("relatedFruits");
            InitOrDerExpressionTest.assertEquals(this.allApples, (Object)this.ocl.evaluate((Object)this.aFruit, expr));
            InitOrDerExpressionTest.assertEquals(Collections.singleton(this.anotherApple), (Object)this.ocl.evaluate((Object)this.anApple, expr));
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_malformedInitExpression() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getOwnedAttribute("relatedFruits", null));
        try {
            this.helper.createInitialValueExpression("if self.oclIsKindOf(Apple) then 'apple' else 'fruit' endif");
            InitOrDerExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            InitOrDerExpressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_malformedDeriveExpression() {
        this.helper.setAttributeContext((Object)this.fruit, (Object)this.fruit.getOwnedAttribute("relatedFruits", null));
        try {
            this.helper.createDerivedValueExpression("if self.oclIsKindOf(Apple) then 'apple' else 'fruit' endif");
            InitOrDerExpressionTest.fail((String)"Should not have parsed");
        }
        catch (Exception e) {
            InitOrDerExpressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
    }

    public void test_bothInitAndDeriveExpressions() {
        try {
            this.parseDef("package ocltest context Fruit::name : String init: 'not a fruit' derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif  endpackage");
            this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif init: 'not a fruit'  endpackage");
        }
        catch (Exception e) {
            InitOrDerExpressionTest.fail((String)("Should not have failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_tooManyInitAndDeriveExpressions() {
        AssertionFailedError err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String init: 'not a fruit' init: 'not a fruit'  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            InitOrDerExpressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            InitOrDerExpressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String init: 'not a fruit' derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif init: 'not a fruit'  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            InitOrDerExpressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
        try {
            this.parseDef("package ocltest context Fruit::name : String derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif init: 'not a fruit' derive: if self.oclIsKindOf(Apple) then 'apple' else 'unknown fruit' endif  endpackage");
        }
        catch (AssertionFailedError e) {
            err = e;
            InitOrDerExpressionTest.debugPrintln((String)("Got expected error: " + e.getLocalizedMessage()));
        }
        InitOrDerExpressionTest.assertNotNull((String)"Should not have successfully parsed", (Object)((Object)err));
        err = null;
    }

    protected void setUp() {
        super.setUp();
        this.banana = ((Package)this.fruitPackage).createOwnedClass("Banana", false);
        this.banana.createGeneralization((Classifier)this.fruit);
        this.aFruit = this.instantiate((Package)this.fruitPackage, (Classifier)this.banana);
        this.anApple = this.instantiate((Package)this.fruitPackage, (Classifier)this.apple);
        this.anotherApple = this.instantiate((Package)this.fruitPackage, (Classifier)this.apple);
        this.allApples = new HashSet<EObject>();
        this.allApples.add((EObject)this.anApple);
        this.allApples.add((EObject)this.anotherApple);
        this.expectModified = true;
    }
}

