/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.expressions.LetExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class PrecedenceTest
extends AbstractTestSuite {
    Resource res;
    Package pkg;
    Class class1;

    public void test_let() {
        this.helper.setContext((Object)this.class1);
        try {
            this.helper.createInvariant("self.base_Property.redefinedProperty->isEmpty() = false implies \n   self.base_Property.redefinedProperty->size() = 1 and\n   let rp : UML::Property =\n            self.base_Property.redefinedProperty->asSequence()->at(1) in \n     self.base_Property.name = rp.name and\n     self.base_Property.type = rp.type");
        }
        catch (Exception e) {
            PrecedenceTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        this.helper.setContext((Object)((Classifier)this.getMetaclass("NamedElement")));
        try {
            this.helper.createInvariant("namespace.getNamesOfMember(\n   let ne : NamedElement = self in ne)->exists(n |\n       let len : Integer = n.size() in len = 1)");
        }
        catch (Exception e) {
            PrecedenceTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_let_inExpression_182201() {
        this.helper.setContext((Object)((Classifier)this.getMetaclass("NamedElement")));
        OCLExpression expr = null;
        try {
            expr = this.helper.createQuery("let ne : NamedElement = self in ne.name");
        }
        catch (Exception e) {
            PrecedenceTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        PrecedenceTest.assertNotNull((Object)expr);
        PrecedenceTest.assertTrue((boolean)(expr instanceof LetExp));
        LetExp letExp = (LetExp)expr;
        PrecedenceTest.assertTrue((boolean)(letExp.getIn() instanceof PropertyCallExp));
        try {
            expr = this.helper.createQuery("let n : String = let ne : NamedElement = self in ne.name in n.size()");
        }
        catch (Exception e) {
            PrecedenceTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        PrecedenceTest.assertNotNull((Object)expr);
        PrecedenceTest.assertTrue((boolean)(expr instanceof LetExp));
        letExp = (LetExp)expr;
        PrecedenceTest.assertTrue((boolean)(letExp.getIn() instanceof OperationCallExp));
        OperationCallExp opCall = (OperationCallExp)letExp.getIn();
        PrecedenceTest.assertEquals((String)"size", (String)((Operation)opCall.getReferredOperation()).getName());
        expr = letExp.getVariable().getInitExpression();
        PrecedenceTest.assertTrue((boolean)(expr instanceof LetExp));
        letExp = (LetExp)letExp.getVariable().getInitExpression();
        PrecedenceTest.assertTrue((boolean)(letExp.getIn() instanceof PropertyCallExp));
        try {
            expr = this.helper.createQuery("let ne : NamedElement = self in let n : String = ne.name in n.size()");
        }
        catch (Exception e) {
            PrecedenceTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
        PrecedenceTest.assertNotNull((Object)expr);
        PrecedenceTest.assertTrue((boolean)(expr instanceof LetExp));
        letExp = (LetExp)expr;
        PrecedenceTest.assertTrue((boolean)(letExp.getIn() instanceof LetExp));
        letExp = (LetExp)letExp.getIn();
        PrecedenceTest.assertTrue((boolean)(letExp.getIn() instanceof OperationCallExp));
        OperationCallExp opCall2 = (OperationCallExp)letExp.getIn();
        PrecedenceTest.assertEquals((String)"size", (String)((Operation)opCall2.getReferredOperation()).getName());
    }

    public void test_equality_relational_179249() {
        this.helper.setContext((Object)this.class1);
        try {
            this.helper.createInvariant("1 < 2 = true");
        }
        catch (Exception e) {
            PrecedenceTest.fail((String)("Failed to parse: " + e.getLocalizedMessage()));
        }
    }

    public void test_or_and_precedence() throws ParserException {
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE, (Object)ProblemHandler.Severity.OK);
        this.helper.setContext((Object)this.class1);
        this.assertTrueWithoutWarning("(true or (false and false)) = true");
        this.assertTrueWithoutWarning("(true or false.\"and\"(false)) = true");
        this.assertTrueWithoutWarning("((true or false) and false) = false");
        this.assertTrueWithoutWarning("(true or false and false) = true");
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ParsingOptions.WARN_OF_XOR_OR_AND_PRECEDENCE_CHANGE, (Object)true);
        this.assertTrueWithoutWarning("(true or (false and false)) = true");
        this.assertTrueWithoutWarning("(true or false.\"and\"(false)) = true");
        this.assertTrueWithoutWarning("((true or false) and false) = false");
        this.assertTrueWithWarning("(true or false and false) = true", OCLMessages.XorOrAndPrecedence_WARNING);
    }

    public void test_xor_or_precedence() throws ParserException {
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ProblemOption.ELEMENT_NAME_QUOTE_ESCAPE, (Object)ProblemHandler.Severity.OK);
        this.helper.setContext((Object)this.class1);
        this.assertTrueWithoutWarning("(true xor (false or false)) = true");
        this.assertTrueWithoutWarning("(true xor false.\"or\"(false)) = true");
        this.assertTrueWithoutWarning("((true xor false) or true) = true");
        this.assertTrueWithoutWarning("(true xor false or true) = false");
        ParsingOptions.setOption((Environment)this.helper.getEnvironment(), (Option)ParsingOptions.WARN_OF_XOR_OR_AND_PRECEDENCE_CHANGE, (Object)true);
        this.assertTrueWithoutWarning("(true xor (false or false)) = true");
        this.assertTrueWithoutWarning("(true xor false.\"or\"(false)) = true");
        this.assertTrueWithoutWarning("((true xor false) or true) = true");
        this.assertTrueWithWarning("(true xor false or true) = false", OCLMessages.XorOrAndPrecedence_WARNING);
    }

    protected void assertTrueWithWarning(String expression, String warning) throws ParserException {
        this.helper.createInvariant(expression);
        try {
            OCLUtil.checkForErrorsOrWarnings((Environment)this.helper.getEnvironment());
            PrecedenceTest.fail((String)("Missing warning: " + warning));
        }
        catch (SemanticException e) {
            PrecedenceTest.debugPrintln((String)("Got expected warning: " + e.getLocalizedMessage()));
            PrecedenceTest.assertEquals((String)warning, (String)e.getMessage());
        }
    }

    protected void assertTrueWithoutWarning(String expression) throws ParserException {
        this.helper.createInvariant(expression);
        OCLUtil.checkForErrorsOrWarnings((Environment)this.helper.getEnvironment());
    }

    protected void setUp() {
        super.setUp();
        this.res = new ResourceImpl(URI.createURI((String)"foo://uml"));
        this.pkg = UMLFactory.eINSTANCE.createPackage();
        this.pkg.setName("testpkg");
        this.res.getContents().add((Object)this.pkg);
        this.class1 = this.pkg.createOwnedClass("Class1", false);
        this.class1.createOwnedAttribute("base_Property", (Type)this.getMetaclass("Property"));
    }
}

