/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.HashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.uml.BagType;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.OrderedSetType;
import org.eclipse.ocl.uml.SequenceType;
import org.eclipse.ocl.uml.SetType;
import org.eclipse.ocl.uml.UMLFactory;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;

public class TypesValidatorTest
extends AbstractTestSuite {
    UMLFactory factory = UMLFactory.eINSTANCE;

    public void test_CollectionType_checkCollectionTypeName() {
        CollectionType type = this.factory.createCollectionType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 2);
        type.setName("Collection(Integer)");
        this.assertProblem((EObject)type, 2);
        type.setName("Sequence(Fruit)");
        this.assertProblem((EObject)type, 2);
    }

    public void test_BagType_checkCollectionTypeName() {
        BagType type = this.factory.createBagType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 1);
        type.setName("Bag(Integer)");
        this.assertProblem((EObject)type, 1);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 1);
    }

    public void test_SetType_checkCollectionTypeName() {
        SetType type = this.factory.createSetType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 9);
        type.setName("Set(Integer)");
        this.assertProblem((EObject)type, 9);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 9);
    }

    public void test_SequenceType_checkCollectionTypeName() {
        SequenceType type = this.factory.createSequenceType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 8);
        type.setName("Sequence(Integer)");
        this.assertProblem((EObject)type, 8);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 8);
    }

    public void test_OrderedSetType_checkCollectionTypeName() {
        OrderedSetType type = this.factory.createOrderedSetType();
        type.setElementType((Object)this.fruit);
        this.assertOK((EObject)type, 7);
        type.setName("OrderedSet(Integer)");
        this.assertProblem((EObject)type, 7);
        type.setName("Collection(Fruit)");
        this.assertProblem((EObject)type, 7);
    }

    public void test_emptyCollectionType_196972() {
        URI uri = this.getTestModelURI("/model/VoidCollectionTypes.uml");
        Resource res = resourceSet.getResource(uri, true);
        Package epackage = (Package)res.getContents().get(0);
        CollectionType setType = (CollectionType)epackage.getOwnedType("Set(T)");
        Classifier oclVoid = (Classifier)this.getOCLStandardLibrary().getOclVoid();
        Classifier elementType = (Classifier)setType.getElementType();
        TypesValidatorTest.assertSame((Object)oclVoid, (Object)elementType);
        this.assertProblem((EObject)setType, 9);
        CollectionType bagType = (CollectionType)epackage.getOwnedType("Bag(OclVoid)");
        TypesValidatorTest.assertSame((Object)oclVoid, (Object)bagType.getElementType());
        this.assertOK((EObject)setType, 1);
        CollectionType collectionType = this.factory.createCollectionType();
        collectionType.setElementType((Object)oclVoid);
        this.assertOK((EObject)collectionType, 2);
        setType = this.factory.createSetType();
        setType.setElementType((Object)oclVoid);
        this.assertOK((EObject)setType, 9);
        OrderedSetType orderedSetType = this.factory.createOrderedSetType();
        orderedSetType.setElementType((Object)oclVoid);
        this.assertOK((EObject)orderedSetType, 7);
        bagType = this.factory.createBagType();
        bagType.setElementType((Object)oclVoid);
        this.assertOK((EObject)bagType, 1);
        SequenceType sequenceType = this.factory.createSequenceType();
        sequenceType.setElementType((Object)oclVoid);
        this.assertOK((EObject)sequenceType, 8);
    }

    protected Diagnostic validate(EObject target) {
        HashMap<Class<Environment>, Environment> ctx = new HashMap<Class<Environment>, Environment>();
        ctx.put(Environment.class, this.ocl.getEnvironment());
        return Diagnostician.INSTANCE.validate(target, ctx);
    }

    protected void assertProblem(EObject target, int code) {
        this.assertProblem(this.validate(target), target, code);
    }

    protected void assertProblem(Diagnostic diagnostic, EObject target, int code) {
        Diagnostic problem = this.findProblem(diagnostic, target, code);
        TypesValidatorTest.assertNotNull((String)"Problem not found", (Object)problem);
        TypesValidatorTest.debugPrintln((String)("Found expected problem: " + problem.getMessage()));
    }

    protected Diagnostic findProblem(Diagnostic diagnostic, EObject target, int code) {
        if ("org.eclipse.ocl.types".equals(diagnostic.getSource()) && diagnostic.getSeverity() != 0 && diagnostic.getData().contains(target) && diagnostic.getCode() == code) {
            return diagnostic;
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            Diagnostic result = this.findProblem(child, target, code);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected Diagnostic findProblem(Diagnostic diagnostic, EObject target) {
        if ("org.eclipse.ocl.types".equals(diagnostic.getSource()) && diagnostic.getSeverity() != 0 && diagnostic.getData().contains(target)) {
            return diagnostic;
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            Diagnostic result = this.findProblem(child, target);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected void assertOK(EObject target, int code) {
        this.assertOK(this.validate(target), target, code);
    }

    protected void assertOK(Diagnostic diagnostic, EObject target, int code) {
        TypesValidatorTest.assertNull((String)"Problem found", (Object)this.findProblem(diagnostic, target, code));
    }

    protected void assertOK(EObject target) {
        this.assertOK(this.validate(target), target);
    }

    protected void assertOK(Diagnostic diagnostic, EObject target) {
        TypesValidatorTest.assertNull((String)"Problem found", (Object)this.findProblem(diagnostic, target));
    }
}

