/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests.framework;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ocl.examples.eventmanager.tests.util.BaseTest;
import org.eclipse.ocl.examples.eventmanager.util.CompositeCollection;
import org.eclipse.ocl.examples.eventmanager.util.CompositeSet;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeSetTest
extends BaseTest {
    private Set<Integer> emptySet = Collections.emptySet();
    private Set<Integer> firstSet;
    private Set<Integer> secondSet;

    @Before
    public void setUp() {
        this.firstSet = new HashSet<Integer>();
        this.firstSet.add(1);
        this.firstSet.add(2);
        this.firstSet.add(3);
        this.secondSet = new HashSet<Integer>();
        this.secondSet.add(4);
        this.secondSet.add(5);
        this.secondSet.add(6);
    }

    @Test
    public void testEmpty() {
        CompositeSet cs = new CompositeSet(new Set[0]);
        CompositeSetTest.assertTrue((boolean)cs.isEmpty());
        CompositeSetTest.assertEquals((int)0, (int)cs.size());
    }

    @Test
    public void testSimpleSet() {
        CompositeSet cs = new CompositeSet(new Set[]{this.firstSet});
        CompositeSetTest.assertFalse((boolean)cs.isEmpty());
        CompositeSetTest.assertEquals((int)this.firstSet.size(), (int)cs.size());
        CompositeSetTest.assertTrue((boolean)this.firstSet.containsAll((Collection<?>)cs));
        CompositeSetTest.assertTrue((boolean)cs.containsAll(this.firstSet));
        CompositeSetTest.assertEquals((Object)cs, this.firstSet);
    }

    @Test
    public void testTwoSets() {
        CompositeSet cs = new CompositeSet(new Set[]{this.firstSet, this.secondSet});
        CompositeSetTest.assertFalse((boolean)cs.isEmpty());
        CompositeSetTest.assertEquals((int)(this.firstSet.size() + this.secondSet.size()), (int)cs.size());
        CompositeSetTest.assertTrue((boolean)cs.containsAll(this.firstSet));
        CompositeSetTest.assertTrue((boolean)cs.containsAll(this.secondSet));
        this.assertContainsAll((CompositeCollection)cs, (Collection)this.firstSet);
        this.assertContainsAll((CompositeCollection)cs, (Collection)this.secondSet);
    }

    @Test
    public void testIntermittentEmptySets() {
        CompositeSet cs = new CompositeSet(new Set[]{this.emptySet, this.firstSet, this.emptySet, this.secondSet, this.emptySet});
        CompositeSetTest.assertFalse((boolean)cs.isEmpty());
        CompositeSetTest.assertEquals((int)(this.firstSet.size() + this.secondSet.size()), (int)cs.size());
        CompositeSetTest.assertTrue((boolean)cs.containsAll(this.firstSet));
        CompositeSetTest.assertTrue((boolean)cs.containsAll(this.secondSet));
        this.assertContainsAll((CompositeCollection)cs, (Collection)this.firstSet);
        this.assertContainsAll((CompositeCollection)cs, (Collection)this.secondSet);
    }

    private <T> void assertContainsAll(CompositeCollection<T> cs, Collection<T> other) {
        HashSet<T> notFound = new HashSet<T>(other);
        for (Object t : cs) {
            notFound.remove(t);
        }
        CompositeSetTest.assertEquals((String)("Didn't find elements " + notFound + " in composite set's iterator"), (int)0, (int)notFound.size());
    }
}

