/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.DataTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.ids.TemplateableTypeId;
import org.eclipse.ocl.pivot.internal.ids.GeneralizedNestedTypeIdImpl;
import org.eclipse.ocl.pivot.internal.ids.SpecializedDataTypeIdImpl;

public class GeneralizedDataTypeIdImpl
extends GeneralizedNestedTypeIdImpl
implements DataTypeId {
    private static int computeHashCode(@NonNull ElementId parentId, int templateParameters, @NonNull String name) {
        return IdHash.createChildHash(parentId, name) + 11 * templateParameters;
    }

    public GeneralizedDataTypeIdImpl(@NonNull PackageId parentId, int templateParameters, @NonNull String name) {
        super(GeneralizedDataTypeIdImpl.computeHashCode(parentId, templateParameters, name), parentId, templateParameters, name);
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitDataTypeId(this);
    }

    @Override
    protected @NonNull TemplateableTypeId createSpecializedId(@NonNull BindingsId templateBindings) {
        return new SpecializedDataTypeIdImpl(this, templateBindings);
    }

    @Override
    public @NonNull String getMetaTypeName() {
        return "DataType";
    }

    public static class DataTypeIdSingletonScope
    extends AbstractSingletonScope<DataTypeId, DataTypeIdValue> {
        public @NonNull DataTypeId getSingleton(@NonNull PackageId packageId, @NonNull String name, int templateParameters) {
            return this.getSingletonFor(new DataTypeIdValue(packageId, name, templateParameters));
        }
    }

    private static class DataTypeIdValue
    extends SingletonScope.AbstractKeyAndValue<DataTypeId> {
        private @NonNull PackageId packageId;
        private @NonNull String name;
        private int templateParameters;

        private DataTypeIdValue(@NonNull PackageId packageId, @NonNull String name, int templateParameters) {
            super(GeneralizedDataTypeIdImpl.computeHashCode(packageId, templateParameters, name));
            this.packageId = packageId;
            this.name = name;
            this.templateParameters = templateParameters;
        }

        @Override
        public @NonNull DataTypeId createSingleton() {
            return new GeneralizedDataTypeIdImpl(this.packageId, this.templateParameters, this.name);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof GeneralizedDataTypeIdImpl) {
                GeneralizedDataTypeIdImpl singleton = (GeneralizedDataTypeIdImpl)that;
                return this.name.equals(singleton.getName()) && this.templateParameters == singleton.getTemplateParameters();
            }
            return false;
        }
    }
}

