/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.PartialProperties;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class ExplicitNavigationProperty
extends AbstractProperty {
    protected @NonNull Property property;
    protected @NonNull PropertyId propertyId;
    private EStructuralFeature eFeature;

    public ExplicitNavigationProperty(@NonNull Property property) {
        this.property = property;
        this.propertyId = property.getPropertyId();
        EObject esObject = property.getESObject();
        this.eFeature = esObject instanceof EStructuralFeature ? (EStructuralFeature)esObject : null;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        Object eValue;
        TemplateableElement rawType;
        EObject eObject = ExplicitNavigationProperty.asNavigableObject(sourceValue, (Object)this.propertyId, executor);
        EStructuralFeature eFeature2 = this.eFeature;
        if (eFeature2 == null) {
            Iterable<Property> partials;
            CompleteClass completeClass = executor.getEnvironmentFactory().getCompleteModel().getCompleteClass(PivotUtil.getOwningClass(this.property));
            Iterable<@NonNull Property> properties = completeClass.getProperties(this.property);
            if (properties instanceof PartialProperties && (partials = ((PartialProperties)properties).getPartials()) != null) {
                for (Property partialProperty : partials) {
                    EObject esObject = partialProperty.getESObject();
                    if (!(esObject instanceof EStructuralFeature)) continue;
                    eFeature2 = (EStructuralFeature)esObject;
                    break;
                }
            }
            if (eFeature2 == null) {
                return null;
            }
            this.eFeature = eFeature2;
        }
        if (eObject instanceof TemplateableElement && !eObject.eIsSet(eFeature2) && (rawType = ((TemplateableElement)eObject).getUnspecializedElement()) != null) {
            eObject = rawType;
        }
        if ((eValue = eObject.eGet(eFeature2, true)) != null) {
            return executor.getIdResolver().boxedValueOf(eValue, (ETypedElement)eFeature2, returnTypeId);
        }
        return null;
    }
}

