/*******************************************************************************
 * Copyright (c) 2011, 2021 Willink Transformations and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     E.D.Willink - initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.xtext.oclinecore.ui.contentassist.antlr;

import java.util.Collection;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.RecognitionException;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.AbstractContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;

import com.google.inject.Inject;

import org.eclipse.ocl.xtext.oclinecore.services.OCLinEcoreGrammarAccess;

public class OCLinEcoreParser extends AbstractContentAssistParser {

	@Inject
	private OCLinEcoreGrammarAccess grammarAccess;

	private Map<AbstractElement, String> nameMappings;

	@Override
	protected org.eclipse.ocl.xtext.oclinecore.ui.contentassist.antlr.internal.InternalOCLinEcoreParser createParser() {
		org.eclipse.ocl.xtext.oclinecore.ui.contentassist.antlr.internal.InternalOCLinEcoreParser result = new org.eclipse.ocl.xtext.oclinecore.ui.contentassist.antlr.internal.InternalOCLinEcoreParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		if (nameMappings == null) {
			nameMappings = new HashMap<AbstractElement, String>() {
				private static final long serialVersionUID = 1L;
				{
					put(grammarAccess.getEnumerationLiteralNameAccess().getAlternatives(), "rule__EnumerationLiteralName__Alternatives");
					put(grammarAccess.getInvariantConstraintCSAccess().getAlternatives_3(), "rule__InvariantConstraintCS__Alternatives_3");
					put(grammarAccess.getAnnotationCSAccess().getNameAlternatives_2_0(), "rule__AnnotationCS__NameAlternatives_2_0");
					put(grammarAccess.getAnnotationCSAccess().getAlternatives_4(), "rule__AnnotationCS__Alternatives_4");
					put(grammarAccess.getAnnotationCSAccess().getAlternatives_4_0_1(), "rule__AnnotationCS__Alternatives_4_0_1");
					put(grammarAccess.getAnnotationElementCSAccess().getAlternatives(), "rule__AnnotationElementCS__Alternatives");
					put(grammarAccess.getAttributeCSAccess().getAlternatives_0(), "rule__AttributeCS__Alternatives_0");
					put(grammarAccess.getAttributeCSAccess().getAlternatives_5_1_0(), "rule__AttributeCS__Alternatives_5_1_0");
					put(grammarAccess.getAttributeCSAccess().getAlternatives_6(), "rule__AttributeCS__Alternatives_6");
					put(grammarAccess.getAttributeCSAccess().getAlternatives_6_0_1(), "rule__AttributeCS__Alternatives_6_0_1");
					put(grammarAccess.getClassCSAccess().getAlternatives(), "rule__ClassCS__Alternatives");
					put(grammarAccess.getDataTypeCSAccess().getAlternatives_5_1(), "rule__DataTypeCS__Alternatives_5_1");
					put(grammarAccess.getDataTypeCSAccess().getAlternatives_6(), "rule__DataTypeCS__Alternatives_6");
					put(grammarAccess.getDataTypeCSAccess().getAlternatives_6_0_1(), "rule__DataTypeCS__Alternatives_6_0_1");
					put(grammarAccess.getDetailCSAccess().getNameAlternatives_0_0(), "rule__DetailCS__NameAlternatives_0_0");
					put(grammarAccess.getDetailCSAccess().getValuesAlternatives_2_0(), "rule__DetailCS__ValuesAlternatives_2_0");
					put(grammarAccess.getEnumerationCSAccess().getAlternatives_4_1(), "rule__EnumerationCS__Alternatives_4_1");
					put(grammarAccess.getEnumerationCSAccess().getAlternatives_5(), "rule__EnumerationCS__Alternatives_5");
					put(grammarAccess.getEnumerationCSAccess().getAlternatives_5_0_1(), "rule__EnumerationCS__Alternatives_5_0_1");
					put(grammarAccess.getEnumerationLiteralCSAccess().getAlternatives_0(), "rule__EnumerationLiteralCS__Alternatives_0");
					put(grammarAccess.getEnumerationLiteralCSAccess().getAlternatives_3(), "rule__EnumerationLiteralCS__Alternatives_3");
					put(grammarAccess.getImportCSAccess().getAlternatives_0(), "rule__ImportCS__Alternatives_0");
					put(grammarAccess.getModelElementCSAccess().getAlternatives(), "rule__ModelElementCS__Alternatives");
					put(grammarAccess.getOperationCSAccess().getAlternatives_0(), "rule__OperationCS__Alternatives_0");
					put(grammarAccess.getOperationCSAccess().getAlternatives_9_1_0(), "rule__OperationCS__Alternatives_9_1_0");
					put(grammarAccess.getOperationCSAccess().getAlternatives_10(), "rule__OperationCS__Alternatives_10");
					put(grammarAccess.getOperationCSAccess().getAlternatives_10_0_1(), "rule__OperationCS__Alternatives_10_0_1");
					put(grammarAccess.getPackageCSAccess().getAlternatives_4(), "rule__PackageCS__Alternatives_4");
					put(grammarAccess.getPackageCSAccess().getAlternatives_4_0_1(), "rule__PackageCS__Alternatives_4_0_1");
					put(grammarAccess.getParameterCSAccess().getAlternatives_2_1_0(), "rule__ParameterCS__Alternatives_2_1_0");
					put(grammarAccess.getImplicitOppositeCSAccess().getAlternatives_4_1_0(), "rule__ImplicitOppositeCS__Alternatives_4_1_0");
					put(grammarAccess.getReferenceCSAccess().getAlternatives_0(), "rule__ReferenceCS__Alternatives_0");
					put(grammarAccess.getReferenceCSAccess().getAlternatives_6_1_0(), "rule__ReferenceCS__Alternatives_6_1_0");
					put(grammarAccess.getReferenceCSAccess().getAlternatives_7(), "rule__ReferenceCS__Alternatives_7");
					put(grammarAccess.getReferenceCSAccess().getAlternatives_7_0_1(), "rule__ReferenceCS__Alternatives_7_0_1");
					put(grammarAccess.getSpecificationCSAccess().getAlternatives(), "rule__SpecificationCS__Alternatives");
					put(grammarAccess.getStructuredClassCSAccess().getAlternatives_7(), "rule__StructuredClassCS__Alternatives_7");
					put(grammarAccess.getStructuredClassCSAccess().getAlternatives_7_0_1(), "rule__StructuredClassCS__Alternatives_7_0_1");
					put(grammarAccess.getStructuralFeatureCSAccess().getAlternatives(), "rule__StructuralFeatureCS__Alternatives");
					put(grammarAccess.getSysMLCSAccess().getAlternatives_2(), "rule__SysMLCS__Alternatives_2");
					put(grammarAccess.getTypeIdentifierAccess().getAlternatives(), "rule__TypeIdentifier__Alternatives");
					put(grammarAccess.getTemplateSignatureCSAccess().getAlternatives(), "rule__TemplateSignatureCS__Alternatives");
					put(grammarAccess.getTypedRefCSAccess().getAlternatives(), "rule__TypedRefCS__Alternatives");
					put(grammarAccess.getTypedTypeRefCSAccess().getAlternatives_1(), "rule__TypedTypeRefCS__Alternatives_1");
					put(grammarAccess.getUnrestrictedNameAccess().getAlternatives(), "rule__UnrestrictedName__Alternatives");
					put(grammarAccess.getEssentialOCLReservedKeywordAccess().getAlternatives(), "rule__EssentialOCLReservedKeyword__Alternatives");
					put(grammarAccess.getEssentialOCLUnaryOperatorNameAccess().getAlternatives(), "rule__EssentialOCLUnaryOperatorName__Alternatives");
					put(grammarAccess.getEssentialOCLInfixOperatorNameAccess().getAlternatives(), "rule__EssentialOCLInfixOperatorName__Alternatives");
					put(grammarAccess.getEssentialOCLNavigationOperatorNameAccess().getAlternatives(), "rule__EssentialOCLNavigationOperatorName__Alternatives");
					put(grammarAccess.getBinaryOperatorNameAccess().getAlternatives(), "rule__BinaryOperatorName__Alternatives");
					put(grammarAccess.getEssentialOCLUnreservedNameAccess().getAlternatives(), "rule__EssentialOCLUnreservedName__Alternatives");
					put(grammarAccess.getURIFirstPathElementCSAccess().getAlternatives(), "rule__URIFirstPathElementCS__Alternatives");
					put(grammarAccess.getPrimitiveTypeIdentifierAccess().getAlternatives(), "rule__PrimitiveTypeIdentifier__Alternatives");
					put(grammarAccess.getCollectionTypeIdentifierAccess().getAlternatives(), "rule__CollectionTypeIdentifier__Alternatives");
					put(grammarAccess.getCollectionLiteralPartCSAccess().getAlternatives(), "rule__CollectionLiteralPartCS__Alternatives");
					put(grammarAccess.getShadowPartCSAccess().getAlternatives(), "rule__ShadowPartCS__Alternatives");
					put(grammarAccess.getShadowPartCSAccess().getOwnedInitExpressionAlternatives_0_2_0(), "rule__ShadowPartCS__OwnedInitExpressionAlternatives_0_2_0");
					put(grammarAccess.getPrimitiveLiteralExpCSAccess().getAlternatives(), "rule__PrimitiveLiteralExpCS__Alternatives");
					put(grammarAccess.getBooleanLiteralExpCSAccess().getAlternatives(), "rule__BooleanLiteralExpCS__Alternatives");
					put(grammarAccess.getTypeLiteralCSAccess().getAlternatives(), "rule__TypeLiteralCS__Alternatives");
					put(grammarAccess.getTypeExpWithoutMultiplicityCSAccess().getAlternatives(), "rule__TypeExpWithoutMultiplicityCS__Alternatives");
					put(grammarAccess.getExpCSAccess().getAlternatives(), "rule__ExpCS__Alternatives");
					put(grammarAccess.getPrefixedLetExpCSAccess().getAlternatives(), "rule__PrefixedLetExpCS__Alternatives");
					put(grammarAccess.getPrefixedPrimaryExpCSAccess().getAlternatives(), "rule__PrefixedPrimaryExpCS__Alternatives");
					put(grammarAccess.getPrimaryExpCSAccess().getAlternatives(), "rule__PrimaryExpCS__Alternatives");
					put(grammarAccess.getRoundBracketedClauseCSAccess().getOwnedArgumentsAlternatives_2_1_0(), "rule__RoundBracketedClauseCS__OwnedArgumentsAlternatives_2_1_0");
					put(grammarAccess.getNavigatingArgCSAccess().getAlternatives(), "rule__NavigatingArgCS__Alternatives");
					put(grammarAccess.getNavigatingArgCSAccess().getAlternatives_0_1(), "rule__NavigatingArgCS__Alternatives_0_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getAlternatives_2(), "rule__NavigatingCommaArgCS__Alternatives_2");
					put(grammarAccess.getIfExpCSAccess().getOwnedConditionAlternatives_1_0(), "rule__IfExpCS__OwnedConditionAlternatives_1_0");
					put(grammarAccess.getMultiplicityCSAccess().getAlternatives_1(), "rule__MultiplicityCS__Alternatives_1");
					put(grammarAccess.getMultiplicityCSAccess().getAlternatives_2(), "rule__MultiplicityCS__Alternatives_2");
					put(grammarAccess.getMultiplicityStringCSAccess().getStringBoundsAlternatives_0(), "rule__MultiplicityStringCS__StringBoundsAlternatives_0");
					put(grammarAccess.getTypeRefCSAccess().getAlternatives(), "rule__TypeRefCS__Alternatives");
					put(grammarAccess.getIDAccess().getAlternatives(), "rule__ID__Alternatives");
					put(grammarAccess.getUPPERAccess().getAlternatives(), "rule__UPPER__Alternatives");
					put(grammarAccess.getTopLevelCSAccess().getGroup(), "rule__TopLevelCS__Group__0");
					put(grammarAccess.getTopLevelCSAccess().getGroup_1(), "rule__TopLevelCS__Group_1__0");
					put(grammarAccess.getSIGNEDAccess().getGroup(), "rule__SIGNED__Group__0");
					put(grammarAccess.getInvariantConstraintCSAccess().getGroup(), "rule__InvariantConstraintCS__Group__0");
					put(grammarAccess.getInvariantConstraintCSAccess().getGroup_2(), "rule__InvariantConstraintCS__Group_2__0");
					put(grammarAccess.getInvariantConstraintCSAccess().getGroup_2_1(), "rule__InvariantConstraintCS__Group_2_1__0");
					put(grammarAccess.getInvariantConstraintCSAccess().getGroup_3_0(), "rule__InvariantConstraintCS__Group_3_0__0");
					put(grammarAccess.getPostconditionConstraintCSAccess().getGroup(), "rule__PostconditionConstraintCS__Group__0");
					put(grammarAccess.getPostconditionConstraintCSAccess().getGroup_1(), "rule__PostconditionConstraintCS__Group_1__0");
					put(grammarAccess.getPostconditionConstraintCSAccess().getGroup_1_1(), "rule__PostconditionConstraintCS__Group_1_1__0");
					put(grammarAccess.getPreconditionConstraintCSAccess().getGroup(), "rule__PreconditionConstraintCS__Group__0");
					put(grammarAccess.getPreconditionConstraintCSAccess().getGroup_1(), "rule__PreconditionConstraintCS__Group_1__0");
					put(grammarAccess.getPreconditionConstraintCSAccess().getGroup_1_1(), "rule__PreconditionConstraintCS__Group_1_1__0");
					put(grammarAccess.getAnnotationCSAccess().getGroup(), "rule__AnnotationCS__Group__0");
					put(grammarAccess.getAnnotationCSAccess().getGroup_3(), "rule__AnnotationCS__Group_3__0");
					put(grammarAccess.getAnnotationCSAccess().getGroup_3_2(), "rule__AnnotationCS__Group_3_2__0");
					put(grammarAccess.getAnnotationCSAccess().getGroup_4_0(), "rule__AnnotationCS__Group_4_0__0");
					put(grammarAccess.getAttributeCSAccess().getGroup(), "rule__AttributeCS__Group__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_0_0(), "rule__AttributeCS__Group_0_0__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_0_1(), "rule__AttributeCS__Group_0_1__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_3(), "rule__AttributeCS__Group_3__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_4(), "rule__AttributeCS__Group_4__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_5(), "rule__AttributeCS__Group_5__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_5_1(), "rule__AttributeCS__Group_5_1__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_6_0(), "rule__AttributeCS__Group_6_0__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_6_0_1_1(), "rule__AttributeCS__Group_6_0_1_1__0");
					put(grammarAccess.getAttributeCSAccess().getGroup_6_0_1_2(), "rule__AttributeCS__Group_6_0_1_2__0");
					put(grammarAccess.getDataTypeCSAccess().getGroup(), "rule__DataTypeCS__Group__0");
					put(grammarAccess.getDataTypeCSAccess().getGroup_4(), "rule__DataTypeCS__Group_4__0");
					put(grammarAccess.getDataTypeCSAccess().getGroup_5(), "rule__DataTypeCS__Group_5__0");
					put(grammarAccess.getDataTypeCSAccess().getGroup_6_0(), "rule__DataTypeCS__Group_6_0__0");
					put(grammarAccess.getDetailCSAccess().getGroup(), "rule__DetailCS__Group__0");
					put(grammarAccess.getDocumentationCSAccess().getGroup(), "rule__DocumentationCS__Group__0");
					put(grammarAccess.getDocumentationCSAccess().getGroup_3(), "rule__DocumentationCS__Group_3__0");
					put(grammarAccess.getDocumentationCSAccess().getGroup_3_2(), "rule__DocumentationCS__Group_3_2__0");
					put(grammarAccess.getEnumerationCSAccess().getGroup(), "rule__EnumerationCS__Group__0");
					put(grammarAccess.getEnumerationCSAccess().getGroup_3(), "rule__EnumerationCS__Group_3__0");
					put(grammarAccess.getEnumerationCSAccess().getGroup_4(), "rule__EnumerationCS__Group_4__0");
					put(grammarAccess.getEnumerationCSAccess().getGroup_5_0(), "rule__EnumerationCS__Group_5_0__0");
					put(grammarAccess.getEnumerationLiteralCSAccess().getGroup(), "rule__EnumerationLiteralCS__Group__0");
					put(grammarAccess.getEnumerationLiteralCSAccess().getGroup_0_0(), "rule__EnumerationLiteralCS__Group_0_0__0");
					put(grammarAccess.getEnumerationLiteralCSAccess().getGroup_1(), "rule__EnumerationLiteralCS__Group_1__0");
					put(grammarAccess.getEnumerationLiteralCSAccess().getGroup_2(), "rule__EnumerationLiteralCS__Group_2__0");
					put(grammarAccess.getEnumerationLiteralCSAccess().getGroup_3_0(), "rule__EnumerationLiteralCS__Group_3_0__0");
					put(grammarAccess.getImportCSAccess().getGroup(), "rule__ImportCS__Group__0");
					put(grammarAccess.getImportCSAccess().getGroup_1(), "rule__ImportCS__Group_1__0");
					put(grammarAccess.getModelElementRefCSAccess().getGroup(), "rule__ModelElementRefCS__Group__0");
					put(grammarAccess.getOperationCSAccess().getGroup(), "rule__OperationCS__Group__0");
					put(grammarAccess.getOperationCSAccess().getGroup_0_0(), "rule__OperationCS__Group_0_0__0");
					put(grammarAccess.getOperationCSAccess().getGroup_0_1(), "rule__OperationCS__Group_0_1__0");
					put(grammarAccess.getOperationCSAccess().getGroup_5(), "rule__OperationCS__Group_5__0");
					put(grammarAccess.getOperationCSAccess().getGroup_5_1(), "rule__OperationCS__Group_5_1__0");
					put(grammarAccess.getOperationCSAccess().getGroup_7(), "rule__OperationCS__Group_7__0");
					put(grammarAccess.getOperationCSAccess().getGroup_8(), "rule__OperationCS__Group_8__0");
					put(grammarAccess.getOperationCSAccess().getGroup_8_2(), "rule__OperationCS__Group_8_2__0");
					put(grammarAccess.getOperationCSAccess().getGroup_9(), "rule__OperationCS__Group_9__0");
					put(grammarAccess.getOperationCSAccess().getGroup_9_1(), "rule__OperationCS__Group_9_1__0");
					put(grammarAccess.getOperationCSAccess().getGroup_10_0(), "rule__OperationCS__Group_10_0__0");
					put(grammarAccess.getOperationCSAccess().getGroup_10_0_1_2(), "rule__OperationCS__Group_10_0_1_2__0");
					put(grammarAccess.getPackageCSAccess().getGroup(), "rule__PackageCS__Group__0");
					put(grammarAccess.getPackageCSAccess().getGroup_2(), "rule__PackageCS__Group_2__0");
					put(grammarAccess.getPackageCSAccess().getGroup_3(), "rule__PackageCS__Group_3__0");
					put(grammarAccess.getPackageCSAccess().getGroup_4_0(), "rule__PackageCS__Group_4_0__0");
					put(grammarAccess.getParameterCSAccess().getGroup(), "rule__ParameterCS__Group__0");
					put(grammarAccess.getParameterCSAccess().getGroup_1(), "rule__ParameterCS__Group_1__0");
					put(grammarAccess.getParameterCSAccess().getGroup_2(), "rule__ParameterCS__Group_2__0");
					put(grammarAccess.getParameterCSAccess().getGroup_2_1(), "rule__ParameterCS__Group_2_1__0");
					put(grammarAccess.getParameterCSAccess().getGroup_3(), "rule__ParameterCS__Group_3__0");
					put(grammarAccess.getImplicitOppositeCSAccess().getGroup(), "rule__ImplicitOppositeCS__Group__0");
					put(grammarAccess.getImplicitOppositeCSAccess().getGroup_4(), "rule__ImplicitOppositeCS__Group_4__0");
					put(grammarAccess.getImplicitOppositeCSAccess().getGroup_4_1(), "rule__ImplicitOppositeCS__Group_4_1__0");
					put(grammarAccess.getReferenceCSAccess().getGroup(), "rule__ReferenceCS__Group__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_0_0(), "rule__ReferenceCS__Group_0_0__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_0_1(), "rule__ReferenceCS__Group_0_1__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_3(), "rule__ReferenceCS__Group_3__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_4(), "rule__ReferenceCS__Group_4__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_5(), "rule__ReferenceCS__Group_5__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_6(), "rule__ReferenceCS__Group_6__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_6_1(), "rule__ReferenceCS__Group_6_1__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_7_0(), "rule__ReferenceCS__Group_7_0__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_7_0_1_1(), "rule__ReferenceCS__Group_7_0_1_1__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_7_0_1_1_2(), "rule__ReferenceCS__Group_7_0_1_1_2__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_7_0_1_2(), "rule__ReferenceCS__Group_7_0_1_2__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_7_0_1_3(), "rule__ReferenceCS__Group_7_0_1_3__0");
					put(grammarAccess.getReferenceCSAccess().getGroup_7_0_1_4(), "rule__ReferenceCS__Group_7_0_1_4__0");
					put(grammarAccess.getStructuredClassCSAccess().getGroup(), "rule__StructuredClassCS__Group__0");
					put(grammarAccess.getStructuredClassCSAccess().getGroup_4(), "rule__StructuredClassCS__Group_4__0");
					put(grammarAccess.getStructuredClassCSAccess().getGroup_4_2(), "rule__StructuredClassCS__Group_4_2__0");
					put(grammarAccess.getStructuredClassCSAccess().getGroup_5(), "rule__StructuredClassCS__Group_5__0");
					put(grammarAccess.getStructuredClassCSAccess().getGroup_6(), "rule__StructuredClassCS__Group_6__0");
					put(grammarAccess.getStructuredClassCSAccess().getGroup_7_0(), "rule__StructuredClassCS__Group_7_0__0");
					put(grammarAccess.getSysMLCSAccess().getGroup(), "rule__SysMLCS__Group__0");
					put(grammarAccess.getSysMLCSAccess().getGroup_2_0(), "rule__SysMLCS__Group_2_0__0");
					put(grammarAccess.getSysMLCSAccess().getGroup_2_1(), "rule__SysMLCS__Group_2_1__0");
					put(grammarAccess.getSysMLCSAccess().getGroup_2_1_1(), "rule__SysMLCS__Group_2_1_1__0");
					put(grammarAccess.getTypedMultiplicityRefCSAccess().getGroup(), "rule__TypedMultiplicityRefCS__Group__0");
					put(grammarAccess.getTemplateSignatureCSAccess().getGroup_0(), "rule__TemplateSignatureCS__Group_0__0");
					put(grammarAccess.getTemplateSignatureCSAccess().getGroup_0_2(), "rule__TemplateSignatureCS__Group_0_2__0");
					put(grammarAccess.getTemplateSignatureCSAccess().getGroup_1(), "rule__TemplateSignatureCS__Group_1__0");
					put(grammarAccess.getTemplateSignatureCSAccess().getGroup_1_2(), "rule__TemplateSignatureCS__Group_1_2__0");
					put(grammarAccess.getTypedTypeRefCSAccess().getGroup(), "rule__TypedTypeRefCS__Group__0");
					put(grammarAccess.getTypedTypeRefCSAccess().getGroup_1_0(), "rule__TypedTypeRefCS__Group_1_0__0");
					put(grammarAccess.getTypedTypeRefCSAccess().getGroup_1_1(), "rule__TypedTypeRefCS__Group_1_1__0");
					put(grammarAccess.getURIPathNameCSAccess().getGroup(), "rule__URIPathNameCS__Group__0");
					put(grammarAccess.getURIPathNameCSAccess().getGroup_1(), "rule__URIPathNameCS__Group_1__0");
					put(grammarAccess.getURIFirstPathElementCSAccess().getGroup_1(), "rule__URIFirstPathElementCS__Group_1__0");
					put(grammarAccess.getCollectionTypeCSAccess().getGroup(), "rule__CollectionTypeCS__Group__0");
					put(grammarAccess.getCollectionTypeCSAccess().getGroup_1(), "rule__CollectionTypeCS__Group_1__0");
					put(grammarAccess.getMapTypeCSAccess().getGroup(), "rule__MapTypeCS__Group__0");
					put(grammarAccess.getMapTypeCSAccess().getGroup_1(), "rule__MapTypeCS__Group_1__0");
					put(grammarAccess.getTupleTypeCSAccess().getGroup(), "rule__TupleTypeCS__Group__0");
					put(grammarAccess.getTupleTypeCSAccess().getGroup_1(), "rule__TupleTypeCS__Group_1__0");
					put(grammarAccess.getTupleTypeCSAccess().getGroup_1_1(), "rule__TupleTypeCS__Group_1_1__0");
					put(grammarAccess.getTupleTypeCSAccess().getGroup_1_1_1(), "rule__TupleTypeCS__Group_1_1_1__0");
					put(grammarAccess.getTuplePartCSAccess().getGroup(), "rule__TuplePartCS__Group__0");
					put(grammarAccess.getCollectionLiteralExpCSAccess().getGroup(), "rule__CollectionLiteralExpCS__Group__0");
					put(grammarAccess.getCollectionLiteralExpCSAccess().getGroup_2(), "rule__CollectionLiteralExpCS__Group_2__0");
					put(grammarAccess.getCollectionLiteralExpCSAccess().getGroup_2_1(), "rule__CollectionLiteralExpCS__Group_2_1__0");
					put(grammarAccess.getCollectionLiteralPartCSAccess().getGroup_0(), "rule__CollectionLiteralPartCS__Group_0__0");
					put(grammarAccess.getCollectionLiteralPartCSAccess().getGroup_0_1(), "rule__CollectionLiteralPartCS__Group_0_1__0");
					put(grammarAccess.getCollectionPatternCSAccess().getGroup(), "rule__CollectionPatternCS__Group__0");
					put(grammarAccess.getCollectionPatternCSAccess().getGroup_2(), "rule__CollectionPatternCS__Group_2__0");
					put(grammarAccess.getCollectionPatternCSAccess().getGroup_2_1(), "rule__CollectionPatternCS__Group_2_1__0");
					put(grammarAccess.getCollectionPatternCSAccess().getGroup_2_2(), "rule__CollectionPatternCS__Group_2_2__0");
					put(grammarAccess.getShadowPartCSAccess().getGroup_0(), "rule__ShadowPartCS__Group_0__0");
					put(grammarAccess.getPatternExpCSAccess().getGroup(), "rule__PatternExpCS__Group__0");
					put(grammarAccess.getLambdaLiteralExpCSAccess().getGroup(), "rule__LambdaLiteralExpCS__Group__0");
					put(grammarAccess.getMapLiteralExpCSAccess().getGroup(), "rule__MapLiteralExpCS__Group__0");
					put(grammarAccess.getMapLiteralExpCSAccess().getGroup_2(), "rule__MapLiteralExpCS__Group_2__0");
					put(grammarAccess.getMapLiteralExpCSAccess().getGroup_2_1(), "rule__MapLiteralExpCS__Group_2_1__0");
					put(grammarAccess.getMapLiteralPartCSAccess().getGroup(), "rule__MapLiteralPartCS__Group__0");
					put(grammarAccess.getTupleLiteralExpCSAccess().getGroup(), "rule__TupleLiteralExpCS__Group__0");
					put(grammarAccess.getTupleLiteralExpCSAccess().getGroup_3(), "rule__TupleLiteralExpCS__Group_3__0");
					put(grammarAccess.getTupleLiteralPartCSAccess().getGroup(), "rule__TupleLiteralPartCS__Group__0");
					put(grammarAccess.getTupleLiteralPartCSAccess().getGroup_1(), "rule__TupleLiteralPartCS__Group_1__0");
					put(grammarAccess.getUnlimitedNaturalLiteralExpCSAccess().getGroup(), "rule__UnlimitedNaturalLiteralExpCS__Group__0");
					put(grammarAccess.getInvalidLiteralExpCSAccess().getGroup(), "rule__InvalidLiteralExpCS__Group__0");
					put(grammarAccess.getNullLiteralExpCSAccess().getGroup(), "rule__NullLiteralExpCS__Group__0");
					put(grammarAccess.getTypeLiteralWithMultiplicityCSAccess().getGroup(), "rule__TypeLiteralWithMultiplicityCS__Group__0");
					put(grammarAccess.getTypeNameExpCSAccess().getGroup(), "rule__TypeNameExpCS__Group__0");
					put(grammarAccess.getTypeNameExpCSAccess().getGroup_1(), "rule__TypeNameExpCS__Group_1__0");
					put(grammarAccess.getTypeNameExpCSAccess().getGroup_1_1(), "rule__TypeNameExpCS__Group_1_1__0");
					put(grammarAccess.getTypeExpCSAccess().getGroup(), "rule__TypeExpCS__Group__0");
					put(grammarAccess.getExpCSAccess().getGroup_0(), "rule__ExpCS__Group_0__0");
					put(grammarAccess.getExpCSAccess().getGroup_0_1(), "rule__ExpCS__Group_0_1__0");
					put(grammarAccess.getPrefixedLetExpCSAccess().getGroup_0(), "rule__PrefixedLetExpCS__Group_0__0");
					put(grammarAccess.getPrefixedPrimaryExpCSAccess().getGroup_0(), "rule__PrefixedPrimaryExpCS__Group_0__0");
					put(grammarAccess.getNameExpCSAccess().getGroup(), "rule__NameExpCS__Group__0");
					put(grammarAccess.getNameExpCSAccess().getGroup_4(), "rule__NameExpCS__Group_4__0");
					put(grammarAccess.getCurlyBracketedClauseCSAccess().getGroup(), "rule__CurlyBracketedClauseCS__Group__0");
					put(grammarAccess.getCurlyBracketedClauseCSAccess().getGroup_2(), "rule__CurlyBracketedClauseCS__Group_2__0");
					put(grammarAccess.getCurlyBracketedClauseCSAccess().getGroup_2_1(), "rule__CurlyBracketedClauseCS__Group_2_1__0");
					put(grammarAccess.getRoundBracketedClauseCSAccess().getGroup(), "rule__RoundBracketedClauseCS__Group__0");
					put(grammarAccess.getRoundBracketedClauseCSAccess().getGroup_2(), "rule__RoundBracketedClauseCS__Group_2__0");
					put(grammarAccess.getSquareBracketedClauseCSAccess().getGroup(), "rule__SquareBracketedClauseCS__Group__0");
					put(grammarAccess.getSquareBracketedClauseCSAccess().getGroup_2(), "rule__SquareBracketedClauseCS__Group_2__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0(), "rule__NavigatingArgCS__Group_0__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_0(), "rule__NavigatingArgCS__Group_0_1_0__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_0_2(), "rule__NavigatingArgCS__Group_0_1_0_2__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_1(), "rule__NavigatingArgCS__Group_0_1_1__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_1_2(), "rule__NavigatingArgCS__Group_0_1_1_2__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_1_3(), "rule__NavigatingArgCS__Group_0_1_1_3__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_2(), "rule__NavigatingArgCS__Group_0_1_2__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_2_0(), "rule__NavigatingArgCS__Group_0_1_2_0__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_0_1_2_1(), "rule__NavigatingArgCS__Group_0_1_2_1__0");
					put(grammarAccess.getNavigatingArgCSAccess().getGroup_1(), "rule__NavigatingArgCS__Group_1__0");
					put(grammarAccess.getNavigatingBarArgCSAccess().getGroup(), "rule__NavigatingBarArgCS__Group__0");
					put(grammarAccess.getNavigatingBarArgCSAccess().getGroup_2(), "rule__NavigatingBarArgCS__Group_2__0");
					put(grammarAccess.getNavigatingBarArgCSAccess().getGroup_2_2(), "rule__NavigatingBarArgCS__Group_2_2__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup(), "rule__NavigatingCommaArgCS__Group__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_0(), "rule__NavigatingCommaArgCS__Group_2_0__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_0_2(), "rule__NavigatingCommaArgCS__Group_2_0_2__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_1(), "rule__NavigatingCommaArgCS__Group_2_1__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_1_2(), "rule__NavigatingCommaArgCS__Group_2_1_2__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_1_3(), "rule__NavigatingCommaArgCS__Group_2_1_3__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_2(), "rule__NavigatingCommaArgCS__Group_2_2__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_2_0(), "rule__NavigatingCommaArgCS__Group_2_2_0__0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getGroup_2_2_1(), "rule__NavigatingCommaArgCS__Group_2_2_1__0");
					put(grammarAccess.getNavigatingSemiArgCSAccess().getGroup(), "rule__NavigatingSemiArgCS__Group__0");
					put(grammarAccess.getNavigatingSemiArgCSAccess().getGroup_2(), "rule__NavigatingSemiArgCS__Group_2__0");
					put(grammarAccess.getNavigatingSemiArgCSAccess().getGroup_2_2(), "rule__NavigatingSemiArgCS__Group_2_2__0");
					put(grammarAccess.getCoIteratorVariableCSAccess().getGroup(), "rule__CoIteratorVariableCS__Group__0");
					put(grammarAccess.getCoIteratorVariableCSAccess().getGroup_1(), "rule__CoIteratorVariableCS__Group_1__0");
					put(grammarAccess.getIfExpCSAccess().getGroup(), "rule__IfExpCS__Group__0");
					put(grammarAccess.getElseIfThenExpCSAccess().getGroup(), "rule__ElseIfThenExpCS__Group__0");
					put(grammarAccess.getLetExpCSAccess().getGroup(), "rule__LetExpCS__Group__0");
					put(grammarAccess.getLetExpCSAccess().getGroup_2(), "rule__LetExpCS__Group_2__0");
					put(grammarAccess.getLetVariableCSAccess().getGroup(), "rule__LetVariableCS__Group__0");
					put(grammarAccess.getLetVariableCSAccess().getGroup_2(), "rule__LetVariableCS__Group_2__0");
					put(grammarAccess.getNestedExpCSAccess().getGroup(), "rule__NestedExpCS__Group__0");
					put(grammarAccess.getSelfExpCSAccess().getGroup(), "rule__SelfExpCS__Group__0");
					put(grammarAccess.getMultiplicityBoundsCSAccess().getGroup(), "rule__MultiplicityBoundsCS__Group__0");
					put(grammarAccess.getMultiplicityBoundsCSAccess().getGroup_1(), "rule__MultiplicityBoundsCS__Group_1__0");
					put(grammarAccess.getMultiplicityCSAccess().getGroup(), "rule__MultiplicityCS__Group__0");
					put(grammarAccess.getPathNameCSAccess().getGroup(), "rule__PathNameCS__Group__0");
					put(grammarAccess.getPathNameCSAccess().getGroup_1(), "rule__PathNameCS__Group_1__0");
					put(grammarAccess.getUnreservedPathNameCSAccess().getGroup(), "rule__UnreservedPathNameCS__Group__0");
					put(grammarAccess.getUnreservedPathNameCSAccess().getGroup_1(), "rule__UnreservedPathNameCS__Group_1__0");
					put(grammarAccess.getTemplateBindingCSAccess().getGroup(), "rule__TemplateBindingCS__Group__0");
					put(grammarAccess.getTemplateBindingCSAccess().getGroup_1(), "rule__TemplateBindingCS__Group_1__0");
					put(grammarAccess.getTypeParameterCSAccess().getGroup(), "rule__TypeParameterCS__Group__0");
					put(grammarAccess.getTypeParameterCSAccess().getGroup_1(), "rule__TypeParameterCS__Group_1__0");
					put(grammarAccess.getTypeParameterCSAccess().getGroup_1_2(), "rule__TypeParameterCS__Group_1_2__0");
					put(grammarAccess.getWildcardTypeRefCSAccess().getGroup(), "rule__WildcardTypeRefCS__Group__0");
					put(grammarAccess.getWildcardTypeRefCSAccess().getGroup_2(), "rule__WildcardTypeRefCS__Group_2__0");
					put(grammarAccess.getTopLevelCSAccess().getOwnedImportsAssignment_2(), "rule__TopLevelCS__OwnedImportsAssignment_2");
					put(grammarAccess.getTopLevelCSAccess().getOwnedPackagesAssignment_3(), "rule__TopLevelCS__OwnedPackagesAssignment_3");
					put(grammarAccess.getInvariantConstraintCSAccess().getIsCallableAssignment_0(), "rule__InvariantConstraintCS__IsCallableAssignment_0");
					put(grammarAccess.getInvariantConstraintCSAccess().getStereotypeAssignment_1(), "rule__InvariantConstraintCS__StereotypeAssignment_1");
					put(grammarAccess.getInvariantConstraintCSAccess().getNameAssignment_2_0(), "rule__InvariantConstraintCS__NameAssignment_2_0");
					put(grammarAccess.getInvariantConstraintCSAccess().getOwnedMessageSpecificationAssignment_2_1_1(), "rule__InvariantConstraintCS__OwnedMessageSpecificationAssignment_2_1_1");
					put(grammarAccess.getInvariantConstraintCSAccess().getOwnedSpecificationAssignment_3_0_1(), "rule__InvariantConstraintCS__OwnedSpecificationAssignment_3_0_1");
					put(grammarAccess.getPostconditionConstraintCSAccess().getStereotypeAssignment_0(), "rule__PostconditionConstraintCS__StereotypeAssignment_0");
					put(grammarAccess.getPostconditionConstraintCSAccess().getNameAssignment_1_0(), "rule__PostconditionConstraintCS__NameAssignment_1_0");
					put(grammarAccess.getPostconditionConstraintCSAccess().getOwnedMessageSpecificationAssignment_1_1_1(), "rule__PostconditionConstraintCS__OwnedMessageSpecificationAssignment_1_1_1");
					put(grammarAccess.getPostconditionConstraintCSAccess().getOwnedSpecificationAssignment_3(), "rule__PostconditionConstraintCS__OwnedSpecificationAssignment_3");
					put(grammarAccess.getPreconditionConstraintCSAccess().getStereotypeAssignment_0(), "rule__PreconditionConstraintCS__StereotypeAssignment_0");
					put(grammarAccess.getPreconditionConstraintCSAccess().getNameAssignment_1_0(), "rule__PreconditionConstraintCS__NameAssignment_1_0");
					put(grammarAccess.getPreconditionConstraintCSAccess().getOwnedMessageSpecificationAssignment_1_1_1(), "rule__PreconditionConstraintCS__OwnedMessageSpecificationAssignment_1_1_1");
					put(grammarAccess.getPreconditionConstraintCSAccess().getOwnedSpecificationAssignment_3(), "rule__PreconditionConstraintCS__OwnedSpecificationAssignment_3");
					put(grammarAccess.getAnnotationCSAccess().getNameAssignment_2(), "rule__AnnotationCS__NameAssignment_2");
					put(grammarAccess.getAnnotationCSAccess().getOwnedDetailsAssignment_3_1(), "rule__AnnotationCS__OwnedDetailsAssignment_3_1");
					put(grammarAccess.getAnnotationCSAccess().getOwnedDetailsAssignment_3_2_1(), "rule__AnnotationCS__OwnedDetailsAssignment_3_2_1");
					put(grammarAccess.getAnnotationCSAccess().getOwnedAnnotationsAssignment_4_0_1_0(), "rule__AnnotationCS__OwnedAnnotationsAssignment_4_0_1_0");
					put(grammarAccess.getAnnotationCSAccess().getOwnedContentsAssignment_4_0_1_1(), "rule__AnnotationCS__OwnedContentsAssignment_4_0_1_1");
					put(grammarAccess.getAnnotationCSAccess().getOwnedReferencesAssignment_4_0_1_2(), "rule__AnnotationCS__OwnedReferencesAssignment_4_0_1_2");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_0_0_0(), "rule__AttributeCS__QualifiersAssignment_0_0_0");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_0_0_1(), "rule__AttributeCS__QualifiersAssignment_0_0_1");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_0_1_0(), "rule__AttributeCS__QualifiersAssignment_0_1_0");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_0_1_1(), "rule__AttributeCS__QualifiersAssignment_0_1_1");
					put(grammarAccess.getAttributeCSAccess().getNameAssignment_2(), "rule__AttributeCS__NameAssignment_2");
					put(grammarAccess.getAttributeCSAccess().getOwnedTypeAssignment_3_1(), "rule__AttributeCS__OwnedTypeAssignment_3_1");
					put(grammarAccess.getAttributeCSAccess().getDefaultAssignment_4_1(), "rule__AttributeCS__DefaultAssignment_4_1");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_0(), "rule__AttributeCS__QualifiersAssignment_5_1_0_0");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_1(), "rule__AttributeCS__QualifiersAssignment_5_1_0_1");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_2(), "rule__AttributeCS__QualifiersAssignment_5_1_0_2");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_3(), "rule__AttributeCS__QualifiersAssignment_5_1_0_3");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_4(), "rule__AttributeCS__QualifiersAssignment_5_1_0_4");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_5(), "rule__AttributeCS__QualifiersAssignment_5_1_0_5");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_6(), "rule__AttributeCS__QualifiersAssignment_5_1_0_6");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_7(), "rule__AttributeCS__QualifiersAssignment_5_1_0_7");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_8(), "rule__AttributeCS__QualifiersAssignment_5_1_0_8");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_9(), "rule__AttributeCS__QualifiersAssignment_5_1_0_9");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_10(), "rule__AttributeCS__QualifiersAssignment_5_1_0_10");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_11(), "rule__AttributeCS__QualifiersAssignment_5_1_0_11");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_12(), "rule__AttributeCS__QualifiersAssignment_5_1_0_12");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_13(), "rule__AttributeCS__QualifiersAssignment_5_1_0_13");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_14(), "rule__AttributeCS__QualifiersAssignment_5_1_0_14");
					put(grammarAccess.getAttributeCSAccess().getQualifiersAssignment_5_1_0_15(), "rule__AttributeCS__QualifiersAssignment_5_1_0_15");
					put(grammarAccess.getAttributeCSAccess().getOwnedAnnotationsAssignment_6_0_1_0(), "rule__AttributeCS__OwnedAnnotationsAssignment_6_0_1_0");
					put(grammarAccess.getAttributeCSAccess().getOwnedDefaultExpressionsAssignment_6_0_1_1_3(), "rule__AttributeCS__OwnedDefaultExpressionsAssignment_6_0_1_1_3");
					put(grammarAccess.getAttributeCSAccess().getOwnedDefaultExpressionsAssignment_6_0_1_2_3(), "rule__AttributeCS__OwnedDefaultExpressionsAssignment_6_0_1_2_3");
					put(grammarAccess.getDataTypeCSAccess().getIsPrimitiveAssignment_0(), "rule__DataTypeCS__IsPrimitiveAssignment_0");
					put(grammarAccess.getDataTypeCSAccess().getNameAssignment_2(), "rule__DataTypeCS__NameAssignment_2");
					put(grammarAccess.getDataTypeCSAccess().getOwnedSignatureAssignment_3(), "rule__DataTypeCS__OwnedSignatureAssignment_3");
					put(grammarAccess.getDataTypeCSAccess().getInstanceClassNameAssignment_4_1(), "rule__DataTypeCS__InstanceClassNameAssignment_4_1");
					put(grammarAccess.getDataTypeCSAccess().getIsSerializableAssignment_5_1_0(), "rule__DataTypeCS__IsSerializableAssignment_5_1_0");
					put(grammarAccess.getDataTypeCSAccess().getOwnedAnnotationsAssignment_6_0_1_0(), "rule__DataTypeCS__OwnedAnnotationsAssignment_6_0_1_0");
					put(grammarAccess.getDataTypeCSAccess().getOwnedConstraintsAssignment_6_0_1_1(), "rule__DataTypeCS__OwnedConstraintsAssignment_6_0_1_1");
					put(grammarAccess.getDetailCSAccess().getNameAssignment_0(), "rule__DetailCS__NameAssignment_0");
					put(grammarAccess.getDetailCSAccess().getValuesAssignment_2(), "rule__DetailCS__ValuesAssignment_2");
					put(grammarAccess.getDocumentationCSAccess().getValueAssignment_2(), "rule__DocumentationCS__ValueAssignment_2");
					put(grammarAccess.getDocumentationCSAccess().getOwnedDetailsAssignment_3_1(), "rule__DocumentationCS__OwnedDetailsAssignment_3_1");
					put(grammarAccess.getDocumentationCSAccess().getOwnedDetailsAssignment_3_2_1(), "rule__DocumentationCS__OwnedDetailsAssignment_3_2_1");
					put(grammarAccess.getEnumerationCSAccess().getNameAssignment_1(), "rule__EnumerationCS__NameAssignment_1");
					put(grammarAccess.getEnumerationCSAccess().getOwnedSignatureAssignment_2(), "rule__EnumerationCS__OwnedSignatureAssignment_2");
					put(grammarAccess.getEnumerationCSAccess().getInstanceClassNameAssignment_3_1(), "rule__EnumerationCS__InstanceClassNameAssignment_3_1");
					put(grammarAccess.getEnumerationCSAccess().getIsSerializableAssignment_4_1_0(), "rule__EnumerationCS__IsSerializableAssignment_4_1_0");
					put(grammarAccess.getEnumerationCSAccess().getOwnedAnnotationsAssignment_5_0_1_0(), "rule__EnumerationCS__OwnedAnnotationsAssignment_5_0_1_0");
					put(grammarAccess.getEnumerationCSAccess().getOwnedLiteralsAssignment_5_0_1_1(), "rule__EnumerationCS__OwnedLiteralsAssignment_5_0_1_1");
					put(grammarAccess.getEnumerationCSAccess().getOwnedConstraintsAssignment_5_0_1_2(), "rule__EnumerationCS__OwnedConstraintsAssignment_5_0_1_2");
					put(grammarAccess.getEnumerationLiteralCSAccess().getNameAssignment_0_0_1(), "rule__EnumerationLiteralCS__NameAssignment_0_0_1");
					put(grammarAccess.getEnumerationLiteralCSAccess().getNameAssignment_0_1(), "rule__EnumerationLiteralCS__NameAssignment_0_1");
					put(grammarAccess.getEnumerationLiteralCSAccess().getLiteralAssignment_1_1(), "rule__EnumerationLiteralCS__LiteralAssignment_1_1");
					put(grammarAccess.getEnumerationLiteralCSAccess().getValueAssignment_2_1(), "rule__EnumerationLiteralCS__ValueAssignment_2_1");
					put(grammarAccess.getEnumerationLiteralCSAccess().getOwnedAnnotationsAssignment_3_0_1(), "rule__EnumerationLiteralCS__OwnedAnnotationsAssignment_3_0_1");
					put(grammarAccess.getImportCSAccess().getNameAssignment_1_0(), "rule__ImportCS__NameAssignment_1_0");
					put(grammarAccess.getImportCSAccess().getOwnedPathNameAssignment_2(), "rule__ImportCS__OwnedPathNameAssignment_2");
					put(grammarAccess.getImportCSAccess().getIsAllAssignment_3(), "rule__ImportCS__IsAllAssignment_3");
					put(grammarAccess.getModelElementRefCSAccess().getOwnedPathNameAssignment_1(), "rule__ModelElementRefCS__OwnedPathNameAssignment_1");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_0_0_0(), "rule__OperationCS__QualifiersAssignment_0_0_0");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_0_0_1(), "rule__OperationCS__QualifiersAssignment_0_0_1");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_0_1_0(), "rule__OperationCS__QualifiersAssignment_0_1_0");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_0_1_1(), "rule__OperationCS__QualifiersAssignment_0_1_1");
					put(grammarAccess.getOperationCSAccess().getOwnedSignatureAssignment_2(), "rule__OperationCS__OwnedSignatureAssignment_2");
					put(grammarAccess.getOperationCSAccess().getNameAssignment_3(), "rule__OperationCS__NameAssignment_3");
					put(grammarAccess.getOperationCSAccess().getOwnedParametersAssignment_5_0(), "rule__OperationCS__OwnedParametersAssignment_5_0");
					put(grammarAccess.getOperationCSAccess().getOwnedParametersAssignment_5_1_1(), "rule__OperationCS__OwnedParametersAssignment_5_1_1");
					put(grammarAccess.getOperationCSAccess().getOwnedTypeAssignment_7_1(), "rule__OperationCS__OwnedTypeAssignment_7_1");
					put(grammarAccess.getOperationCSAccess().getOwnedExceptionsAssignment_8_1(), "rule__OperationCS__OwnedExceptionsAssignment_8_1");
					put(grammarAccess.getOperationCSAccess().getOwnedExceptionsAssignment_8_2_1(), "rule__OperationCS__OwnedExceptionsAssignment_8_2_1");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_0(), "rule__OperationCS__QualifiersAssignment_9_1_0_0");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_1(), "rule__OperationCS__QualifiersAssignment_9_1_0_1");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_2(), "rule__OperationCS__QualifiersAssignment_9_1_0_2");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_3(), "rule__OperationCS__QualifiersAssignment_9_1_0_3");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_4(), "rule__OperationCS__QualifiersAssignment_9_1_0_4");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_5(), "rule__OperationCS__QualifiersAssignment_9_1_0_5");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_6(), "rule__OperationCS__QualifiersAssignment_9_1_0_6");
					put(grammarAccess.getOperationCSAccess().getQualifiersAssignment_9_1_0_7(), "rule__OperationCS__QualifiersAssignment_9_1_0_7");
					put(grammarAccess.getOperationCSAccess().getOwnedAnnotationsAssignment_10_0_1_0(), "rule__OperationCS__OwnedAnnotationsAssignment_10_0_1_0");
					put(grammarAccess.getOperationCSAccess().getOwnedPreconditionsAssignment_10_0_1_1(), "rule__OperationCS__OwnedPreconditionsAssignment_10_0_1_1");
					put(grammarAccess.getOperationCSAccess().getOwnedBodyExpressionsAssignment_10_0_1_2_3(), "rule__OperationCS__OwnedBodyExpressionsAssignment_10_0_1_2_3");
					put(grammarAccess.getOperationCSAccess().getOwnedPostconditionsAssignment_10_0_1_3(), "rule__OperationCS__OwnedPostconditionsAssignment_10_0_1_3");
					put(grammarAccess.getPackageCSAccess().getNameAssignment_1(), "rule__PackageCS__NameAssignment_1");
					put(grammarAccess.getPackageCSAccess().getNsPrefixAssignment_2_1(), "rule__PackageCS__NsPrefixAssignment_2_1");
					put(grammarAccess.getPackageCSAccess().getNsURIAssignment_3_1(), "rule__PackageCS__NsURIAssignment_3_1");
					put(grammarAccess.getPackageCSAccess().getOwnedAnnotationsAssignment_4_0_1_0(), "rule__PackageCS__OwnedAnnotationsAssignment_4_0_1_0");
					put(grammarAccess.getPackageCSAccess().getOwnedPackagesAssignment_4_0_1_1(), "rule__PackageCS__OwnedPackagesAssignment_4_0_1_1");
					put(grammarAccess.getPackageCSAccess().getOwnedClassesAssignment_4_0_1_2(), "rule__PackageCS__OwnedClassesAssignment_4_0_1_2");
					put(grammarAccess.getParameterCSAccess().getNameAssignment_0(), "rule__ParameterCS__NameAssignment_0");
					put(grammarAccess.getParameterCSAccess().getOwnedTypeAssignment_1_1(), "rule__ParameterCS__OwnedTypeAssignment_1_1");
					put(grammarAccess.getParameterCSAccess().getQualifiersAssignment_2_1_0_0(), "rule__ParameterCS__QualifiersAssignment_2_1_0_0");
					put(grammarAccess.getParameterCSAccess().getQualifiersAssignment_2_1_0_1(), "rule__ParameterCS__QualifiersAssignment_2_1_0_1");
					put(grammarAccess.getParameterCSAccess().getQualifiersAssignment_2_1_0_2(), "rule__ParameterCS__QualifiersAssignment_2_1_0_2");
					put(grammarAccess.getParameterCSAccess().getQualifiersAssignment_2_1_0_3(), "rule__ParameterCS__QualifiersAssignment_2_1_0_3");
					put(grammarAccess.getParameterCSAccess().getOwnedAnnotationsAssignment_3_1(), "rule__ParameterCS__OwnedAnnotationsAssignment_3_1");
					put(grammarAccess.getImplicitOppositeCSAccess().getNameAssignment_1(), "rule__ImplicitOppositeCS__NameAssignment_1");
					put(grammarAccess.getImplicitOppositeCSAccess().getOwnedTypeAssignment_3(), "rule__ImplicitOppositeCS__OwnedTypeAssignment_3");
					put(grammarAccess.getImplicitOppositeCSAccess().getQualifiersAssignment_4_1_0_0(), "rule__ImplicitOppositeCS__QualifiersAssignment_4_1_0_0");
					put(grammarAccess.getImplicitOppositeCSAccess().getQualifiersAssignment_4_1_0_1(), "rule__ImplicitOppositeCS__QualifiersAssignment_4_1_0_1");
					put(grammarAccess.getImplicitOppositeCSAccess().getQualifiersAssignment_4_1_0_2(), "rule__ImplicitOppositeCS__QualifiersAssignment_4_1_0_2");
					put(grammarAccess.getImplicitOppositeCSAccess().getQualifiersAssignment_4_1_0_3(), "rule__ImplicitOppositeCS__QualifiersAssignment_4_1_0_3");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_0_0_0(), "rule__ReferenceCS__QualifiersAssignment_0_0_0");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_0_0_1(), "rule__ReferenceCS__QualifiersAssignment_0_0_1");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_0_1_0(), "rule__ReferenceCS__QualifiersAssignment_0_1_0");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_0_1_1(), "rule__ReferenceCS__QualifiersAssignment_0_1_1");
					put(grammarAccess.getReferenceCSAccess().getNameAssignment_2(), "rule__ReferenceCS__NameAssignment_2");
					put(grammarAccess.getReferenceCSAccess().getReferredOppositeAssignment_3_1(), "rule__ReferenceCS__ReferredOppositeAssignment_3_1");
					put(grammarAccess.getReferenceCSAccess().getOwnedTypeAssignment_4_1(), "rule__ReferenceCS__OwnedTypeAssignment_4_1");
					put(grammarAccess.getReferenceCSAccess().getDefaultAssignment_5_1(), "rule__ReferenceCS__DefaultAssignment_5_1");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_0(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_0");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_1(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_1");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_2(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_2");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_3(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_3");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_4(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_4");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_5(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_5");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_6(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_6");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_7(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_7");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_8(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_8");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_9(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_9");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_10(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_10");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_11(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_11");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_12(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_12");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_13(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_13");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_14(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_14");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_15(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_15");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_16(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_16");
					put(grammarAccess.getReferenceCSAccess().getQualifiersAssignment_6_1_0_17(), "rule__ReferenceCS__QualifiersAssignment_6_1_0_17");
					put(grammarAccess.getReferenceCSAccess().getOwnedAnnotationsAssignment_7_0_1_0(), "rule__ReferenceCS__OwnedAnnotationsAssignment_7_0_1_0");
					put(grammarAccess.getReferenceCSAccess().getReferredKeysAssignment_7_0_1_1_1(), "rule__ReferenceCS__ReferredKeysAssignment_7_0_1_1_1");
					put(grammarAccess.getReferenceCSAccess().getReferredKeysAssignment_7_0_1_1_2_1(), "rule__ReferenceCS__ReferredKeysAssignment_7_0_1_1_2_1");
					put(grammarAccess.getReferenceCSAccess().getOwnedDefaultExpressionsAssignment_7_0_1_2_3(), "rule__ReferenceCS__OwnedDefaultExpressionsAssignment_7_0_1_2_3");
					put(grammarAccess.getReferenceCSAccess().getOwnedDefaultExpressionsAssignment_7_0_1_3_3(), "rule__ReferenceCS__OwnedDefaultExpressionsAssignment_7_0_1_3_3");
					put(grammarAccess.getReferenceCSAccess().getOwnedImplicitOppositesAssignment_7_0_1_4_0(), "rule__ReferenceCS__OwnedImplicitOppositesAssignment_7_0_1_4_0");
					put(grammarAccess.getSpecificationCSAccess().getOwnedExpressionAssignment_0(), "rule__SpecificationCS__OwnedExpressionAssignment_0");
					put(grammarAccess.getSpecificationCSAccess().getExprStringAssignment_1(), "rule__SpecificationCS__ExprStringAssignment_1");
					put(grammarAccess.getStructuredClassCSAccess().getIsAbstractAssignment_0(), "rule__StructuredClassCS__IsAbstractAssignment_0");
					put(grammarAccess.getStructuredClassCSAccess().getNameAssignment_2(), "rule__StructuredClassCS__NameAssignment_2");
					put(grammarAccess.getStructuredClassCSAccess().getOwnedSignatureAssignment_3(), "rule__StructuredClassCS__OwnedSignatureAssignment_3");
					put(grammarAccess.getStructuredClassCSAccess().getOwnedSuperTypesAssignment_4_1(), "rule__StructuredClassCS__OwnedSuperTypesAssignment_4_1");
					put(grammarAccess.getStructuredClassCSAccess().getOwnedSuperTypesAssignment_4_2_1(), "rule__StructuredClassCS__OwnedSuperTypesAssignment_4_2_1");
					put(grammarAccess.getStructuredClassCSAccess().getInstanceClassNameAssignment_5_1(), "rule__StructuredClassCS__InstanceClassNameAssignment_5_1");
					put(grammarAccess.getStructuredClassCSAccess().getIsInterfaceAssignment_6_1(), "rule__StructuredClassCS__IsInterfaceAssignment_6_1");
					put(grammarAccess.getStructuredClassCSAccess().getOwnedAnnotationsAssignment_7_0_1_0(), "rule__StructuredClassCS__OwnedAnnotationsAssignment_7_0_1_0");
					put(grammarAccess.getStructuredClassCSAccess().getOwnedOperationsAssignment_7_0_1_1(), "rule__StructuredClassCS__OwnedOperationsAssignment_7_0_1_1");
					put(grammarAccess.getStructuredClassCSAccess().getOwnedPropertiesAssignment_7_0_1_2(), "rule__StructuredClassCS__OwnedPropertiesAssignment_7_0_1_2");
					put(grammarAccess.getStructuredClassCSAccess().getOwnedConstraintsAssignment_7_0_1_3(), "rule__StructuredClassCS__OwnedConstraintsAssignment_7_0_1_3");
					put(grammarAccess.getSysMLCSAccess().getOwnedDetailsAssignment_2_0_0(), "rule__SysMLCS__OwnedDetailsAssignment_2_0_0");
					put(grammarAccess.getSysMLCSAccess().getOwnedDetailsAssignment_2_1_1_0(), "rule__SysMLCS__OwnedDetailsAssignment_2_1_1_0");
					put(grammarAccess.getTypedMultiplicityRefCSAccess().getOwnedMultiplicityAssignment_1(), "rule__TypedMultiplicityRefCS__OwnedMultiplicityAssignment_1");
					put(grammarAccess.getTemplateSignatureCSAccess().getOwnedParametersAssignment_0_1(), "rule__TemplateSignatureCS__OwnedParametersAssignment_0_1");
					put(grammarAccess.getTemplateSignatureCSAccess().getOwnedParametersAssignment_0_2_1(), "rule__TemplateSignatureCS__OwnedParametersAssignment_0_2_1");
					put(grammarAccess.getTemplateSignatureCSAccess().getOwnedParametersAssignment_1_1(), "rule__TemplateSignatureCS__OwnedParametersAssignment_1_1");
					put(grammarAccess.getTemplateSignatureCSAccess().getOwnedParametersAssignment_1_2_1(), "rule__TemplateSignatureCS__OwnedParametersAssignment_1_2_1");
					put(grammarAccess.getTypedTypeRefCSAccess().getOwnedPathNameAssignment_0(), "rule__TypedTypeRefCS__OwnedPathNameAssignment_0");
					put(grammarAccess.getTypedTypeRefCSAccess().getOwnedBindingAssignment_1_0_1(), "rule__TypedTypeRefCS__OwnedBindingAssignment_1_0_1");
					put(grammarAccess.getTypedTypeRefCSAccess().getOwnedBindingAssignment_1_1_1(), "rule__TypedTypeRefCS__OwnedBindingAssignment_1_1_1");
					put(grammarAccess.getModelAccess().getOwnedExpressionAssignment(), "rule__Model__OwnedExpressionAssignment");
					put(grammarAccess.getURIPathNameCSAccess().getOwnedPathElementsAssignment_0(), "rule__URIPathNameCS__OwnedPathElementsAssignment_0");
					put(grammarAccess.getURIPathNameCSAccess().getOwnedPathElementsAssignment_1_1(), "rule__URIPathNameCS__OwnedPathElementsAssignment_1_1");
					put(grammarAccess.getURIFirstPathElementCSAccess().getReferredElementAssignment_0(), "rule__URIFirstPathElementCS__ReferredElementAssignment_0");
					put(grammarAccess.getURIFirstPathElementCSAccess().getReferredElementAssignment_1_1(), "rule__URIFirstPathElementCS__ReferredElementAssignment_1_1");
					put(grammarAccess.getSimplePathNameCSAccess().getOwnedPathElementsAssignment(), "rule__SimplePathNameCS__OwnedPathElementsAssignment");
					put(grammarAccess.getPrimitiveTypeCSAccess().getNameAssignment(), "rule__PrimitiveTypeCS__NameAssignment");
					put(grammarAccess.getCollectionTypeCSAccess().getNameAssignment_0(), "rule__CollectionTypeCS__NameAssignment_0");
					put(grammarAccess.getCollectionTypeCSAccess().getOwnedTypeAssignment_1_1(), "rule__CollectionTypeCS__OwnedTypeAssignment_1_1");
					put(grammarAccess.getCollectionTypeCSAccess().getOwnedCollectionMultiplicityAssignment_1_2(), "rule__CollectionTypeCS__OwnedCollectionMultiplicityAssignment_1_2");
					put(grammarAccess.getMapTypeCSAccess().getNameAssignment_0(), "rule__MapTypeCS__NameAssignment_0");
					put(grammarAccess.getMapTypeCSAccess().getOwnedKeyTypeAssignment_1_1(), "rule__MapTypeCS__OwnedKeyTypeAssignment_1_1");
					put(grammarAccess.getMapTypeCSAccess().getOwnedValueTypeAssignment_1_3(), "rule__MapTypeCS__OwnedValueTypeAssignment_1_3");
					put(grammarAccess.getTupleTypeCSAccess().getNameAssignment_0(), "rule__TupleTypeCS__NameAssignment_0");
					put(grammarAccess.getTupleTypeCSAccess().getOwnedPartsAssignment_1_1_0(), "rule__TupleTypeCS__OwnedPartsAssignment_1_1_0");
					put(grammarAccess.getTupleTypeCSAccess().getOwnedPartsAssignment_1_1_1_1(), "rule__TupleTypeCS__OwnedPartsAssignment_1_1_1_1");
					put(grammarAccess.getTuplePartCSAccess().getNameAssignment_0(), "rule__TuplePartCS__NameAssignment_0");
					put(grammarAccess.getTuplePartCSAccess().getOwnedTypeAssignment_2(), "rule__TuplePartCS__OwnedTypeAssignment_2");
					put(grammarAccess.getCollectionLiteralExpCSAccess().getOwnedTypeAssignment_0(), "rule__CollectionLiteralExpCS__OwnedTypeAssignment_0");
					put(grammarAccess.getCollectionLiteralExpCSAccess().getOwnedPartsAssignment_2_0(), "rule__CollectionLiteralExpCS__OwnedPartsAssignment_2_0");
					put(grammarAccess.getCollectionLiteralExpCSAccess().getOwnedPartsAssignment_2_1_1(), "rule__CollectionLiteralExpCS__OwnedPartsAssignment_2_1_1");
					put(grammarAccess.getCollectionLiteralPartCSAccess().getOwnedExpressionAssignment_0_0(), "rule__CollectionLiteralPartCS__OwnedExpressionAssignment_0_0");
					put(grammarAccess.getCollectionLiteralPartCSAccess().getOwnedLastExpressionAssignment_0_1_1(), "rule__CollectionLiteralPartCS__OwnedLastExpressionAssignment_0_1_1");
					put(grammarAccess.getCollectionLiteralPartCSAccess().getOwnedExpressionAssignment_1(), "rule__CollectionLiteralPartCS__OwnedExpressionAssignment_1");
					put(grammarAccess.getCollectionPatternCSAccess().getOwnedTypeAssignment_0(), "rule__CollectionPatternCS__OwnedTypeAssignment_0");
					put(grammarAccess.getCollectionPatternCSAccess().getOwnedPartsAssignment_2_0(), "rule__CollectionPatternCS__OwnedPartsAssignment_2_0");
					put(grammarAccess.getCollectionPatternCSAccess().getOwnedPartsAssignment_2_1_1(), "rule__CollectionPatternCS__OwnedPartsAssignment_2_1_1");
					put(grammarAccess.getCollectionPatternCSAccess().getRestVariableNameAssignment_2_2_1(), "rule__CollectionPatternCS__RestVariableNameAssignment_2_2_1");
					put(grammarAccess.getShadowPartCSAccess().getReferredPropertyAssignment_0_0(), "rule__ShadowPartCS__ReferredPropertyAssignment_0_0");
					put(grammarAccess.getShadowPartCSAccess().getOwnedInitExpressionAssignment_0_2(), "rule__ShadowPartCS__OwnedInitExpressionAssignment_0_2");
					put(grammarAccess.getShadowPartCSAccess().getOwnedInitExpressionAssignment_1(), "rule__ShadowPartCS__OwnedInitExpressionAssignment_1");
					put(grammarAccess.getPatternExpCSAccess().getPatternVariableNameAssignment_0(), "rule__PatternExpCS__PatternVariableNameAssignment_0");
					put(grammarAccess.getPatternExpCSAccess().getOwnedPatternTypeAssignment_2(), "rule__PatternExpCS__OwnedPatternTypeAssignment_2");
					put(grammarAccess.getLambdaLiteralExpCSAccess().getOwnedExpressionCSAssignment_2(), "rule__LambdaLiteralExpCS__OwnedExpressionCSAssignment_2");
					put(grammarAccess.getMapLiteralExpCSAccess().getOwnedTypeAssignment_0(), "rule__MapLiteralExpCS__OwnedTypeAssignment_0");
					put(grammarAccess.getMapLiteralExpCSAccess().getOwnedPartsAssignment_2_0(), "rule__MapLiteralExpCS__OwnedPartsAssignment_2_0");
					put(grammarAccess.getMapLiteralExpCSAccess().getOwnedPartsAssignment_2_1_1(), "rule__MapLiteralExpCS__OwnedPartsAssignment_2_1_1");
					put(grammarAccess.getMapLiteralPartCSAccess().getOwnedKeyAssignment_0(), "rule__MapLiteralPartCS__OwnedKeyAssignment_0");
					put(grammarAccess.getMapLiteralPartCSAccess().getOwnedValueAssignment_2(), "rule__MapLiteralPartCS__OwnedValueAssignment_2");
					put(grammarAccess.getTupleLiteralExpCSAccess().getOwnedPartsAssignment_2(), "rule__TupleLiteralExpCS__OwnedPartsAssignment_2");
					put(grammarAccess.getTupleLiteralExpCSAccess().getOwnedPartsAssignment_3_1(), "rule__TupleLiteralExpCS__OwnedPartsAssignment_3_1");
					put(grammarAccess.getTupleLiteralPartCSAccess().getNameAssignment_0(), "rule__TupleLiteralPartCS__NameAssignment_0");
					put(grammarAccess.getTupleLiteralPartCSAccess().getOwnedTypeAssignment_1_1(), "rule__TupleLiteralPartCS__OwnedTypeAssignment_1_1");
					put(grammarAccess.getTupleLiteralPartCSAccess().getOwnedInitExpressionAssignment_3(), "rule__TupleLiteralPartCS__OwnedInitExpressionAssignment_3");
					put(grammarAccess.getNumberLiteralExpCSAccess().getSymbolAssignment(), "rule__NumberLiteralExpCS__SymbolAssignment");
					put(grammarAccess.getStringLiteralExpCSAccess().getSegmentsAssignment(), "rule__StringLiteralExpCS__SegmentsAssignment");
					put(grammarAccess.getBooleanLiteralExpCSAccess().getSymbolAssignment_0(), "rule__BooleanLiteralExpCS__SymbolAssignment_0");
					put(grammarAccess.getBooleanLiteralExpCSAccess().getSymbolAssignment_1(), "rule__BooleanLiteralExpCS__SymbolAssignment_1");
					put(grammarAccess.getTypeLiteralWithMultiplicityCSAccess().getOwnedMultiplicityAssignment_1(), "rule__TypeLiteralWithMultiplicityCS__OwnedMultiplicityAssignment_1");
					put(grammarAccess.getTypeLiteralExpCSAccess().getOwnedTypeAssignment(), "rule__TypeLiteralExpCS__OwnedTypeAssignment");
					put(grammarAccess.getTypeNameExpCSAccess().getOwnedPathNameAssignment_0(), "rule__TypeNameExpCS__OwnedPathNameAssignment_0");
					put(grammarAccess.getTypeNameExpCSAccess().getOwnedCurlyBracketedClauseAssignment_1_0(), "rule__TypeNameExpCS__OwnedCurlyBracketedClauseAssignment_1_0");
					put(grammarAccess.getTypeNameExpCSAccess().getOwnedPatternGuardAssignment_1_1_1(), "rule__TypeNameExpCS__OwnedPatternGuardAssignment_1_1_1");
					put(grammarAccess.getTypeExpCSAccess().getOwnedMultiplicityAssignment_1(), "rule__TypeExpCS__OwnedMultiplicityAssignment_1");
					put(grammarAccess.getExpCSAccess().getNameAssignment_0_1_1(), "rule__ExpCS__NameAssignment_0_1_1");
					put(grammarAccess.getExpCSAccess().getOwnedRightAssignment_0_1_2(), "rule__ExpCS__OwnedRightAssignment_0_1_2");
					put(grammarAccess.getPrefixedLetExpCSAccess().getNameAssignment_0_1(), "rule__PrefixedLetExpCS__NameAssignment_0_1");
					put(grammarAccess.getPrefixedLetExpCSAccess().getOwnedRightAssignment_0_2(), "rule__PrefixedLetExpCS__OwnedRightAssignment_0_2");
					put(grammarAccess.getPrefixedPrimaryExpCSAccess().getNameAssignment_0_1(), "rule__PrefixedPrimaryExpCS__NameAssignment_0_1");
					put(grammarAccess.getPrefixedPrimaryExpCSAccess().getOwnedRightAssignment_0_2(), "rule__PrefixedPrimaryExpCS__OwnedRightAssignment_0_2");
					put(grammarAccess.getNameExpCSAccess().getOwnedPathNameAssignment_0(), "rule__NameExpCS__OwnedPathNameAssignment_0");
					put(grammarAccess.getNameExpCSAccess().getOwnedSquareBracketedClausesAssignment_1(), "rule__NameExpCS__OwnedSquareBracketedClausesAssignment_1");
					put(grammarAccess.getNameExpCSAccess().getOwnedRoundBracketedClauseAssignment_2(), "rule__NameExpCS__OwnedRoundBracketedClauseAssignment_2");
					put(grammarAccess.getNameExpCSAccess().getOwnedCurlyBracketedClauseAssignment_3(), "rule__NameExpCS__OwnedCurlyBracketedClauseAssignment_3");
					put(grammarAccess.getNameExpCSAccess().getIsPreAssignment_4_0(), "rule__NameExpCS__IsPreAssignment_4_0");
					put(grammarAccess.getCurlyBracketedClauseCSAccess().getOwnedPartsAssignment_2_0(), "rule__CurlyBracketedClauseCS__OwnedPartsAssignment_2_0");
					put(grammarAccess.getCurlyBracketedClauseCSAccess().getOwnedPartsAssignment_2_1_1(), "rule__CurlyBracketedClauseCS__OwnedPartsAssignment_2_1_1");
					put(grammarAccess.getRoundBracketedClauseCSAccess().getOwnedArgumentsAssignment_2_0(), "rule__RoundBracketedClauseCS__OwnedArgumentsAssignment_2_0");
					put(grammarAccess.getRoundBracketedClauseCSAccess().getOwnedArgumentsAssignment_2_1(), "rule__RoundBracketedClauseCS__OwnedArgumentsAssignment_2_1");
					put(grammarAccess.getSquareBracketedClauseCSAccess().getOwnedTermsAssignment_1(), "rule__SquareBracketedClauseCS__OwnedTermsAssignment_1");
					put(grammarAccess.getSquareBracketedClauseCSAccess().getOwnedTermsAssignment_2_1(), "rule__SquareBracketedClauseCS__OwnedTermsAssignment_2_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedNameExpressionAssignment_0_0(), "rule__NavigatingArgCS__OwnedNameExpressionAssignment_0_0");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedCoIteratorAssignment_0_1_0_1(), "rule__NavigatingArgCS__OwnedCoIteratorAssignment_0_1_0_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedInitExpressionAssignment_0_1_0_2_1(), "rule__NavigatingArgCS__OwnedInitExpressionAssignment_0_1_0_2_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedTypeAssignment_0_1_1_1(), "rule__NavigatingArgCS__OwnedTypeAssignment_0_1_1_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedCoIteratorAssignment_0_1_1_2_1(), "rule__NavigatingArgCS__OwnedCoIteratorAssignment_0_1_1_2_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedInitExpressionAssignment_0_1_1_3_1(), "rule__NavigatingArgCS__OwnedInitExpressionAssignment_0_1_1_3_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedTypeAssignment_0_1_2_0_1(), "rule__NavigatingArgCS__OwnedTypeAssignment_0_1_2_0_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedCoIteratorAssignment_0_1_2_1_1(), "rule__NavigatingArgCS__OwnedCoIteratorAssignment_0_1_2_1_1");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedInitExpressionAssignment_0_1_2_3(), "rule__NavigatingArgCS__OwnedInitExpressionAssignment_0_1_2_3");
					put(grammarAccess.getNavigatingArgCSAccess().getOwnedTypeAssignment_1_1(), "rule__NavigatingArgCS__OwnedTypeAssignment_1_1");
					put(grammarAccess.getNavigatingBarArgCSAccess().getPrefixAssignment_0(), "rule__NavigatingBarArgCS__PrefixAssignment_0");
					put(grammarAccess.getNavigatingBarArgCSAccess().getOwnedNameExpressionAssignment_1(), "rule__NavigatingBarArgCS__OwnedNameExpressionAssignment_1");
					put(grammarAccess.getNavigatingBarArgCSAccess().getOwnedTypeAssignment_2_1(), "rule__NavigatingBarArgCS__OwnedTypeAssignment_2_1");
					put(grammarAccess.getNavigatingBarArgCSAccess().getOwnedInitExpressionAssignment_2_2_1(), "rule__NavigatingBarArgCS__OwnedInitExpressionAssignment_2_2_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getPrefixAssignment_0(), "rule__NavigatingCommaArgCS__PrefixAssignment_0");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedNameExpressionAssignment_1(), "rule__NavigatingCommaArgCS__OwnedNameExpressionAssignment_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedCoIteratorAssignment_2_0_1(), "rule__NavigatingCommaArgCS__OwnedCoIteratorAssignment_2_0_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedInitExpressionAssignment_2_0_2_1(), "rule__NavigatingCommaArgCS__OwnedInitExpressionAssignment_2_0_2_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedTypeAssignment_2_1_1(), "rule__NavigatingCommaArgCS__OwnedTypeAssignment_2_1_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedCoIteratorAssignment_2_1_2_1(), "rule__NavigatingCommaArgCS__OwnedCoIteratorAssignment_2_1_2_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedInitExpressionAssignment_2_1_3_1(), "rule__NavigatingCommaArgCS__OwnedInitExpressionAssignment_2_1_3_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedTypeAssignment_2_2_0_1(), "rule__NavigatingCommaArgCS__OwnedTypeAssignment_2_2_0_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedCoIteratorAssignment_2_2_1_1(), "rule__NavigatingCommaArgCS__OwnedCoIteratorAssignment_2_2_1_1");
					put(grammarAccess.getNavigatingCommaArgCSAccess().getOwnedInitExpressionAssignment_2_2_3(), "rule__NavigatingCommaArgCS__OwnedInitExpressionAssignment_2_2_3");
					put(grammarAccess.getNavigatingSemiArgCSAccess().getPrefixAssignment_0(), "rule__NavigatingSemiArgCS__PrefixAssignment_0");
					put(grammarAccess.getNavigatingSemiArgCSAccess().getOwnedNameExpressionAssignment_1(), "rule__NavigatingSemiArgCS__OwnedNameExpressionAssignment_1");
					put(grammarAccess.getNavigatingSemiArgCSAccess().getOwnedTypeAssignment_2_1(), "rule__NavigatingSemiArgCS__OwnedTypeAssignment_2_1");
					put(grammarAccess.getNavigatingSemiArgCSAccess().getOwnedInitExpressionAssignment_2_2_1(), "rule__NavigatingSemiArgCS__OwnedInitExpressionAssignment_2_2_1");
					put(grammarAccess.getCoIteratorVariableCSAccess().getNameAssignment_0(), "rule__CoIteratorVariableCS__NameAssignment_0");
					put(grammarAccess.getCoIteratorVariableCSAccess().getOwnedTypeAssignment_1_1(), "rule__CoIteratorVariableCS__OwnedTypeAssignment_1_1");
					put(grammarAccess.getIfExpCSAccess().getOwnedConditionAssignment_1(), "rule__IfExpCS__OwnedConditionAssignment_1");
					put(grammarAccess.getIfExpCSAccess().getOwnedThenExpressionAssignment_3(), "rule__IfExpCS__OwnedThenExpressionAssignment_3");
					put(grammarAccess.getIfExpCSAccess().getOwnedIfThenExpressionsAssignment_4(), "rule__IfExpCS__OwnedIfThenExpressionsAssignment_4");
					put(grammarAccess.getIfExpCSAccess().getOwnedElseExpressionAssignment_6(), "rule__IfExpCS__OwnedElseExpressionAssignment_6");
					put(grammarAccess.getElseIfThenExpCSAccess().getOwnedConditionAssignment_1(), "rule__ElseIfThenExpCS__OwnedConditionAssignment_1");
					put(grammarAccess.getElseIfThenExpCSAccess().getOwnedThenExpressionAssignment_3(), "rule__ElseIfThenExpCS__OwnedThenExpressionAssignment_3");
					put(grammarAccess.getLetExpCSAccess().getOwnedVariablesAssignment_1(), "rule__LetExpCS__OwnedVariablesAssignment_1");
					put(grammarAccess.getLetExpCSAccess().getOwnedVariablesAssignment_2_1(), "rule__LetExpCS__OwnedVariablesAssignment_2_1");
					put(grammarAccess.getLetExpCSAccess().getOwnedInExpressionAssignment_4(), "rule__LetExpCS__OwnedInExpressionAssignment_4");
					put(grammarAccess.getLetVariableCSAccess().getNameAssignment_0(), "rule__LetVariableCS__NameAssignment_0");
					put(grammarAccess.getLetVariableCSAccess().getOwnedRoundBracketedClauseAssignment_1(), "rule__LetVariableCS__OwnedRoundBracketedClauseAssignment_1");
					put(grammarAccess.getLetVariableCSAccess().getOwnedTypeAssignment_2_1(), "rule__LetVariableCS__OwnedTypeAssignment_2_1");
					put(grammarAccess.getLetVariableCSAccess().getOwnedInitExpressionAssignment_4(), "rule__LetVariableCS__OwnedInitExpressionAssignment_4");
					put(grammarAccess.getNestedExpCSAccess().getOwnedExpressionAssignment_1(), "rule__NestedExpCS__OwnedExpressionAssignment_1");
					put(grammarAccess.getMultiplicityBoundsCSAccess().getLowerBoundAssignment_0(), "rule__MultiplicityBoundsCS__LowerBoundAssignment_0");
					put(grammarAccess.getMultiplicityBoundsCSAccess().getUpperBoundAssignment_1_1(), "rule__MultiplicityBoundsCS__UpperBoundAssignment_1_1");
					put(grammarAccess.getMultiplicityCSAccess().getIsNullFreeAssignment_2_1(), "rule__MultiplicityCS__IsNullFreeAssignment_2_1");
					put(grammarAccess.getMultiplicityStringCSAccess().getStringBoundsAssignment(), "rule__MultiplicityStringCS__StringBoundsAssignment");
					put(grammarAccess.getPathNameCSAccess().getOwnedPathElementsAssignment_0(), "rule__PathNameCS__OwnedPathElementsAssignment_0");
					put(grammarAccess.getPathNameCSAccess().getOwnedPathElementsAssignment_1_1(), "rule__PathNameCS__OwnedPathElementsAssignment_1_1");
					put(grammarAccess.getUnreservedPathNameCSAccess().getOwnedPathElementsAssignment_0(), "rule__UnreservedPathNameCS__OwnedPathElementsAssignment_0");
					put(grammarAccess.getUnreservedPathNameCSAccess().getOwnedPathElementsAssignment_1_1(), "rule__UnreservedPathNameCS__OwnedPathElementsAssignment_1_1");
					put(grammarAccess.getFirstPathElementCSAccess().getReferredElementAssignment(), "rule__FirstPathElementCS__ReferredElementAssignment");
					put(grammarAccess.getNextPathElementCSAccess().getReferredElementAssignment(), "rule__NextPathElementCS__ReferredElementAssignment");
					put(grammarAccess.getTemplateBindingCSAccess().getOwnedSubstitutionsAssignment_0(), "rule__TemplateBindingCS__OwnedSubstitutionsAssignment_0");
					put(grammarAccess.getTemplateBindingCSAccess().getOwnedSubstitutionsAssignment_1_1(), "rule__TemplateBindingCS__OwnedSubstitutionsAssignment_1_1");
					put(grammarAccess.getTemplateBindingCSAccess().getOwnedMultiplicityAssignment_2(), "rule__TemplateBindingCS__OwnedMultiplicityAssignment_2");
					put(grammarAccess.getTemplateParameterSubstitutionCSAccess().getOwnedActualParameterAssignment(), "rule__TemplateParameterSubstitutionCS__OwnedActualParameterAssignment");
					put(grammarAccess.getTypeParameterCSAccess().getNameAssignment_0(), "rule__TypeParameterCS__NameAssignment_0");
					put(grammarAccess.getTypeParameterCSAccess().getOwnedExtendsAssignment_1_1(), "rule__TypeParameterCS__OwnedExtendsAssignment_1_1");
					put(grammarAccess.getTypeParameterCSAccess().getOwnedExtendsAssignment_1_2_1(), "rule__TypeParameterCS__OwnedExtendsAssignment_1_2_1");
					put(grammarAccess.getWildcardTypeRefCSAccess().getOwnedExtendsAssignment_2_1(), "rule__WildcardTypeRefCS__OwnedExtendsAssignment_2_1");
				}
			};
		}
		return nameMappings.get(element);
	}

	@Override
	protected Collection<FollowElement> getFollowElements(AbstractInternalContentAssistParser parser) {
		try {
			org.eclipse.ocl.xtext.oclinecore.ui.contentassist.antlr.internal.InternalOCLinEcoreParser typedParser = (org.eclipse.ocl.xtext.oclinecore.ui.contentassist.antlr.internal.InternalOCLinEcoreParser) parser;
			typedParser.entryRuleTopLevelCS();
			return typedParser.getFollowElements();
		} catch(RecognitionException ex) {
			throw new RuntimeException(ex);
		}
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public OCLinEcoreGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(OCLinEcoreGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
