/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.ResourceWithSize;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.model.ShrinkedResourceProvider;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.NotificationForModelList;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.NotificationResourceLoader;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.RawNotification;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.RealWorldReplayNotificationProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkNotificationPreparer {
    public static Collection<RawNotification> prepareRealWorldReplayNotification(String eventTraceFixturePath) {
        return new RealWorldReplayNotificationProducer().produce(eventTraceFixturePath);
    }

    public static Collection<NotificationForModelList> prepareModelSizeVariationNotification(String eventTraceFixturePath, String modelFixturePath, boolean noShrinking) {
        List<ResourceWithSize> resources;
        ArrayList<NotificationForModelList> result = new ArrayList<NotificationForModelList>();
        ResourceWithSize fullSizeModel = NotificationResourceLoader.loadModel(modelFixturePath);
        if (noShrinking) {
            resources = Collections.singletonList(fullSizeModel);
        } else {
            ShrinkedResourceProvider shrinkedResourceProvider = new ShrinkedResourceProvider((Resource)fullSizeModel);
            shrinkedResourceProvider.runShrinkingProcess();
            resources = shrinkedResourceProvider.getAllResourcesFromLargeToSmall();
        }
        for (Resource resource : resources) {
            System.out.println("\t\t\tCreate notifications for resource: " + resource.getURI().toString());
            Collection<RawNotification> notiList = new RealWorldReplayNotificationProducer().produce(eventTraceFixturePath);
            System.out.println("\t\t\t\t " + notiList.size() + " created");
            result.add(new NotificationForModelList(resource, (List)notiList));
        }
        return result;
    }
}

