/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class OppositePropertyDetails {
    public static final @NonNull String BODY_KEY = "body";
    public static final @NonNull String LOWER_KEY = "lower";
    public static final @NonNull String ORDERED_KEY = "ordered";
    public static final @NonNull String UNIQUE_KEY = "unique";
    public static final @NonNull String UPPER_KEY = "upper";
    private static final Logger logger = Logger.getLogger(OppositePropertyDetails.class);
    public static final String PROPERTY_OPPOSITE_ROLE_NAME_KEY = "Property.oppositeRoleName";
    public static final Object PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY = "Property.oppositeUnique";
    public static final Object PROPERTY_OPPOSITE_ROLE_ORDERED_KEY = "Property.oppositeOrdered";
    public static final Object PROPERTY_OPPOSITE_ROLE_LOWER_KEY = "Property.oppositeLower";
    public static final Object PROPERTY_OPPOSITE_ROLE_UPPER_KEY = "Property.oppositeUpper";
    protected final @Nullable String name;
    protected final @Nullable Boolean ordered;
    protected final @Nullable Boolean unique;
    protected final @Nullable IntegerValue lower;
    protected final @Nullable UnlimitedNaturalValue upper;

    public static @Nullable OppositePropertyDetails createFromEReference(@NonNull EReference eReference) {
        EReference eOpposite = eReference.getEOpposite();
        if (eOpposite != null) {
            String oppositeName = eOpposite.getName();
            IntegerValue lower = ValueUtil.integerValueOf(eOpposite.getLowerBound());
            UnlimitedNaturalValue upper = ValueUtil.unlimitedNaturalValueOf(eOpposite.getUpperBound());
            return new OppositePropertyDetails(oppositeName, eOpposite.isOrdered(), eOpposite.isUnique(), lower, upper);
        }
        EAnnotation oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml");
        if (oppositeRole != null) {
            EMap details = oppositeRole.getDetails();
            String oppositeName = (String)details.get((Object)PROPERTY_OPPOSITE_ROLE_NAME_KEY);
            if (oppositeName != null) {
                UnlimitedNaturalValue upper;
                IntegerValue lower;
                String uniqueValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UNIQUE_KEY);
                String orderedValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_ORDERED_KEY);
                String lowerValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_LOWER_KEY);
                String upperValue = (String)details.get(PROPERTY_OPPOSITE_ROLE_UPPER_KEY);
                boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                IntegerValue one = ValueUtil.ONE_VALUE;
                IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf(lowerValue) : one;
                if (lower.isInvalid()) {
                    logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_LOWER_KEY + " " + lower));
                    lower = one;
                }
                UnlimitedNaturalValue unlimitedOne = ValueUtil.UNLIMITED_ONE_VALUE;
                UnlimitedNaturalValue unlimitedNaturalValue = upper = upperValue != null ? ValueUtil.unlimitedNaturalValueOf(upperValue) : unlimitedOne;
                if (upper.isInvalid()) {
                    logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_UPPER_KEY + " " + upper));
                    upper = unlimitedOne;
                }
                return new OppositePropertyDetails(oppositeName, isOrdered, isUnique, lower, upper);
            }
        } else {
            EMap details;
            String oppositeName;
            oppositeRole = eReference.getEAnnotation("http://schema.omg.org/spec/MOF/2.0/emof.xml#Property.oppositeRoleName");
            if (oppositeRole != null && (oppositeName = (String)(details = oppositeRole.getDetails()).get((Object)BODY_KEY)) != null) {
                UnlimitedNaturalValue upper;
                IntegerValue lower;
                String uniqueValue = (String)details.get((Object)UNIQUE_KEY);
                String orderedValue = (String)details.get((Object)ORDERED_KEY);
                String lowerValue = (String)details.get((Object)LOWER_KEY);
                String upperValue = (String)details.get((Object)UPPER_KEY);
                boolean isOrdered = orderedValue != null ? Boolean.valueOf(orderedValue) : false;
                boolean isUnique = uniqueValue != null ? Boolean.valueOf(uniqueValue) : true;
                IntegerValue integerValue = lower = lowerValue != null ? ValueUtil.integerValueOf(lowerValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                if (lower.isInvalid()) {
                    logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_LOWER_KEY + " " + lower));
                    lower = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE;
                }
                UnlimitedNaturalValue unlimitedNaturalValue = upper = upperValue != null ? ValueUtil.unlimitedNaturalValueOf(upperValue) : PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                if (upper.isInvalid()) {
                    logger.error((Object)("Invalid " + PROPERTY_OPPOSITE_ROLE_UPPER_KEY + " " + upper));
                    upper = PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE;
                }
                return new OppositePropertyDetails(oppositeName, isOrdered, isUnique, lower, upper);
            }
        }
        return null;
    }

    public static @Nullable OppositePropertyDetails createFromProperty(@NonNull Property property) {
        String name;
        UnlimitedNaturalValue upperValue;
        IntegerValue lowerValue;
        Type type;
        IntegerValue oppositeLower = null;
        Boolean oppositeOrdered = null;
        Boolean oppositeUnique = null;
        UnlimitedNaturalValue oppositeUpper = null;
        Type propertyType = property.getType();
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            type = collectionType.getElementType();
            lowerValue = collectionType.getLowerValue();
            upperValue = collectionType.getUpperValue();
            if (collectionType.isOrdered()) {
                oppositeOrdered = collectionType.isOrdered();
            }
            if (collectionType.isUnique()) {
                oppositeUnique = collectionType.isUnique();
            }
        } else {
            type = propertyType;
            lowerValue = property.isIsRequired() ? ValueUtil.ONE_VALUE : ValueUtil.ZERO_VALUE;
            upperValue = ValueUtil.UNLIMITED_ONE_VALUE;
        }
        if (!PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE.equals(lowerValue)) {
            oppositeLower = lowerValue;
        }
        if (!(property.getOpposite().isIsComposite() ? ValueUtil.UNLIMITED_ONE_VALUE : PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE).equals(upperValue)) {
            oppositeUpper = upperValue;
        }
        if ((name = property.getName()).equals(type.getName()) && oppositeLower == null && oppositeOrdered == null && oppositeUnique == null && oppositeUpper == null) {
            return null;
        }
        oppositeLower = null;
        oppositeOrdered = null;
        oppositeUnique = null;
        oppositeUpper = null;
        if (propertyType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)propertyType;
            if (collectionType.isOrdered()) {
                oppositeOrdered = collectionType.isOrdered();
            }
            if (!collectionType.isUnique()) {
                oppositeUnique = collectionType.isUnique();
            }
        }
        if (!PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_LOWER_VALUE.equals(lowerValue)) {
            oppositeLower = lowerValue;
        }
        if (!PivotConstantsInternal.ANNOTATED_IMPLICIT_OPPOSITE_UPPER_VALUE.equals(upperValue)) {
            oppositeUpper = upperValue;
        }
        return new OppositePropertyDetails(name, oppositeOrdered, oppositeUnique, oppositeLower, oppositeUpper);
    }

    public static @NonNull OppositePropertyDetails createImplicitFromEReference(@NonNull EReference eReference) {
        assert (eReference.getEOpposite() == null);
        EClass eClass = ClassUtil.nonNullState(eReference.getEContainingClass());
        String oppositeName = ClassUtil.nonNullState(eClass.getName());
        IntegerValue oppositeLower = null;
        Boolean oppositeOrdered = null;
        Boolean oppositeUnique = null;
        UnlimitedNaturalValue oppositeUpper = null;
        if (eReference.isContainment()) {
            oppositeOrdered = Boolean.FALSE;
            oppositeUnique = Boolean.FALSE;
            oppositeLower = ValueUtil.ZERO_VALUE;
            oppositeUpper = ValueUtil.UNLIMITED_ONE_VALUE;
        } else {
            oppositeOrdered = false;
            oppositeUnique = false;
            oppositeLower = PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE;
            oppositeUpper = PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE;
        }
        return new OppositePropertyDetails(oppositeName, oppositeOrdered, oppositeUnique, oppositeLower, oppositeUpper);
    }

    public static @NonNull OppositePropertyDetails createImplicitFromProperty(@NonNull Property asProperty) {
        Class asClass = PivotUtil.getOwningClass(asProperty);
        String oppositeName = PivotUtil.getName(asClass);
        IntegerValue oppositeLower = null;
        Boolean oppositeOrdered = null;
        Boolean oppositeUnique = null;
        UnlimitedNaturalValue oppositeUpper = null;
        if (asProperty.isIsComposite()) {
            oppositeOrdered = Boolean.FALSE;
            oppositeUnique = Boolean.FALSE;
            oppositeLower = ValueUtil.ZERO_VALUE;
            oppositeUpper = ValueUtil.UNLIMITED_ONE_VALUE;
        } else {
            oppositeOrdered = false;
            oppositeUnique = false;
            oppositeLower = PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_LOWER_VALUE;
            oppositeUpper = PivotConstantsInternal.DEFAULT_IMPLICIT_OPPOSITE_UPPER_VALUE;
        }
        return new OppositePropertyDetails(oppositeName, oppositeOrdered, oppositeUnique, oppositeLower, oppositeUpper);
    }

    public OppositePropertyDetails(@Nullable String name, @Nullable Boolean ordered, @Nullable Boolean unique, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        this.name = name;
        this.ordered = ordered;
        this.unique = unique;
        this.lower = lower;
        this.upper = upper;
    }

    public void addToDetails(@NonNull EMap<String, String> eAnnotationDetails) {
        String name2 = this.name;
        if (name2 == null) {
            eAnnotationDetails.removeKey((Object)BODY_KEY);
        } else {
            eAnnotationDetails.put((Object)BODY_KEY, (Object)name2);
        }
        IntegerValue lower2 = this.lower;
        if (lower2 == null) {
            eAnnotationDetails.removeKey((Object)LOWER_KEY);
        } else {
            eAnnotationDetails.put((Object)LOWER_KEY, (Object)lower2.toString());
        }
        Boolean ordered2 = this.ordered;
        if (ordered2 == null) {
            eAnnotationDetails.removeKey((Object)ORDERED_KEY);
        } else {
            eAnnotationDetails.put((Object)ORDERED_KEY, (Object)ordered2.toString());
        }
        Boolean unique2 = this.unique;
        if (unique2 == null) {
            eAnnotationDetails.removeKey((Object)UNIQUE_KEY);
        } else {
            eAnnotationDetails.put((Object)UNIQUE_KEY, (Object)unique2.toString());
        }
        UnlimitedNaturalValue upper2 = this.upper;
        if (upper2 == null) {
            eAnnotationDetails.removeKey((Object)UPPER_KEY);
        } else if (upper2.isUnlimited()) {
            eAnnotationDetails.put((Object)UPPER_KEY, (Object)"-1");
        } else {
            eAnnotationDetails.put((Object)UPPER_KEY, (Object)upper2.toString());
        }
    }

    public void addDetails(@NonNull Map<@NonNull String, @NonNull String> eAnnotationDetails) {
        String name2 = this.name;
        if (name2 == null) {
            eAnnotationDetails.remove(BODY_KEY);
        } else {
            eAnnotationDetails.put(BODY_KEY, name2);
        }
        IntegerValue lower2 = this.lower;
        if (lower2 == null) {
            eAnnotationDetails.remove(LOWER_KEY);
        } else {
            eAnnotationDetails.put(LOWER_KEY, lower2.toString());
        }
        Boolean ordered2 = this.ordered;
        if (ordered2 == null) {
            eAnnotationDetails.remove(ORDERED_KEY);
        } else {
            eAnnotationDetails.put(ORDERED_KEY, ordered2.toString());
        }
        Boolean unique2 = this.unique;
        if (unique2 == null) {
            eAnnotationDetails.remove(UNIQUE_KEY);
        } else {
            eAnnotationDetails.put(UNIQUE_KEY, unique2.toString());
        }
        UnlimitedNaturalValue upper2 = this.upper;
        if (upper2 == null) {
            eAnnotationDetails.remove(UPPER_KEY);
        } else if (upper2.isUnlimited()) {
            eAnnotationDetails.put(UPPER_KEY, "-1");
        } else {
            eAnnotationDetails.put(UPPER_KEY, upper2.toString());
        }
    }

    public @Nullable IntegerValue basicGetLower() {
        return this.lower;
    }

    public @Nullable String basicGetName() {
        return this.name;
    }

    public @Nullable UnlimitedNaturalValue basicGetUpper() {
        return this.upper;
    }

    public @Nullable Boolean basicIsOrdered() {
        return this.ordered;
    }

    public @Nullable Boolean basicIsUnique() {
        return this.unique;
    }

    public @NonNull IntegerValue getLower() {
        return ClassUtil.nonNullState(this.lower);
    }

    public @NonNull UnlimitedNaturalValue getUpper() {
        return ClassUtil.nonNullState(this.upper);
    }

    public @NonNull String getName() {
        return ClassUtil.nonNullState(this.name);
    }

    public @NonNull Boolean isOrdered() {
        return ClassUtil.nonNullState(this.ordered);
    }

    public @NonNull Boolean isUnique() {
        return ClassUtil.nonNullState(this.unique);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append("[");
        s.append(this.lower);
        s.append("..");
        s.append(this.upper);
        s.append("]{");
        s.append(this.ordered != false ? ORDERED_KEY : "!ordered");
        s.append(",");
        s.append(this.unique != false ? UNIQUE_KEY : "!unique");
        s.append("}");
        return s.toString();
    }
}

