/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.xtext.base.serializer.Indexed;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CharacterRange;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.XtextSwitch;

public class SerializationUtils {
    public static @NonNull String defaultIndentation = "    ";
    public static final @NonNull IndexedComparator INDEXED_COMPARATOR = IndexedComparator.INSTANCE;
    public static @NonNull List<@NonNull String> indents = new ArrayList<String>(10);

    public static void appendIndentation(@NonNull StringBuilder s, int depth) {
        SerializationUtils.appendIndentation(s, depth, defaultIndentation);
    }

    public static void appendIndentation(@NonNull StringBuilder s, int depth, @NonNull String string) {
        if (depth >= 0) {
            s.append("\n");
        }
        int i = 0;
        while (i < depth) {
            s.append(string);
            ++i;
        }
    }

    public static @NonNull EClass eClass(@NonNull EObject eObject) {
        return (EClass)ClassUtil.nonNullState((Object)eObject.eClass());
    }

    public static @NonNull EStructuralFeature eContainingFeature(@NonNull EObject eObject) {
        return (EStructuralFeature)ClassUtil.nonNullState((Object)eObject.eContainingFeature());
    }

    public static @NonNull EReference eContainmentFeature(@NonNull EObject eObject) {
        return (EReference)ClassUtil.nonNullState((Object)eObject.eContainmentFeature());
    }

    public static @NonNull EObject eContainer(@NonNull EObject eObject) {
        return (EObject)ClassUtil.nonNullState((Object)eObject.eContainer());
    }

    public static @NonNull AbstractElement getAlternatives(@NonNull AbstractRule abstractRule) {
        return (AbstractElement)ClassUtil.nonNullState((Object)abstractRule.getAlternatives());
    }

    public static @NonNull Iterable<@NonNull INode> getChildren(@NonNull ICompositeNode compositeNode) {
        return ClassUtil.nullFree((Iterable)compositeNode.getChildren());
    }

    public static @NonNull EClassifier getClassifier(TypeRef type) {
        return (EClassifier)ClassUtil.nonNullState((Object)type.getClassifier());
    }

    public static @NonNull EClass getEClassScope(@NonNull AbstractElement abstractElement) {
        TypeRef type = null;
        AbstractElement eObject = abstractElement;
        AbstractElement eChild = null;
        while (type == null && eObject != null) {
            if (eObject instanceof ParserRule) {
                type = ((ParserRule)eObject).getType();
            } else {
                if (eObject instanceof Action && ((Action)eObject).getFeature() != null) {
                    type = ((Action)eObject).getType();
                    break;
                }
                if (eObject instanceof Group && eChild != null) {
                    List<@NonNull AbstractElement> elements = SerializationUtils.getElements((CompoundElement)((Group)eObject));
                    int index = elements.indexOf(eChild);
                    assert (index >= 0);
                    int i = index;
                    while (--i >= 0) {
                        AbstractElement element = elements.get(i);
                        if (!(element instanceof Action)) continue;
                        type = ((Action)element).getType();
                        break;
                    }
                }
            }
            eChild = eObject;
            eObject = eObject.eContainer();
        }
        if (type != null) {
            return (EClass)SerializationUtils.getClassifier(type);
        }
        throw new IllegalStateException();
    }

    public static @NonNull EClass getEContainingClass(@NonNull EStructuralFeature eFeature) {
        return (EClass)ClassUtil.nonNullState((Object)eFeature.getEContainingClass());
    }

    public static @NonNull EPackage getEPackage(@NonNull EClassifier eClassifier) {
        return (EPackage)ClassUtil.nonNullState((Object)eClassifier.getEPackage());
    }

    public static @NonNull List<@NonNull AbstractElement> getElements(@NonNull CompoundElement compoundElement) {
        return ClassUtil.nullFree((EList)compoundElement.getElements());
    }

    public static @NonNull Grammar getEContainingGrammar(@NonNull EObject eObject) {
        EObject eCursor = eObject;
        while (eCursor != null) {
            if (eCursor instanceof Grammar) {
                return (Grammar)eCursor;
            }
            eCursor = eCursor.eContainer();
        }
        throw new IllegalStateException();
    }

    public static @NonNull EClass getEReferenceType(@NonNull EReference eReference) {
        return (EClass)ClassUtil.nonNullState((Object)eReference.getEReferenceType());
    }

    public static @NonNull EStructuralFeature getEStructuralFeature(@NonNull EClass eClass, @NonNull String featureName) {
        return (EStructuralFeature)ClassUtil.nonNullState((Object)eClass.getEStructuralFeature(featureName));
    }

    public static @NonNull EStructuralFeature getEStructuralFeature(@NonNull Assignment assignment) {
        return SerializationUtils.getEStructuralFeature(SerializationUtils.getEClassScope((AbstractElement)assignment), SerializationUtils.getFeature(assignment));
    }

    public static @NonNull EClass getSubTypeOf(@NonNull EClass thisEClass, @NonNull EClass thatEClass) {
        if (thisEClass == thatEClass) {
            return thisEClass;
        }
        if (thisEClass.isSuperTypeOf(thatEClass)) {
            return thatEClass;
        }
        if (thatEClass.isSuperTypeOf(thisEClass)) {
            return thisEClass;
        }
        throw new IllegalStateException("No common subtype");
    }

    public static @NonNull String getFeature(@NonNull Action action) {
        return (String)ClassUtil.nonNullState((Object)action.getFeature());
    }

    public static @NonNull String getFeature(@NonNull Assignment assignment) {
        return (String)ClassUtil.nonNullState((Object)assignment.getFeature());
    }

    public static @NonNull String getIndent(int indent) {
        if (indents.size() <= indent) {
            int i = indents.size();
            while (i <= indent) {
                indents.add(i == 0 ? "" : String.valueOf(indents.get(i - 1)) + "  ");
                ++i;
            }
        }
        return indents.get(indent);
    }

    public static @NonNull Keyword getLeft(@NonNull CharacterRange characterRange) {
        return (Keyword)ClassUtil.nonNullState((Object)characterRange.getLeft());
    }

    public static @NonNull String getName(@NonNull AbstractRule abstractRule) {
        return (String)ClassUtil.nonNullState((Object)abstractRule.getName());
    }

    public static @NonNull String getName(@NonNull ENamedElement eNamedElement) {
        return (String)ClassUtil.nonNullState((Object)eNamedElement.getName());
    }

    public static @NonNull Resource getResource(@NonNull EObject eObject) {
        return (Resource)ClassUtil.nonNullState((Object)eObject.eResource());
    }

    public static @NonNull Keyword getRight(@NonNull CharacterRange characterRange) {
        return (Keyword)ClassUtil.nonNullState((Object)characterRange.getRight());
    }

    public static @NonNull AbstractRule getRule(@NonNull RuleCall ruleCall) {
        return (AbstractRule)ClassUtil.nonNullState((Object)ruleCall.getRule());
    }

    public static @NonNull String getSafeName(@Nullable Nameable aNameable) {
        if (aNameable == null) {
            return "";
        }
        String name = aNameable.getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    public static @NonNull AbstractElement getTerminal(@NonNull Assignment assignment) {
        return (AbstractElement)ClassUtil.nonNullState((Object)assignment.getTerminal());
    }

    public static @NonNull AbstractElement getTerminal(@NonNull CrossReference crossReference) {
        return (AbstractElement)ClassUtil.nonNullState((Object)crossReference.getTerminal());
    }

    public static @NonNull AbstractElement getTerminal(@NonNull UntilToken untilToken) {
        return (AbstractElement)ClassUtil.nonNullState((Object)untilToken.getTerminal());
    }

    public static @NonNull TypeRef getType(@NonNull AbstractRule abstractRule) {
        return (TypeRef)ClassUtil.nonNullState((Object)abstractRule.getType());
    }

    public static @NonNull TypeRef getType(@NonNull Action action) {
        return (TypeRef)ClassUtil.nonNullState((Object)action.getType());
    }

    public static @NonNull Iterable<@NonNull Grammar> getUsedGrammars(@NonNull Grammar grammar) {
        return ClassUtil.nullFree((EList)grammar.getUsedGrammars());
    }

    public static @NonNull String getValue(@NonNull Keyword keyword) {
        return (String)ClassUtil.nonNullState((Object)keyword.getValue());
    }

    public static final class IndexedComparator
    implements Comparator<Indexed> {
        public static final @NonNull IndexedComparator INSTANCE = new IndexedComparator();

        @Override
        public int compare(@NonNull Indexed o1, @NonNull Indexed o2) {
            int n1 = o1.getIndex();
            int n2 = o2.getIndex();
            return n1 - n2;
        }
    }

    public static class NodeIterator
    implements Iterator<INode> {
        private @Nullable INode node;
        private boolean hasNext;
        private boolean childrenPending;

        public NodeIterator(@NonNull INode node) {
            this.node = node;
            this.hasNext = true;
            this.childrenPending = node instanceof ICompositeNode;
        }

        public NodeIterator(@NonNull NodeIterator nodeIterator) {
            this.node = nodeIterator.node;
            this.hasNext = nodeIterator.hasNext;
            this.childrenPending = nodeIterator.childrenPending;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            INode thisNode = this.node;
            if (thisNode == null) {
                return false;
            }
            INode nextNode = null;
            if (this.childrenPending) {
                nextNode = ((ICompositeNode)thisNode).getFirstChild();
                this.childrenPending = nextNode instanceof ICompositeNode;
            }
            if (nextNode == null) {
                nextNode = thisNode.getNextSibling();
                if (nextNode == null) {
                    nextNode = thisNode.getParent();
                    this.childrenPending = false;
                } else {
                    this.childrenPending = nextNode instanceof ICompositeNode;
                }
            }
            this.node = nextNode;
            this.hasNext = nextNode != null;
            return this.hasNext;
        }

        public boolean isChildrenPending() {
            assert (this.node instanceof ICompositeNode);
            return this.childrenPending;
        }

        @Override
        public @NonNull INode next() {
            this.hasNext = false;
            if (this.node != null) {
                return this.node;
            }
            throw new NoSuchElementException();
        }
    }

    public static class XtextToString
    extends XtextSwitch<Object> {
        protected final @NonNull StringBuilder s;
        protected final boolean showIds;

        public XtextToString(@NonNull StringBuilder s, boolean showIds) {
            this.s = s;
            this.showIds = showIds;
        }

        protected void appendCardinality(AbstractElement object) {
            String cardinality = object.getCardinality();
            if (cardinality != null) {
                this.s.append(cardinality);
            }
        }

        protected void appendElement(EObject object) {
            if (this.showIds) {
                this.s.append(object.eClass().getName());
                this.s.append("@");
                this.s.append(Integer.toHexString(System.identityHashCode(object)));
            }
        }

        public Object caseAction(Action object) {
            this.appendElement((EObject)object);
            this.s.append("{");
            this.doSwitch((EObject)object.getType());
            this.s.append(".");
            this.s.append(object.getFeature());
            this.s.append(object.getOperator());
            this.s.append("current}");
            this.appendCardinality((AbstractElement)object);
            return this;
        }

        public Object caseAlternatives(Alternatives object) {
            this.appendElement((EObject)object);
            this.s.append("(");
            boolean isFirst = true;
            for (AbstractElement g : object.getElements()) {
                if (!isFirst) {
                    this.s.append("|");
                }
                this.doSwitch((EObject)g);
                isFirst = false;
            }
            this.s.append(")");
            this.appendCardinality((AbstractElement)object);
            return this;
        }

        public Object caseAssignment(Assignment object) {
            this.appendElement((EObject)object);
            this.s.append(object.getFeature());
            this.s.append(object.getOperator());
            this.doSwitch((EObject)object.getTerminal());
            this.appendCardinality((AbstractElement)object);
            return this;
        }

        public Object caseCrossReference(CrossReference object) {
            this.appendElement((EObject)object);
            this.doSwitch((EObject)object.getTerminal());
            this.appendCardinality((AbstractElement)object);
            return this;
        }

        public Object caseGroup(Group object) {
            this.appendElement((EObject)object);
            this.s.append("(");
            boolean isFirst = true;
            for (AbstractElement g : object.getElements()) {
                if (!isFirst) {
                    this.s.append(" ");
                }
                this.doSwitch((EObject)g);
                isFirst = false;
            }
            this.s.append(")");
            this.appendCardinality((AbstractElement)object);
            return this;
        }

        public Object caseKeyword(Keyword object) {
            this.appendElement((EObject)object);
            this.s.append("'");
            this.s.append(object.getValue());
            this.s.append("'");
            this.appendCardinality((AbstractElement)object);
            return this;
        }

        public Object caseParserRule(ParserRule object) {
            this.appendElement((EObject)object);
            this.s.append(object.getName());
            return this;
        }

        public Object caseRuleCall(RuleCall object) {
            this.appendElement((EObject)object);
            this.doSwitch((EObject)object.getRule());
            this.appendCardinality((AbstractElement)object);
            return this;
        }

        public Object caseTerminalRule(TerminalRule object) {
            this.appendElement((EObject)object);
            this.s.append(object.getName());
            return this;
        }

        public Object caseTypeRef(TypeRef object) {
            this.appendElement((EObject)object);
            EClassifier eClassifier = object.getClassifier();
            this.s.append(eClassifier.getEPackage().getName());
            this.s.append("::");
            this.s.append(eClassifier.getName());
            return this;
        }

        public Object defaultCase(EObject object) {
            this.s.append("**");
            if (this.showIds) {
                this.appendElement(object);
            } else {
                this.s.append(object.eClass().getName());
            }
            this.s.append("**");
            return this;
        }
    }
}

