/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import java.util.regex.Pattern;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.FunctionScript;
import org.eclipse.papyrus.designer.languages.c.codegen.utils.CGenUtils;
import org.eclipse.papyrus.designer.languages.c.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BehaviorScript {
    public static CharSequence returnSpec(Behavior behavior) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        Parameter _returnResult = GenUtils.returnResult((Behavior)behavior);
        boolean bl = _tripleEquals = _returnResult == null;
        if (_tripleEquals) {
            _builder.append("void ");
        } else {
            String _modCVQualifier = Modifier.modCVQualifier((Element)GenUtils.returnResult((Behavior)behavior));
            _builder.append(_modCVQualifier);
            _builder.append(" ");
            String _cppQualifiedName = CGenUtils.cppQualifiedName((NamedElement)GenUtils.returnResult((Behavior)behavior).getType());
            _builder.append(_cppQualifiedName);
            String _modPtr = Modifier.modPtr((Element)GenUtils.returnResult((Behavior)behavior));
            _builder.append(_modPtr);
            String _modRef = Modifier.modRef((Element)GenUtils.returnResult((Behavior)behavior));
            _builder.append(_modRef);
            _builder.append(" ");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence behaviorImplementation(String name, OpaqueBehavior behavior) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genComment = CommonScript.genComment((Element)behavior);
        _builder.append((Object)_genComment);
        _builder.newLineIfNotEmpty();
        CharSequence _returnSpec = BehaviorScript.returnSpec((Behavior)behavior);
        _builder.append((Object)_returnSpec);
        _builder.append(name);
        _builder.append("(");
        CharSequence _behaviorParameters = BehaviorScript.behaviorParameters((Behavior)behavior, false);
        _builder.append((Object)_behaviorParameters);
        _builder.append(")");
        String _modCVQualifier = Modifier.modCVQualifier((Element)behavior);
        _builder.append(_modCVQualifier);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _bodyFromOB = GenUtils.getBodyFromOB((OpaqueBehavior)behavior, (Pattern)FunctionScript.CLANGUAGE);
        _builder.append(_bodyFromOB, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static String InlineTxt(Element element) {
        String _xifexpression = null;
        boolean _hasStereotype = GenUtils.hasStereotype((Element)element, Inline.class);
        if (_hasStereotype) {
            _xifexpression = "inline ";
        }
        return _xifexpression;
    }

    public static CharSequence behaviorDeclaration(String name, Behavior behavior) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genComment = CommonScript.genComment((Element)behavior);
        _builder.append((Object)_genComment);
        _builder.newLineIfNotEmpty();
        String _InlineTxt = BehaviorScript.InlineTxt((Element)behavior);
        _builder.append(_InlineTxt);
        CharSequence _returnSpec = BehaviorScript.returnSpec(behavior);
        _builder.append((Object)_returnSpec);
        _builder.append(name);
        _builder.append("(");
        CharSequence _behaviorParameters = BehaviorScript.behaviorParameters(behavior, true);
        _builder.append((Object)_behaviorParameters);
        _builder.append(")");
        String _modCVQualifier = Modifier.modCVQualifier((Element)behavior);
        _builder.append(_modCVQualifier);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence behaviorParameters(Behavior behavior, boolean showDefault) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)behavior.getOwnedParameters(), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Parameter ownedParameter : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _parameter = BehaviorScript.parameter(ownedParameter, showDefault);
            _builder.append(_parameter);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String parameter(Parameter parameter, boolean showDefault) {
        String _modCVQualifier = Modifier.modCVQualifier((Element)parameter);
        String _modSCQualifier = Modifier.modSCQualifier((Element)parameter);
        String _plus = String.valueOf(_modCVQualifier) + _modSCQualifier;
        String _cppQualifiedName = CGenUtils.cppQualifiedName((NamedElement)parameter.getType());
        String _plus_1 = String.valueOf(_plus) + _cppQualifiedName;
        String _modPtr = Modifier.modPtr((Element)parameter);
        String _plus_2 = String.valueOf(_plus_1) + _modPtr;
        String _modRef = Modifier.modRef((Element)parameter);
        String _plus_3 = String.valueOf(_plus_2) + _modRef;
        String _dirInfo = Modifier.dirInfo((Element)parameter);
        String _plus_4 = String.valueOf(_plus_3) + _dirInfo;
        String _plus_5 = String.valueOf(_plus_4) + " ";
        String _name = parameter.getName();
        String _plus_6 = String.valueOf(_plus_5) + _name;
        String _modArray = Modifier.modArray((Element)parameter);
        String _plus_7 = String.valueOf(_plus_6) + _modArray;
        String _xifexpression = null;
        _xifexpression = showDefault ? BehaviorScript.defaultValue(parameter) : "";
        return String.valueOf(_plus_7) + _xifexpression;
    }

    public static String defaultValue(Parameter parameter) {
        boolean _tripleNotEquals;
        String _xifexpression = null;
        ValueSpecification _defaultValue = parameter.getDefaultValue();
        boolean bl = _tripleNotEquals = _defaultValue != null;
        if (_tripleNotEquals) {
            String _stringValue = parameter.getDefaultValue().stringValue();
            _xifexpression = " = " + _stringValue;
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }
}

