/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.cpp.codegen.preferences;

public class CppCodeGenConstants {

	/**
	 * Suffix for generated header files
	 */
	public static final String P_HEADER_SUFFIX = "headSuffix"; //$NON-NLS-1$

	/**
	 * Suffix for generated body/implementation files
	 */
	public static final String P_IMPLEM_SUFFIX = "implSuffix"; //$NON-NLS-1$

	/**
	 * Suffix for generated body/implementation files
	 */
	public static final String P_OUT_INOUT_OP = "outInoutOp"; //$NON-NLS-1$

	/**
	 * User defined comment header in generated files
	 */
	public static final String P_COMMENT_HEADER = "commentHeader"; //$NON-NLS-1$

	/**
	 * Project prefix to use
	 */
	public static final String P_PROJECT_PREFIX = "projectPrefix"; //$NON-NLS-1$

	/**
	 * If true, generate automatic "using" statements
	 */
	public static final String P_USING_NAMESPACES = "usingNamespaces"; //$NON-NLS-1$

	/**
	 * If true, generate an C++ 11 class enumeration (impact on scoping)
	 */
	public static final String P_CPP11_CLASS_ENUM = "c++11ClassEnum"; //$NON-NLS-1$

	/**
	 * If true (default), format the generated code
	 */
	public static final String P_FORMAT_CODE = "formatCode"; //$NON-NLS-1$

}
