/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class TimeEventTransformation {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private Class superContext;

    public TimeEventTransformation(SM2ClassesTransformationCore core) {
        this.core = core;
        this.superContext = core.superContext;
        this.cdefs = core.cdefs;
    }

    public void createTimeEvents() {
        boolean _isEmpty = this.core.timeEvents.isEmpty();
        if (_isEmpty) {
            return;
        }
        Operation timeEventOp = this.superContext.createOwnedOperation("listenTimeEvent", null, null);
        timeEventOp.createOwnedParameter("id", this.core.intType);
        timeEventOp.createOwnedParameter("duration", this.core.intType);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("while (true) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("long startTime = System.currentTimeMillis();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("synchronized (this) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("wait(duration);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} catch (InterruptedException e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("// TODO Auto-generated catch block");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("long endTime = System.currentTimeMillis();");
        _builder.newLine();
        _builder.append("long timedWaitResult = endTime - startTime;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("boolean commitEvent = false;");
        _builder.newLine();
        _builder.append("if (timedWaitResult >= duration) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// timeout");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("commitEvent = true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("timeEventFlags[id] = false;");
        _builder.newLine();
        _builder.append("if (commitEvent) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Event_t event = new Event_t(EventPriority_t.PRIORITY_2, id, EventType_t.TIME_EVENT, id, 0);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("eventQueue.add(event);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        this.core.createOpaqueBehavior(this.superContext, timeEventOp, _builder.toString());
    }
}

