/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.cpp.xtend;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.components.transformation.cpp.xtend.StaticCppToOO;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.TemplateBinding;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class CreateMultiRefClass {
    private StaticCppToOO cppToOO;
    private LazyCopier copier;
    private static String progLang = "C++";

    public CreateMultiRefClass(StaticCppToOO cppToOO, LazyCopier copier) {
        this.cppToOO = cppToOO;
        this.copier = copier;
    }

    public String createDelegationProvided(Class implementation, List<ConnectorEnd> ces, Port port, String portName, Interface providedIntf) {
        String attributeName = String.valueOf(PrefixConstants.attributePrefix) + portName;
        Property attr = implementation.getOwnedAttribute(attributeName, null);
        if (attr == null || attr instanceof Port) {
            Class broadcastClass = this.getOrCreateBroadcastClass(providedIntf);
            attr = implementation.createOwnedAttribute(attributeName, (Type)broadcastClass);
            ValueSpecification _createDefaultValue = attr.createDefaultValue("default", attr.getType(), UMLPackage.Literals.LITERAL_STRING);
            LiteralString defaultValue = (LiteralString)_createDefaultValue;
            defaultValue.setValue("NULL");
            attr.setAggregation(AggregationKind.SHARED_LITERAL);
            return this.createDelegationConnCode(ces, broadcastClass, portName, providedIntf);
        }
        return "";
    }

    public String createDelegationConnCode(List<ConnectorEnd> ces, Class broadcastClass, String portName, Interface providedIntf) {
        StringConcatenation _builder = new StringConcatenation();
        String attributeName = String.valueOf(PrefixConstants.attributePrefix) + portName;
        _builder.newLineIfNotEmpty();
        _builder.append("// generated broadcast class uses generic port name");
        _builder.newLine();
        String connectOpName = String.valueOf(PrefixConstants.connectQ_Prefix) + "port";
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("if (");
        _builder.append(attributeName);
        _builder.append(" == NULL) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(attributeName, "\t");
        _builder.append(" = new ");
        String _qualifiedName = broadcastClass.getQualifiedName();
        _builder.append(_qualifiedName, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        for (ConnectorEnd ce : ces) {
            boolean _greaterThan_2;
            Property part = ce.getPartWithPort();
            _builder.newLineIfNotEmpty();
            ConnectableElement role = ce.getRole();
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            if (role instanceof Port) {
                boolean _greaterThan_1;
                Port rolePort = (Port)role;
                _builder.newLineIfNotEmpty();
                boolean _contains = rolePort.getProvideds().contains((Object)providedIntf);
                if (!_contains) continue;
                if (rolePort.getProvideds().size() > 1 || rolePort.getProvideds().size() == 1 && !(rolePort.getType() instanceof Interface)) {
                    boolean _greaterThan;
                    int _upper = part.getUpper();
                    boolean bl = _greaterThan = _upper > 1;
                    if (_greaterThan) {
                        int _upper_1 = part.getUpper();
                        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _upper_1, true);
                        for (Integer i : _doubleDotLessThan) {
                            _builder.append(attributeName);
                            _builder.append("->");
                            _builder.append(connectOpName);
                            _builder.append("(");
                            String _name = part.getName();
                            _builder.append(_name);
                            _builder.append("[");
                            _builder.append((Object)i);
                            _builder.append("].");
                            _builder.append(PrefixConstants.getP_Prefix);
                            String _name_1 = ((Port)role).getName();
                            _builder.append(_name_1);
                            String _name_2 = providedIntf.getName();
                            _builder.append(_name_2);
                            _builder.append("());");
                            _builder.newLineIfNotEmpty();
                        }
                        continue;
                    }
                    _builder.append(attributeName);
                    _builder.append("->");
                    _builder.append(connectOpName);
                    _builder.append("(");
                    String _nameRef = this.cppToOO.nameRef(part);
                    _builder.append(_nameRef);
                    _builder.append(PrefixConstants.getP_Prefix);
                    String _name_3 = ((Port)role).getName();
                    _builder.append(_name_3);
                    String _name_4 = providedIntf.getName();
                    _builder.append(_name_4);
                    _builder.append("());");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                int _upper_2 = part.getUpper();
                boolean bl = _greaterThan_1 = _upper_2 > 1;
                if (_greaterThan_1) {
                    int _upper_3 = part.getUpper();
                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _upper_3, true);
                    for (Integer i_1 : _doubleDotLessThan_1) {
                        _builder.append(attributeName);
                        _builder.append("->");
                        _builder.append(connectOpName);
                        _builder.append("(");
                        String _name_5 = part.getName();
                        _builder.append(_name_5);
                        _builder.append("[");
                        _builder.append((Object)i_1);
                        _builder.append("].");
                        _builder.append(PrefixConstants.getP_Prefix);
                        String _name_6 = ((Port)role).getName();
                        _builder.append(_name_6);
                        _builder.append("());");
                        _builder.newLineIfNotEmpty();
                    }
                    continue;
                }
                _builder.append(attributeName);
                _builder.append("->");
                _builder.append(connectOpName);
                _builder.append("(");
                String _nameRef_1 = this.cppToOO.nameRef(part);
                _builder.append(_nameRef_1);
                _builder.append(PrefixConstants.getP_Prefix);
                String _name_7 = ((Port)role).getName();
                _builder.append(_name_7);
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                continue;
            }
            if (!(role instanceof Property)) continue;
            Type roleType = ((Property)role).getType();
            _builder.newLineIfNotEmpty();
            if (!(roleType instanceof BehavioredClassifier) || ((BehavioredClassifier)roleType).getInterfaceRealization(null, providedIntf) == null) continue;
            int _upper_4 = ((Property)role).getUpper();
            boolean bl = _greaterThan_2 = _upper_4 > 1;
            if (_greaterThan_2) {
                int _upper_5 = ((Property)role).getUpper();
                ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, _upper_5, true);
                for (Integer i_2 : _doubleDotLessThan_2) {
                    _builder.append(attributeName);
                    _builder.append("->");
                    _builder.append(connectOpName);
                    _builder.append("(");
                    String _name_8 = ((Property)role).getName();
                    _builder.append(_name_8);
                    _builder.append("[");
                    _builder.append((Object)i_2);
                    _builder.append("]);");
                    _builder.newLineIfNotEmpty();
                }
                continue;
            }
            _builder.append(attributeName);
            _builder.append("->");
            _builder.append(connectOpName);
            _builder.append("(");
            String _name_9 = ((Property)role).getName();
            _builder.append(_name_9);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("return ");
        _builder.append(attributeName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String createDelegationRequired(Class implementation, String portName, Interface requiredIntf) {
        String attributeName = String.valueOf(PrefixConstants.attributePrefix) + portName;
        String opName = String.valueOf(PrefixConstants.connectQ_Prefix) + "port";
        Property attr = implementation.getOwnedAttribute(attributeName, null);
        if (attr == null || attr instanceof Port) {
            Class broadcastClass = this.getOrCreateBroadcastClass(requiredIntf);
            attr = implementation.createOwnedAttribute(attributeName, (Type)broadcastClass);
            ValueSpecification _createDefaultValue = attr.createDefaultValue("default", attr.getType(), UMLPackage.Literals.LITERAL_STRING);
            LiteralString defaultValue = (LiteralString)_createDefaultValue;
            defaultValue.setValue("NULL");
            this.cppToOO.applyRef((Element)attr);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("if (!");
            _builder.append(attributeName);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(attributeName, "\t");
            _builder.append(" = new ");
            String _qualifiedName = broadcastClass.getQualifiedName();
            _builder.append(_qualifiedName, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.append(attributeName);
            _builder.append("->");
            _builder.append(opName);
            _builder.append("(ref);");
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        }
        return "";
    }

    public Class getOrCreateBroadcastClass(Interface intf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Broadcast_");
        String _name = intf.getName();
        _builder.append(_name);
        String broadcastClassName = _builder.toString();
        PackageableElement broadcastClass = intf.getNearestPackage().getPackagedElement(broadcastClassName);
        if (broadcastClass instanceof Class) {
            return (Class)broadcastClass;
        }
        return this.createBroadcastClass(intf);
    }

    public Class createBroadcastClass(Interface intf) {
        String opName = String.valueOf(PrefixConstants.connectQ_Prefix) + "port";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Broadcast_");
        String _name = intf.getName();
        _builder.append(_name);
        String broadcastClassName = _builder.toString();
        Class broadcastClass = intf.getNearestPackage().createOwnedClass(broadcastClassName, false);
        broadcastClass.createInterfaceRealization("broadcast" + intf, intf);
        PackageUtil.loadPackage((URI)CppUriConstants.STL_LIB_URI, (ResourceSet)this.copier.source.eResource().getResourceSet());
        NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)this.copier.source, (String)"std::vector");
        Type vector = (Type)_qualifiedElementFromRS;
        if (vector == null) {
            String _format = String.format("Can not find type %s. Thus, unable to create suitable connect operation in component to OO transformation", "std::vector");
            throw new RuntimeException(_format);
        }
        vector = (Type)this.copier.getCopy((Element)vector);
        Property references = broadcastClass.createOwnedAttribute("references", vector);
        TemplateBinding tBinding = (TemplateBinding)StereotypeUtil.applyApp((Element)references, TemplateBinding.class);
        tBinding.getActuals().add((Object)this.cppToOO.createPtrType((Type)intf));
        Operation connectOperation = broadcastClass.createOwnedOperation(opName, null, null);
        Parameter connectRefParam = connectOperation.createOwnedParameter("ref", (Type)intf);
        this.cppToOO.applyRef((Element)connectRefParam);
        Behavior _createOwnedBehavior = broadcastClass.createOwnedBehavior(opName, UMLPackage.eINSTANCE.getOpaqueBehavior());
        OpaqueBehavior connectBehavior = (OpaqueBehavior)_createOwnedBehavior;
        connectOperation.getMethods().add((Object)connectBehavior);
        connectBehavior.getLanguages().add((Object)progLang);
        EList _bodies = connectBehavior.getBodies();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("references.push_back(ref);");
        _builder_1.newLine();
        _bodies.add((Object)_builder_1.toString());
        EList _operations = intf.getOperations();
        for (Operation operation : _operations) {
            BasicEList parameterNames = new BasicEList();
            BasicEList parameterTypes = new BasicEList();
            BasicEList parameterNamesWithReturn = new BasicEList();
            BasicEList parameterTypesWithReturn = new BasicEList();
            EList _ownedParameters = operation.getOwnedParameters();
            for (Parameter parameter : _ownedParameters) {
                boolean _notEquals;
                ParameterDirectionKind _direction = parameter.getDirection();
                boolean bl = _notEquals = !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                if (_notEquals) {
                    parameterNames.add((Object)parameter.getName());
                    parameterTypes.add((Object)parameter.getType());
                }
                parameterNamesWithReturn.add((Object)parameter.getName());
                parameterTypesWithReturn.add((Object)parameter.getType());
            }
            Operation copiedOperation = (Operation)EcoreUtil.copy((EObject)operation);
            broadcastClass.getOwnedOperations().add((Object)copiedOperation);
            Operation delegationOperation = copiedOperation;
            this.cppToOO.copyCppOperationAndParameterStereotypes((Element)operation, (Element)copiedOperation);
            StringConcatenation _builder_2 = new StringConcatenation();
            String _name_1 = operation.getName();
            _builder_2.append(_name_1);
            _builder_2.append("(");
            _builder_2.newLineIfNotEmpty();
            boolean _hasElements = false;
            for (String parameterName : parameterNames) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)", ", "\t");
                }
                _builder_2.append("\t");
                _builder_2.append(parameterName, "\t");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t\t\t\t\t");
            }
            _builder_2.append(")");
            _builder_2.newLineIfNotEmpty();
            String delegateOperationCall = _builder_2.toString().trim();
            int _size = parameterNamesWithReturn.size();
            int _size_1 = parameterNames.size();
            boolean hasReturn = _size > _size_1;
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("for (unsigned int i = 0; i < references.size()");
            if (hasReturn) {
                _builder_3.append(" - 1");
            }
            _builder_3.append("; i++) {");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("\t");
            _builder_3.append("references[i]->");
            _builder_3.append(delegateOperationCall, "\t");
            _builder_3.append(";");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("}");
            _builder_3.newLine();
            if (hasReturn) {
                _builder_3.append("return references[references.size() - 1]->");
                _builder_3.append(delegateOperationCall);
                _builder_3.append(";");
                _builder_3.newLineIfNotEmpty();
            }
            String delegationOperationBody = _builder_3.toString();
            Behavior _createOwnedBehavior_1 = broadcastClass.createOwnedBehavior(opName, UMLPackage.eINSTANCE.getOpaqueBehavior());
            OpaqueBehavior delegationOperationBehavior = (OpaqueBehavior)_createOwnedBehavior_1;
            delegationOperation.getMethods().add((Object)delegationOperationBehavior);
            delegationOperationBehavior.getLanguages().add((Object)progLang);
            delegationOperationBehavior.getBodies().add((Object)delegationOperationBody);
        }
        return broadcastClass;
    }
}

