/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.templates;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

public class ComponentTemplateUtils {
    public static void retargetConnectors(StructuredClassifier composite, Property part) {
        Type partType = part.getType();
        if (partType instanceof EncapsulatedClassifier) {
            EncapsulatedClassifier partTypeEC = (EncapsulatedClassifier)partType;
            for (Connector connector : composite.getOwnedConnectors()) {
                ConnectorEnd connEnd;
                if (!ConnectorUtil.connectsPart((Connector)connector, (Property)part) || !((connEnd = ConnectorUtil.connEndForPart((Connector)connector, (Property)part)).getRole() instanceof Port)) continue;
                Port connectedTemplatePort = (Port)connEnd.getRole();
                Port connectedBoundPort = (Port)ElementUtils.getNamedElementFromList(PortUtils.getAllPorts(partTypeEC), (String)connectedTemplatePort.getName());
                connEnd.setRole((ConnectableElement)connectedBoundPort);
            }
        }
    }

    public static void retargetConnectors(StructuredClassifier composite) {
        for (Connector connector : composite.getOwnedConnectors()) {
            for (ConnectorEnd connEnd : connector.getEnds()) {
                Property part = connEnd.getPartWithPort();
                if (part == null || !(part.getType() instanceof EncapsulatedClassifier)) continue;
                EncapsulatedClassifier partTypeEC = (EncapsulatedClassifier)part.getType();
                ConnectableElement role = connEnd.getRole();
                EList<Port> ports = PortUtils.getAllPorts(partTypeEC);
                if (!(role instanceof Port) || ports.contains((Object)role)) continue;
                Port connectedBoundPort = (Port)ElementUtils.getNamedElementFromList(ports, (String)role.getName());
                connEnd.setRole((ConnectableElement)connectedBoundPort);
            }
        }
    }
}

