/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GeneratorHint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class HintUtils {
    public static GeneratorHint getGeneratorHintFromElement(Element element) {
        GeneratorHint codeGenOpt = (GeneratorHint)UMLUtil.getStereotypeApplication((Element)element, GeneratorHint.class);
        if (codeGenOpt != null && codeGenOpt.getLanguage() != null) {
            return codeGenOpt;
        }
        if (element.getOwner() instanceof Package) {
            return HintUtils.getGeneratorHintFromElement(element.getOwner());
        }
        return null;
    }

    public static String getLanguageFromElement(Element element) {
        GeneratorHint codeGenOpt = HintUtils.getGeneratorHintFromElement(element);
        if (codeGenOpt != null && codeGenOpt.getLanguage() != null) {
            return codeGenOpt.getLanguage().getBase_Class().getName();
        }
        List eligibleGenerators = LanguageCodegen.getEligibleGeneratorList((Pattern)LanguageCodegen.MATCH_ALL, (Element)element);
        if (eligibleGenerators.size() > 0) {
            return LanguageCodegen.getLanguage((ILangCodegen)((ILangCodegen)eligibleGenerators.get(0)));
        }
        return "C++";
    }
}

