/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.Constants;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppClassUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppDocumentation;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppParameter;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppTemplates;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Default;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Delete;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Variadic;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;

public class CppOperations {
    public static CharSequence CppOperationImplementation(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _CppOperationDoc = CppDocumentation.CppOperationDoc(operation);
        _builder.append((Object)_CppOperationDoc);
        _builder.newLineIfNotEmpty();
        String _name = operation.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)"main");
        if (_equals) {
            String _CppReturnSpec = CppOperations.CppReturnSpec(operation);
            _builder.append(_CppReturnSpec);
            String _name_1 = operation.getName();
            _builder.append(_name_1);
            _builder.append("(");
            CharSequence _CppOperationParameters = CppParameter.CppOperationParameters(operation, false);
            _builder.append((Object)_CppOperationParameters);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _body = GenUtils.getBody((Operation)operation, (Pattern)Constants.supportedLanguages);
            _builder.append(_body, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("} ");
            _builder.newLine();
        } else {
            CharSequence _templateSignature = CppTemplates.templateSignature(operation);
            _builder.append((Object)_templateSignature);
            String _InlineTxt = CppOperations.InlineTxt((Element)operation);
            _builder.append(_InlineTxt);
            String _CppReturnSpec_1 = CppOperations.CppReturnSpec(operation);
            _builder.append(_CppReturnSpec_1);
            String _nestedOperationFarthestClassifierOwnerNamespace = GenUtils.getNestedOperationFarthestClassifierOwnerNamespace((Operation)operation);
            _builder.append(_nestedOperationFarthestClassifierOwnerNamespace);
            CharSequence _templateShortSignature = CppTemplates.templateShortSignature(operation);
            _builder.append((Object)_templateShortSignature);
            _builder.append("::");
            String _destructor = CppOperations.destructor(operation);
            _builder.append(_destructor);
            String _name_2 = operation.getName();
            _builder.append(_name_2);
            _builder.append("(");
            CharSequence _CppOperationParameters_1 = CppParameter.CppOperationParameters(operation, false);
            _builder.append((Object)_CppOperationParameters_1);
            String _variadicParameter = CppOperations.variadicParameter(operation);
            _builder.append(_variadicParameter);
            _builder.append(")");
            String _modCVQualifier = Modifier.modCVQualifier((Element)operation);
            _builder.append(_modCVQualifier);
            CharSequence _throwss = CppOperations.throwss(operation);
            _builder.append((Object)_throwss);
            String _CppConstInit = CppOperations.CppConstInit(operation);
            _builder.append(_CppConstInit);
            _builder.append(" {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _body_1 = GenUtils.getBody((Operation)operation, (Pattern)Constants.supportedLanguages);
            _builder.append(_body_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public static String CppReturnSpec(Operation operation) {
        String _xifexpression = null;
        if (operation.getType() == null || CppOperations.isConsOrDestructor(operation)) {
            _xifexpression = CppOperations.ConsDestructorOrVoid(operation);
        } else {
            String _modCVQualifier = Modifier.modCVQualifier((Element)operation.getReturnResult());
            String _plus = String.valueOf(_modCVQualifier) + " ";
            String _cppQualifiedName = CppGenUtils.cgu((Element)operation).cppQualifiedName((NamedElement)operation.getType());
            String _plus_1 = String.valueOf(_plus) + _cppQualifiedName;
            String _modPtr = Modifier.modPtr((Element)operation.getReturnResult());
            String _plus_2 = String.valueOf(_plus_1) + _modPtr;
            String _modRef = Modifier.modRef((Element)operation.getReturnResult());
            String _plus_3 = String.valueOf(_plus_2) + _modRef;
            _xifexpression = String.valueOf(_plus_3) + " ";
        }
        return _xifexpression;
    }

    public static CharSequence CppReturnSpec(Behavior behavior) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        Parameter _returnResult = GenUtils.returnResult((Behavior)behavior);
        boolean bl = _tripleEquals = _returnResult == null;
        if (_tripleEquals) {
            _builder.append("void ");
        } else {
            String _modCVQualifier = Modifier.modCVQualifier((Element)GenUtils.returnResult((Behavior)behavior));
            _builder.append(_modCVQualifier);
            _builder.append(" ");
            String _cppQualifiedName = CppGenUtils.cgu((Element)behavior).cppQualifiedName((NamedElement)GenUtils.returnResult((Behavior)behavior).getType());
            _builder.append(_cppQualifiedName);
            String _modPtr = Modifier.modPtr((Element)GenUtils.returnResult((Behavior)behavior));
            _builder.append(_modPtr);
            String _modRef = Modifier.modRef((Element)GenUtils.returnResult((Behavior)behavior));
            _builder.append(_modRef);
            _builder.append(" ");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence throwss(Operation operation) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _length = ((Object[])Conversions.unwrapArray((Object)operation.getRaisedExceptions(), Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append(" ");
            _builder.append("throw(");
            EList _raisedExceptions = operation.getRaisedExceptions();
            boolean _hasElements = false;
            for (Type re : _raisedExceptions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _cppQualifiedName = CppGenUtils.cgu((Element)operation).cppQualifiedName((NamedElement)re);
                _builder.append(_cppQualifiedName);
            }
            _builder.append(")");
        }
        return _builder;
    }

    public static String ConsDestructorOrVoid(Operation operation) {
        String _xifexpression = null;
        boolean _isConsOrDestructor = CppOperations.isConsOrDestructor(operation);
        _xifexpression = _isConsOrDestructor ? null : "void ";
        return _xifexpression;
    }

    public static boolean isConsOrDestructor(Operation operation) {
        return GenUtils.hasStereotype((Element)operation, Create.class) || GenUtils.hasStereotype((Element)operation, Destroy.class);
    }

    public static String CppConstInit(Operation operation) {
        String _xifexpression = null;
        if (GenUtils.hasStereotype((Element)operation, ConstInit.class) && GenUtils.hasStereotype((Element)operation, Create.class)) {
            String _initialisation = ((ConstInit)UMLUtil.getStereotypeApplication((Element)operation, ConstInit.class)).getInitialisation();
            _xifexpression = ": " + _initialisation;
        }
        return _xifexpression;
    }

    public static Collection<Operation> getOwnedOperations(Classifier cl) {
        EList<Operation> _xblockexpression = null;
        EList<Operation> operations = CppOperations.getOwnedOperationsWNull(cl);
        EList<Operation> _xifexpression = null;
        _xifexpression = operations == null ? CollectionLiterals.emptySet() : operations;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static EList<Operation> getOwnedOperationsWNull(Classifier cl) {
        EList _xifexpression = null;
        if (cl instanceof Class) {
            _xifexpression = ((Class)cl).getOwnedOperations();
        } else {
            EList _xifexpression_1 = null;
            if (cl instanceof DataType) {
                _xifexpression_1 = ((DataType)cl).getOwnedOperations();
            } else {
                EList _xifexpression_2 = null;
                _xifexpression_2 = cl instanceof Interface ? ((Interface)cl).getOwnedOperations() : null;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static Collection<Operation> getNestedOperations(Classifier c1) {
        EList<Operation> _xblockexpression = null;
        EList<Operation> operations = CppOperations.getNestedOperationsWNull(c1);
        EList<Operation> _xifexpression = null;
        _xifexpression = operations == null ? CollectionLiterals.emptySet() : operations;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static EList<Operation> getNestedOperationsWNull(Classifier cl) {
        EList<Operation> _xifexpression = null;
        if (cl instanceof Class || cl instanceof Interface) {
            _xifexpression = CppClassUtils.nestedOperations(cl);
        }
        return _xifexpression;
    }

    public static CharSequence CppBehaviorImplementation(OpaqueBehavior behavior) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _CppBehaviorDoc = CppDocumentation.CppBehaviorDoc((Behavior)behavior);
        _builder.append((Object)_CppBehaviorDoc);
        _builder.newLineIfNotEmpty();
        CharSequence _CppReturnSpec = CppOperations.CppReturnSpec((Behavior)behavior);
        _builder.append((Object)_CppReturnSpec);
        String _nestedBehaviorFarthestClassifierOwnerNamespace = GenUtils.getNestedBehaviorFarthestClassifierOwnerNamespace((OpaqueBehavior)behavior);
        _builder.append(_nestedBehaviorFarthestClassifierOwnerNamespace);
        _builder.append("::");
        String _qualifiedBehaviorName = CppOperations.qualifiedBehaviorName((Behavior)behavior);
        _builder.append(_qualifiedBehaviorName);
        _builder.append("(");
        CharSequence _CppBehaviorParameters = CppParameter.CppBehaviorParameters((Behavior)behavior, false);
        _builder.append((Object)_CppBehaviorParameters);
        _builder.append(")");
        String _modCVQualifier = Modifier.modCVQualifier((Element)behavior);
        _builder.append(_modCVQualifier);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _bodyFromOB = GenUtils.getBodyFromOB((OpaqueBehavior)behavior, (Pattern)Constants.supportedLanguages);
        _builder.append(_bodyFromOB, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence CppOperationDeclaration(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _CppOperationDoc = CppDocumentation.CppOperationDoc(operation);
        _builder.append((Object)_CppOperationDoc);
        _builder.newLineIfNotEmpty();
        String _InlineTxt = CppOperations.InlineTxt((Element)operation);
        _builder.append(_InlineTxt);
        String _virtualTxt = CppOperations.virtualTxt(operation);
        _builder.append(_virtualTxt);
        String _staticTxt = CppOperations.staticTxt(operation);
        _builder.append(_staticTxt);
        String _CppReturnSpec = CppOperations.CppReturnSpec(operation);
        _builder.append(_CppReturnSpec);
        String _destructor = CppOperations.destructor(operation);
        _builder.append(_destructor);
        String _name = operation.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _CppOperationParameters = CppParameter.CppOperationParameters(operation, true);
        _builder.append((Object)_CppOperationParameters);
        String _variadicParameter = CppOperations.variadicParameter(operation);
        _builder.append(_variadicParameter);
        _builder.append(")");
        String _modCVQualifier = Modifier.modCVQualifier((Element)operation);
        _builder.append(_modCVQualifier);
        CharSequence _throwss = CppOperations.throwss(operation);
        _builder.append((Object)_throwss);
        String _virtualSuffix = CppOperations.virtualSuffix(operation);
        _builder.append(_virtualSuffix);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String InlineTxt(Element element) {
        String _xifexpression = null;
        boolean _hasStereotype = GenUtils.hasStereotype((Element)element, Inline.class);
        if (_hasStereotype) {
            _xifexpression = "inline ";
        }
        return _xifexpression;
    }

    public static String virtualTxt(Operation operation) {
        String _xifexpression = null;
        if (operation.getInterface() != null || operation.isAbstract() || GenUtils.hasStereotype((Element)operation, Virtual.class)) {
            _xifexpression = "virtual ";
        }
        return _xifexpression;
    }

    public static String staticTxt(Operation operation) {
        String _xifexpression = null;
        boolean _isStatic = operation.isStatic();
        if (_isStatic) {
            _xifexpression = "static ";
        }
        return _xifexpression;
    }

    public static String destructor(Operation operation) {
        String _xifexpression = null;
        _xifexpression = GenUtils.hasStereotype((Element)operation, Destroy.class) && !operation.getName().startsWith("~") ? "~" : "";
        return _xifexpression;
    }

    public static String virtualSuffix(Operation operation) {
        String _xifexpression = null;
        if (operation.getInterface() != null || operation.isAbstract()) {
            _xifexpression = " = 0";
        } else {
            String _xifexpression_1 = null;
            boolean _isApplied = StereotypeUtil.isApplied((Element)operation, Delete.class);
            if (_isApplied) {
                _xifexpression_1 = " = delete";
            } else {
                String _xifexpression_2 = null;
                boolean _isApplied_1 = StereotypeUtil.isApplied((Element)operation, Default.class);
                if (_isApplied_1) {
                    _xifexpression_2 = " = default";
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static CharSequence CppBehaviorDeclaration(Classifier cl, Behavior behavior) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _CppBehaviorDoc = CppDocumentation.CppBehaviorDoc(behavior);
        _builder.append((Object)_CppBehaviorDoc);
        _builder.newLineIfNotEmpty();
        String _InlineTxt = CppOperations.InlineTxt((Element)behavior);
        _builder.append(_InlineTxt);
        CharSequence _CppReturnSpec = CppOperations.CppReturnSpec(behavior);
        _builder.append((Object)_CppReturnSpec);
        String _qualifiedBehaviorName = CppOperations.qualifiedBehaviorName(behavior);
        _builder.append(_qualifiedBehaviorName);
        _builder.append("(");
        CharSequence _CppBehaviorParameters = CppParameter.CppBehaviorParameters(behavior, true);
        _builder.append((Object)_CppBehaviorParameters);
        _builder.append(")");
        String _modCVQualifier = Modifier.modCVQualifier((Element)behavior);
        _builder.append(_modCVQualifier);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String qualifiedBehaviorName(Behavior behavior) {
        Behavior ne = behavior;
        String name = behavior.getName();
        while (ne != null && !(ne instanceof Classifier) || ne instanceof Behavior) {
            String _plus_1;
            Element _owner_2;
            Element _owner = ne.getOwner();
            if (_owner instanceof NamedElement) {
                Element _owner_1 = ne.getOwner();
                ne = (NamedElement)_owner_1;
            }
            if (!((_owner_2 = ne.getOwner()) instanceof Region)) continue;
            String _name = ne.getName();
            String _plus = String.valueOf(_name) + "_";
            name = _plus_1 = String.valueOf(_plus) + name;
        }
        return name;
    }

    public static String variadicParameter(Operation operation) {
        String _xblockexpression = null;
        boolean hasParameters = false;
        int i = 0;
        String _xifexpression = null;
        boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, Variadic.class);
        if (_hasStereotype) {
            String _xblockexpression_1 = null;
            while (i < operation.getOwnedParameters().size() && !hasParameters) {
                boolean _notEquals;
                ParameterDirectionKind _direction = ((Parameter)operation.getOwnedParameters().get(i)).getDirection();
                boolean bl = _notEquals = !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                if (_notEquals) {
                    hasParameters = true;
                }
                ++i;
            }
            String _xifexpression_1 = null;
            _xifexpression_1 = hasParameters ? ", ..." : "...";
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

