/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.monitoring.sm.runnable;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.eclipse.papyrus.designer.monitoring.sm.data.Message;
import org.eclipse.papyrus.designer.monitoring.sm.data.MessageQueue;
import org.eclipse.papyrus.designer.monitoring.sm.preferences.MonitoringPreferencesUtil;

public class DatagramSocketReader
implements Runnable {
    private boolean running;
    private DatagramSocket socket;
    private byte[] buffer;
    private MessageQueue messageQueue;
    private final int sleepTime = 10;

    public DatagramSocketReader(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        boolean rebind = false;
        do {
            try {
                this.socket = new DatagramSocket(MonitoringPreferencesUtil.getPort());
                this.socket.setSoTimeout(100);
                this.buffer = new byte[1024];
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (rebind);
        if (this.socket != null) {
            this.running = true;
        }
    }

    @Override
    public void run() {
        DatagramPacket packet = new DatagramPacket(this.buffer, this.buffer.length);
        while (this.running && this.socket != null && this.buffer != null && this.messageQueue != null) {
            try {
                this.socket.receive(packet);
                String received = new String(packet.getData(), 0, packet.getLength());
                Message message = new Message(received);
                this.messageQueue.getMessages().add(message);
                if (received.equals("PAPYRUS_END_SM_MONITORING")) {
                    this.running = false;
                }
            }
            catch (IOException received) {
            }
            catch (Exception received) {
                // empty catch block
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void stop() {
        this.running = false;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }
}

