/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.designer.languages.common.base.StringUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.CppInit;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class EnumService {
    private static final String GLOBALENUMS = "globalenums";
    public static Package enumPkg;
    private static Map<String, Enumeration> enumHash;

    static {
        enumHash = new HashMap<String, Enumeration>();
    }

    public static void init() {
        enumHash.clear();
    }

    public static String enumSvcPrefix() {
        return enumPkg.getQualifiedName();
    }

    public static String quoteLiteral(Element dummy, String enumName, String literal) {
        return StringUtils.quoteString((String)EnumService.literal(enumName, literal));
    }

    public static String literal(String enumName, String literal) {
        return EnumService.literal(enumName, literal, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String literal(String enumName, String literal, int initialValue) {
        Enumeration enumeration;
        boolean first = false;
        if (enumName.startsWith("L")) {
            if (!(TransformationContext.current.classifier instanceof Class)) throw new RuntimeException("Local enumeration " + enumName + " is not used in the transformation context of a class");
            Class clazz = (Class)TransformationContext.current.classifier;
            enumeration = (Enumeration)clazz.getNestedClassifier(enumName);
            if (enumeration == null) {
                enumeration = (Enumeration)clazz.createNestedClassifier(enumName, UMLPackage.eINSTANCE.getEnumeration());
            }
        } else {
            enumeration = enumHash.get(enumName);
            if (enumPkg == null) {
                throw new RuntimeException("global enumeration " + enumName + " can not be created, since the enumPkg (from Transformation context) is not initialized");
            }
            if (enumeration == null) {
                enumeration = enumPkg.createOwnedEnumeration(enumName);
                enumHash.put(enumName, enumeration);
                first = true;
            }
        }
        if (enumeration.getOwnedLiteral(literal) == null) {
            EnumerationLiteral umlLiteral = enumeration.createOwnedLiteral(literal);
            if (first && initialValue != -1) {
                CppInit cppInit = (CppInit)StereotypeUtil.applyApp((Element)umlLiteral, CppInit.class);
                cppInit.setValue(initialValue);
            }
        }
        EnumService.checkAndCreateDependency(TransformationContext.current.classifier, (NamedElement)enumeration);
        if (!enumName.startsWith("L")) return "globalenums::" + literal;
        return literal;
    }

    public static void checkAndCreateDependency(Classifier classifier, NamedElement target) {
        boolean found = false;
        for (Dependency dep : classifier.getClientDependencies()) {
            if (!dep.getSuppliers().contains((Object)target)) continue;
            found = true;
        }
        if (!found) {
            Dependency dep;
            dep = classifier.createDependency(target);
            dep.setName(String.format("from %s to %s", classifier.getName(), target.getName()));
        }
    }

    public static void createEnumPackage(Package root) {
        EnumService.init();
        enumPkg = root.createNestedPackage(GLOBALENUMS);
    }

    public static void createEnums() {
    }
}

