/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.templates;

import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.CreationUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Activator;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;

public class TemplateUtils {
    public static TemplateSignature getSignature(TemplateableElement template) {
        TemplateSignature signature = TemplateUtils.getSignatureDirect(template);
        if (signature != null) {
            return signature;
        }
        Element owner = template.getOwner();
        if (owner instanceof TemplateableElement) {
            return TemplateUtils.getSignature((TemplateableElement)owner);
        }
        return null;
    }

    public static Element getTemplateOwner(Element ne, TemplateSignature signature) {
        if (ne instanceof TemplateableElement && TemplateUtils.getSignatureDirect((TemplateableElement)ne) == signature) {
            return ne;
        }
        Element owner = ne.getOwner();
        if (owner != null) {
            return TemplateUtils.getTemplateOwner(owner, signature);
        }
        return null;
    }

    public static TemplateSignature getSignatureDirect(TemplateableElement template) {
        Package pkg;
        Iterator iterator;
        for (Element element : template.getOwnedElements()) {
            if (!(element instanceof TemplateSignature)) continue;
            return (TemplateSignature)element;
        }
        if (template instanceof Package && (iterator = (pkg = (Package)template).getPackageMerges().iterator()).hasNext()) {
            PackageMerge pkgImport = (PackageMerge)iterator.next();
            Package importedPkg = pkgImport.getMergedPackage();
            return TemplateUtils.getSignature((TemplateableElement)importedPkg);
        }
        return null;
    }

    public static boolean withinPkgTemplate(InstanceSpecification instance) {
        Classifier cl = DepUtils.getClassifier((InstanceSpecification)instance);
        TemplateSignature ts = TemplateUtils.getSignature((TemplateableElement)cl);
        if (ts == null) {
            return false;
        }
        return ts.getOwner() instanceof Package;
    }

    public static TemplateBinding fixedBinding(Package model, TemplateableElement template, Classifier fixedActual) throws TransformationException {
        TemplateBinding binding;
        TemplateSignature signature = TemplateUtils.getSignature(template);
        if (signature == null) {
            return null;
        }
        BasicEList actuals = new BasicEList();
        Package pkgTemplate = (Package)signature.getOwner();
        String name = pkgTemplate.getName();
        actuals.add((Object)fixedActual);
        name = String.valueOf(name) + "_" + fixedActual.getName();
        Namespace owner = (Namespace)pkgTemplate.getOwner();
        owner = CreationUtils.getAndCreate((Package)model, (EList)owner.allNamespaces());
        Package boundPackage = (Package)owner.getMember(name);
        if (boundPackage == null) {
            boundPackage = ((Package)owner).createNestedPackage(name);
            Activator.log.info(String.format(Messages.TemplateUtils_InfoCreateBoundPackage, name, owner.getName()));
        }
        if ((binding = boundPackage.getTemplateBinding(signature)) == null) {
            binding = boundPackage.createTemplateBinding(signature);
            Iterator actualsIter = actuals.iterator();
            for (TemplateParameter parameter : signature.getOwnedParameters()) {
                TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                substitution.setFormal(parameter);
                Type actual = (Type)actualsIter.next();
                substitution.setActual((ParameterableElement)actual);
            }
        }
        return binding;
    }

    public static TemplateBinding getSubBinding(Package model, TemplateableElement te, TemplateBinding existingBinding) throws TransformationException {
        for (TemplateParameterSubstitution tps : existingBinding.getParameterSubstitutions()) {
            ParameterableElement pe = tps.getActual();
            if (!(pe instanceof Classifier)) continue;
            return TemplateUtils.fixedBinding(model, te, (Classifier)pe);
        }
        return null;
    }

    public static void adaptActualsToTargetModel(LazyCopier copy, TemplateBinding binding) {
        for (TemplateParameterSubstitution substitution : binding.getParameterSubstitutions()) {
            substitution.setActual(copy.getCopy(substitution.getActual()));
        }
    }

    public static Classifier getActualFromBinding(TemplateBinding binding, Type formal) {
        for (TemplateParameterSubstitution substitution : binding.getParameterSubstitutions()) {
            ParameterableElement pe = substitution.getFormal().getParameteredElement();
            if (pe != formal) continue;
            Activator.log.info(String.format(Messages.TemplateUtils_InfoGetActualFrom, pe));
            return (Classifier)substitution.getActual();
        }
        return null;
    }

    public static Classifier getActualFromBinding(TemplateBinding binding, String formalName) {
        for (TemplateParameterSubstitution substitution : binding.getParameterSubstitutions()) {
            ParameterableElement pe = substitution.getFormal().getParameteredElement();
            if (pe instanceof NamedElement) {
                Activator.log.info(String.format(Messages.TemplateUtils_InfoGetActualFrom, ((NamedElement)pe).getName()));
            }
            if (!(pe instanceof NamedElement) || !((NamedElement)pe).getName().equals(formalName)) continue;
            return (Classifier)substitution.getActual();
        }
        return null;
    }

    public static Classifier getFirstActualFromBinding(TemplateBinding binding) {
        Iterator iterator = binding.getParameterSubstitutions().iterator();
        if (iterator.hasNext()) {
            TemplateParameterSubstitution substitution = (TemplateParameterSubstitution)iterator.next();
            ParameterableElement pe = substitution.getFormal().getParameteredElement();
            Activator.log.info(String.format(Messages.TemplateUtils_InfoGetActualFrom, pe));
            return (Classifier)substitution.getActual();
        }
        return null;
    }

    public static EList<Namespace> relativePathWithMerge(Element element, Namespace searchNS) {
        BasicEList pathList = new BasicEList();
        Element owner = element.getOwner();
        if (!(owner instanceof Namespace)) {
            return null;
        }
        Namespace ns = (Namespace)owner;
        while (ns != null) {
            Package pkg;
            Iterator pkgMerges;
            if (ns == searchNS) {
                return pathList;
            }
            pathList.add((Object)ns);
            if (ns instanceof Package && (pkgMerges = (pkg = (Package)ns).getPackageMerges().iterator()).hasNext()) {
                PackageMerge pkgMerge = (PackageMerge)pkgMerges.next();
                ns = pkgMerge.getMergedPackage();
                continue;
            }
            ns = (Namespace)ns.getOwner();
        }
        return null;
    }
}

