/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.extensions.IM2MTrafo;
import org.eclipse.papyrus.designer.transformation.extensions.M2MTrafoExt;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.ApplyTransformation;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ApplyRecursive {
    protected M2MTrafo stTrafo;
    protected IM2MTrafoElem transformation;

    public ApplyRecursive(M2MTrafo stTrafo, IM2MTrafoElem transformation) {
        this.stTrafo = stTrafo;
        this.transformation = transformation;
    }

    public void applyRecursive(Package pkg) throws TransformationException {
        this.applyRecursiveSub(pkg);
        BasicEList additionalRootPkgs = new BasicEList();
        additionalRootPkgs.addAll(TransformationContext.current.copier.getAdditionalRootPkgs());
        for (ModelManagement mm : additionalRootPkgs) {
            this.applyRecursiveSub(mm.getModel());
        }
    }

    public void applyRecursiveSub(Package pkg) throws TransformationException {
        BasicEList elements = new BasicEList();
        elements.addAll((Collection)pkg.getPackagedElements());
        for (PackageableElement pe : elements) {
            if (pe instanceof Classifier) {
                TransformationContext.current.classifier = (Classifier)pe;
                if (this.transformation != null) {
                    this.transformation.transformElement(this.stTrafo, (Element)pe);
                    continue;
                }
                ApplyTransformation applyTrafo = (ApplyTransformation)UMLUtil.getStereotypeApplication((Element)pe, ApplyTransformation.class);
                if (applyTrafo == null) continue;
                for (M2MTrafo stTrafo : applyTrafo.getTrafo()) {
                    IM2MTrafo trafo = M2MTrafoExt.getM2MTrafo((M2MTrafo)stTrafo);
                    if (!(trafo instanceof IM2MTrafoElem)) continue;
                    ((IM2MTrafoElem)trafo).transformElement(stTrafo, (Element)pe);
                }
                continue;
            }
            if (!(pe instanceof Package)) continue;
            this.applyRecursiveSub((Package)pe);
        }
    }
}

