/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.monitoring.sm.animation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.monitoring.sm.data.StateMachineModel;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.Monitored;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationEngine;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Animator {
    private StateMachineModel stateMachineModel;
    private AnimationEngine animationEngine;
    private boolean initialized = false;
    private boolean noMarkers = true;

    public Animator(StateMachineModel stateMachineModel) {
        this.stateMachineModel = stateMachineModel;
        this.animationEngine = new AnimationEngine();
    }

    public synchronized void animate(String metaClass, String qualifiedName) {
        Transition transition;
        if (metaClass != null && qualifiedName != null && metaClass.equals("TRANSITION") && (transition = this.stateMachineModel.getTransitionMap().get(qualifiedName.trim())) != null) {
            Monitored monitoredStereotype;
            boolean monitorThis = true;
            StateMachine stateMachine = transition.containingStateMachine();
            if (stateMachine != null && (monitoredStereotype = (Monitored)UMLUtil.getStereotypeApplication((Element)stateMachine, Monitored.class)) != null && (monitorThis = monitoredStereotype.isMonitored())) {
                boolean bl = monitorThis = !monitoredStereotype.getExclude().contains((Object)transition);
                if (monitorThis && !monitoredStereotype.getExclusivelyInclude().isEmpty()) {
                    monitorThis = monitoredStereotype.getExclusivelyInclude().contains((Object)transition);
                }
            }
            if (monitorThis) {
                if (transition.getSource() != transition.getTarget()) {
                    this.animationEngine.startRendering((EObject)transition.getSource(), null, AnimationKind.VISITED);
                }
                this.animationEngine.startRendering((EObject)transition, null, AnimationKind.ANIMATED);
                this.animationEngine.startRendering((EObject)transition, null, AnimationKind.VISITED);
                this.animationEngine.startRendering((EObject)transition.getTarget(), null, AnimationKind.ANIMATED);
                this.noMarkers = false;
            }
        }
    }

    public synchronized void initialize() {
        if (!this.initialized) {
            this.animationEngine.deleteAllMarkers();
            if (this.stateMachineModel != null && this.stateMachineModel.getInitialStates().size() > 0) {
                this.animationEngine.init((EObject)this.stateMachineModel.getInitialStates().get(0));
                for (State initialState : this.stateMachineModel.getInitialStates()) {
                    Monitored monitoredStereotype;
                    boolean monitorThis = true;
                    StateMachine stateMachine = initialState.containingStateMachine();
                    if (stateMachine != null && (monitoredStereotype = (Monitored)UMLUtil.getStereotypeApplication((Element)stateMachine, Monitored.class)) != null) {
                        monitorThis = monitoredStereotype.isMonitored();
                    }
                    if (!monitorThis) continue;
                    this.animationEngine.startRendering((EObject)initialState, null, AnimationKind.ANIMATED);
                    this.initialized = true;
                    this.noMarkers = false;
                }
            }
        }
    }

    public synchronized void deleteMarkers() {
        if (!this.noMarkers) {
            this.animationEngine.deleteAllMarkers();
            this.noMarkers = true;
        }
    }
}

