/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr;

import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.TypedNode;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.VariableDeclarator;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.AnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.Expression;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.internal.Utils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.GenericVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.VoidVisitor;

public final class VariableDeclarationExpr
extends Expression
implements TypedNode {
    private int modifiers;
    private List<AnnotationExpr> annotations;
    private Type type;
    private List<VariableDeclarator> vars;

    public VariableDeclarationExpr() {
    }

    public VariableDeclarationExpr(Type type, List<VariableDeclarator> vars) {
        this.setType(type);
        this.setVars(vars);
    }

    public VariableDeclarationExpr(int modifiers, Type type, List<VariableDeclarator> vars) {
        this.setModifiers(modifiers);
        this.setType(type);
        this.setVars(vars);
    }

    public VariableDeclarationExpr(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, Type type, List<VariableDeclarator> vars) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setModifiers(modifiers);
        this.setAnnotations(annotations);
        this.setType(type);
        this.setVars(vars);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<AnnotationExpr> getAnnotations() {
        this.annotations = Utils.ensureNotNull(this.annotations);
        return this.annotations;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public List<VariableDeclarator> getVars() {
        this.vars = Utils.ensureNotNull(this.vars);
        return this.vars;
    }

    public void setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(this.annotations);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
    }

    public void setVars(List<VariableDeclarator> vars) {
        this.vars = vars;
        this.setAsParentNodeOf(this.vars);
    }
}

