package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.papyrus.designer.languages.c.codegen.preferences.CCodeGenConstants;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class StateMachineScript {
  private static List<Transition> transitions = new ArrayList<Transition>();

  public static Region region;

  public List<State> states = new ArrayList<State>();

  public static String ACTIVE_ROOT_STATE_ID = "activeStateID";

  public static String genProcessCompletionEventMethodBody(final org.eclipse.uml2.uml.Class clazz) {
    StateMachineScript.region = IterableExtensions.<Region>head(IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class)).getRegions());
    final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
      @Override
      public Boolean apply(final Transition it) {
        return Boolean.valueOf(((it.getSource() != null) && (it.getTarget() != null)));
      }
    };
    Iterables.<Transition>addAll(StateMachineScript.transitions, IterableExtensions.<Transition>filter(StateMachineScript.region.getTransitions(), _function));
    final ArrayList<Transition> NonTriggeredTrans = new ArrayList<Transition>();
    final Consumer<Transition> _function_1 = new Consumer<Transition>() {
      @Override
      public void accept(final Transition it) {
        if ((((it.getSource() instanceof State) && (!(it.getTarget() instanceof FinalState))) && (ListExtensions.<Trigger, Event>map(it.getTriggers(), new Function1<Trigger, Event>() {
          @Override
          public Event apply(final Trigger it_1) {
            return it_1.getEvent();
          }
        }).size() == 0))) {
          NonTriggeredTrans.add(it);
        }
      }
    };
    StateMachineScript.transitions.forEach(_function_1);
    final Function1<Transition, Vertex> _function_2 = new Function1<Transition, Vertex>() {
      @Override
      public Vertex apply(final Transition it) {
        return it.getSource();
      }
    };
    final Set<State> sources = IterableExtensions.<State>toSet(Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(NonTriggeredTrans, _function_2), State.class));
    final Set<Transition> setTransitions = IterableExtensions.<Transition>toSet(NonTriggeredTrans);
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      int _size = NonTriggeredTrans.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("switch(self->");
        _builder.append(StateMachineScript.ACTIVE_ROOT_STATE_ID);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        {
          for(final State state : sources) {
            _builder.append("\t");
            _builder.append("case ");
            String _name = state.getName();
            _builder.append(_name, "\t");
            _builder.append(": ");
            _builder.newLineIfNotEmpty();
            {
              for(final Transition t : setTransitions) {
                {
                  Vertex _source = t.getSource();
                  boolean _equals = Objects.equal(_source, state);
                  if (_equals) {
                    _builder.append("\t");
                    _builder.append("\t");
                    Vertex _source_1 = t.getSource();
                    String _generateTransitionCode = StateMachineScript.generateTransitionCode(((State) _source_1), t);
                    _builder.append(_generateTransitionCode, "\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("{}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
        _builder.append("\t");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// do nothing");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    String body = _builder.toString();
    return body;
  }

  public static String genProcessMethodBody(final Event callevent, final org.eclipse.uml2.uml.Class clazz) {
    StateMachineScript.region = IterableExtensions.<Region>head(IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class)).getRegions());
    final Function1<Transition, Boolean> _function = new Function1<Transition, Boolean>() {
      @Override
      public Boolean apply(final Transition it) {
        return Boolean.valueOf(((it.getSource() != null) && (it.getTarget() != null)));
      }
    };
    Iterables.<Transition>addAll(StateMachineScript.transitions, IterableExtensions.<Transition>filter(StateMachineScript.region.getTransitions(), _function));
    final ArrayList<Transition> TriggeredTrans = new ArrayList<Transition>();
    final Consumer<Transition> _function_1 = new Consumer<Transition>() {
      @Override
      public void accept(final Transition it) {
        if (((it.getSource() instanceof State) && (!(ListExtensions.<Trigger, Event>map(it.getTriggers(), new Function1<Trigger, Event>() {
          @Override
          public Event apply(final Trigger it_1) {
            return it_1.getEvent();
          }
        }).size() == 0)))) {
          final Function1<Trigger, Event> _function = new Function1<Trigger, Event>() {
            @Override
            public Event apply(final Trigger it_1) {
              return it_1.getEvent();
            }
          };
          List<Event> events = IterableExtensions.<Event>toList(ListExtensions.<Trigger, Event>map(it.getTriggers(), _function));
          boolean _contains = events.contains(callevent);
          if (_contains) {
            boolean _contains_1 = TriggeredTrans.contains(it);
            boolean _not = (!_contains_1);
            if (_not) {
              TriggeredTrans.add(it);
            }
          }
        }
      }
    };
    StateMachineScript.transitions.forEach(_function_1);
    final Function1<Transition, Vertex> _function_2 = new Function1<Transition, Vertex>() {
      @Override
      public Vertex apply(final Transition it) {
        return it.getSource();
      }
    };
    final Set<State> sources = IterableExtensions.<State>toSet(Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(TriggeredTrans, _function_2), State.class));
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      int _size = TriggeredTrans.size();
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("switch(self->");
        _builder.append(StateMachineScript.ACTIVE_ROOT_STATE_ID);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        {
          for(final State state : sources) {
            _builder.append("\t\t\t\t\t");
            _builder.append("case ");
            String _name = state.getName();
            _builder.append(_name, "\t\t\t\t\t");
            _builder.append(": ");
            _builder.newLineIfNotEmpty();
            {
              for(final Transition t : TriggeredTrans) {
                {
                  Vertex _source = t.getSource();
                  boolean _equals = Objects.equal(_source, state);
                  if (_equals) {
                    _builder.append("\t\t\t\t\t");
                    _builder.append("\t");
                    Vertex _source_1 = t.getSource();
                    String _generateTransitionCode = StateMachineScript.generateTransitionCode(((State) _source_1), t);
                    _builder.append(_generateTransitionCode, "\t\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
            _builder.append("\t\t\t\t\t");
            _builder.append("\t");
            _builder.append("{}");
            _builder.newLine();
            _builder.append("\t\t\t\t\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t\t\t\t\t");
            _builder.append("break;");
            _builder.newLine();
          }
        }
        _builder.append("\t\t\t\t\t");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("//do nothing");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("break;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    String body = _builder.toString();
    return body;
  }

  public static String generateTransitionCode(final State s, final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    String ret = _builder.toString();
    final String cGuard = StateMachineScript.getGuard(t);
    final String acslGuard = AcslScript.getGuard(t);
    Vertex _target = t.getTarget();
    if ((_target instanceof State)) {
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("/*  transition guard */");
      _builder_1.newLine();
      {
        boolean _isEmpty = acslGuard.isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          _builder_1.append(acslGuard);
        }
      }
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("if (");
      {
        boolean _isEmpty_1 = cGuard.isEmpty();
        boolean _not_1 = (!_isEmpty_1);
        if (_not_1) {
          _builder_1.append(cGuard);
        } else {
          _builder_1.append("1");
        }
      }
      _builder_1.append(") {");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.append("/* exit Transition source */");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("if (self->states[");
      String _name = t.getSource().getName();
      _builder_1.append(_name, "\t");
      _builder_1.append("].exit != NULL) {");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t\t");
      _builder_1.append("self->states[");
      String _name_1 = t.getSource().getName();
      _builder_1.append(_name_1, "\t\t");
      _builder_1.append("].exit();");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.append("}");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("/* transition effect*/");
      _builder_1.newLine();
      _builder_1.append("\t");
      String _transitionEffect = StateMachineScript.getTransitionEffect(t);
      _builder_1.append(_transitionEffect, "\t");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("/* update current state */");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("self->");
      _builder_1.append(StateMachineScript.ACTIVE_ROOT_STATE_ID, "\t");
      _builder_1.append(" = ");
      String _name_2 = t.getTarget().getName();
      _builder_1.append(_name_2, "\t");
      _builder_1.append(" ;");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("/* entry of the new state */");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("if (self->states[");
      String _name_3 = t.getTarget().getName();
      _builder_1.append(_name_3, "\t");
      _builder_1.append("].entry != NULL) {");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t\t");
      _builder_1.append("self->states[");
      String _name_4 = t.getTarget().getName();
      _builder_1.append(_name_4, "\t\t");
      _builder_1.append("].entry();");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.append("}");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("/* doActivity of the new state */");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("if (self->states[");
      String _name_5 = t.getTarget().getName();
      _builder_1.append(_name_5, "\t");
      _builder_1.append("].doActivity != NULL) {");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t\t");
      _builder_1.append("self->states[");
      String _name_6 = t.getTarget().getName();
      _builder_1.append(_name_6, "\t\t");
      _builder_1.append("].doActivity();");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.append("}");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("/* always call process completion event to handle completion transition */");
      _builder_1.newLine();
      _builder_1.append("\t");
      _builder_1.append("ProcessCompletionEvent(self);");
      _builder_1.newLine();
      _builder_1.append("} else");
      ret = _builder_1.toString();
    }
    return ret;
  }

  public static String getTransitionEffect(final Transition t) {
    if (((t.getEffect() != null) && (t.getEffect() instanceof OpaqueBehavior))) {
      Behavior _effect = t.getEffect();
      return IterableExtensions.<String>head(((OpaqueBehavior) _effect).getBodies());
    }
    StringConcatenation _builder = new StringConcatenation();
    return _builder.toString();
  }

  public static String getGuard(final Transition t) {
    if (((t.getGuard() != null) && (t.getGuard().getSpecification() instanceof OpaqueExpression))) {
      ValueSpecification _specification = t.getGuard().getSpecification();
      final OpaqueExpression opaqueExpression = ((OpaqueExpression) _specification);
      int _size = opaqueExpression.getLanguages().size();
      int _size_1 = opaqueExpression.getBodies().size();
      boolean _tripleEquals = (_size == _size_1);
      if (_tripleEquals) {
        for (int i = 0; (i < opaqueExpression.getLanguages().size()); i++) {
          {
            final String language = opaqueExpression.getLanguages().get(i);
            final Matcher matcher = CCodeGenConstants.supportedLanguages.matcher(language);
            boolean _matches = matcher.matches();
            if (_matches) {
              return GenUtils.cleanCR(opaqueExpression.getBodies().get(i));
            }
          }
        }
      }
    }
    return "";
  }

  public static String getGuard(final Transition t, final Pattern selectedLanguages) {
    if (((t.getGuard() != null) && (t.getGuard().getSpecification() instanceof OpaqueExpression))) {
      ValueSpecification _specification = t.getGuard().getSpecification();
      final OpaqueExpression opaqueExpression = ((OpaqueExpression) _specification);
      int _size = opaqueExpression.getLanguages().size();
      int _size_1 = opaqueExpression.getBodies().size();
      boolean _tripleEquals = (_size == _size_1);
      if (_tripleEquals) {
        for (int i = 0; (i < opaqueExpression.getLanguages().size()); i++) {
          {
            final String language = opaqueExpression.getLanguages().get(i);
            final Matcher matcher = selectedLanguages.matcher(language);
            boolean _matches = matcher.matches();
            if (_matches) {
              return GenUtils.cleanCR(opaqueExpression.getBodies().get(i));
            }
          }
        }
      }
    }
    return "";
  }
}
