/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.transformations;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.deployment.tools.AllocUtils;
import org.eclipse.papyrus.designer.deployment.tools.ConfigUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.base.UIContext;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.StdModelLibs;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoModelSplit;
import org.eclipse.papyrus.designer.transformation.core.templates.PkgTemplateUtils;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterKeepLanguage;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterKeepM2MTrafo;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterProfiles;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterTemplateBinding;
import org.eclipse.papyrus.designer.transformation.extensions.InstanceConfigurator;
import org.eclipse.papyrus.designer.transformation.library.Messages;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;

public class DeployToNodes
implements IM2MTrafoModelSplit {
    public static final String TRAFOS_DEFAULT_PLATFORM_DEFAULT_NODE = "trafos::defaultPlatform::defaultNode";
    InstanceSpecification node;

    public List<TransformationContext> splitModel(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        EList topLevelInstances = DepUtils.getTopLevelInstances((Package)TransformationContext.current.deploymentPlan);
        DepCreation.initAutoValues((Collection)topLevelInstances);
        EList nodes = AllocUtils.getAllNodes((Collection)topLevelInstances);
        BasicEList splitModels = new BasicEList();
        InstanceConfigurator.onNodeModel = true;
        if (nodes.size() > 0) {
            int nodeIndex = 0;
            while (nodeIndex < nodes.size()) {
                InstanceSpecification node = (InstanceSpecification)nodes.get(nodeIndex);
                try {
                    splitModels.add((Object)this.deployNode((EList<InstanceSpecification>)topLevelInstances, TransformationContext.current.modelRoot, (EList<InstanceSpecification>)nodes, nodeIndex, node, false));
                }
                catch (InterruptedException e) {
                    throw new TransformationException(e.getMessage());
                }
                ++nodeIndex;
            }
        } else {
            InstanceSpecification defaultNode = (InstanceSpecification)ElementUtils.getQualifiedElementFromRS((Element)TransformationContext.initialSourceRoot, (String)TRAFOS_DEFAULT_PLATFORM_DEFAULT_NODE);
            if (defaultNode == null) {
                PackageUtil.loadPackage((URI)StdModelLibs.TRAFO_PROFILE_URI, (ResourceSet)deploymentPlan.eResource().getResourceSet());
                defaultNode = (InstanceSpecification)ElementUtils.getQualifiedElementFromRS((Element)deploymentPlan, (String)TRAFOS_DEFAULT_PLATFORM_DEFAULT_NODE);
                if (defaultNode == null) {
                    throw new TransformationException(String.format(Messages.DeployToNodes_CantFindDefaultNode, TRAFOS_DEFAULT_PLATFORM_DEFAULT_NODE));
                }
            }
            try {
                splitModels.add((Object)this.deployNode((EList<InstanceSpecification>)topLevelInstances, PackageUtil.getRootPackage((Package)deploymentPlan), (EList<InstanceSpecification>)nodes, 0, defaultNode, true));
            }
            catch (InterruptedException e) {
                throw new TransformationException(e.getMessage());
            }
        }
        return splitModels;
    }

    private TransformationContext deployNode(EList<InstanceSpecification> topLevelInstances, Package existingModel, EList<InstanceSpecification> nodes, int nodeIndex, InstanceSpecification node, boolean allocAll) throws TransformationException, InterruptedException {
        ModelManagement genModelManagement = ModelManagement.createNewModel((Package)existingModel);
        Package generatedModel = genModelManagement.getModel();
        this.checkProgressStatus();
        LazyCopier targetCopier = new LazyCopier(existingModel, generatedModel, LazyCopier.CopyExtResources.ALL_EXCEPT, true);
        targetCopier.preCopyListeners.add((Object)FilterKeepM2MTrafo.getInstance());
        targetCopier.preCopyListeners.add((Object)FilterKeepLanguage.getInstance());
        targetCopier.preCopyListeners.add((Object)FilterTemplateBinding.getInstance());
        targetCopier.preCopyListeners.add((Object)FilterProfiles.getInstance());
        targetCopier.addResource(null);
        UIContext.monitor.setTaskName(String.format(Messages.InstantiateDepPlan_InfoDeployingForNode, node.getName()));
        TransformationContext tc = new TransformationContext();
        tc.modelRoot = generatedModel;
        tc.copier = targetCopier;
        tc.mm = genModelManagement;
        this.node = node;
        for (InstanceSpecification is : topLevelInstances) {
            if (PkgTemplateUtils.withinPkgTemplate((InstanceSpecification)is)) continue;
            this.distributeToNode(targetCopier, allocAll, is);
        }
        tc.deploymentPlan = (Package)targetCopier.get((Object)TransformationContext.current.deploymentPlan);
        tc.node = node;
        return tc;
    }

    public InstanceSpecification distributeToNode(LazyCopier targetCopier, boolean allocAll, InstanceSpecification instance) throws TransformationException {
        Classifier smImplementation;
        if (AllocUtils.getNodesOrThreads((InstanceSpecification)instance).contains((Object)this.node)) {
            allocAll = true;
        }
        if ((smImplementation = DepUtils.getClassifier((InstanceSpecification)instance)) == null) {
            throw new TransformationException(String.format(Messages.DeployToNodes_CantFindImplementation, instance.getName()));
        }
        InstanceSpecification tmInstance = (InstanceSpecification)targetCopier.getCopy((Element)instance);
        for (Slot slot : instance.getSlots()) {
            InstanceSpecification containedInstance = DepUtils.getInstance((Slot)slot);
            if (containedInstance == null || DepUtils.isShared((Slot)slot)) continue;
            StructuralFeature sf = slot.getDefiningFeature();
            if (!allocAll && !AllocUtils.getAllNodes((InstanceSpecification)containedInstance).contains((Object)this.node)) continue;
            InstanceSpecification tmContainedInstance = this.distributeToNode(targetCopier, allocAll, containedInstance);
            if (!(sf instanceof Property)) continue;
            ConfigUtils.configureInstance((InstanceSpecification)tmContainedInstance, (Property)((Property)sf), (InstanceSpecification)tmInstance);
        }
        return tmInstance;
    }

    private void initiateProgressMonitor(boolean generateCode, EList<InstanceSpecification> nodes) {
        int steps = 3;
        steps += 5 * nodes.size();
        if (generateCode) {
            steps += nodes.size();
        }
        UIContext.monitor.beginTask(Messages.InstantiateDepPlan_InfoGeneratingModel, steps);
    }

    private void checkProgressStatus() throws InterruptedException {
        if (UIContext.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        UIContext.monitor.worked(1);
    }
}

