/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.deployment.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.ConfigurationProperty;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;

public class InstanceSpecificationSlotForAllProperties
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Classifier cl;
        InstanceSpecification is = (InstanceSpecification)ctx.getTarget();
        if (is.getClassifiers().size() > 0 && (cl = (Classifier)is.getClassifiers().get(0)) instanceof Class) {
            Class class_ = (Class)cl;
            for (Property attribute : class_.getOwnedAttributes()) {
                boolean foundAttribute = false;
                if (!StereotypeUtil.isApplied((Element)attribute, ConfigurationProperty.class)) continue;
                for (Slot slot : is.getSlots()) {
                    if (slot.getDefiningFeature() != attribute) continue;
                    foundAttribute = true;
                    break;
                }
                if (foundAttribute) continue;
                return ctx.createFailureStatus(new Object[]{String.format("The instance specification '%s' has no slot for property '%s'", is.getName() + attribute.getName())});
            }
        }
        return ctx.createSuccessStatus();
    }
}

