/*******************************************************************************
 * Copyright (c) 2016 CEA LIST
 *
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Ansgar Radermacher - Initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.idl.codegen.preferences;


public class IDLCodeGenConstants {
	
	/**
	 * Suffix for generated IDL files
	 */
	public static final String P_IDL_SUFFIX_KEY = "idlSuffix"; //$NON-NLS-1$

	public static final String P_IDL_SUFFIX_DVAL = "idl"; //$NON-NLS-1$

	/**
	 * User defined comment header in generated files
	 */
	public static final String P_IDL_COMMENT_HEADER_KEY = "idlCommentHeader"; //$NON-NLS-1$
	
	static final String NL = System.getProperties().getProperty("line.separator"); //$NON-NLS-1$
	
	public static final String P_IDL_COMMENT_HEADER_DVAL =
		"// --------------------------------------------------------" + NL + //$NON-NLS-1$
		"// Code generated by Papyrus IDL" + NL + //$NON-NLS-1$
		"// --------------------------------------------------------" + NL + //$NON-NLS-1$
		NL;
}
