/**
 * Copyright (c) 2006 - 2016 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.Modifier;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class JavaAttribute {
  public static Collection<Property> getOwnedAttributes(final Classifier cl) {
    Collection<Property> _xblockexpression = null;
    {
      final EList<Property> attributes = JavaAttribute.getOwnedAttributesWNull(cl);
      Collection<Property> _xifexpression = null;
      if ((attributes == null)) {
        _xifexpression = CollectionLiterals.<Property>emptySet();
      } else {
        _xifexpression = attributes;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  /**
   * @return a list of owned attributes, since this is not supported directly on a classifier, null if not available
   */
  public static EList<Property> getOwnedAttributesWNull(final Classifier cl) {
    EList<Property> _xifexpression = null;
    if ((cl instanceof AttributeOwner)) {
      _xifexpression = ((AttributeOwner) cl).getOwnedAttributes();
    } else {
      return null;
    }
    return _xifexpression;
  }

  public static String defaultValue(final Property attribute) {
    String _xifexpression = null;
    ValueSpecification _defaultValue = attribute.getDefaultValue();
    boolean _tripleNotEquals = (_defaultValue != null);
    if (_tripleNotEquals) {
      String _stringValue = attribute.getDefaultValue().stringValue();
      _xifexpression = (" =" + _stringValue);
    }
    return _xifexpression;
  }

  public static CharSequence javaAttributeDeclaration(final Property attribute) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _javaElementDoc = JavaDocumentation.javaElementDoc(attribute);
    _builder.append(_javaElementDoc);
    _builder.newLineIfNotEmpty();
    String _attributeModifiers = Modifier.attributeModifiers(attribute);
    _builder.append(_attributeModifiers);
    String _javaType = JavaTypedElement.javaType(attribute);
    _builder.append(_javaType);
    _builder.append(" ");
    String _name = attribute.getName();
    _builder.append(_name);
    String _defaultValue = JavaAttribute.defaultValue(attribute);
    _builder.append(_defaultValue);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
