/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.JdtAstUtils;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.LocalContext;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.PropertyDeclarationHelper;
import org.eclipse.papyrus.designer.languages.java.reverse.jdt.TypeReferenceDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ClassifierCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.CreationPackageCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ImportedTypeCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.TypeResolver;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.UmlUtils;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.VisibilityKind;

public class JdtCompilationUnitAnalyzer {
    public static String DEFAULT_GENERATION_PACKAGE_NAME = "generated";
    public static String DEFAULT_ROOT_PACKAGE_NAME = "model";
    private List<String> generationPackageQualifiedName;
    private Package defaultGenerationPackage;
    private CreationPackageCatalog creationPackageCatalog;
    private ClassifierCatalog classifierCatalog;
    private ImportedTypeCatalog importedTypes;
    private TypeResolver typeResolver;

    public JdtCompilationUnitAnalyzer(Package modelRootPackage, String generatePackageName, List<String> searchPaths) {
        this.initCompilationUnitAnalyser(modelRootPackage, generatePackageName, searchPaths);
    }

    private void initCompilationUnitAnalyser(Package modelRootPackage, String defaultGenerationPackageName, List<String> searchPaths) {
        if (defaultGenerationPackageName == null) {
            defaultGenerationPackageName = DEFAULT_GENERATION_PACKAGE_NAME;
        }
        this.generationPackageQualifiedName = this.dirToQualifiedName(defaultGenerationPackageName);
        if (!(searchPaths = searchPaths != null ? new ArrayList<String>(searchPaths) : new ArrayList<String>()).contains(defaultGenerationPackageName)) {
            searchPaths.add(defaultGenerationPackageName);
        }
        System.out.println(String.format("%s.CT(%s, searchpaths=%s)", this.getClass().getSimpleName(), this.generationPackageQualifiedName, searchPaths));
        this.createDefaultGenerationPackage(modelRootPackage);
        this.classifierCatalog = new ClassifierCatalog(modelRootPackage, searchPaths);
        this.importedTypes = new ImportedTypeCatalog();
        this.creationPackageCatalog = new CreationPackageCatalog(modelRootPackage, this.defaultGenerationPackage, null);
        this.typeResolver = new TypeResolver(this.classifierCatalog, this.importedTypes, this.creationPackageCatalog);
    }

    private List<String> dirToQualifiedName(String qname) {
        String[] splittedName = qname.split("/");
        return Arrays.asList(splittedName);
    }

    private void addImports(ImportedTypeCatalog importedTypes, List<ImportDeclaration> imports) {
        for (ImportDeclaration decl : imports) {
            String qname = decl.getName().getFullyQualifiedName();
            List<String> qualifiedName = UmlUtils.toQualifiedName(qname);
            if (decl.isStatic()) continue;
            if (decl.isOnDemand()) {
                importedTypes.addStarImport(qualifiedName);
                continue;
            }
            importedTypes.addImport(qualifiedName);
        }
    }

    public ClassifierCatalog getClassifierCatalog() {
        return this.classifierCatalog;
    }

    public void processCompilationUnit(CompilationUnit cu) {
        Package currentCompilationUnitPackage = this.getCuPackage(cu.getPackage());
        LocalContext localContext = new LocalContext((Namespace)currentCompilationUnitPackage);
        this.classifierCatalog.setCurrentCompilationUnitPackage(currentCompilationUnitPackage);
        this.importedTypes.clear();
        if (cu.imports() != null) {
            this.addImports(this.importedTypes, cu.imports());
        }
        List types = cu.types();
        for (AbstractTypeDeclaration abstractType : types) {
            Classifier classifier = this.processNamedElementDeclaration(abstractType, localContext);
        }
        for (AbstractTypeDeclaration abstractType : types) {
            this.processNamedElementReferences(abstractType, localContext);
        }
    }

    private Classifier processNamedElementDeclaration(AbstractTypeDeclaration abstractType, LocalContext localContext) {
        switch (abstractType.getNodeType()) {
            case 55: {
                return this.processTypeDeclaration((TypeDeclaration)abstractType, localContext);
            }
            case 81: {
                return this.processAnnotationTypeDeclaration((AnnotationTypeDeclaration)abstractType, localContext);
            }
            case 71: {
                return this.processEnumDeclaration((EnumDeclaration)abstractType, localContext);
            }
        }
        return null;
    }

    private void processNamedElementReferences(AbstractTypeDeclaration abstractType, LocalContext localContext) {
        switch (abstractType.getNodeType()) {
            case 55: {
                this.processTypeReferences((TypeDeclaration)abstractType, localContext);
                break;
            }
            case 81: {
                this.processAnnotationTypeReferences((AnnotationTypeDeclaration)abstractType, localContext);
                break;
            }
            case 71: {
                this.processEnumReferences((EnumDeclaration)abstractType, localContext);
                break;
            }
        }
    }

    private Classifier processTypeDeclaration(TypeDeclaration node, LocalContext parentContext) {
        Object processedClass = node.isInterface() ? this.createInterface(parentContext, node) : this.createClass(parentContext, node);
        LocalContext localContext = new LocalContext((Namespace)processedClass, parentContext);
        TypeDeclaration[] typeDeclarationArray = node.getTypes();
        int n = typeDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration nestedTypes = typeDeclarationArray[n2];
            this.processTypeDeclaration(nestedTypes, localContext);
            ++n2;
        }
        return processedClass;
    }

    private Classifier processEnumDeclaration(EnumDeclaration node, LocalContext parentContext) {
        Enumeration processedClass = this.createEnumeration(parentContext, node);
        LocalContext localContext = new LocalContext((Namespace)processedClass, parentContext);
        List bodies = node.bodyDeclarations();
        for (BodyDeclaration nestedBody : bodies) {
            switch (nestedBody.getNodeType()) {
                case 55: 
                case 71: 
                case 81: {
                    this.processTypeDeclaration((TypeDeclaration)nestedBody, localContext);
                }
            }
        }
        return processedClass;
    }

    private Classifier processAnnotationTypeDeclaration(AnnotationTypeDeclaration typeDecl, LocalContext localContext) {
        System.err.println("processAnnotationTypeDeclaration() - Not yet implemented !!");
        return null;
    }

    private Classifier processTypeReferences(TypeDeclaration node, LocalContext parentContext) {
        Object processedClass = node.isInterface() ? this.lookupInterface(parentContext, node) : this.lookupClass(parentContext, node);
        LocalContext localContext = new LocalContext((Namespace)processedClass, parentContext);
        this.processJavadoc(node.getJavadoc(), (Element)processedClass);
        this.processModifiers((Classifier)processedClass, node.modifiers());
        if (node.isInterface()) {
            List implementedTypes = node.superInterfaceTypes();
            for (Type type : implementedTypes) {
                Interface generalization = this.getInterfaceForType(type, localContext);
                if (processedClass instanceof BehavioredClassifier) {
                    UmlUtils.getInterfaceRealization((BehavioredClassifier)processedClass, generalization);
                    continue;
                }
                UmlUtils.getGeneralization((Classifier)processedClass, (Classifier)generalization);
            }
        } else {
            Type superclassType = node.getSuperclassType();
            if (superclassType != null) {
                Class generalization = this.getClassForType(superclassType, localContext);
                UmlUtils.getGeneralization((Classifier)processedClass, (Classifier)generalization);
            }
            List implementedTypes = node.superInterfaceTypes();
            for (Type type : implementedTypes) {
                Interface generalization = this.getInterfaceForType(type, localContext);
                if (processedClass instanceof BehavioredClassifier) {
                    UmlUtils.getInterfaceRealization((BehavioredClassifier)processedClass, generalization);
                    continue;
                }
                UmlUtils.getGeneralization((Classifier)processedClass, (Classifier)generalization);
            }
        }
        FieldDeclaration[] fieldDeclarationArray = node.getFields();
        int n = fieldDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            this.processFieldDeclaration((Classifier)processedClass, fieldDeclaration, localContext);
            ++n2;
        }
        fieldDeclarationArray = node.getMethods();
        n = fieldDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            FieldDeclaration methodDeclaration = fieldDeclarationArray[n2];
            this.processMethodDeclaration((Classifier)processedClass, (MethodDeclaration)methodDeclaration, localContext);
            ++n2;
        }
        fieldDeclarationArray = node.getTypes();
        n = fieldDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            FieldDeclaration nestedTypes = fieldDeclarationArray[n2];
            this.processTypeReferences((TypeDeclaration)nestedTypes, localContext);
            ++n2;
        }
        return processedClass;
    }

    private void processMethodDeclaration(Classifier classifier, MethodDeclaration methodDeclaration, LocalContext context) {
    }

    private void processFieldDeclaration(Classifier classifier, FieldDeclaration fieldDeclaration, LocalContext context) {
        TypeReferenceDeclaration data = this.getTypeReferenceDeclaration(fieldDeclaration);
        Type t = fieldDeclaration.getType();
        PropertyDeclarationHelper helper = new PropertyDeclarationHelper(fieldDeclaration, this.typeResolver);
        List variables = fieldDeclaration.fragments();
        for (VariableDeclarationFragment var : variables) {
            helper.setVariableDeclaration(var);
            this.updateProperty(classifier, helper, context);
        }
    }

    private void updateProperty(Classifier classifier, PropertyDeclarationHelper helper, LocalContext context) {
        if (helper.isSimpleProperty()) {
            this.updateSimpleProperty(classifier, helper, context);
        } else if (helper.isArrayProperty()) {
            this.updateArrayProperty(classifier, helper, context);
        }
    }

    private void updateSimpleProperty(Classifier parent, PropertyDeclarationHelper helper, LocalContext context) {
        Property property = UmlUtils.createProperty(parent, helper.getPropertyType(context), helper.getPropertyName(), 0);
        System.err.println("Property created :" + String.valueOf(property));
    }

    private void updateArrayProperty(Classifier parent, PropertyDeclarationHelper helper, LocalContext context) {
        Property property = UmlUtils.createProperty(parent, helper.getPropertyType(context), helper.getPropertyName(), 0);
        property.setLower(helper.getLower());
        property.setUpper(helper.getUpper());
    }

    private TypeReferenceDeclaration getTypeReferenceDeclaration(FieldDeclaration fieldDeclaration) {
        return new TypeReferenceDeclaration(fieldDeclaration);
    }

    private void processModifiers(Classifier processedClass, List<IExtendedModifier> modifiers) {
        for (IExtendedModifier modifier : modifiers) {
            if (modifier instanceof Modifier) {
                this.processModifier(processedClass, (Modifier)modifier);
                continue;
            }
            if (!(modifier instanceof Annotation)) continue;
            this.processAnnotation(processedClass, (Annotation)modifier);
        }
    }

    private void processAnnotation(Classifier processedClass, Annotation modifier) {
    }

    private void processModifier(Classifier c, Modifier modifier) {
        if (modifier.isPrivate()) {
            c.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        }
        if (modifier.isProtected()) {
            c.setVisibility(VisibilityKind.PROTECTED_LITERAL);
        }
        if (modifier.isPublic()) {
            c.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        }
        if (modifier.isAbstract()) {
            c.setIsAbstract(true);
        }
        if (modifier.isFinal()) {
            c.setIsLeaf(true);
        }
    }

    private Classifier processEnumReferences(EnumDeclaration node, LocalContext parentContext) {
        Enumeration processedClass = this.lookupEnumeration(parentContext, node);
        LocalContext localContext = new LocalContext((Namespace)processedClass, parentContext);
        List bodies = node.bodyDeclarations();
        for (BodyDeclaration nestedBody : bodies) {
            switch (nestedBody.getNodeType()) {
                case 55: 
                case 71: 
                case 81: {
                    this.processTypeReferences((TypeDeclaration)nestedBody, localContext);
                }
            }
        }
        return processedClass;
    }

    private Classifier processAnnotationTypeReferences(AnnotationTypeDeclaration typeDecl, LocalContext localContext) {
        System.err.println("processAnnotationTypeReferences() - Not yet implemented !!");
        return null;
    }

    private void processJavadoc(Javadoc javaDoc, Element umlElement) {
        if (javaDoc == null) {
            return;
        }
        EList ownedComments = umlElement.getOwnedComments();
        Comment comment = ownedComments != null && ownedComments.size() > 0 ? (Comment)ownedComments.get(0) : umlElement.createOwnedComment();
        String commentBody = this.javaDocToString(javaDoc);
        comment.setBody(commentBody);
    }

    private String javaDocToString(Javadoc javaDoc) {
        return javaDoc.toString();
    }

    protected Class createClass(LocalContext parentContext, TypeDeclaration node) {
        return UmlUtils.getExactClass(parentContext.getNamespace(), node.getName().getIdentifier());
    }

    protected Enumeration createEnumeration(LocalContext parentContext, EnumDeclaration node) {
        return UmlUtils.getExactEnumeration(parentContext.getNamespace(), node.getName().getIdentifier());
    }

    protected Interface createInterface(LocalContext parentContext, TypeDeclaration node) {
        System.out.println(String.format("getInterface(%s)", node.getName()));
        return UmlUtils.getExactInterface(parentContext.getNamespace(), node.getName().getIdentifier());
    }

    protected Class lookupClass(LocalContext parentContext, TypeDeclaration node) {
        return UmlUtils.lookupClass(parentContext.getNamespace(), node.getName().getIdentifier());
    }

    protected Enumeration lookupEnumeration(LocalContext parentContext, EnumDeclaration node) {
        return UmlUtils.lookupEnumeration(parentContext.getNamespace(), node.getName().getIdentifier());
    }

    protected Interface lookupInterface(LocalContext parentContext, TypeDeclaration node) {
        return UmlUtils.lookupInterface(parentContext.getNamespace(), node.getName().getIdentifier());
    }

    private void createDefaultGenerationPackage(Package rootModelElement) {
        Package p;
        this.defaultGenerationPackage = p = UmlUtils.getModel(rootModelElement, this.generationPackageQualifiedName);
    }

    private Package getCuPackage(PackageDeclaration packageDecl) {
        if (packageDecl == null) {
            return this.getDefaultGenerationPackage();
        }
        List<String> qualifiedName = UmlUtils.toQualifiedName(packageDecl.getName().getFullyQualifiedName());
        Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName, null);
        Package p = UmlUtils.getPackage(creationPackage, qualifiedName);
        return p;
    }

    private Package getDefaultGenerationPackage() {
        return this.defaultGenerationPackage;
    }

    private Class getClassForType(Type requestedType, LocalContext context) {
        return (Class)this.getClassifierForType(requestedType, context, UmlUtils.CLASS_TYPE);
    }

    private Interface getInterfaceForType(Type requestedType, LocalContext context) {
        return (Interface)this.getClassifierForType(requestedType, context, UmlUtils.INTERFACE_TYPE);
    }

    private Classifier getClassifierForType(Type requestedType, LocalContext context, EClass type) {
        String shortname = JdtAstUtils.getTypeShortname(requestedType);
        List<String> qualifiedName = this.importedTypes.getQualifiedName(shortname);
        if (qualifiedName.size() > 1) {
            Classifier result = this.classifierCatalog.getClassifier(qualifiedName);
            if (result != null) {
                return result;
            }
            Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName, null);
            result = (Classifier)UmlUtils.getClassifier(creationPackage, qualifiedName, type);
            return result;
        }
        Classifier result = context.lookupClassifier(shortname, type);
        if (result != null) {
            return result;
        }
        for (List<String> parentPackageQName : this.importedTypes.getStarImports()) {
            ArrayList<String> fullQName = new ArrayList<String>(parentPackageQName);
            fullQName.add(shortname);
            result = this.classifierCatalog.getClassifier(fullQName);
            if (result == null) continue;
            return result;
        }
        Package parentPackage = context.getCurrentPackage();
        result = (Classifier)UmlUtils.createType(parentPackage, shortname, type);
        return result;
    }

    private Classifier getClassifierForTypeOld(Type requestedType, LocalContext context, EClass type) {
        String shortname = JdtAstUtils.getTypeShortname(requestedType);
        List<String> qualifiedName = this.importedTypes.getQualifiedName(shortname);
        if (qualifiedName.size() > 1) {
            Classifier result = this.classifierCatalog.getClassifier(qualifiedName);
            if (result != null) {
                return result;
            }
            Package creationPackage = this.creationPackageCatalog.getCreationPackage(qualifiedName, null);
            result = (Classifier)UmlUtils.getClassifier(creationPackage, qualifiedName, type);
            return result;
        }
        Classifier result = context.lookupClassifier(shortname, type);
        if (result != null) {
            return result;
        }
        for (List<String> parentPackageQName : this.importedTypes.getStarImports()) {
            ArrayList<String> fullQName = new ArrayList<String>(parentPackageQName);
            fullQName.add(shortname);
            result = this.classifierCatalog.getClassifier(fullQName);
            if (result == null) continue;
            return result;
        }
        Package parentPackage = context.getCurrentPackage();
        result = (Classifier)UmlUtils.createType(parentPackage, shortname, type);
        return result;
    }
}

