/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;

public class FileUtils {
    public static String decodeID(String encodedURI) {
        Object result = "";
        int i = 0;
        while (i < encodedURI.length()) {
            char c = encodedURI.charAt(i);
            if (c == '_') {
                char next = encodedURI.charAt(i + 1);
                if (next == 'M') {
                    result = (String)result + "-";
                } else if (next == '_') {
                    result = (String)result + "_";
                }
                ++i;
            } else {
                result = (String)result + c;
            }
            ++i;
        }
        return result;
    }

    public static String encodeID(String uri) {
        return uri.replace("_", "__").replace("-", "_M");
    }

    public static String fragment(Element element) {
        Resource resource = element.eResource();
        if (resource instanceof XMLResource) {
            XMLResource xmlResource = (XMLResource)resource;
            return "\"" + xmlResource.getURIFragment((EObject)element) + "\"";
        }
        return null;
    }

    public static String getAbsoluteFN(String fileName) {
        try {
            URL absoluteURL = FileLocator.toFileURL((URL)new URL(fileName));
            return absoluteURL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static String getURI(Element element) {
        Resource resource = element.eResource();
        if (resource != null) {
            URI uri = resource.getURI();
            return uri.toString();
        }
        return null;
    }

    public static EList<Namespace> relativePath(Element element, Namespace searchNS) {
        BasicEList pathList = new BasicEList();
        Element owner = element.getOwner();
        if (!(owner instanceof Namespace)) {
            return null;
        }
        Namespace ns = (Namespace)owner;
        while (ns != null) {
            if (ns == searchNS) {
                return pathList;
            }
            pathList.add((Object)ns);
            ns = (Namespace)ns.getOwner();
        }
        return null;
    }
}

