/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;

public class OperationSync {
    public static void sync(Operation sourceOp, Operation targetOp) {
        if (targetOp != null) {
            CopyUtils.copyFeatureModifiers((Feature)sourceOp, (Feature)targetOp);
            targetOp.setIsQuery(sourceOp.isQuery());
            targetOp.setIsAbstract(sourceOp.isAbstract());
            targetOp.setName(sourceOp.getName());
            targetOp.getOwnedParameters().clear();
            for (Parameter parameter : sourceOp.getOwnedParameters()) {
                Type type = parameter.getType();
                Parameter newParameter = targetOp.createOwnedParameter(parameter.getLabel(), type);
                newParameter.setDirection(parameter.getDirection());
                CopyUtils.copyMultElemModifiers((MultiplicityElement)parameter, (MultiplicityElement)newParameter);
                StUtils.copyStereotypes((Element)parameter, (Element)newParameter);
            }
        }
        StUtils.copyStereotypes((Element)sourceOp, (Element)targetOp);
    }
}

