/**
 * Copyright (c) 2017, 2019 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Ansgar Radermacher - Initial API and implementation
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - Bug 530251
 *     Yoann Farre (CIL4Sys) - Bug 550446
 *     Yoann Farre (CIL4Sys) - Bug 576960
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.External;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.common.profile.CommonProfileResource;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.EnumStyle;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationSync;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.IncludeUtils;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCommon;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.transformation.vsl.ParseVSL;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StateMachineUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class SM2ClassesTransformationCore {
  @Extension
  protected CDefinitions cdefs;

  public int MAX_NUMBER_ORTHOGONAL_REGIONS = 1;

  private StateMachine sm;

  public Type boolType;

  public Type threadFuncEnum;

  public org.eclipse.uml2.uml.Class superContext;

  private List<Transition> transitions = new ArrayList<Transition>();

  private List<OpaqueBehavior> actions = new ArrayList<OpaqueBehavior>();

  public Region topRegion;

  public List<State> states = new ArrayList<State>();

  private List<Vertex> vertexes = new ArrayList<Vertex>();

  public LazyCopier copier;

  private String langID = "C++";

  private Type stateStruct;

  public boolean generateActionLog = false;

  private boolean createDoActivity = true;

  private boolean useThreadCpp11 = true;

  private Type threadCpp11;

  public Type voidType;

  private Enumeration stateIdEnum;

  public Type intType;

  public Type charType;

  private Enumeration eventIdEnum;

  public Type fptr;

  public PThreadTypes ptTypes;

  public Type sockAddrInType;

  public List<TimeEvent> timeEvents = new ArrayList<TimeEvent>();

  public List<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();

  public List<CallEvent> callEvents = new ArrayList<CallEvent>();

  private List<SignalEvent> signalEvents = new ArrayList<SignalEvent>();

  private List<AnyReceiveEvent> anyEvents = new ArrayList<AnyReceiveEvent>();

  private List<Pseudostate> junctions = new ArrayList<Pseudostate>();

  public ConcurrencyGenerator concurrency;

  public EventTransformation eventTransform;

  public PseudostateGenerator pseudostateGenerator;

  public MonitoringTransformation monitoringTransformation;

  public static String smLibraryUri = "platform:/resource/org.eclipse.papyrus.designer.codegen.statemachine/models/SmLibrary.uml";

  public List<Behavior> doActivityList = new ArrayList<Behavior>();

  public org.eclipse.uml2.uml.Package smPack;

  private List<Region> regions = new ArrayList<Region>();

  public List<Transition> parallelTransitions = new ArrayList<Transition>();

  public Map<State, List<TimeEvent>> states2TimeEvents = new HashMap<State, List<TimeEvent>>();

  private Type threadStructType;

  public SM2ClassesTransformationCore(final LazyCopier copier, final StateMachine sm, final org.eclipse.uml2.uml.Class tmClass) {
    this.copier = copier;
    this.superContext = tmClass;
    this.sm = sm;
    final ResourceSet resourceSet = this.getTargetPacket().eResource().getResourceSet();
    this.boolType = this.getPrimitiveType("bool", resourceSet);
    this.voidType = this.getPrimitiveType("void", resourceSet);
    this.intType = this.getPrimitiveType("int", resourceSet);
    this.charType = this.getPrimitiveType("char", resourceSet);
    this.sockAddrInType = this.getSocketType("sockaddr_in", resourceSet);
    PThreadTypes _pThreadTypes = new PThreadTypes(this.superContext);
    this.ptTypes = _pThreadTypes;
    CDefinitions _cDefinitions = new CDefinitions(this.superContext);
    this.cdefs = _cDefinitions;
  }

  public org.eclipse.uml2.uml.Package setSmPack(final org.eclipse.uml2.uml.Package smPack) {
    return this.smPack = smPack;
  }

  public Type getThreadStructType() {
    return this.threadStructType;
  }

  public Type setThreadStructType(final Type threadStructType) {
    return this.threadStructType = threadStructType;
  }

  /**
   * @since 0.7.7_2018
   */
  public Type getSocketType(final String name, final ResourceSet resourceSet) {
    final org.eclipse.uml2.uml.Package socketLibrary = ElementUtils.loadPackage(CppUriConstants.SOCKET_LIB_URI, resourceSet);
    final Element element = socketLibrary.getPackagedElement(name);
    if ((element instanceof Type)) {
      return ((Type)element);
    }
    return null;
  }

  public org.eclipse.uml2.uml.Package getRoot() {
    return TransformationContext.current.copier.source;
  }

  public Type getPrimitiveType(final String name, final ResourceSet resourceSet) {
    final org.eclipse.uml2.uml.Package ansiCLibrary = ElementUtils.loadPackage(CppUriConstants.ANSIC_LIB_URI, resourceSet);
    final Element element = ansiCLibrary.getPackagedElement(name);
    if ((element instanceof Type)) {
      return ((Type)element);
    }
    return null;
  }

  public org.eclipse.uml2.uml.Package getTargetPacket() {
    return this.copier.target;
  }

  public org.eclipse.uml2.uml.Package getExternalPackage(final org.eclipse.uml2.uml.Package parentPack) {
    org.eclipse.uml2.uml.Package _nestedPackage = parentPack.getNestedPackage("external");
    boolean _tripleEquals = (_nestedPackage == null);
    if (_tripleEquals) {
      org.eclipse.uml2.uml.Package createdPack = parentPack.createNestedPackage("external");
      StereotypeUtil.apply(createdPack, NoCodeGen.class);
    }
    return parentPack.getNestedPackage("external");
  }

  public void transform() {
    final org.eclipse.uml2.uml.Package targetPack = this.getTargetPacket();
    final ResourceSet resourceSet = targetPack.eResource().getResourceSet();
    final org.eclipse.uml2.uml.Package stdProfile = ElementUtils.loadPackage(StdUriConstants.UML_STD_PROFILE_URI, resourceSet);
    if ((stdProfile instanceof Profile)) {
      PackageUtil.applyProfile(targetPack, ((Profile) stdProfile), true);
    }
    final org.eclipse.uml2.uml.Package cgProfile = ElementUtils.loadPackage(CommonProfileResource.PROFILE_PATH_URI, resourceSet);
    if ((cgProfile instanceof Profile)) {
      PackageUtil.applyProfile(targetPack, ((Profile) cgProfile), true);
    }
    if (this.useThreadCpp11) {
      org.eclipse.uml2.uml.Package externalPackage = this.getExternalPackage(targetPack);
      this.threadCpp11 = externalPackage.createOwnedType("std::thread", UMLPackage.Literals.DATA_TYPE);
      StereotypeUtil.apply(this.threadCpp11, External.class);
    }
    this.topRegion = IterableExtensions.<Region>head(this.sm.getRegions());
    ConcurrencyGenerator _concurrencyGenerator = new ConcurrencyGenerator(this);
    this.concurrency = _concurrencyGenerator;
    EventTransformation _eventTransformation = new EventTransformation(this);
    this.eventTransform = _eventTransformation;
    PseudostateGenerator _pseudostateGenerator = new PseudostateGenerator(this);
    this.pseudostateGenerator = _pseudostateGenerator;
    MonitoringTransformation _monitoringTransformation = new MonitoringTransformation(this);
    this.monitoringTransformation = _monitoringTransformation;
    Map<Event, List<Transition>> eventMap = this.getAllEvents(this.topRegion);
    final BiConsumer<Event, List<Transition>> _function = (Event e, List<Transition> k) -> {
      if ((e instanceof TimeEvent)) {
        this.timeEvents.add(((TimeEvent)e));
      } else {
        if ((e instanceof CallEvent)) {
          this.callEvents.add(((CallEvent)e));
        } else {
          if ((e instanceof SignalEvent)) {
            this.signalEvents.add(((SignalEvent)e));
          } else {
            if ((e instanceof ChangeEvent)) {
              this.changeEvents.add(((ChangeEvent)e));
            } else {
              if ((e instanceof AnyReceiveEvent)) {
                this.anyEvents.add(((AnyReceiveEvent)e));
              }
            }
          }
        }
      }
    };
    eventMap.forEach(_function);
    Classifier _createNestedClassifier = this.superContext.createNestedClassifier(SMCodeGeneratorConstants.EVENT_ID, UMLPackage.Literals.ENUMERATION);
    this.eventIdEnum = ((Enumeration) _createNestedClassifier);
    final EnumStyle eventIdEnumStyle = StereotypeUtil.<EnumStyle>applyApp(this.eventIdEnum, EnumStyle.class);
    eventIdEnumStyle.setClassEnum(false);
    final Consumer<TimeEvent> _function_1 = (TimeEvent it) -> {
      this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID(it));
    };
    this.timeEvents.forEach(_function_1);
    final Consumer<ChangeEvent> _function_2 = (ChangeEvent it) -> {
      this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID(it));
    };
    this.changeEvents.forEach(_function_2);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#define ");
    String _TIME_EVENT_LOWER_BOUND = this.cdefs.TIME_EVENT_LOWER_BOUND();
    _builder.append(_TIME_EVENT_LOWER_BOUND);
    _builder.append(" (0)");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _CHANGE_EVENT_LOWER_BOUND = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
    _builder.append(_CHANGE_EVENT_LOWER_BOUND);
    _builder.append(" (");
    int _size = this.timeEvents.size();
    _builder.append(_size);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _TE_INDEX = this.cdefs.TE_INDEX();
    _builder.append(_TE_INDEX);
    _builder.append("(id) (id - ");
    String _TIME_EVENT_LOWER_BOUND_1 = this.cdefs.TIME_EVENT_LOWER_BOUND();
    _builder.append(_TIME_EVENT_LOWER_BOUND_1);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _CHE_INDEX = this.cdefs.CHE_INDEX();
    _builder.append(_CHE_INDEX);
    _builder.append("(id) (id - ");
    String _CHANGE_EVENT_LOWER_BOUND_1 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
    _builder.append(_CHANGE_EVENT_LOWER_BOUND_1);
    _builder.append(")");
    _builder.newLineIfNotEmpty();
    IncludeUtils.appendIncludeHeader(this.superContext, _builder.toString());
    this.monitoringTransformation.appendInclude();
    final Consumer<SignalEvent> _function_3 = (SignalEvent it) -> {
      this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID(it));
    };
    this.signalEvents.forEach(_function_3);
    final Consumer<CallEvent> _function_4 = (CallEvent it) -> {
      this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID(it));
    };
    this.callEvents.forEach(_function_4);
    final Consumer<AnyReceiveEvent> _function_5 = (AnyReceiveEvent it) -> {
      this.eventIdEnum.createOwnedLiteral(StateMachineUtils.eventID(it));
    };
    this.anyEvents.forEach(_function_5);
    String _upperCase = SMCodeGeneratorConstants.COMPLETION_EVENT.toUpperCase();
    String _plus = (_upperCase + "_ID");
    this.eventIdEnum.createOwnedLiteral(_plus);
    this.getAllActionsTransitionsStates(this.topRegion);
    final Function1<State, Boolean> _function_6 = (State it) -> {
      return Boolean.valueOf(it.isOrthogonal());
    };
    final Consumer<State> _function_7 = (State it) -> {
      int _size_1 = it.getRegions().size();
      boolean _greaterThan = (_size_1 > this.MAX_NUMBER_ORTHOGONAL_REGIONS);
      if (_greaterThan) {
        this.MAX_NUMBER_ORTHOGONAL_REGIONS = it.getRegions().size();
      }
    };
    IterableExtensions.<State>filter(this.states, _function_6).forEach(_function_7);
    final Consumer<State> _function_8 = (State it) -> {
      final ArrayList<Trigger> triggers = new ArrayList<Trigger>();
      final Consumer<Transition> _function_9 = (Transition it_1) -> {
        triggers.addAll(it_1.getTriggers());
      };
      it.getOutgoings().forEach(_function_9);
      final Function1<Trigger, Event> _function_10 = (Trigger it_1) -> {
        return it_1.getEvent();
      };
      final List<Event> events = ListExtensions.<Trigger, Event>map(triggers, _function_10);
      final List<TimeEvent> timeEvents = IterableExtensions.<TimeEvent>toList(Iterables.<TimeEvent>filter(events, TimeEvent.class));
      this.states2TimeEvents.put(it, timeEvents);
    };
    this.states.forEach(_function_8);
    final Consumer<Pseudostate> _function_9 = (Pseudostate it) -> {
      PseudostateKind _kind = it.getKind();
      boolean _equals = Objects.equals(_kind, PseudostateKind.JUNCTION_LITERAL);
      if (_equals) {
        this.junctions.add(it);
      }
    };
    Iterables.<Pseudostate>filter(this.vertexes, Pseudostate.class).forEach(_function_9);
    final Consumer<Pseudostate> _function_10 = (Pseudostate it) -> {
      this.superContext.createOwnedAttribute(it.getName(), this.intType);
    };
    this.junctions.forEach(_function_10);
    Classifier _createNestedClassifier_1 = this.superContext.createNestedClassifier("StateIDEnum", UMLPackage.Literals.ENUMERATION);
    this.stateIdEnum = ((Enumeration) _createNestedClassifier_1);
    final EnumStyle stateIdEnumStyle = StereotypeUtil.<EnumStyle>applyApp(this.stateIdEnum, EnumStyle.class);
    stateIdEnumStyle.setClassEnum(false);
    this.monitoringTransformation.createMonitorAttributes();
    this.createStateStruct();
    Property stateArrayAttr = this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, this.stateStruct);
    StereotypeUtil.apply(stateArrayAttr, Array.class);
    Array _stereotypeApplication = UMLUtil.<Array>getStereotypeApplication(stateArrayAttr, Array.class);
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("[");
    int _size_1 = this.states.size();
    _builder_1.append(_size_1);
    _builder_1.append("]");
    _stereotypeApplication.setDefinition(_builder_1.toString());
    this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, this.stateIdEnum);
    this.createRegionMethods();
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("startBehavior();");
    final String startCode = _builder_2.toString();
    boolean _supportsLifeCycle = LifeCycleUtil.supportsLifeCycle(this.superContext);
    if (_supportsLifeCycle) {
      LifeCycleUtil.addUnimplemented(this.superContext);
      Operation activateOp = this.superContext.getOperation(LifeCycleUtil.M_ACTIVATE, null, null);
      BehaviorUtils.appendBody(activateOp, startCode);
    } else {
      final Function1<Operation, Boolean> _function_11 = (Operation it) -> {
        return Boolean.valueOf((StereotypeUtil.isApplied(it, Create.class) && Objects.equals(it.getName(), this.superContext.getName())));
      };
      final Iterable<Operation> constructors = IterableExtensions.<Operation>filter(this.superContext.getOwnedOperations(), _function_11);
      boolean _isEmpty = IterableExtensions.isEmpty(constructors);
      if (_isEmpty) {
        Operation ctor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
        StereotypeUtil.apply(ctor, Create.class);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("startBehavior();");
        this.createOpaqueBehavior(this.superContext, ctor, _builder_3.toString());
      } else {
        final Consumer<Operation> _function_12 = (Operation it) -> {
          BehaviorUtils.appendBody(it, startCode);
        };
        constructors.forEach(_function_12);
      }
    }
    this.monitoringTransformation.createConstructor();
    this.monitoringTransformation.createDestructor();
    Operation startBehavior = this.superContext.createOwnedOperation("startBehavior", null, null);
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
    _builder_4.append(" = statemachine::SystemStateEnum_t::IDLE;");
    _builder_4.newLineIfNotEmpty();
    {
      for(final State s : this.states) {
        {
          boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist(s.getEntry());
          if (_isBehaviorExist) {
            _builder_4.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_4.append("[");
            String _upperCase_1 = s.getName().toUpperCase();
            _builder_4.append(_upperCase_1);
            _builder_4.append("_ID].");
            _builder_4.append(SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_4.append(" = &");
            String _name = this.superContext.getName();
            _builder_4.append(_name);
            _builder_4.append("::");
            String _name_1 = s.getName();
            String _plus_1 = (_name_1 + "_");
            String _plus_2 = (_plus_1 + SMCodeGeneratorConstants.ENTRY_NAME);
            _builder_4.append(_plus_2);
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
          }
        }
        {
          boolean _isBehaviorExist_1 = StateMachineUtils.isBehaviorExist(s.getExit());
          if (_isBehaviorExist_1) {
            _builder_4.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_4.append("[");
            String _upperCase_2 = s.getName().toUpperCase();
            _builder_4.append(_upperCase_2);
            _builder_4.append("_ID].");
            _builder_4.append(SMCodeGeneratorConstants.EXIT_NAME);
            _builder_4.append(" = &");
            String _name_2 = this.superContext.getName();
            _builder_4.append(_name_2);
            _builder_4.append("::");
            String _name_3 = s.getName();
            String _plus_3 = (_name_3 + "_");
            String _plus_4 = (_plus_3 + SMCodeGeneratorConstants.EXIT_NAME);
            _builder_4.append(_plus_4);
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
          }
        }
        {
          boolean _isBehaviorExist_2 = StateMachineUtils.isBehaviorExist(s.getDoActivity());
          if (_isBehaviorExist_2) {
            _builder_4.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_4.append("[");
            String _upperCase_3 = s.getName().toUpperCase();
            _builder_4.append(_upperCase_3);
            _builder_4.append("_ID].");
            _builder_4.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
            _builder_4.append(" = &");
            String _name_4 = this.superContext.getName();
            _builder_4.append(_name_4);
            _builder_4.append("::");
            String _name_5 = s.getName();
            String _plus_5 = (_name_5 + "_");
            String _plus_6 = (_plus_5 + SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
            _builder_4.append(_plus_6);
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
          }
        }
        _builder_4.append(SMCodeGeneratorConstants.DO_ACTIVITY_TABLE);
        _builder_4.append("[");
        String _upperCase_4 = s.getName().toUpperCase();
        _builder_4.append(_upperCase_4);
        _builder_4.append("_ID] =  ");
        _builder_4.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
        _builder_4.append("[");
        String _upperCase_5 = s.getName().toUpperCase();
        _builder_4.append(_upperCase_5);
        _builder_4.append("_ID].");
        _builder_4.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
        _builder_4.append(";");
        _builder_4.newLineIfNotEmpty();
      }
    }
    _builder_4.newLine();
    _builder_4.append("// initialize all threads, the threads wait until the associated flag is set");
    _builder_4.newLine();
    _builder_4.append("for(int i = 0; i < (int) ");
    _builder_4.append(SMCodeGeneratorConstants.STATE_MAX);
    _builder_4.append("; i++) {");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t");
    _builder_4.append("if (");
    _builder_4.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder_4.append("[i].");
    _builder_4.append(SMCodeGeneratorConstants.DO_ACTIVITY_NAME, "\t");
    _builder_4.append(" != &");
    String _name_6 = this.superContext.getName();
    _builder_4.append(_name_6, "\t");
    _builder_4.append("::doActivity_dft) {");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t\t");
    _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
    _builder_4.append("[i].id = i;");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t\t");
    _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
    _builder_4.append("[i].ptr = this;");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t\t");
    _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
    _builder_4.append("[i].func_type = ");
    _builder_4.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
    _builder_4.append(";");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t\t");
    _builder_4.append(SMCodeGeneratorConstants.MUTEXES, "\t\t");
    _builder_4.append("[i] = PTHREAD_MUTEX_INITIALIZER;");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t\t");
    _builder_4.append(SMCodeGeneratorConstants.CONDITIONS, "\t\t");
    _builder_4.append("[i] = PTHREAD_COND_INITIALIZER;");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t\t");
    _builder_4.append(SMCodeGeneratorConstants.FORK_NAME, "\t\t");
    _builder_4.append("(&");
    _builder_4.append(SMCodeGeneratorConstants.THREADS, "\t\t");
    _builder_4.append("[i], NULL, &");
    String _name_7 = this.superContext.getName();
    _builder_4.append(_name_7, "\t\t");
    _builder_4.append("::");
    _builder_4.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "\t\t");
    _builder_4.append(", &");
    _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS, "\t\t");
    _builder_4.append("[i]);");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("\t");
    _builder_4.append("}");
    _builder_4.newLine();
    _builder_4.append("}");
    _builder_4.newLine();
    _builder_4.newLine();
    {
      int _size_2 = this.timeEvents.size();
      boolean _greaterThan = (_size_2 > 0);
      if (_greaterThan) {
        {
          for(final TimeEvent e : this.timeEvents) {
            ValueSpecification _expr = e.getWhen().getExpr();
            long duration = ParseVSL.getMsDurationFromVSL(((OpaqueExpression) _expr).getBodies().get(0));
            _builder_4.newLineIfNotEmpty();
            _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT);
            _builder_4.append("[");
            String _TE_INDEX_1 = this.cdefs.TE_INDEX();
            _builder_4.append(_TE_INDEX_1);
            _builder_4.append("(");
            String _eventID = StateMachineUtils.eventID(e);
            _builder_4.append(_eventID);
            _builder_4.append(")].duration = ");
            _builder_4.append(duration);
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
          }
        }
        _builder_4.append("for(int i = ");
        String _TIME_EVENT_LOWER_BOUND_2 = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder_4.append(_TIME_EVENT_LOWER_BOUND_2);
        _builder_4.append("; i < ");
        int _size_3 = this.timeEvents.size();
        _builder_4.append(_size_3);
        _builder_4.append("; i++) {");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_2 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_2, "\t");
        _builder_4.append("(i)].id = i;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_3 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_3, "\t");
        _builder_4.append("(i)].ptr = this;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_4 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_4, "\t");
        _builder_4.append("(i)].func_type = ");
        _builder_4.append(SMCppCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE, "\t");
        _builder_4.append(";");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.MUTEXES_TIME_EVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_5 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_5, "\t");
        _builder_4.append("(i)] = PTHREAD_MUTEX_INITIALIZER;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.CONDITIONS_TIME_EVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_6 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_6, "\t");
        _builder_4.append("(i)] = PTHREAD_COND_INITIALIZER;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.FORK_NAME, "\t");
        _builder_4.append("(&");
        _builder_4.append(SMCodeGeneratorConstants.THREADS_TIME_EVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_7 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_7, "\t");
        _builder_4.append("(i)], NULL, &");
        String _name_8 = this.superContext.getName();
        _builder_4.append(_name_8, "\t");
        _builder_4.append("::");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "\t");
        _builder_4.append(", &");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_TIMEEVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_8 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_8, "\t");
        _builder_4.append("(i)]);");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append("while (");
        _builder_4.append(SMCodeGeneratorConstants.FLAGS_TIME_EVENT, "\t");
        _builder_4.append("[");
        String _TE_INDEX_9 = this.cdefs.TE_INDEX();
        _builder_4.append(_TE_INDEX_9, "\t");
        _builder_4.append("(i)]) {");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t\t");
        _builder_4.append("usleep(100);");
        _builder_4.newLine();
        _builder_4.append("\t");
        _builder_4.append("}");
        _builder_4.newLine();
        _builder_4.append("}");
        _builder_4.newLine();
      }
    }
    _builder_4.newLine();
    {
      boolean _isEmpty_1 = this.orthogonalRegions.isEmpty();
      boolean _not = (!_isEmpty_1);
      if (_not) {
        {
          for(final Region r : this.orthogonalRegions) {
            _builder_4.append(SMCodeGeneratorConstants.REGION_TABLE);
            _builder_4.append("[");
            String _regionMacroId = this.getRegionMacroId(r);
            _builder_4.append(_regionMacroId);
            _builder_4.append("] = &");
            String _name_9 = this.superContext.getName();
            _builder_4.append(_name_9);
            _builder_4.append("::");
            String _regionMethodName = this.getRegionMethodName(r);
            _builder_4.append(_regionMethodName);
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append(SMCodeGeneratorConstants.REGION_TABLE_EXIT);
            _builder_4.append("[");
            String _regionMacroId_1 = this.getRegionMacroId(r);
            _builder_4.append(_regionMacroId_1);
            _builder_4.append("] = &");
            String _name_10 = this.superContext.getName();
            _builder_4.append(_name_10);
            _builder_4.append("::");
            String _regionMethodExitName = this.getRegionMethodExitName(r);
            _builder_4.append(_regionMethodExitName);
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder_4.newLine();
    {
      boolean _isEmpty_2 = this.parallelTransitions.isEmpty();
      boolean _not_1 = (!_isEmpty_2);
      if (_not_1) {
        {
          for(final Transition t : this.parallelTransitions) {
            _builder_4.append(SMCodeGeneratorConstants.PARALLEL_TRANSITION_TABLE);
            _builder_4.append("[");
            String _parallelTransitionId = this.concurrency.parallelTransitionId(t);
            _builder_4.append(_parallelTransitionId);
            _builder_4.append("] = &");
            String _name_11 = this.superContext.getName();
            _builder_4.append(_name_11);
            _builder_4.append("::");
            String _parallelTransitionMethodName = this.concurrency.parallelTransitionMethodName(t);
            _builder_4.append(_parallelTransitionMethodName);
            _builder_4.append(";");
            _builder_4.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder_4.newLine();
    _builder_4.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX);
    _builder_4.append(" = PTHREAD_MUTEX_INITIALIZER;");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND);
    _builder_4.append(" = PTHREAD_COND_INITIALIZER;");
    _builder_4.newLineIfNotEmpty();
    _builder_4.newLine();
    _builder_4.append("dispatchStruct = ");
    _builder_4.append(SMCppCodeGeneratorConstants.STRUCT_FOR_THREAD);
    _builder_4.append("(this, 0, 0, ");
    _builder_4.append(SMCppCodeGeneratorConstants.THREAD_FUNC_STATE_MACHINE_TYPE);
    _builder_4.append(", 0);");
    _builder_4.newLineIfNotEmpty();
    String _name_12 = this.superContext.getName();
    _builder_4.append(_name_12);
    _builder_4.append("_THREAD_CREATE(dispatchThread, dispatchStruct)");
    _builder_4.newLineIfNotEmpty();
    _builder_4.append("while (!dispatchFlag) {");
    _builder_4.newLine();
    _builder_4.append("\t");
    _builder_4.append("usleep(100);");
    _builder_4.newLine();
    _builder_4.append("}");
    _builder_4.newLine();
    _builder_4.newLine();
    {
      int _size_4 = this.changeEvents.size();
      boolean _greaterThan_1 = (_size_4 > 0);
      if (_greaterThan_1) {
        _builder_4.append("// threads for changeEvent");
        _builder_4.newLine();
        _builder_4.append("for(int i = ");
        String _CHANGE_EVENT_LOWER_BOUND_2 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder_4.append(_CHANGE_EVENT_LOWER_BOUND_2);
        _builder_4.append("; i < ");
        String _CHANGE_EVENT_LOWER_BOUND_3 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
        _builder_4.append(_CHANGE_EVENT_LOWER_BOUND_3);
        _builder_4.append(" + ");
        int _size_5 = this.changeEvents.size();
        _builder_4.append(_size_5);
        _builder_4.append("; i++) {");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_4.append("[");
        String _CHE_INDEX_1 = this.cdefs.CHE_INDEX();
        _builder_4.append(_CHE_INDEX_1, "\t");
        _builder_4.append("(i)].id = i;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_4.append("[");
        String _CHE_INDEX_2 = this.cdefs.CHE_INDEX();
        _builder_4.append(_CHE_INDEX_2, "\t");
        _builder_4.append("(i)].ptr = this;");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_4.append("[");
        String _CHE_INDEX_3 = this.cdefs.CHE_INDEX();
        _builder_4.append(_CHE_INDEX_3, "\t");
        _builder_4.append("(i)].func_type = ");
        _builder_4.append(SMCppCodeGeneratorConstants.THREAD_FUNC_CHANGEEVENT_TYPE, "\t");
        _builder_4.append(";");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append(SMCodeGeneratorConstants.FORK_NAME, "\t");
        _builder_4.append("(&");
        _builder_4.append(SMCodeGeneratorConstants.THREADS_CHANGE_EVENT, "\t");
        _builder_4.append("[");
        String _CHE_INDEX_4 = this.cdefs.CHE_INDEX();
        _builder_4.append(_CHE_INDEX_4, "\t");
        _builder_4.append("(i)], NULL, &");
        String _name_13 = this.superContext.getName();
        _builder_4.append(_name_13, "\t");
        _builder_4.append("::");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER, "\t");
        _builder_4.append(", &");
        _builder_4.append(SMCodeGeneratorConstants.THREAD_STRUCTS_FOR_CHANGEEVENT, "\t");
        _builder_4.append("[");
        String _CHE_INDEX_5 = this.cdefs.CHE_INDEX();
        _builder_4.append(_CHE_INDEX_5, "\t");
        _builder_4.append("(i)]);");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("}");
        _builder_4.newLine();
      }
    }
    _builder_4.newLine();
    _builder_4.append("//initialze root active state");
    _builder_4.newLine();
    _builder_4.append("//execute initial effect");
    _builder_4.newLine();
    String _regionMethodName_1 = this.getRegionMethodName(this.topRegion);
    _builder_4.append(_regionMethodName_1);
    _builder_4.append("(");
    String _initialMacroName = this.getInitialMacroName(this.topRegion);
    _builder_4.append(_initialMacroName);
    _builder_4.append(");");
    _builder_4.newLineIfNotEmpty();
    this.createOpaqueBehavior(this.superContext, startBehavior, _builder_4.toString());
    final Property dispatchFlagAttribute = this.superContext.createOwnedAttribute("dispatchFlag", this.boolType);
    ValueSpecification _createDefaultValue = dispatchFlagAttribute.createDefaultValue("defaultValue", this.boolType, UMLPackage.Literals.LITERAL_BOOLEAN);
    final LiteralBoolean litBool = ((LiteralBoolean) _createDefaultValue);
    litBool.setValue(false);
    final BiConsumer<Event, List<Transition>> _function_13 = (Event e_1, List<Transition> trans) -> {
      this.eventTransform.createEventMethod(e_1, trans);
    };
    eventMap.forEach(_function_13);
    final ArrayList<Transition> autoTrans = new ArrayList<Transition>();
    final Consumer<Transition> _function_14 = (Transition it) -> {
      if (((it.getSource() instanceof State) && (ListExtensions.<Trigger, Event>map(it.getTriggers(), ((Function1<Trigger, Event>) (Trigger it_1) -> {
        return it_1.getEvent();
      })).size() == 0))) {
        autoTrans.add(it);
      }
    };
    this.transitions.forEach(_function_14);
    this.eventTransform.createEventMethod(SMCodeGeneratorConstants.COMPLETION_EVENT, autoTrans);
    final Consumer<State> _function_15 = (State it) -> {
      String _upperCase_6 = it.getName().toUpperCase();
      String _plus_7 = (_upperCase_6 + "_ID");
      this.stateIdEnum.createOwnedLiteral(_plus_7);
      boolean _isBehaviorExist_3 = StateMachineUtils.isBehaviorExist(it.getEntry());
      if (_isBehaviorExist_3) {
        String _name_14 = it.getName();
        String _plus_8 = (_name_14 + "_");
        String _plus_9 = (_plus_8 + SMCodeGeneratorConstants.ENTRY_NAME);
        Operation entry = this.superContext.createOwnedOperation(_plus_9, null, null);
        Behavior _entry = it.getEntry();
        OpaqueBehavior opaque = this.createOpaqueBehavior(this.superContext, entry, IterableExtensions.<String>head(((OpaqueBehavior) _entry).getBodies()));
        opaque.getLanguages().add(this.langID);
      }
      boolean _isBehaviorExist_4 = StateMachineUtils.isBehaviorExist(it.getExit());
      if (_isBehaviorExist_4) {
        String _name_15 = it.getName();
        String _plus_10 = (_name_15 + "_");
        String _plus_11 = (_plus_10 + SMCodeGeneratorConstants.EXIT_NAME);
        Operation exit = this.superContext.createOwnedOperation(_plus_11, null, null);
        Behavior _exit = it.getExit();
        OpaqueBehavior opaque_1 = this.createOpaqueBehavior(this.superContext, exit, IterableExtensions.<String>head(((OpaqueBehavior) _exit).getBodies()));
        opaque_1.getLanguages().add(this.langID);
      }
      boolean _isBehaviorExist_5 = StateMachineUtils.isBehaviorExist(it.getDoActivity());
      if (_isBehaviorExist_5) {
        this.doActivityList.add(it.getDoActivity());
        String _name_16 = it.getName();
        String _plus_12 = (_name_16 + "_");
        String _plus_13 = (_plus_12 + SMCodeGeneratorConstants.DO_ACTIVITY_NAME);
        Operation doActivity = this.superContext.createOwnedOperation(_plus_13, null, null);
        StringConcatenation _builder_5 = new StringConcatenation();
        String callCompletionEvent = _builder_5.toString();
        boolean _isComposite = it.isComposite();
        boolean _not_2 = (!_isComposite);
        if (_not_2) {
        }
        Behavior _doActivity = it.getDoActivity();
        String _head = IterableExtensions.<String>head(((OpaqueBehavior) _doActivity).getBodies());
        String _plus_14 = (_head + "\n");
        String _plus_15 = (_plus_14 + callCompletionEvent);
        OpaqueBehavior opaque_2 = this.createOpaqueBehavior(this.superContext, doActivity, _plus_15);
        opaque_2.getLanguages().add(this.langID);
      } else {
      }
    };
    this.states.forEach(_function_15);
    this.stateIdEnum.createOwnedLiteral(SMCodeGeneratorConstants.STATE_MAX);
    this.concurrency.createThreadBasedParallelism();
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append("#define ");
    String _name_14 = this.superContext.getName();
    _builder_5.append(_name_14);
    _builder_5.append("_THREAD_CREATE(thThread, str) ");
    _builder_5.append(SMCodeGeneratorConstants.FORK_NAME);
    _builder_5.append("(&thThread, NULL, &");
    String _name_15 = this.superContext.getName();
    _builder_5.append(_name_15);
    _builder_5.append("::");
    _builder_5.append(SMCodeGeneratorConstants.THREAD_FUNC_WRAPPER);
    _builder_5.append(", &str);");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("#define ");
    String _upperCase_6 = this.superContext.getName().toUpperCase();
    _builder_5.append(_upperCase_6);
    _builder_5.append("_GET_CONTROL /*mutex synchronization to protect run-to-completion semantics*/ \\");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t\t");
    _builder_5.append("pthread_mutex_lock(&");
    _builder_5.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, "\t\t");
    _builder_5.append("); \\");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t\t");
    _builder_5.append("while (");
    _builder_5.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
    _builder_5.append(" != statemachine::SystemStateEnum_t::IDLE) {\\");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t\t\t");
    _builder_5.append("pthread_cond_wait(&");
    _builder_5.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND, "\t\t\t");
    _builder_5.append(", &");
    _builder_5.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, "\t\t\t");
    _builder_5.append(");\\");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t\t");
    _builder_5.append("}");
    _builder_5.newLine();
    _builder_5.append("#define ");
    String _upperCase_7 = this.superContext.getName().toUpperCase();
    _builder_5.append(_upperCase_7);
    _builder_5.append("_RELEASE_CONTROL ");
    _builder_5.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR);
    _builder_5.append(" = statemachine::SystemStateEnum_t::IDLE; pthread_cond_signal(&");
    _builder_5.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND);
    _builder_5.append("); \\");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t\t\t");
    _builder_5.append("pthread_mutex_unlock(&");
    _builder_5.append(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, "\t\t\t");
    _builder_5.append(");");
    _builder_5.newLineIfNotEmpty();
    IncludeUtils.appendIncludeHeader(this.superContext, _builder_5.toString());
    Type eventClass = this.smPack.getOwnedType("Event_t");
    Type eventQueueClass = this.smPack.getOwnedType("EventPriorityQueue");
    this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.EVENT_QUEUE, eventQueueClass);
    final Property curentEvent = this.superContext.createOwnedAttribute("currentEvent", eventClass);
    StereotypeUtil.apply(curentEvent, Ptr.class);
    Operation eventDispatch = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.EVENT_DISPATCH, null, null);
    StringConcatenation _builder_6 = new StringConcatenation();
    _builder_6.append("bool popDeferred = false;");
    _builder_6.newLine();
    _builder_6.append("while(true) {");
    _builder_6.newLine();
    _builder_6.append("\t");
    _builder_6.append("//run-to-completion: need to have a mutex here");
    _builder_6.newLine();
    _builder_6.append("\t");
    _builder_6.append("currentEvent = ");
    _builder_6.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t");
    _builder_6.append(".pop(popDeferred);");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t");
    _builder_6.append("dispatchFlag = true;");
    _builder_6.newLine();
    _builder_6.append("\t");
    _builder_6.append("if (currentEvent != NULL) {");
    _builder_6.newLine();
    _builder_6.append("\t\t");
    _builder_6.append("unsigned int eventID = currentEvent->eventID;");
    _builder_6.newLine();
    _builder_6.append("\t\t");
    String _upperCase_8 = this.superContext.getName().toUpperCase();
    _builder_6.append(_upperCase_8, "\t\t");
    _builder_6.append("_GET_CONTROL");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t\t");
    _builder_6.append("switch(eventID) {");
    _builder_6.newLine();
    {
      final Function1<Event, Boolean> _function_16 = (Event it) -> {
        return Boolean.valueOf((!(it instanceof CallEvent)));
      };
      Iterable<Event> _filter = IterableExtensions.<Event>filter(eventMap.keySet(), _function_16);
      for(final Event e_1 : _filter) {
        _builder_6.append("\t\t\t");
        _builder_6.append("case ");
        String _eventID_1 = StateMachineUtils.eventID(e_1);
        _builder_6.append(_eventID_1, "\t\t\t");
        _builder_6.append(": {");
        _builder_6.newLineIfNotEmpty();
        {
          if ((e_1 instanceof SignalEvent)) {
            {
              Signal _signal = ((SignalEvent)e_1).getSignal();
              boolean _tripleNotEquals = (_signal != null);
              if (_tripleNotEquals) {
                _builder_6.append("\t\t\t");
                _builder_6.append("\t");
                String _cppQualifiedName = CppGenUtils.cgu(this.superContext).cppQualifiedName(((SignalEvent)e_1).getSignal());
                _builder_6.append(_cppQualifiedName, "\t\t\t\t");
                _builder_6.append(" sig_");
                String _eventID_2 = StateMachineUtils.eventID(e_1);
                _builder_6.append(_eventID_2, "\t\t\t\t");
                _builder_6.append(";");
                _builder_6.newLineIfNotEmpty();
                _builder_6.append("\t\t\t");
                _builder_6.append("\t");
                _builder_6.append("if (currentEvent != NULL) {");
                _builder_6.newLine();
                _builder_6.append("\t\t\t");
                _builder_6.append("\t");
                _builder_6.append("\t");
                _builder_6.append("memcpy(&sig_");
                String _eventID_3 = StateMachineUtils.eventID(e_1);
                _builder_6.append(_eventID_3, "\t\t\t\t\t");
                _builder_6.append(", currentEvent->data, sizeof(");
                String _cppQualifiedName_1 = CppGenUtils.cgu(this.superContext).cppQualifiedName(((SignalEvent)e_1).getSignal());
                _builder_6.append(_cppQualifiedName_1, "\t\t\t\t\t");
                _builder_6.append("));");
                _builder_6.newLineIfNotEmpty();
                _builder_6.append("\t\t\t");
                _builder_6.append("\t");
                _builder_6.append("\t");
                _builder_6.append("process");
                String _eventName = StateMachineUtils.eventName(e_1);
                _builder_6.append(_eventName, "\t\t\t\t\t");
                _builder_6.append("(sig_");
                String _eventID_4 = StateMachineUtils.eventID(e_1);
                _builder_6.append(_eventID_4, "\t\t\t\t\t");
                _builder_6.append(");");
                _builder_6.newLineIfNotEmpty();
                _builder_6.append("\t\t\t");
                _builder_6.append("\t");
                _builder_6.append("}");
                _builder_6.newLine();
              } else {
                _builder_6.append("\t\t\t");
                _builder_6.append("\t");
                _builder_6.append("process");
                String _eventName_1 = StateMachineUtils.eventName(e_1);
                _builder_6.append(_eventName_1, "\t\t\t\t");
                _builder_6.append("();");
                _builder_6.newLineIfNotEmpty();
              }
            }
          } else {
            _builder_6.append("\t\t\t");
            _builder_6.append("\t");
            _builder_6.append("process");
            String _eventName_2 = StateMachineUtils.eventName(e_1);
            _builder_6.append(_eventName_2, "\t\t\t\t");
            _builder_6.append("();");
            _builder_6.newLineIfNotEmpty();
          }
        }
        _builder_6.append("\t\t\t");
        _builder_6.append("\t");
        _builder_6.append("break;");
        _builder_6.newLine();
        _builder_6.append("\t\t\t");
        _builder_6.append("}");
        _builder_6.newLine();
      }
    }
    _builder_6.append("\t\t\t");
    _builder_6.append("case COMPLETIONEVENT_ID: {");
    _builder_6.newLine();
    _builder_6.append("\t\t\t\t");
    _builder_6.append("processCompletionEvent();");
    _builder_6.newLine();
    _builder_6.append("\t\t\t\t");
    _builder_6.append("break;");
    _builder_6.newLine();
    _builder_6.append("\t\t\t\t");
    _builder_6.append("}");
    _builder_6.newLine();
    _builder_6.append("\t\t");
    _builder_6.append("}");
    _builder_6.newLine();
    _builder_6.append("\t\t");
    _builder_6.append("if (");
    _builder_6.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
    _builder_6.append(" == statemachine::SystemStateEnum_t::EVENT_DEFERRED) {");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t\t\t");
    _builder_6.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t\t\t");
    _builder_6.append(".saveDeferred(*currentEvent);");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t\t");
    _builder_6.append("}");
    _builder_6.newLine();
    _builder_6.append("\t\t");
    _builder_6.append("popDeferred = (");
    _builder_6.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
    _builder_6.append(" != statemachine::SystemStateEnum_t::EVENT_DEFERRED);");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t\t");
    _builder_6.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t");
    _builder_6.append(" = statemachine::SystemStateEnum_t::IDLE;");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t\t");
    String _upperCase_9 = this.superContext.getName().toUpperCase();
    _builder_6.append(_upperCase_9, "\t\t");
    _builder_6.append("_RELEASE_CONTROL");
    _builder_6.newLineIfNotEmpty();
    _builder_6.append("\t");
    _builder_6.append("}");
    _builder_6.newLine();
    _builder_6.append("\t");
    _builder_6.append("usleep(100);");
    _builder_6.newLine();
    _builder_6.append("}");
    _builder_6.newLine();
    this.createOpaqueBehavior(this.superContext, eventDispatch, _builder_6.toString());
    this.concurrency.createConcurrencyForTransitions();
    this.superContext.createOwnedAttribute("dispatchThread", this.ptTypes.getPthread());
    this.superContext.createOwnedAttribute("dispatchStruct", this.concurrency.threadStructType);
    this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.RUN_TO_COMPLETION_MUTEX, this.ptTypes.getPthreadMutex());
    this.superContext.createOwnedAttribute(SMCodeGeneratorConstants.RUN_TO_COMPLETION_COND, this.ptTypes.getPthreadCond());
    this.createChangeEvents();
  }

  private void createChangeEvents() {
    new ChangeEventTransformation(this).createChangeEvents();
  }

  public String generateChangeState(final State s) {
    Region _container = s.getContainer();
    boolean _equals = Objects.equals(_container, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
      _builder.append(" = ");
      String _upperCase = s.getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_ID;");
      return _builder.toString();
    }
    int rIndex = s.getContainer().getState().getRegions().indexOf(s.getContainer());
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder_1.append("[");
    String _upperCase_1 = s.getContainer().getState().getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID].");
    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
    _builder_1.append("[");
    _builder_1.append(rIndex);
    _builder_1.append("] = ");
    String _upperCase_2 = s.getName().toUpperCase();
    _builder_1.append(_upperCase_2);
    _builder_1.append("_ID;");
    return _builder_1.toString();
  }

  public String generateExitingSubStates(final State parent, final boolean exitParent) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        _builder_1.append("//exiting concurrent state ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.newLineIfNotEmpty();
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            String _generateForkCall = this.concurrency.generateForkCall(r, false, "0");
            _builder_1.append(_generateForkCall);
            _builder_1.newLineIfNotEmpty();
          }
        }
        {
          EList<Region> _regions_1 = parent.getRegions();
          for(final Region r_1 : _regions_1) {
            String _generateJoinCall = this.concurrency.generateJoinCall(r_1, false);
            _builder_1.append(_generateJoinCall);
            _builder_1.newLineIfNotEmpty();
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          String _regionMethodExitName = this.getRegionMethodExitName(IterableExtensions.<Region>head(parent.getRegions()));
          _builder_1.append(_regionMethodExitName);
          _builder_1.append("();");
          _builder_1.newLineIfNotEmpty();
        } else {
        }
      }
    }
    {
      if (exitParent) {
        {
          boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist(parent.getDoActivity());
          if (_isBehaviorExist) {
            _builder_1.append("//signal to exit the doActivity of ");
            String _name_1 = parent.getName();
            _builder_1.append(_name_1);
            _builder_1.newLineIfNotEmpty();
            _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
            _builder_1.append("(");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID, ");
            _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
            _builder_1.append(", false);");
            _builder_1.newLineIfNotEmpty();
          }
        }
        CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "false");
        _builder_1.append(_generateActivateTimeEvent);
        _builder_1.newLineIfNotEmpty();
        {
          boolean _isBehaviorExist_1 = StateMachineUtils.isBehaviorExist(parent.getExit());
          if (_isBehaviorExist_1) {
            _builder_1.append("//exit action of ");
            String _name_2 = parent.getName();
            _builder_1.append(_name_2);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.EXIT_NAME);
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
          }
        }
        _builder_1.append("\t\t");
      }
    }
    return _builder_1.toString();
  }

  public CharSequence generateActivateTimeEvent(final State s, final String trueOrFalse) {
    StringConcatenation _builder = new StringConcatenation();
    {
      List<TimeEvent> _get = this.states2TimeEvents.get(s);
      boolean _tripleNotEquals = (_get != null);
      if (_tripleNotEquals) {
        {
          List<TimeEvent> _get_1 = this.states2TimeEvents.get(s);
          for(final TimeEvent te : _get_1) {
            _builder.append(SMCodeGeneratorConstants.SET_FLAG);
            _builder.append("(");
            String _TE_INDEX = this.cdefs.TE_INDEX();
            _builder.append(_TE_INDEX);
            _builder.append("(");
            String _eventID = StateMachineUtils.eventID(te);
            _builder.append(_eventID);
            _builder.append("), ");
            _builder.append(SMCppCodeGeneratorConstants.THREAD_FUNC_TIMEEVENT_TYPE);
            _builder.append(", ");
            _builder.append(trueOrFalse);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }

  @Deprecated
  public String generateExitingSubStatesWithTransition(final State parent, final boolean exitParent, final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              final Function1<State, Boolean> _function = (State it) -> {
                return Boolean.valueOf(((!(it instanceof FinalState)) && it.isComposite()));
              };
              Iterable<State> _filter = IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function);
              boolean _hasElements = false;
              for(final State s : _filter) {
                if (!_hasElements) {
                  _hasElements = true;
                } else {
                  _builder_1.appendImmediate(" else ", "");
                }
                _builder_1.append("if (");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                _builder_1.append("[");
                String _upperCase_1 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_1);
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                _builder_1.append("[");
                int _indexOf = parent.getRegions().indexOf(r);
                _builder_1.append(_indexOf);
                _builder_1.append("] == &");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                _builder_1.append("[");
                String _upperCase_2 = s.getName().toUpperCase();
                _builder_1.append(_upperCase_2);
                _builder_1.append("_ID]) {");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                String _generateExitingSubStates = this.generateExitingSubStates(s, true);
                _builder_1.append(_generateExitingSubStates, "\t");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
              }
            }
            _builder_1.append("if (");
            _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_1.append("[");
            String _upperCase_3 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_3);
            _builder_1.append("_ID].");
            _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
            _builder_1.append("[");
            int _indexOf_1 = parent.getRegions().indexOf(r);
            _builder_1.append(_indexOf_1);
            _builder_1.append("] != NULL) {");
            _builder_1.newLineIfNotEmpty();
            {
              final Function1<State, Boolean> _function_1 = (State it) -> {
                return Boolean.valueOf((!(it instanceof FinalState)));
              };
              Iterable<State> _filter_1 = IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function_1);
              boolean _hasElements_1 = false;
              for(final State sub : _filter_1) {
                if (!_hasElements_1) {
                  _hasElements_1 = true;
                } else {
                  _builder_1.appendImmediate(" else ", "\t");
                }
                _builder_1.append("\t");
                _builder_1.append("if (");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                _builder_1.append("[");
                String _upperCase_4 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_4, "\t");
                _builder_1.append("_ID].");
                _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
                _builder_1.append("[");
                int _indexOf_2 = parent.getRegions().indexOf(r);
                _builder_1.append(_indexOf_2, "\t");
                _builder_1.append("] == &");
                _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
                _builder_1.append("[");
                String _upperCase_5 = sub.getName().toUpperCase();
                _builder_1.append(_upperCase_5, "\t");
                _builder_1.append("_ID]) {");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("\t");
                _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "\t\t");
                _builder_1.append("(");
                String _upperCase_6 = sub.getName().toUpperCase();
                _builder_1.append(_upperCase_6, "\t\t");
                _builder_1.append("_ID, ");
                _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
                _builder_1.append(", false);");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("\t");
                _builder_1.append("}");
                _builder_1.newLine();
              }
            }
            _builder_1.append("\t");
            String _upperCase_7 = parent.getName().toUpperCase();
            String _plus = ((SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE + "[") + _upperCase_7);
            String _plus_1 = (_plus + "_ID].");
            String _plus_2 = (_plus_1 + SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
            String _plus_3 = (_plus_2 + "[");
            int _indexOf_3 = parent.getRegions().indexOf(r);
            String _plus_4 = (_plus_3 + Integer.valueOf(_indexOf_3));
            String _plus_5 = (_plus_4 + "]");
            String _fptrCall = this.getFptrCall(_plus_5, true, SMCodeGeneratorConstants.EXIT_NAME);
            _builder_1.append(_fptrCall, "\t");
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
            _builder_1.append("[");
            String _upperCase_8 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_8);
            _builder_1.append("_ID].");
            _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
            _builder_1.append("[");
            int _indexOf_4 = parent.getRegions().indexOf(r);
            _builder_1.append(_indexOf_4);
            _builder_1.append("] = NULL;");
            _builder_1.newLineIfNotEmpty();
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            final Function1<State, Boolean> _function_2 = (State it) -> {
              return Boolean.valueOf(((!(it instanceof FinalState)) && it.isComposite()));
            };
            Iterable<State> _filter_2 = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_2);
            boolean _hasElements_2 = false;
            for(final State s_1 : _filter_2) {
              if (!_hasElements_2) {
                _hasElements_2 = true;
              } else {
                _builder_1.appendImmediate(" else ", "");
              }
              _builder_1.append("if (");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[");
              String _upperCase_9 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_9);
              _builder_1.append("_ID].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_1.append("[0] == &");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[");
              String _upperCase_10 = s_1.getName().toUpperCase();
              _builder_1.append(_upperCase_10);
              _builder_1.append("_ID]) {");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              String _generateExitingSubStates_1 = this.generateExitingSubStates(s_1, true);
              _builder_1.append(_generateExitingSubStates_1, "\t");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("}");
              _builder_1.newLine();
            }
          }
          _builder_1.append("if (");
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[");
          String _upperCase_11 = parent.getName().toUpperCase();
          _builder_1.append(_upperCase_11);
          _builder_1.append("_ID].");
          _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_1.append("[0] != NULL) {");
          _builder_1.newLineIfNotEmpty();
          {
            final Function1<State, Boolean> _function_3 = (State it) -> {
              return Boolean.valueOf((!(it instanceof FinalState)));
            };
            Iterable<State> _filter_3 = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_3);
            boolean _hasElements_3 = false;
            for(final State sub_1 : _filter_3) {
              if (!_hasElements_3) {
                _hasElements_3 = true;
              } else {
                _builder_1.appendImmediate(" else ", "\t");
              }
              _builder_1.append("\t");
              _builder_1.append("if (");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
              _builder_1.append("[");
              String _upperCase_12 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_12, "\t");
              _builder_1.append("_ID].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
              _builder_1.append("[0] == &");
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
              _builder_1.append("[");
              String _upperCase_13 = sub_1.getName().toUpperCase();
              _builder_1.append(_upperCase_13, "\t");
              _builder_1.append("_ID]) {");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("\t");
              _builder_1.append(SMCodeGeneratorConstants.SET_FLAG, "\t\t");
              _builder_1.append("(");
              String _upperCase_14 = sub_1.getName().toUpperCase();
              _builder_1.append(_upperCase_14, "\t\t");
              _builder_1.append("_ID, ");
              _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t\t");
              _builder_1.append(", false);");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("}");
              _builder_1.newLine();
            }
          }
          _builder_1.append("\t");
          String _upperCase_15 = parent.getName().toUpperCase();
          String _plus_6 = ((SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE + "[") + _upperCase_15);
          String _plus_7 = (_plus_6 + "_ID].");
          String _plus_8 = (_plus_7 + SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          String _plus_9 = (_plus_8 + "[0]");
          String _fptrCall_1 = this.getFptrCall(_plus_9, true, SMCodeGeneratorConstants.EXIT_NAME);
          _builder_1.append(_fptrCall_1, "\t");
          _builder_1.append(";");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[");
          String _upperCase_16 = parent.getName().toUpperCase();
          _builder_1.append(_upperCase_16);
          _builder_1.append("_ID].");
          _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_1.append("[0] = NULL;");
          _builder_1.newLineIfNotEmpty();
        } else {
        }
      }
    }
    {
      if (exitParent) {
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(");
        String _upperCase_17 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_17);
        _builder_1.append("_ID, ");
        _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", false);");
        _builder_1.newLineIfNotEmpty();
        String _fptrCall_2 = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.EXIT_NAME);
        _builder_1.append(_fptrCall_2);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
      }
    }
    String _transitionEffect = StateMachineUtils.getTransitionEffect(t);
    _builder_1.append(_transitionEffect);
    return _builder_1.toString();
  }

  @Deprecated
  public String generateEnteringSubStates(final State parent, final boolean enterParent) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      if (enterParent) {
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID, ");
        _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
      }
    }
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              State _findInitialState = StateMachineUtils.findInitialState(r);
              boolean _tripleNotEquals = (_findInitialState != null);
              if (_tripleNotEquals) {
                String _initialEffect = StateMachineUtils.getInitialEffect(r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(StateMachineUtils.findInitialState(r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _findInitialState_1 = StateMachineUtils.findInitialState(IterableExtensions.<Region>head(parent.getRegions()));
            boolean _tripleNotEquals_1 = (_findInitialState_1 != null);
            if (_tripleNotEquals_1) {
              String _initialEffect_1 = StateMachineUtils.getInitialEffect(IterableExtensions.<Region>head(parent.getRegions()));
              _builder_1.append(_initialEffect_1);
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState(IterableExtensions.<Region>head(parent.getRegions())), true);
              _builder_1.append(_generateEnteringSubStates_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }

  @Deprecated
  public String generateEnteringSubStates(final State parent, final State child, final boolean enterParent, final boolean gotoSubstate) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      if (enterParent) {
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID, ");
        _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
      }
    }
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equals(_container, r);
              if (_equals) {
                {
                  if (gotoSubstate) {
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              } else {
                State _findInitialState = StateMachineUtils.findInitialState(r);
                boolean _tripleNotEquals = (_findInitialState != null);
                if (_tripleNotEquals) {
                  String _initialEffect = StateMachineUtils.getInitialEffect(r);
                  _builder_1.append(_initialEffect);
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState(r), true);
                  _builder_1.append(_generateEnteringSubStates_1);
                  _builder_1.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          _builder_1.append("//");
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[");
          String _upperCase_2 = parent.getName().toUpperCase();
          _builder_1.append(_upperCase_2);
          _builder_1.append("_ID].");
          _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_1.append("[0] = &");
          _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_1.append("[");
          String _upperCase_3 = child.getName().toUpperCase();
          _builder_1.append(_upperCase_3);
          _builder_1.append("_ID];");
          _builder_1.newLineIfNotEmpty();
          String _generateEnteringSubStates_2 = this.generateEnteringSubStates(child, true);
          _builder_1.append(_generateEnteringSubStates_2);
          _builder_1.newLineIfNotEmpty();
        } else {
        }
      }
    }
    return _builder_1.toString();
  }

  @Deprecated
  public String generateEnteringTransitiveSubStates(final State parent, final State child) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder_1.append(_generateChangeState);
    _builder_1.newLineIfNotEmpty();
    String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
    _builder_1.append(_fptrCall);
    _builder_1.append(";");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("//start activity of ");
    String _name = parent.getName();
    _builder_1.append(_name);
    _builder_1.append(" by calling setFlag");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
    _builder_1.append("(");
    String _upperCase_1 = parent.getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID, ");
    _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
    _builder_1.append(", true);");
    _builder_1.newLineIfNotEmpty();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equals(_container, r);
              if (_equals) {
                String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
              } else {
                boolean _contains = StateMachineUtils.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = (State it) -> {
                    return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                  _builder_1.append(_generateEnteringTransitiveSubStates);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = StateMachineUtils.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = StateMachineUtils.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equals(_state, parent);
            if (_equals_1) {
              String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, false, false);
              _builder_1.append(_generateEnteringSubStates_2);
              _builder_1.newLineIfNotEmpty();
            } else {
              final Function1<State, Boolean> _function_1 = (State it) -> {
                return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
              _builder_1.append(_generateEnteringTransitiveSubStates_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }

  @Deprecated
  public String generateEnteringTransitiveSubStates(final State parent, final State child, final boolean enterParent, final boolean gotoChild) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      if (enterParent) {
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("//start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder_1.append("(");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID, ");
        _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
      }
    }
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equals(_container, r);
              if (_equals) {
                {
                  if (gotoChild) {
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              } else {
                boolean _contains = StateMachineUtils.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = (State it) -> {
                    return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                  _builder_1.append(_generateEnteringTransitiveSubStates);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = StateMachineUtils.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = StateMachineUtils.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates_1 = this.generateEnteringSubStates(StateMachineUtils.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equals(_state, parent);
            if (_equals_1) {
              {
                if (gotoChild) {
                  String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, enterParent, false);
                  _builder_1.append(_generateEnteringSubStates_2);
                  _builder_1.newLineIfNotEmpty();
                }
              }
            } else {
              final Function1<State, Boolean> _function_1 = (State it) -> {
                return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
              _builder_1.append(_generateEnteringTransitiveSubStates_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }

  @Deprecated
  public String generateEnteringSpecial(final State parent, final Pseudostate child) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder_1.append(_generateChangeState);
    _builder_1.newLineIfNotEmpty();
    String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
    _builder_1.append(_fptrCall);
    _builder_1.append(";");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("//start activity of ");
    String _name = parent.getName();
    _builder_1.append(_name);
    _builder_1.append(" by calling setFlag");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
    _builder_1.append("(");
    String _upperCase_1 = parent.getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID, ");
    _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
    _builder_1.append(", true);");
    _builder_1.newLineIfNotEmpty();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equals(_container, r);
              if (_equals) {
                String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                _builder_1.append(_generatePseudo);
                _builder_1.newLineIfNotEmpty();
              } else {
                boolean _contains = StateMachineUtils.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = (State it) -> {
                    return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                  _builder_1.append("[");
                  String _upperCase_2 = parent.getName().toUpperCase();
                  _builder_1.append(_upperCase_2);
                  _builder_1.append("_ID].");
                  _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                  _builder_1.append("[");
                  int _indexOf = parent.getRegions().indexOf(r);
                  _builder_1.append(_indexOf);
                  _builder_1.append("] = ");
                  String _upperCase_3 = nextParent.getName().toUpperCase();
                  _builder_1.append(_upperCase_3);
                  _builder_1.append("_ID;");
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                  _builder_1.append(_generateEnteringSpecial);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = StateMachineUtils.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = StateMachineUtils.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                    _builder_1.append("[");
                    String _upperCase_4 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_4);
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                    _builder_1.append("[");
                    int _indexOf_1 = parent.getRegions().indexOf(r);
                    _builder_1.append(_indexOf_1);
                    _builder_1.append("] = ");
                    String _upperCase_5 = StateMachineUtils.findInitialState(r).getName().toUpperCase();
                    _builder_1.append(_upperCase_5);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates = this.generateEnteringSubStates(StateMachineUtils.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equals(_state, parent);
            if (_equals_1) {
              String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
              _builder_1.append(_generatePseudo_1);
              _builder_1.newLineIfNotEmpty();
            } else {
              final Function1<State, Boolean> _function_1 = (State it) -> {
                return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[");
              String _upperCase_6 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_6);
              _builder_1.append("_ID].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_1.append("[0] = ");
              String _upperCase_7 = nextParent_1.getName().toUpperCase();
              _builder_1.append(_upperCase_7);
              _builder_1.append("_ID;");
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
              _builder_1.append(_generateEnteringSpecial_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }

  @Deprecated
  public String generateEnteringSpecial(final State parent, final Pseudostate child, final Transition t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase = parent.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ID]");
    String pAttr = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder_1.append(_generateChangeState);
    _builder_1.newLineIfNotEmpty();
    String _transitionEffect = StateMachineUtils.getTransitionEffect(t);
    _builder_1.append(_transitionEffect);
    _builder_1.newLineIfNotEmpty();
    String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
    _builder_1.append(_fptrCall);
    _builder_1.append(";");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append("//start activity of ");
    String _name = parent.getName();
    _builder_1.append(_name);
    _builder_1.append(" by calling setFlag");
    _builder_1.newLineIfNotEmpty();
    _builder_1.append(SMCodeGeneratorConstants.SET_FLAG);
    _builder_1.append("(");
    String _upperCase_1 = parent.getName().toUpperCase();
    _builder_1.append(_upperCase_1);
    _builder_1.append("_ID, ");
    _builder_1.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
    _builder_1.append(", true);");
    _builder_1.newLineIfNotEmpty();
    _builder_1.newLine();
    {
      boolean _isOrthogonal = parent.isOrthogonal();
      if (_isOrthogonal) {
        {
          EList<Region> _regions = parent.getRegions();
          for(final Region r : _regions) {
            {
              Region _container = child.getContainer();
              boolean _equals = Objects.equals(_container, r);
              if (_equals) {
                String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                _builder_1.append(_generatePseudo);
                _builder_1.newLineIfNotEmpty();
              } else {
                boolean _contains = StateMachineUtils.transitiveSubStates(r).contains(child);
                if (_contains) {
                  final Function1<State, Boolean> _function = (State it) -> {
                    return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
                  };
                  State nextParent = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function));
                  _builder_1.newLineIfNotEmpty();
                  _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                  _builder_1.append("[");
                  String _upperCase_2 = parent.getName().toUpperCase();
                  _builder_1.append(_upperCase_2);
                  _builder_1.append("_ID].");
                  _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                  _builder_1.append("[");
                  int _indexOf = parent.getRegions().indexOf(r);
                  _builder_1.append(_indexOf);
                  _builder_1.append("] = ");
                  String _upperCase_3 = nextParent.getName().toUpperCase();
                  _builder_1.append(_upperCase_3);
                  _builder_1.append("_ID;");
                  _builder_1.newLineIfNotEmpty();
                  String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                  _builder_1.append(_generateEnteringSpecial);
                  _builder_1.newLineIfNotEmpty();
                } else {
                  State _findInitialState = StateMachineUtils.findInitialState(r);
                  boolean _tripleNotEquals = (_findInitialState != null);
                  if (_tripleNotEquals) {
                    String _initialEffect = StateMachineUtils.getInitialEffect(r);
                    _builder_1.append(_initialEffect);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                    _builder_1.append("[");
                    String _upperCase_4 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_4);
                    _builder_1.append("_ID].");
                    _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
                    _builder_1.append("[");
                    int _indexOf_1 = parent.getRegions().indexOf(r);
                    _builder_1.append(_indexOf_1);
                    _builder_1.append("] = ");
                    String _upperCase_5 = StateMachineUtils.findInitialState(r).getName().toUpperCase();
                    _builder_1.append(_upperCase_5);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates = this.generateEnteringSubStates(StateMachineUtils.findInitialState(r), true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      } else {
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
          {
            State _state = child.getContainer().getState();
            boolean _equals_1 = Objects.equals(_state, parent);
            if (_equals_1) {
              String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
              _builder_1.append(_generatePseudo_1);
              _builder_1.newLineIfNotEmpty();
            } else {
              final Function1<State, Boolean> _function_1 = (State it) -> {
                return Boolean.valueOf(StateMachineUtils.transitiveSubStates(it).contains(child));
              };
              State nextParent_1 = IterableExtensions.<State>head(IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(parent.getRegions()).getSubvertices(), State.class), _function_1));
              _builder_1.newLineIfNotEmpty();
              _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
              _builder_1.append("[");
              String _upperCase_6 = parent.getName().toUpperCase();
              _builder_1.append(_upperCase_6);
              _builder_1.append("_ID].");
              _builder_1.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
              _builder_1.append("[0] = ");
              String _upperCase_7 = nextParent_1.getName().toUpperCase();
              _builder_1.append(_upperCase_7);
              _builder_1.append("_ID;");
              _builder_1.newLineIfNotEmpty();
              String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
              _builder_1.append(_generateEnteringSpecial_1);
              _builder_1.newLineIfNotEmpty();
            }
          }
        } else {
        }
      }
    }
    return _builder_1.toString();
  }

  public String generateCompletionCall(final State state) {
    StringConcatenation _builder = new StringConcatenation();
    String callCompletionEvent = _builder.toString();
    State composite = state.getContainer().getState();
    if ((composite == null)) {
      StringConcatenation _builder_1 = new StringConcatenation();
      callCompletionEvent = _builder_1.toString();
    } else {
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append("if (");
      {
        EList<Region> _regions = composite.getRegions();
        boolean _hasElements = false;
        for(final Region r : _regions) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder_2.appendImmediate(" && ", "");
          }
          _builder_2.append("(");
          _builder_2.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
          _builder_2.append("[");
          String _upperCase = composite.getName().toUpperCase();
          _builder_2.append(_upperCase);
          _builder_2.append("_ID].");
          _builder_2.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
          _builder_2.append("[");
          int _indexOf = composite.getRegions().indexOf(r);
          _builder_2.append(_indexOf);
          _builder_2.append("] == ");
          _builder_2.append(SMCodeGeneratorConstants.STATE_MAX);
          _builder_2.append(")");
        }
      }
      _builder_2.append(") {");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      _builder_2.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t");
      _builder_2.append(".push(statemachine::EventPriority_t::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::EventType_t::COMPLETION_EVENT, ");
      String _upperCase_1 = composite.getName().toUpperCase();
      _builder_2.append(_upperCase_1, "\t");
      _builder_2.append("_ID);");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("}");
      callCompletionEvent = _builder_2.toString();
    }
    return callCompletionEvent;
  }

  public TransitionGraph calculateTransitionGraphs(final State s, final Transition t) {
    TransitionGraph ret = new TransitionGraph();
    Vertex _target = t.getTarget();
    ret.P.add(((Pseudostate) _target));
    ret.T.add(t);
    ret.S.add(s);
    Vertex _target_1 = t.getTarget();
    Pseudostate target = ((Pseudostate) _target_1);
    PseudostateKind _kind = target.getKind();
    boolean _equals = Objects.equals(_kind, PseudostateKind.JOIN_LITERAL);
    if (_equals) {
      final Function1<Transition, Boolean> _function = (Transition it) -> {
        State _state = it.getSource().getContainer().getState();
        State _state_1 = s.getContainer().getState();
        return Boolean.valueOf(Objects.equals(_state, _state_1));
      };
      List<Transition> ins = IterableExtensions.<Transition>toList(IterableExtensions.<Transition>filter(target.getIncomings(), _function));
      final Function1<Transition, Vertex> _function_1 = (Transition it) -> {
        return it.getSource();
      };
      Iterables.<State>addAll(ret.S, Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(ins, _function_1), State.class));
      ret.T.addAll(ins);
    }
    List<Transition> nexts = SMCommon.findTrans(t.getTarget());
    ret.T.addAll(nexts);
    final Function1<Transition, Vertex> _function_2 = (Transition it) -> {
      return t.getTarget();
    };
    final Function1<Pseudostate, Boolean> _function_3 = (Pseudostate it) -> {
      return Boolean.valueOf((Objects.equals(it.getKind(), PseudostateKind.DEEP_HISTORY_LITERAL) || Objects.equals(it.getKind(), PseudostateKind.SHALLOW_HISTORY_LITERAL)));
    };
    Iterable<Pseudostate> H = IterableExtensions.<Pseudostate>filter(Iterables.<Pseudostate>filter(ListExtensions.<Transition, Vertex>map(nexts, _function_2), Pseudostate.class), _function_3);
    Iterables.<Pseudostate>addAll(ret.P, H);
    final Function1<Transition, Vertex> _function_4 = (Transition it) -> {
      return it.getSource();
    };
    Iterables.<Pseudostate>addAll(ret.P, Iterables.<Pseudostate>filter(ListExtensions.<Transition, Vertex>map(nexts, _function_4), Pseudostate.class));
    final Function1<Transition, Vertex> _function_5 = (Transition it) -> {
      return it.getTarget();
    };
    Iterables.<State>addAll(ret.L, Iterables.<State>filter(ListExtensions.<Transition, Vertex>map(nexts, _function_5), State.class));
    return ret;
  }

  public String generateDelegation(final State s, final List<Transition> transitions) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _checkTransitiveSubStatesAcceptEvent = this.checkTransitiveSubStatesAcceptEvent(s, transitions);
      if (_checkTransitiveSubStatesAcceptEvent) {
        {
          boolean _isOrthogonal = s.isOrthogonal();
          if (_isOrthogonal) {
          } else {
            _builder.append("\t");
            _builder.newLine();
          }
        }
        _builder.append("\t\t");
      }
    }
    return _builder.toString();
  }

  public boolean checkSubStatesAcceptEvent(final State parent, final List<Transition> transitions) {
    final ArrayList<State> substates = new ArrayList<State>();
    final Consumer<Region> _function = (Region it) -> {
      Iterables.<State>addAll(substates, Iterables.<State>filter(it.getSubvertices(), State.class));
    };
    parent.getRegions().forEach(_function);
    boolean ret = false;
    for (final Transition t : transitions) {
      if (((!ret) && substates.contains(t.getSource()))) {
        ret = true;
      }
    }
    return ret;
  }

  public boolean checkTransitiveSubStatesAcceptEvent(final State parent, final List<Transition> transitions) {
    final List<State> substates = StateMachineUtils.transitiveSubStates(parent);
    boolean ret = false;
    for (final Transition t : transitions) {
      if (((!ret) && substates.contains(t.getSource()))) {
        ret = true;
      }
    }
    return ret;
  }

  public Dependency createStateStruct() {
    Dependency _xblockexpression = null;
    {
      this.superContext.createOwnedOperation("entry_dft", null, null);
      this.superContext.createOwnedOperation("exit_dft", null, null);
      this.superContext.createOwnedOperation("doActivity_dft", null, null);
      this.stateStruct = this.superContext.createNestedClassifier(SMCodeGeneratorConstants.STATE_STRUCT_NAME, UMLPackage.Literals.PRIMITIVE_TYPE);
      StereotypeUtil.apply(this.stateStruct, Typedef.class);
      Typedef _stereotypeApplication = UMLUtil.<Typedef>getStereotypeApplication(this.stateStruct, Typedef.class);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("struct ");
      _builder.append(SMCodeGeneratorConstants.STATE_STRUCT_NAME);
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("//");
      _builder.append(this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
      _builder.append(" is configured as the maximum number of orthogonal regions a composite states can have");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("unsigned int /*");
      _builder.append(SMCodeGeneratorConstants.STATE_ID_ENUM, "\t");
      _builder.append("*/ ");
      _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t");
      _builder.append("[");
      _builder.append(this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
      _builder.append("]; //for history states");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("unsigned int /*");
      _builder.append(SMCodeGeneratorConstants.STATE_ID_ENUM, "\t");
      _builder.append("*/ ");
      _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
      _builder.append("[");
      _builder.append(this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t");
      _builder.append("];");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("void (");
      String _name = this.superContext.getName();
      _builder.append(_name, "\t");
      _builder.append("::*entry)();");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("void (");
      String _name_1 = this.superContext.getName();
      _builder.append(_name_1, "\t");
      _builder.append("::*exit)();");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("void (");
      String _name_2 = this.superContext.getName();
      _builder.append(_name_2, "\t");
      _builder.append("::*doActivity)();");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append(SMCodeGeneratorConstants.STATE_STRUCT_NAME, "\t");
      _builder.append("() {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("entry = &");
      String _name_3 = this.superContext.getName();
      _builder.append(_name_3, "\t\t");
      _builder.append("::entry_dft;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("exit = &");
      String _name_4 = this.superContext.getName();
      _builder.append(_name_4, "\t\t");
      _builder.append("::exit_dft;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("doActivity = &");
      String _name_5 = this.superContext.getName();
      _builder.append(_name_5, "\t\t");
      _builder.append("::doActivity_dft;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("for(int i = 0; i < ");
      _builder.append(this.MAX_NUMBER_ORTHOGONAL_REGIONS, "\t\t");
      _builder.append("; i++) {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t\t\t");
      _builder.append("[i] = ");
      _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t\t\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t\t\t");
      _builder.append("[i] = ");
      _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t\t\t");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("} ");
      _stereotypeApplication.setDefinition(_builder.toString());
      _xblockexpression = this.stateStruct.createDependency(this.stateIdEnum);
    }
    return _xblockexpression;
  }

  public String getFptrCall(final String attr, final boolean isPointer, final String fptrName) {
    if (isPointer) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("(this->*");
      _builder.append(attr);
      _builder.append("->");
      _builder.append(fptrName);
      _builder.append(")()");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("(this->*");
    _builder_1.append(attr);
    _builder_1.append(".");
    _builder_1.append(fptrName);
    _builder_1.append(")()");
    return _builder_1.toString();
  }

  private Map<Event, List<Transition>> getAllEvents(final Region region) {
    final Map<Event, List<Transition>> ret = new LinkedHashMap<Event, List<Transition>>();
    EList<Vertex> subVertices = region.getSubvertices();
    EList<Transition> transitions = region.getTransitions();
    final Consumer<Transition> _function = (Transition it) -> {
      EList<Trigger> _triggers = it.getTriggers();
      for (final Trigger trigger : _triggers) {
        Event _event = trigger.getEvent();
        boolean _tripleNotEquals = (_event != null);
        if (_tripleNotEquals) {
          boolean _containsKey = ret.containsKey(trigger.getEvent());
          boolean _not = (!_containsKey);
          if (_not) {
            Event _event_1 = trigger.getEvent();
            ArrayList<Transition> _arrayList = new ArrayList<Transition>();
            ret.put(_event_1, _arrayList);
          }
          boolean _contains = ret.get(trigger.getEvent()).contains(it);
          boolean _not_1 = (!_contains);
          if (_not_1) {
            ret.get(trigger.getEvent()).add(it);
          }
        }
      }
    };
    transitions.forEach(_function);
    final Consumer<State> _function_1 = (State it) -> {
      EList<Region> _regions = it.getRegions();
      for (final Region subRe : _regions) {
        {
          Map<Event, List<Transition>> m = this.getAllEvents(subRe);
          Set<Map.Entry<Event, List<Transition>>> _entrySet = m.entrySet();
          for (final Map.Entry<Event, List<Transition>> e : _entrySet) {
            boolean _containsKey = ret.containsKey(e.getKey());
            boolean _not = (!_containsKey);
            if (_not) {
              ret.put(e.getKey(), e.getValue());
            } else {
              ret.get(e.getKey()).addAll(e.getValue());
            }
          }
        }
      }
    };
    Iterables.<State>filter(subVertices, State.class).forEach(_function_1);
    return ret;
  }

  private void getAllActionsTransitionsStates(final Region region) {
    boolean _contains = this.regions.contains(region);
    boolean _not = (!_contains);
    if (_not) {
      this.regions.add(region);
    }
    final Function1<Transition, Boolean> _function = (Transition it) -> {
      return Boolean.valueOf(((it.getSource() != null) && (it.getTarget() != null)));
    };
    Iterables.<Transition>addAll(this.transitions, IterableExtensions.<Transition>filter(region.getTransitions(), _function));
    final Function1<Transition, Boolean> _function_1 = (Transition it) -> {
      boolean _contains_1 = this.parallelTransitions.contains(it);
      return Boolean.valueOf((!_contains_1));
    };
    final Consumer<Transition> _function_2 = (Transition it) -> {
      Vertex _source = it.getSource();
      if ((_source instanceof Pseudostate)) {
        if ((Objects.equals(((Pseudostate) it.getSource()).getKind(), PseudostateKind.FORK_LITERAL) && (it.getEffect() != null))) {
          this.parallelTransitions.add(it);
        }
      }
      Vertex _target = it.getTarget();
      if ((_target instanceof Pseudostate)) {
        if ((Objects.equals(((Pseudostate) it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL) && (it.getEffect() != null))) {
          this.parallelTransitions.add(it);
        }
      }
    };
    IterableExtensions.<Transition>filter(this.transitions, _function_1).forEach(_function_2);
    EList<Vertex> _subvertices = region.getSubvertices();
    for (final Vertex s : _subvertices) {
      {
        this.vertexes.add(s);
        if ((s instanceof State)) {
          if ((!(s instanceof FinalState))) {
            this.states.add(((State)s));
          }
          if (((((State)s).getEntry() != null) && (((State)s).getEntry() instanceof OpaqueBehavior))) {
            Behavior _entry = ((State)s).getEntry();
            this.actions.add(((OpaqueBehavior) _entry));
          }
          if (((((State)s).getExit() != null) && (((State)s).getExit() instanceof OpaqueBehavior))) {
            Behavior _exit = ((State)s).getExit();
            this.actions.add(((OpaqueBehavior) _exit));
          }
          if (((this.createDoActivity && (((State)s).getDoActivity() != null)) && (((State)s).getDoActivity() instanceof OpaqueBehavior))) {
            Behavior _doActivity = ((State)s).getDoActivity();
            this.actions.add(((OpaqueBehavior) _doActivity));
          }
          final Consumer<Region> _function_3 = (Region it) -> {
            this.getAllActionsTransitionsStates(it);
          };
          ((State)s).getRegions().forEach(_function_3);
        }
      }
    }
  }

  public List<Region> orthogonalRegions = new ArrayList<Region>();

  private void createRegionMethods() {
    String macros = "";
    for (int i = 0; (i < this.regions.size()); i++) {
      {
        String _macros = macros;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#define ");
        String _regionMacroName = this.getRegionMacroName(this.regions.get(i));
        _builder.append(_regionMacroName);
        _builder.append(" (");
        _builder.append(i);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        macros = (_macros + _builder);
        this.createRegionMethod(this.regions.get(i));
        this.createRegionMethodExit(this.regions.get(i));
        if (((this.regions.get(i).getState() != null) && this.regions.get(i).getState().isOrthogonal())) {
          this.orthogonalRegions.add(this.regions.get(i));
        }
      }
    }
    for (int i = 0; (i < this.orthogonalRegions.size()); i++) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("#define ");
      String _regionMacroId = this.getRegionMacroId(this.orthogonalRegions.get(i));
      _builder.append(_regionMacroId);
      _builder.append(" (");
      _builder.append(i);
      _builder.append(")");
      IncludeUtils.appendIncludeHeader(this.superContext, _builder.toString());
    }
    boolean _isApplied = StereotypeUtil.isApplied(this.superContext, Include.class);
    boolean _not = (!_isApplied);
    if (_not) {
      StereotypeUtil.apply(this.superContext, Include.class);
    }
    String header = UMLUtil.<Include>getStereotypeApplication(this.superContext, Include.class).getHeader();
    Include _stereotypeApplication = UMLUtil.<Include>getStereotypeApplication(this.superContext, Include.class);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(header);
    _builder.newLineIfNotEmpty();
    _builder.append(macros);
    _stereotypeApplication.setHeader(_builder.toString());
  }

  public String getRegionMacroId(final Region r) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("REGION_ID_");
    String _upperCase = r.getState().getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_");
    String _upperCase_1 = r.getName().toUpperCase();
    _builder.append(_upperCase_1);
    return _builder.toString();
  }

  public String getRegionMethodName(final Region r) {
    boolean _equals = Objects.equals(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _name = r.getStateMachine().getName();
      _builder.append(_name);
      _builder.append("_");
      String _name_1 = r.getName();
      _builder.append(_name_1);
      _builder.append("_Enter");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _name_2 = r.getState().getName();
    _builder_1.append(_name_2);
    _builder_1.append("_");
    String _name_3 = r.getName();
    _builder_1.append(_name_3);
    _builder_1.append("_Enter");
    return _builder_1.toString();
  }

  public String getRegionMacroName(final Region r) {
    boolean _equals = Objects.equals(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _upperCase = r.getStateMachine().getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_");
      String _upperCase_1 = r.getName().toUpperCase();
      _builder.append(_upperCase_1);
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _upperCase_2 = r.getState().getName().toUpperCase();
    _builder_1.append(_upperCase_2);
    _builder_1.append("_");
    String _upperCase_3 = r.getName().toUpperCase();
    _builder_1.append(_upperCase_3);
    return _builder_1.toString();
  }

  public String getVertexMacroName(final Vertex v) {
    Region _container = v.getContainer();
    boolean _equals = Objects.equals(_container, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _upperCase = this.topRegion.getStateMachine().getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_");
      String _upperCase_1 = v.getContainer().getName().toUpperCase();
      _builder.append(_upperCase_1);
      _builder.append("_");
      String _upperCase_2 = v.getName().toUpperCase();
      _builder.append(_upperCase_2);
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _upperCase_3 = v.getContainer().getState().getName().toUpperCase();
    _builder_1.append(_upperCase_3);
    _builder_1.append("_");
    String _upperCase_4 = v.getContainer().getName().toUpperCase();
    _builder_1.append(_upperCase_4);
    _builder_1.append("_");
    String _upperCase_5 = v.getName().toUpperCase();
    _builder_1.append(_upperCase_5);
    return _builder_1.toString();
  }

  public String getInitialMacroName(final Region r) {
    boolean _equals = Objects.equals(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _upperCase = r.getStateMachine().getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_");
      String _upperCase_1 = r.getName().toUpperCase();
      _builder.append(_upperCase_1);
      _builder.append("_DEFAULT");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _upperCase_2 = r.getState().getName().toUpperCase();
    _builder_1.append(_upperCase_2);
    _builder_1.append("_");
    String _upperCase_3 = r.getName().toUpperCase();
    _builder_1.append(_upperCase_3);
    _builder_1.append("_DEFAULT");
    return _builder_1.toString();
  }

  private ArrayList<Vertex> getSubVertexes(final State state) {
    final ArrayList<Vertex> ret = new ArrayList<Vertex>();
    final Consumer<Region> _function = (Region it) -> {
      ret.addAll(it.getSubvertices());
    };
    state.getRegions().forEach(_function);
    return ret;
  }

  private void createRegionMethod(final Region r) {
    ArrayList<Vertex> endVertices = new ArrayList<Vertex>();
    EList<Vertex> _subvertices = r.getSubvertices();
    for (final Vertex v : _subvertices) {
      {
        final Function1<Transition, Boolean> _function = (Transition it) -> {
          return Boolean.valueOf(((!Objects.equals(it.getSource().getContainer(), v.getContainer())) || ((it.getSource() instanceof State) && this.getSubVertexes(((State) it.getSource())).contains(it.getTarget()))));
        };
        final Iterable<Transition> incomings = IterableExtensions.<Transition>filter(v.getIncomings(), _function);
        final Function1<Transition, Vertex> _function_1 = (Transition it) -> {
          return it.getSource();
        };
        final Iterable<Vertex> sources = IterableExtensions.<Transition, Vertex>map(incomings, _function_1);
        int _size = IterableExtensions.size(sources);
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          boolean _contains = endVertices.contains(v);
          boolean _not = (!_contains);
          if (_not) {
            endVertices.add(v);
          }
        }
      }
    }
    String body = "";
    String macros = "";
    Pseudostate _firstPseudoState = StateMachineUtils.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
    boolean _tripleNotEquals = (_firstPseudoState != null);
    if (_tripleNotEquals) {
      Pseudostate initialP = StateMachineUtils.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
      Vertex _target = IterableExtensions.<Transition>head(initialP.getOutgoings()).getTarget();
      State initialState = ((State) _target);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
      _builder.append("[");
      String _upperCase = initialState.getName().toUpperCase();
      _builder.append(_upperCase);
      _builder.append("_ID]");
      String pAttr = _builder.toString();
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append(macros);
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("#define ");
      String _initialMacroName = this.getInitialMacroName(r);
      _builder_1.append(_initialMacroName);
      _builder_1.append(" (0)");
      macros = _builder_1.toString();
      StringConcatenation _builder_2 = new StringConcatenation();
      _builder_2.append(body);
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("case ");
      String _initialMacroName_1 = this.getInitialMacroName(r);
      _builder_2.append(_initialMacroName_1);
      _builder_2.append(":");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      String _transitionEffect = StateMachineUtils.getTransitionEffect(IterableExtensions.<Transition>head(initialP.getOutgoings()));
      _builder_2.append(_transitionEffect, "\t");
      _builder_2.newLineIfNotEmpty();
      _builder_2.append("\t");
      String _generateChangeState = this.generateChangeState(initialState);
      _builder_2.append(_generateChangeState, "\t");
      _builder_2.newLineIfNotEmpty();
      _builder_2.newLine();
      {
        boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist(initialState.getEntry());
        if (_isBehaviorExist) {
          _builder_2.append("\t");
          String _fptrCall = this.getFptrCall(pAttr, false, SMCodeGeneratorConstants.ENTRY_NAME);
          _builder_2.append(_fptrCall, "\t");
          _builder_2.append(";");
          _builder_2.newLineIfNotEmpty();
          _builder_2.append("\t");
          _builder_2.append("//starting the counters for time events");
          _builder_2.newLine();
        }
      }
      _builder_2.append("\t");
      CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(initialState, "true");
      _builder_2.append(_generateActivateTimeEvent, "\t");
      _builder_2.newLineIfNotEmpty();
      _builder_2.newLine();
      {
        if ((StateMachineUtils.isBehaviorExist(initialState.getDoActivity()) || StateMachineUtils.hasTriggerlessTransition(initialState))) {
          _builder_2.append("\t");
          _builder_2.append("//start activity of ");
          String _name = initialState.getName();
          _builder_2.append(_name, "\t");
          _builder_2.append(" by calling setFlag");
          _builder_2.newLineIfNotEmpty();
          _builder_2.append("\t");
          _builder_2.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
          _builder_2.append("(");
          String _upperCase_1 = initialState.getName().toUpperCase();
          _builder_2.append(_upperCase_1, "\t");
          _builder_2.append("_ID, ");
          _builder_2.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
          _builder_2.append(", true);");
          _builder_2.newLineIfNotEmpty();
        }
      }
      {
        boolean _isComposite = initialState.isComposite();
        if (_isComposite) {
          {
            boolean _isOrthogonal = initialState.isOrthogonal();
            if (_isOrthogonal) {
              _builder_2.append("\t");
              _builder_2.append("//TODO: fork region funtions");
              _builder_2.newLine();
              {
                EList<Region> _regions = initialState.getRegions();
                for(final Region subRegion : _regions) {
                  _builder_2.append("\t");
                  _builder_2.append("//");
                  String _regionMethodName = this.getRegionMethodName(subRegion);
                  _builder_2.append(_regionMethodName, "\t");
                  _builder_2.append("(");
                  String _initialMacroName_2 = this.getInitialMacroName(subRegion);
                  _builder_2.append(_initialMacroName_2, "\t");
                  _builder_2.append(");");
                  _builder_2.newLineIfNotEmpty();
                  _builder_2.append("\t");
                  String _generateForkCall = this.concurrency.generateForkCall(subRegion, true, this.getInitialMacroName(subRegion));
                  _builder_2.append(_generateForkCall, "\t");
                  _builder_2.newLineIfNotEmpty();
                }
              }
              _builder_2.append("\t");
              _builder_2.append("//TODO: join region functions");
              _builder_2.newLine();
              {
                EList<Region> _regions_1 = initialState.getRegions();
                for(final Region subRegion_1 : _regions_1) {
                  _builder_2.append("\t");
                  _builder_2.append("//");
                  String _regionMethodName_1 = this.getRegionMethodName(subRegion_1);
                  _builder_2.append(_regionMethodName_1, "\t");
                  _builder_2.append("(");
                  String _initialMacroName_3 = this.getInitialMacroName(subRegion_1);
                  _builder_2.append(_initialMacroName_3, "\t");
                  _builder_2.append(");");
                  _builder_2.newLineIfNotEmpty();
                  _builder_2.append("\t");
                  String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, true);
                  _builder_2.append(_generateJoinCall, "\t");
                  _builder_2.newLineIfNotEmpty();
                }
              }
            } else {
              _builder_2.append("\t");
              String _regionMethodName_2 = this.getRegionMethodName(IterableExtensions.<Region>head(initialState.getRegions()));
              _builder_2.append(_regionMethodName_2, "\t");
              _builder_2.append("(");
              String _initialMacroName_4 = this.getInitialMacroName(IterableExtensions.<Region>head(initialState.getRegions()));
              _builder_2.append(_initialMacroName_4, "\t");
              _builder_2.append(");");
              _builder_2.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder_2.append("\t");
      _builder_2.append("//TODO: set systemState to EVENT_CONSUMED");
      _builder_2.newLine();
      _builder_2.append("\t");
      _builder_2.append("break;");
      _builder_2.newLine();
      body = _builder_2.toString();
    }
    for (int i = 0; (i < endVertices.size()); i++) {
      StringConcatenation _builder_3 = new StringConcatenation();
      _builder_3.append(macros);
      _builder_3.newLineIfNotEmpty();
      _builder_3.append("#define ");
      String _vertexMacroName = this.getVertexMacroName(endVertices.get(i));
      _builder_3.append(_vertexMacroName);
      _builder_3.append(" (");
      _builder_3.append((i + 1));
      _builder_3.append(")");
      macros = _builder_3.toString();
    }
    IncludeUtils.appendIncludeHeader(this.superContext, macros);
    Operation regionMethod = this.superContext.createOwnedOperation(this.getRegionMethodName(r), null, null);
    regionMethod.createOwnedParameter(SMCodeGeneratorConstants.ENTER_MODE_PARAM, this.charType);
    String _body = body;
    StringConcatenation _builder_3 = new StringConcatenation();
    {
      for(final Vertex v_1 : endVertices) {
        {
          if ((v_1 instanceof State)) {
            _builder_3.append("case ");
            String _vertexMacroName = this.getVertexMacroName(v_1);
            _builder_3.append(_vertexMacroName);
            _builder_3.append(":");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("\t");
            String _generateChangeState_1 = this.generateChangeState(((State)v_1));
            _builder_3.append(_generateChangeState_1, "\t");
            _builder_3.newLineIfNotEmpty();
            {
              boolean _isBehaviorExist_1 = StateMachineUtils.isBehaviorExist(((State)v_1).getEntry());
              if (_isBehaviorExist_1) {
                _builder_3.append("\t");
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
                _builder_4.append("[");
                String _upperCase_2 = ((State)v_1).getName().toUpperCase();
                _builder_4.append(_upperCase_2);
                _builder_4.append("_ID]");
                String _fptrCall_1 = this.getFptrCall(_builder_4.toString(), false, SMCodeGeneratorConstants.ENTRY_NAME);
                _builder_3.append(_fptrCall_1, "\t");
                _builder_3.append(";");
                _builder_3.newLineIfNotEmpty();
              }
            }
            _builder_3.append("\t");
            _builder_3.append("//starting the counters for time events");
            _builder_3.newLine();
            _builder_3.append("\t");
            CharSequence _generateActivateTimeEvent_1 = this.generateActivateTimeEvent(((State)v_1), "true");
            _builder_3.append(_generateActivateTimeEvent_1, "\t");
            _builder_3.newLineIfNotEmpty();
            {
              if ((StateMachineUtils.isBehaviorExist(((State)v_1).getDoActivity()) || StateMachineUtils.hasTriggerlessTransition(((State)v_1)))) {
                _builder_3.append("\t");
                _builder_3.append("//start activity of ");
                String _name_1 = ((State)v_1).getName();
                _builder_3.append(_name_1, "\t");
                _builder_3.append(" by calling setFlag");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t");
                _builder_3.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
                _builder_3.append("(");
                String _upperCase_3 = ((State)v_1).getName().toUpperCase();
                _builder_3.append(_upperCase_3, "\t");
                _builder_3.append("_ID, ");
                _builder_3.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
                _builder_3.append(", true);");
                _builder_3.newLineIfNotEmpty();
              }
            }
            {
              boolean _isComposite_1 = ((State)v_1).isComposite();
              if (_isComposite_1) {
                {
                  boolean _isOrthogonal_1 = ((State)v_1).isOrthogonal();
                  if (_isOrthogonal_1) {
                    _builder_3.append("\t");
                    _builder_3.append("//TODO: fork region funtions");
                    _builder_3.newLine();
                    {
                      EList<Region> _regions_2 = ((State)v_1).getRegions();
                      for(final Region subRegion_2 : _regions_2) {
                        _builder_3.append("\t");
                        _builder_3.append("//");
                        String _regionMethodName_3 = this.getRegionMethodName(subRegion_2);
                        _builder_3.append(_regionMethodName_3, "\t");
                        _builder_3.append("(");
                        String _initialMacroName_5 = this.getInitialMacroName(subRegion_2);
                        _builder_3.append(_initialMacroName_5, "\t");
                        _builder_3.append(");");
                        _builder_3.newLineIfNotEmpty();
                        _builder_3.append("\t");
                        String _generateForkCall_1 = this.concurrency.generateForkCall(subRegion_2, true, this.getInitialMacroName(subRegion_2));
                        _builder_3.append(_generateForkCall_1, "\t");
                        _builder_3.newLineIfNotEmpty();
                      }
                    }
                    _builder_3.append("\t");
                    _builder_3.append("//TODO: join region functions");
                    _builder_3.newLine();
                    {
                      EList<Region> _regions_3 = ((State)v_1).getRegions();
                      for(final Region subRegion_3 : _regions_3) {
                        _builder_3.append("\t");
                        _builder_3.append("//");
                        String _regionMethodName_4 = this.getRegionMethodName(subRegion_3);
                        _builder_3.append(_regionMethodName_4, "\t");
                        _builder_3.append("(");
                        String _initialMacroName_6 = this.getInitialMacroName(subRegion_3);
                        _builder_3.append(_initialMacroName_6, "\t");
                        _builder_3.append(");");
                        _builder_3.newLineIfNotEmpty();
                        _builder_3.append("\t");
                        String _generateJoinCall_1 = this.concurrency.generateJoinCall(subRegion_3, true);
                        _builder_3.append(_generateJoinCall_1, "\t");
                        _builder_3.newLineIfNotEmpty();
                      }
                    }
                  } else {
                    _builder_3.append("\t");
                    String _regionMethodName_5 = this.getRegionMethodName(IterableExtensions.<Region>head(((State)v_1).getRegions()));
                    _builder_3.append(_regionMethodName_5, "\t");
                    _builder_3.append("(");
                    String _initialMacroName_7 = this.getInitialMacroName(IterableExtensions.<Region>head(((State)v_1).getRegions()));
                    _builder_3.append(_initialMacroName_7, "\t");
                    _builder_3.append(");");
                    _builder_3.newLineIfNotEmpty();
                  }
                }
              }
            }
          } else {
            _builder_3.append("case ");
            String _vertexMacroName_1 = this.getVertexMacroName(v_1);
            _builder_3.append(_vertexMacroName_1);
            _builder_3.append(": ");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("\t");
            String _generatePseudo = this.pseudostateGenerator.generatePseudo(((Pseudostate) v_1));
            _builder_3.append(_generatePseudo, "\t");
            _builder_3.newLineIfNotEmpty();
          }
        }
        _builder_3.append("\t");
        _builder_3.append("//TODO: set systemState to EVENT_CONSUMED");
        _builder_3.newLine();
        _builder_3.append("\t");
        _builder_3.append("break;");
        _builder_3.newLine();
      }
    }
    body = (_body + _builder_3);
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append("switch(");
    _builder_5.append(SMCodeGeneratorConstants.ENTER_MODE_PARAM);
    _builder_5.append(") {");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("\t");
    _builder_5.append(body, "\t");
    _builder_5.newLineIfNotEmpty();
    _builder_5.append("}");
    _builder_5.newLine();
    final String switchBody = _builder_5.toString();
    this.createOpaqueBehavior(this.superContext, regionMethod, switchBody);
  }

  public CharSequence generateEnteringOnSubVertex(final State parent, final Vertex subVertex) {
    StringConcatenation _builder = new StringConcatenation();
    String _generateChangeState = this.generateChangeState(parent);
    _builder.append(_generateChangeState);
    _builder.newLineIfNotEmpty();
    {
      boolean _isBehaviorExist = StateMachineUtils.isBehaviorExist(parent.getEntry());
      if (_isBehaviorExist) {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
        _builder_1.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder_1.append(_upperCase);
        _builder_1.append("_ID]");
        String _fptrCall = this.getFptrCall(_builder_1.toString(), false, SMCodeGeneratorConstants.ENTRY_NAME);
        _builder.append(_fptrCall);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("//starting the counters for time events");
    _builder.newLine();
    CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "true");
    _builder.append(_generateActivateTimeEvent);
    _builder.newLineIfNotEmpty();
    {
      if ((StateMachineUtils.isBehaviorExist(parent.getDoActivity()) || StateMachineUtils.hasTriggerlessTransition(parent))) {
        _builder.append("//start activity of ");
        String _name = parent.getName();
        _builder.append(_name);
        _builder.append(" by calling setFlag");
        _builder.newLineIfNotEmpty();
        _builder.append(SMCodeGeneratorConstants.SET_FLAG);
        _builder.append("(");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_ID, ");
        _builder.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE);
        _builder.append(", true);");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      if ((parent.isComposite() && (!Objects.equals(parent, subVertex)))) {
        {
          boolean _isOrthogonal = parent.isOrthogonal();
          if (_isOrthogonal) {
            ArrayList<Region> toJoinList = new ArrayList<Region>();
            _builder.newLineIfNotEmpty();
            {
              EList<Region> _regions = parent.getRegions();
              for(final Region r : _regions) {
                {
                  if ((subVertex != null)) {
                    {
                      Region _container = subVertex.getContainer();
                      boolean _equals = Objects.equals(_container, r);
                      if (_equals) {
                        boolean _add = toJoinList.add(r);
                        _builder.append(_add);
                        _builder.newLineIfNotEmpty();
                        _builder.append("//");
                        String _regionMethodName = this.getRegionMethodName(r);
                        _builder.append(_regionMethodName);
                        _builder.append("(");
                        String _vertexMacroName = this.getVertexMacroName(subVertex);
                        _builder.append(_vertexMacroName);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                        String _generateForkCall = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                        _builder.append(_generateForkCall);
                        _builder.newLineIfNotEmpty();
                      } else {
                        boolean _contains = this.allSubVertexes(r).contains(subVertex);
                        if (_contains) {
                          boolean _add_1 = toJoinList.add(r);
                          _builder.append(_add_1);
                          _builder.newLineIfNotEmpty();
                          _builder.append("//");
                          String _regionMethodName_1 = this.getRegionMethodName(r);
                          _builder.append(_regionMethodName_1);
                          _builder.append("(");
                          String _vertexMacroName_1 = this.getVertexMacroName(subVertex);
                          _builder.append(_vertexMacroName_1);
                          _builder.append(");");
                          _builder.newLineIfNotEmpty();
                          String _generateForkCall_1 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                          _builder.append(_generateForkCall_1);
                          _builder.newLineIfNotEmpty();
                        } else {
                          State _findInitialState = StateMachineUtils.findInitialState(r);
                          boolean _tripleNotEquals = (_findInitialState != null);
                          if (_tripleNotEquals) {
                            boolean _add_2 = toJoinList.add(r);
                            _builder.append(_add_2);
                            _builder.newLineIfNotEmpty();
                            _builder.append("//");
                            String _regionMethodName_2 = this.getRegionMethodName(r);
                            _builder.append(_regionMethodName_2);
                            _builder.append("(");
                            String _initialMacroName = this.getInitialMacroName(r);
                            _builder.append(_initialMacroName);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                            String _generateForkCall_2 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                            _builder.append(_generateForkCall_2);
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      }
                    }
                  } else {
                    if (((subVertex != null) && (subVertex.getContainer() == null))) {
                      {
                        EObject _eContainer = subVertex.eContainer();
                        boolean _equals_1 = Objects.equals(_eContainer, parent);
                        if (_equals_1) {
                          boolean _add_3 = toJoinList.add(r);
                          _builder.append(_add_3);
                          _builder.newLineIfNotEmpty();
                          String _generateForkCall_3 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                          _builder.append(_generateForkCall_3);
                          _builder.newLineIfNotEmpty();
                        } else {
                          boolean _add_4 = toJoinList.add(r);
                          _builder.append(_add_4);
                          _builder.newLineIfNotEmpty();
                          String _generateForkCall_4 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                          _builder.append(_generateForkCall_4);
                          _builder.newLineIfNotEmpty();
                        }
                      }
                    } else {
                      {
                        State _findInitialState_1 = StateMachineUtils.findInitialState(r);
                        boolean _tripleNotEquals_1 = (_findInitialState_1 != null);
                        if (_tripleNotEquals_1) {
                          boolean _add_5 = toJoinList.add(r);
                          _builder.append(_add_5);
                          _builder.newLineIfNotEmpty();
                          _builder.append("//");
                          String _regionMethodName_3 = this.getRegionMethodName(r);
                          _builder.append(_regionMethodName_3);
                          _builder.append("(");
                          String _initialMacroName_1 = this.getInitialMacroName(r);
                          _builder.append(_initialMacroName_1);
                          _builder.append(");");
                          _builder.newLineIfNotEmpty();
                          String _generateForkCall_5 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                          _builder.append(_generateForkCall_5);
                          _builder.newLineIfNotEmpty();
                        }
                      }
                    }
                  }
                }
              }
            }
            {
              for(final Region r_1 : toJoinList) {
                String _generateJoinCall = this.concurrency.generateJoinCall(r_1, true);
                _builder.append(_generateJoinCall);
                _builder.newLineIfNotEmpty();
              }
            }
          } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
              {
                if ((subVertex != null)) {
                  {
                    if (((subVertex.getContainer() == null) && (subVertex.eContainer() instanceof State))) {
                      String _regionMethodName_4 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                      _builder.append(_regionMethodName_4);
                      _builder.append("(");
                      String _vertexMacroName_2 = this.getVertexMacroName(subVertex);
                      _builder.append(_vertexMacroName_2);
                      _builder.append(");");
                      _builder.newLineIfNotEmpty();
                    } else {
                      State _state = subVertex.getContainer().getState();
                      boolean _equals_2 = Objects.equals(_state, parent);
                      if (_equals_2) {
                        String _regionMethodName_5 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                        _builder.append(_regionMethodName_5);
                        _builder.append("(");
                        String _vertexMacroName_3 = this.getVertexMacroName(subVertex);
                        _builder.append(_vertexMacroName_3);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                      } else {
                        final Function1<Region, Boolean> _function = (Region it) -> {
                          return Boolean.valueOf(this.allSubVertexes(it).contains(subVertex));
                        };
                        Region containingRegion = IterableExtensions.<Region>head(IterableExtensions.<Region>filter(parent.getRegions(), _function));
                        _builder.newLineIfNotEmpty();
                        {
                          if ((containingRegion != null)) {
                            String _regionMethodName_6 = this.getRegionMethodName(containingRegion);
                            _builder.append(_regionMethodName_6);
                            _builder.append("(");
                            String _vertexMacroName_4 = this.getVertexMacroName(subVertex);
                            _builder.append(_vertexMacroName_4);
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      }
                    }
                  }
                } else {
                  String _regionMethodName_7 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder.append(_regionMethodName_7);
                  _builder.append("(");
                  String _initialMacroName_2 = this.getInitialMacroName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder.append(_initialMacroName_2);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            } else {
            }
          }
        }
      } else {
        if ((parent.isComposite() && Objects.equals(parent, subVertex))) {
          {
            boolean _isOrthogonal_1 = parent.isOrthogonal();
            if (_isOrthogonal_1) {
              ArrayList<Region> toJoinList_1 = new ArrayList<Region>();
              _builder.newLineIfNotEmpty();
              {
                EList<Region> _regions_1 = parent.getRegions();
                for(final Region r_2 : _regions_1) {
                  {
                    State _findInitialState_2 = StateMachineUtils.findInitialState(r_2);
                    boolean _tripleNotEquals_2 = (_findInitialState_2 != null);
                    if (_tripleNotEquals_2) {
                      boolean _add_6 = toJoinList_1.add(r_2);
                      _builder.append(_add_6);
                      _builder.newLineIfNotEmpty();
                      _builder.append("//");
                      String _regionMethodName_8 = this.getRegionMethodName(r_2);
                      _builder.append(_regionMethodName_8);
                      _builder.append("(");
                      String _initialMacroName_3 = this.getInitialMacroName(r_2);
                      _builder.append(_initialMacroName_3);
                      _builder.append(");");
                      _builder.newLineIfNotEmpty();
                      String _generateForkCall_6 = this.concurrency.generateForkCall(r_2, true, this.getInitialMacroName(r_2));
                      _builder.append(_generateForkCall_6);
                      _builder.newLineIfNotEmpty();
                    }
                  }
                }
              }
              {
                for(final Region r_3 : toJoinList_1) {
                  String _generateJoinCall_1 = this.concurrency.generateJoinCall(r_3, true);
                  _builder.append(_generateJoinCall_1);
                  _builder.newLineIfNotEmpty();
                }
              }
            } else {
              {
                State _findInitialState_3 = StateMachineUtils.findInitialState(IterableExtensions.<Region>head(parent.getRegions()));
                boolean _tripleNotEquals_3 = (_findInitialState_3 != null);
                if (_tripleNotEquals_3) {
                  String _regionMethodName_9 = this.getRegionMethodName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder.append(_regionMethodName_9);
                  _builder.append("(");
                  String _initialMacroName_4 = this.getInitialMacroName(IterableExtensions.<Region>head(parent.getRegions()));
                  _builder.append(_initialMacroName_4);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
    }
    return _builder;
  }

  private void createRegionMethodExit(final Region r) {
    if (((r.getState() == null) || (!r.getState().isComposite()))) {
      return;
    }
    State parent = r.getState();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("//exiting region ");
    String _name = r.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    int regionIndex = r.getState().getRegions().indexOf(r);
    _builder.newLineIfNotEmpty();
    {
      final Function1<State, Boolean> _function = (State it) -> {
        return Boolean.valueOf(((!(it instanceof FinalState)) && it.isComposite()));
      };
      Iterable<State> _filter = IterableExtensions.<State>filter(Iterables.<State>filter(r.getSubvertices(), State.class), _function);
      boolean _hasElements = false;
      for(final State s : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(" else ", "");
        }
        _builder.append("if (");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
        _builder.append("[");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
        _builder.append("[");
        _builder.append(regionIndex);
        _builder.append("] == ");
        String _upperCase_1 = s.getName().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append("_ID) {");
        _builder.newLineIfNotEmpty();
        {
          boolean _isOrthogonal = s.isOrthogonal();
          if (_isOrthogonal) {
            {
              EList<Region> _regions = s.getRegions();
              for(final Region subRegion : _regions) {
                _builder.append("\t");
                String _generateForkCall = this.concurrency.generateForkCall(subRegion, false, "0");
                _builder.append(_generateForkCall, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
            {
              EList<Region> _regions_1 = s.getRegions();
              for(final Region subRegion_1 : _regions_1) {
                _builder.append("\t");
                String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, false);
                _builder.append(_generateJoinCall, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
          } else {
            _builder.append("\t");
            String _regionMethodExitName = this.getRegionMethodExitName(IterableExtensions.<Region>head(s.getRegions()));
            _builder.append(_regionMethodExitName, "\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("if (");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE);
    _builder.append("[");
    String _upperCase_2 = parent.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_ID].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES);
    _builder.append("[");
    _builder.append(regionIndex);
    _builder.append("] != ");
    _builder.append(SMCodeGeneratorConstants.STATE_MAX);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("//signal to exit the doActivity of sub-state of ");
    String _name_1 = parent.getName();
    _builder.append(_name_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(SMCodeGeneratorConstants.SET_FLAG, "\t");
    _builder.append("(");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[");
    String _upperCase_3 = parent.getName().toUpperCase();
    _builder.append(_upperCase_3, "\t");
    _builder.append("_ID].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
    _builder.append("[0], ");
    _builder.append(SMCppCodeGeneratorConstants.THREAD_FUNC_DOACTIVITY_TYPE, "\t");
    _builder.append(", false);");
    _builder.newLineIfNotEmpty();
    {
      Iterable<State> _filter_1 = Iterables.<State>filter(r.getSubvertices(), State.class);
      boolean _hasElements_1 = false;
      for(final State sub : _filter_1) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder.appendImmediate(" else ", "\t");
        }
        {
          List<TimeEvent> _get = this.states2TimeEvents.get(sub);
          boolean _tripleNotEquals = (_get != null);
          if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("if (");
            String _upperCase_4 = sub.getName().toUpperCase();
            _builder.append(_upperCase_4, "\t");
            _builder.append("_ID == ");
            _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
            _builder.append("[");
            String _upperCase_5 = parent.getName().toUpperCase();
            _builder.append(_upperCase_5, "\t");
            _builder.append("_ID].");
            _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
            _builder.append("[");
            _builder.append(regionIndex, "\t");
            _builder.append("]) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(sub, "false");
            _builder.append(_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    _builder.append("//exit action of sub-state of ");
    String _name_2 = parent.getName();
    _builder.append(_name_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("(this->*");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[");
    String _upperCase_6 = parent.getName().toUpperCase();
    _builder.append(_upperCase_6, "\t");
    _builder.append("_ID].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
    _builder.append("[0]].");
    _builder.append(SMCodeGeneratorConstants.EXIT_NAME, "\t");
    _builder.append(")();");
    _builder.newLineIfNotEmpty();
    {
      boolean _isSavehistory = StateMachineUtils.isSavehistory(r);
      if (_isSavehistory) {
        _builder.append("\t");
        _builder.append("//save history region ");
        String _name_3 = r.getName();
        _builder.append(_name_3, "\t");
        _builder.append(" of state ");
        String _name_4 = parent.getName();
        _builder.append(_name_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        String _upperCase_7 = parent.getName().toUpperCase();
        _builder.append(_upperCase_7, "\t");
        _builder.append("_ID].");
        _builder.append(SMCodeGeneratorConstants.PREVIOUS_STATES, "\t");
        _builder.append("[");
        _builder.append(regionIndex, "\t");
        _builder.append("] = ");
        _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
        _builder.append("[");
        String _upperCase_8 = parent.getName().toUpperCase();
        _builder.append(_upperCase_8, "\t");
        _builder.append("_ID].");
        _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
        _builder.append("[");
        _builder.append(regionIndex, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("//set active sub-state of ");
    String _name_5 = parent.getName();
    _builder.append(_name_5, "\t");
    _builder.append(" to ");
    _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t");
    _builder.append(" meaning NULL");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "\t");
    _builder.append("[");
    String _upperCase_9 = parent.getName().toUpperCase();
    _builder.append(_upperCase_9, "\t");
    _builder.append("_ID].");
    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "\t");
    _builder.append("[");
    _builder.append(regionIndex, "\t");
    _builder.append("] = ");
    _builder.append(SMCodeGeneratorConstants.STATE_MAX, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    String body = _builder.toString();
    Operation exitOp = this.superContext.createOwnedOperation(this.getRegionMethodExitName(r), null, null);
    this.createOpaqueBehavior(this.superContext, exitOp, body);
  }

  private String getRegionMethodExitName(final Region r) {
    boolean _equals = Objects.equals(r, this.topRegion);
    if (_equals) {
      StringConcatenation _builder = new StringConcatenation();
      String _name = r.getStateMachine().getName();
      _builder.append(_name);
      _builder.append("_");
      String _name_1 = r.getName();
      _builder.append(_name_1);
      _builder.append("_Exit");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    String _name_2 = r.getState().getName();
    _builder_1.append(_name_2);
    _builder_1.append("_");
    String _name_3 = r.getName();
    _builder_1.append(_name_3);
    _builder_1.append("_Exit");
    return _builder_1.toString();
  }

  public List<Vertex> allSubVertexes(final Region r) {
    final ArrayList<Vertex> ret = new ArrayList<Vertex>();
    ret.addAll(r.getSubvertices());
    final Consumer<State> _function = (State it) -> {
      final Consumer<Region> _function_1 = (Region it_1) -> {
        ret.addAll(this.allSubVertexes(it_1));
      };
      it.getRegions().forEach(_function_1);
    };
    Iterables.<State>filter(r.getSubvertices(), State.class).forEach(_function);
    return ret;
  }

  private OpaqueBehavior createOpaqueBehavior(final org.eclipse.uml2.uml.Class container, final Operation op) {
    OpaqueBehavior opaque = IterableExtensions.<OpaqueBehavior>head(Iterables.<OpaqueBehavior>filter(op.getMethods(), OpaqueBehavior.class));
    if ((opaque == null)) {
      Behavior _createClassifierBehavior = container.createClassifierBehavior(op.getName(), UMLPackage.Literals.OPAQUE_BEHAVIOR);
      opaque = ((OpaqueBehavior) _createClassifierBehavior);
      op.getMethods().add(opaque);
      opaque.getLanguages().add(this.langID);
    }
    return opaque;
  }

  public OpaqueBehavior createOpaqueBehavior(final org.eclipse.uml2.uml.Class container, final Operation op, final String body) {
    OpaqueBehavior opaque = this.createOpaqueBehavior(container, op);
    int _size = opaque.getBodies().size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      opaque.getBodies().set(0, body);
    } else {
      opaque.getLanguages().add(this.langID);
      opaque.getBodies().add(body);
    }
    return opaque;
  }

  private OpaqueExpression createOpaqueExpressionDefaultValue(final Property container, final String name) {
    ValueSpecification _defaultValue = container.getDefaultValue();
    OpaqueExpression opaque = ((OpaqueExpression) _defaultValue);
    if ((opaque == null)) {
      ValueSpecification _createDefaultValue = container.createDefaultValue(name, null, UMLPackage.Literals.OPAQUE_EXPRESSION);
      opaque = ((OpaqueExpression) _createDefaultValue);
      opaque.getLanguages().add(this.langID);
    }
    return opaque;
  }

  public OpaqueExpression createOpaqueExpressionDefaultValue(final Property container, final String name, final String body) {
    OpaqueExpression opaque = this.createOpaqueExpressionDefaultValue(container, name);
    int _size = opaque.getBodies().size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      opaque.getBodies().set(0, body);
    } else {
      opaque.getLanguages().add(this.langID);
      opaque.getBodies().add(body);
    }
    return opaque;
  }

  public Operation createDerivedOperation(final org.eclipse.uml2.uml.Class clz, final Operation source) {
    Operation _xblockexpression = null;
    {
      String name = source.getName();
      Operation derivedOp = clz.createOwnedOperation(name, null, null);
      OperationSync.sync(source, derivedOp);
      derivedOp.setName(name);
      StereotypeUtil.apply(derivedOp, DerivedElement.class);
      DerivedElement _stereotypeApplication = UMLUtil.<DerivedElement>getStereotypeApplication(derivedOp, DerivedElement.class);
      _stereotypeApplication.setSource(source);
      StereotypeUtil.apply(derivedOp, Virtual.class);
      _xblockexpression = derivedOp;
    }
    return _xblockexpression;
  }

  public String getGuard(final Transition t) {
    ValueSpecification _specification = t.getGuard().getSpecification();
    return IterableExtensions.<String>head(((OpaqueExpression) _specification).getBodies());
  }
}
