/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.library.transformations;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.core.templates.TextTemplateBinding;
import org.eclipse.papyrus.designer.transformation.library.transformations.MergeClass;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.transformation.tracing.library.utils.TraceUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.util.UMLUtil;

public class LTTngTrafo
extends MergeClass
implements IM2MTrafoElem {
    public void instrumentOperation(M2MTrafo trafo, Operation op) throws TransformationException {
        Class templateClass = trafo.getBase_Class();
        for (Operation templateOp : templateClass.getOwnedOperations()) {
            String templateBody = TextTemplateBinding.bind((String)BehaviorUtils.body((Operation)templateOp), (Element)op, null);
            String body = BehaviorUtils.body((Operation)op);
            BehaviorUtils.set((Operation)op, (String)(templateBody + body));
        }
    }

    public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
        if (element instanceof Class) {
            boolean first = true;
            Class clazz = (Class)element;
            BasicEList opList = new BasicEList((Collection)clazz.getOwnedOperations());
            for (Operation operation : opList) {
                if (!TraceUtils.hasTrace((EObject)operation)) continue;
                if (first) {
                    super.transformElement(trafo, element);
                    Include cppIncludeOnTemplate = (Include)UMLUtil.getStereotypeApplication((Element)trafo.getBase_Class(), Include.class);
                    if (cppIncludeOnTemplate != null) {
                        Include cppOnElement = (Include)UMLUtil.getStereotypeApplication((Element)clazz, Include.class);
                        if (cppOnElement == null) {
                            cppOnElement = (Include)StereotypeUtil.applyApp((Element)clazz, Include.class);
                        }
                        if (cppIncludeOnTemplate.getHeader() != null) {
                            cppOnElement.setHeader(cppOnElement.getHeader() + TextTemplateBinding.bind((String)cppIncludeOnTemplate.getHeader(), (Element)clazz, null));
                        }
                        if (cppIncludeOnTemplate.getPreBody() != null) {
                            cppOnElement.setPreBody(cppOnElement.getPreBody() + TextTemplateBinding.bind((String)cppIncludeOnTemplate.getPreBody(), (Element)clazz, null));
                        }
                        if (cppIncludeOnTemplate.getBody() != null) {
                            cppOnElement.setBody(cppOnElement.getBody() + TextTemplateBinding.bind((String)cppIncludeOnTemplate.getBody(), (Element)clazz, null));
                        }
                    }
                    first = false;
                }
                this.instrumentOperation(trafo, operation);
            }
        }
        if (TraceUtils.hasTrace((EObject)element) && element instanceof Operation) {
            Operation op = (Operation)element;
            System.err.println(op);
        }
    }
}

