/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.deployment.tools.DepPlanUtils;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.sync.DepPlanSync;
import org.eclipse.papyrus.designer.transformation.ui.Messages;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;

public class CreateDepPlanHandler
extends CmdHandler {
    private Package depPlans;

    public boolean isEnabled() {
        this.updateSelectedEObject();
        return this.selectedEObject instanceof Class && !((Class)this.selectedEObject).isAbstract();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!(this.selectedEObject instanceof Class)) {
            return null;
        }
        final Class selectedComposite = (Class)this.selectedEObject;
        final Shell shell = Display.getCurrent().getActiveShell();
        CommandSupport.exec((EObject)selectedComposite, (String)Messages.CreateDepPlanHandler_CreateDP, (Runnable)new Runnable(){

            @Override
            public void run() {
                CreateDepPlanHandler.this.depPlans = DepPlanUtils.getDepPlanRoot((Element)selectedComposite);
                String depPlanName = selectedComposite.getName() + "DepPlan";
                if (CreateDepPlanHandler.this.depPlans.getMember(depPlanName) != null) {
                    String[] dialogButtonLabels = new String[]{Messages.CreateDepPlanHandler_Cancel, Messages.CreateDepPlanHandler_Sync, Messages.CreateDepPlanHandler_CreateNew};
                    MessageDialog dialog = new MessageDialog(shell, Messages.CreateDepPlanHandler_WhatShouldIDo, null, String.format(Messages.CreateDepPlanHandler_DPwithNameExistsAlready, depPlanName), 3, dialogButtonLabels, 0);
                    int result = dialog.open();
                    if (result == 0) {
                        return;
                    }
                    if (result == 1) {
                        NamedElement existing = CreateDepPlanHandler.this.depPlans.getMember(depPlanName);
                        if (existing instanceof Package) {
                            DepPlanSync.syncDepPlan((Package)((Package)existing));
                            return;
                        }
                        MessageDialog.openError((Shell)shell, (String)Messages.CreateDepPlanHandler_CannotSync, (String)String.format(Messages.CreateDepPlanHandler_DPwithNameExistsNoPackage, depPlanName));
                    } else {
                        int i = 2;
                        while (CreateDepPlanHandler.this.depPlans.getMember(depPlanName = selectedComposite.getName() + "DepPlan" + i) != null) {
                            ++i;
                        }
                    }
                }
                Package cdp = DepCreation.createDepPlanPkg((Package)CreateDepPlanHandler.this.depPlans, (String)depPlanName);
                try {
                    InstanceSpecification newRootIS = DepCreation.createDepPlan((Package)cdp, (Class)selectedComposite, (String)"mainInstance", (boolean)true);
                    DepCreation.initAutoValues((InstanceSpecification)newRootIS);
                }
                catch (TransformationException e) {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.CreateDepPlanHandler_CannotCreateDP, (String)e.getMessage());
                }
            }
        });
        return null;
    }
}

