/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.status.State;

public final class DnDStatus {
    private final State state;
    private final String message;
    private final Set<EObject> elementsToDisplay;

    private DnDStatus(State state, String message, Set<EObject> elementsToDisplay) {
        this.state = state;
        this.message = message;
        this.elementsToDisplay = elementsToDisplay;
    }

    public static DnDStatus createFailingStatus(String message, Set<EObject> elements) {
        return new DnDStatus(State.FAILED, message, elements);
    }

    public static DnDStatus createOKStatus(Set<EObject> elements) {
        return new DnDStatus(State.DONE, "", elements);
    }

    public static DnDStatus createNothingStatus(Set<EObject> elements) {
        return new DnDStatus(State.NOTHING, "", elements);
    }

    public State getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<EObject> getElementsToDisplay() {
        return this.elementsToDisplay;
    }
}

