/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.edges;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.EMFUtils;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ActivityEdgeHelper;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementDomainBasedEdgeContainerProvider
implements IDomainBasedEdgeContainerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementDomainBasedEdgeContainerProvider.class);
    private final IEditableChecker editableChecker;

    public ElementDomainBasedEdgeContainerProvider(IEditableChecker editableChecker) {
        this.editableChecker = editableChecker;
    }

    @Override
    public EObject getContainer(EObject semanticSource, EObject semanticTarget, EObject semanticEdge, IViewQuerier querier, Object sourceNode, Object targetNode) {
        EObject container = (EObject)new ElementDomainBasedEdgeContainerProviderSwitch(semanticSource, semanticTarget, this.editableChecker, querier).doSwitch(semanticEdge);
        if (this.editableChecker.canEdit(container)) {
            return container;
        }
        return null;
    }

    static class ElementDomainBasedEdgeContainerProviderSwitch
    extends UMLSwitch<EObject> {
        private final EObject source;
        private final EObject target;
        private final IEditableChecker editableChecker;
        private final IViewQuerier querier;

        ElementDomainBasedEdgeContainerProviderSwitch(EObject source, EObject target, IEditableChecker editableChecker, IViewQuerier querier) {
            this.source = source;
            this.target = target;
            this.editableChecker = editableChecker;
            this.querier = querier;
        }

        public EObject caseActivityEdge(ActivityEdge activityEdge) {
            return new ActivityEdgeHelper().deduceContainer(this.source, this.target);
        }

        public EObject caseAssociation(Association object) {
            EObject diagramElement;
            EObject parent = diagramElement = this.querier.getSemanticElement(this.querier.getDiagram());
            while (parent != null) {
                if (parent instanceof Package) {
                    return parent;
                }
                parent = parent.eContainer();
            }
            return null;
        }

        public EObject caseComponentRealization(ComponentRealization object) {
            return this.target;
        }

        public EObject caseConnector(Connector object) {
            List<StructuredClassifier> sourceStructureClassifiers = EMFUtils.getAncestors(StructuredClassifier.class, this.source);
            List<StructuredClassifier> targetStructureClassifiers = EMFUtils.getAncestors(StructuredClassifier.class, this.target);
            for (StructuredClassifier structuredClassifier : targetStructureClassifiers) {
                if (!sourceStructureClassifiers.contains(structuredClassifier)) continue;
                return structuredClassifier;
            }
            return null;
        }

        public EObject caseDeployment(Deployment deployment) {
            return this.target;
        }

        public EObject caseDirectedRelationship(DirectedRelationship object) {
            Package proposedContainer;
            List containmentRefCandidates = this.source.eClass().getEAllReferences().stream().filter(ref -> ref.isContainment() && ref.getEType().isInstance((Object)object)).collect(Collectors.toList());
            if (containmentRefCandidates.isEmpty()) {
                proposedContainer = EMFUtils.getLeastCommonContainer(Package.class, this.source, this.target);
                if (proposedContainer == null || !this.editableChecker.canEdit((EObject)proposedContainer)) {
                    proposedContainer = EMFUtils.getAncestor(Package.class, this.source);
                }
                if (proposedContainer == null || !this.editableChecker.canEdit((EObject)proposedContainer)) {
                    proposedContainer = EMFUtils.getAncestor(Package.class, this.target);
                }
            } else {
                if (containmentRefCandidates.size() > 1) {
                    LOGGER.warn("More than one containment reference candidates:" + containmentRefCandidates.stream().map(ENamedElement::getName).collect(Collectors.joining(",")));
                }
                proposedContainer = this.source;
            }
            if (this.editableChecker.canEdit((EObject)proposedContainer)) {
                return proposedContainer;
            }
            return (EObject)super.caseDirectedRelationship(object);
        }

        public EObject caseElementImport(ElementImport elementImport) {
            return this.source;
        }

        public EObject caseExtend(Extend extend) {
            return this.source;
        }

        public EObject caseExtension(Extension extension) {
            EObject element = this.source;
            while (element != null) {
                if (element instanceof Package) {
                    return element;
                }
                element = element.eContainer();
            }
            return null;
        }

        public EObject caseGeneralization(Generalization object) {
            return this.source;
        }

        public EObject caseInclude(Include object) {
            return this.source;
        }

        public EObject caseInterfaceRealization(InterfaceRealization object) {
            return this.source;
        }

        public EObject caseMessage(Message message) {
            EObject element = this.source;
            while (element != null) {
                if (element instanceof Interaction) {
                    return element;
                }
                element = element.eContainer();
            }
            return null;
        }

        public EObject casePackageImport(PackageImport object) {
            return this.source;
        }

        public EObject casePackageMerge(PackageMerge object) {
            return this.source;
        }

        public EObject caseSubstitution(Substitution object) {
            return this.source;
        }

        public EObject caseTransition(Transition transition) {
            Region container = EMFUtils.getAncestor(Region.class, this.source);
            if (container == null && (container = EMFUtils.getAncestor(Region.class, this.target)) == null) {
                container = this.getFirstRegionStateMachine();
            }
            return container;
        }

        private Region getFirstRegionStateMachine() {
            EList regions;
            EObject eContainer = this.source.eContainer();
            if (eContainer instanceof StateMachine && !(regions = ((StateMachine)eContainer).getRegions()).isEmpty()) {
                return (Region)regions.get(0);
            }
            return null;
        }
    }
}

