/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.ModuleCategoryDefinition;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.tools.ContributionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public class ModuleDefinition {
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String VISIBLE = "visible";
    private static final String CATEGORY = "category";
    private static final String DEPENDENCY = "dependency";
    private static final String ID = "id";
    private static final String ICON = "icon";
    private final IConfigurationElement fConfig;
    private IPath fPath = null;

    public static ModuleDefinition getDefinition(Object module) {
        IScriptService scriptService = ScriptService.getService();
        for (ModuleDefinition definition : scriptService.getAvailableModules()) {
            if (!definition.getModuleClass().equals(module.getClass())) continue;
            return definition;
        }
        return null;
    }

    public ModuleDefinition(IConfigurationElement config) {
        this.fConfig = config;
    }

    public String getName() {
        return this.fConfig.getAttribute(NAME);
    }

    public List<ModuleDependency> getDependencies() {
        ArrayList<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
        IConfigurationElement[] iConfigurationElementArray = this.fConfig.getChildren(DEPENDENCY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            dependencies.add(new ModuleDependency(element));
            ++n2;
        }
        return dependencies;
    }

    public Class<?> getModuleClass() {
        Object instance;
        Bundle bundle = Platform.getBundle((String)this.fConfig.getDeclaringExtension().getContributor().getName());
        if (bundle != null) {
            try {
                String className = this.fConfig.getAttribute(CLASS);
                return Platform.getBundle((String)this.fConfig.getDeclaringExtension().getContributor().getName()).loadClass(className);
            }
            catch (InvalidRegistryObjectException className) {
            }
            catch (ClassNotFoundException className) {
                // empty catch block
            }
        }
        if ((instance = this.createModuleInstance()) != null) {
            return this.createModuleInstance().getClass();
        }
        return null;
    }

    public Object createModuleInstance() {
        try {
            return this.fConfig.createExecutableExtension(CLASS);
        }
        catch (CoreException e) {
            Logger.error("org.eclipse.ease", "Could not create module instance", e);
            return null;
        }
    }

    public boolean isVisible() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease");
        Preferences node = prefs.node("modules");
        return node.getBoolean(this.getPath().toString(), Boolean.parseBoolean(this.fConfig.getAttribute(VISIBLE)));
    }

    public void setVisible(boolean visible) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease");
        Preferences node = prefs.node("modules");
        node.putBoolean(this.getPath().toString(), visible);
    }

    public void resetVisible() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease");
        Preferences node = prefs.node("modules");
        node.remove(this.getPath().toString());
    }

    public IPath getPath() {
        if (this.fPath == null) {
            IScriptService scriptService = ScriptService.getService();
            this.fPath = new Path(this.getName());
            String categoryID = this.fConfig.getAttribute(CATEGORY);
            while (categoryID != null) {
                ModuleCategoryDefinition definition = scriptService.getAvailableModuleCategories().get(categoryID);
                if (definition != null) {
                    this.fPath = new Path(definition.getName()).append(this.fPath);
                    categoryID = definition.getParentId();
                    continue;
                }
                Logger.error("org.eclipse.ease", "Invalid category \"" + categoryID + "\" detected for module \"" + this.getName() + "\"");
                categoryID = null;
            }
            this.fPath = this.fPath.makeAbsolute();
        }
        return this.fPath;
    }

    public String getId() {
        return this.fConfig.getAttribute(ID) != null ? this.fConfig.getAttribute(ID) : "";
    }

    public ImageDescriptor getImageDescriptor() {
        return ContributionTools.getImageDescriptor(this.fConfig, ICON);
    }

    public String getBundleID() {
        return this.fConfig.getContributor().getName();
    }

    public List<Method> getMethods() {
        return ModuleHelper.getMethods(this.getModuleClass());
    }

    public List<Field> getFields() {
        return ModuleHelper.getFields(this.getModuleClass());
    }

    public String getHelpLocation(String topic) {
        return "/" + this.getBundleID() + "/help/module_" + this.getId().replace(' ', '_').toLowerCase() + ".html" + (topic != null ? "#" + topic : "");
    }

    public boolean isDeprecated() {
        return this.getModuleClass().getAnnotation(Deprecated.class) != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDefinition other = (ModuleDefinition)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public static class ModuleDependency {
        private static final String CONFIG_DEPENDENCY_ID = "module";
        private final IConfigurationElement fElement;

        public ModuleDependency(IConfigurationElement element) {
            this.fElement = element;
        }

        public String getId() {
            return this.fElement.getAttribute(CONFIG_DEPENDENCY_ID);
        }

        public ModuleDefinition getDefinition() {
            ScriptService scriptService = ScriptService.getInstance();
            return scriptService.getModuleDefinition(this.getId());
        }
    }
}

